/*
 * Copyright (C) 2017 MediaTek Inc.

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/slab.h>
#include <linux/sched.h>
#include <linux/spinlock.h>
#include <linux/interrupt.h>
#include <linux/list.h>
#include <linux/mutex.h>
#include <linux/kthread.h>
#include <linux/device.h>
#include <linux/kdev_t.h>
#include <linux/fs.h>
#include <linux/cdev.h>
#include <linux/delay.h>
#include <linux/platform_device.h>
#include <linux/proc_fs.h>
#include <linux/syscalls.h>
#include <linux/sched.h>
#include <linux/writeback.h>
#include <linux/seq_file.h>
#include <linux/uaccess.h>
#include <linux/ratelimit.h>
#include "include/pmic.h"
#include <soc/mediatek/mtk_auxadc_intf.h>
#include "upmu_hw.h"
#include "upmu_sw.h"
#include <linux/regmap.h>

struct regmap *pwrap_regmap;

static int count_time_out = 100;
#ifdef WAKELOCK
static struct wake_lock  mt6355_auxadc_wake_lock;
#else
static struct wakeup_source  mt6355_auxadc_wake_lock;
#endif
static struct mutex mt6355_adc_mutex;
unsigned int g_pmic_pad_vbif28_vol = 1;

static DEFINE_MUTEX(auxadc_ch3_mutex);

/*--Monitor MTS Thread Start--*/
static int mts_adc;
#ifdef WAKELOCK
static struct wake_lock  adc_monitor_wake_lock;
#else
static struct wakeup_source  adc_monitor_wake_lock;
#endif
static struct mutex adc_monitor_mutex;
static struct task_struct *adc_thread_handle;

void wake_up_auxadc_detect(void)
{
	PMICLOG("[%s]\n", __func__);
	if (adc_thread_handle != NULL) {
		#ifdef WAKELOCK
		wake_lock(&adc_monitor_wake_lock);
		#else
		__pm_stay_awake(&adc_monitor_wake_lock);
		#endif
		wake_up_process(adc_thread_handle);
	} else
		pr_err(PMICTAG "[%s] adc_thread_handle not ready\n", __func__);
}
/*--Monitor MTS Thread End--*/

unsigned int pmic_config_interface(unsigned int reg_num, unsigned int val,
				   unsigned int mask, unsigned int shift)
{
	unsigned int return_value = 0;
	unsigned int pmic_reg = 0;

	if (val > mask) {
		pr_err("[Power/PMIC][pmic_config_interface] Invalid data, Reg[%x]: mask = 0x%x, val = 0x%x\n",
			reg_num, mask, val);
		return -1;
	}

	return_value = regmap_read(pwrap_regmap, reg_num, &pmic_reg);
	if (return_value != 0) {
		pr_err("[Power/PMIC][pmic_config_interface] Reg[%x]= pmic_wrap read data fail\n"
			, reg_num);
		return return_value;
	}

	pmic_reg &= ~(mask << shift);
	pmic_reg |= (val << shift);

	return_value = regmap_write(pwrap_regmap, reg_num, pmic_reg);
	if (return_value != 0) {
		pr_err("[Power/PMIC][pmic_config_interface] Reg[%x]= pmic_wrap read data fail\n"
			, reg_num);
		return return_value;
	}

	return return_value;
}

unsigned int pmic_read_interface(unsigned int reg_num, unsigned int *val,
				 unsigned int mask, unsigned int shift)
{
	unsigned int return_value = 0;
	unsigned int pmic_reg = 0;

	return_value = regmap_read(pwrap_regmap, reg_num, &pmic_reg);
	if (return_value != 0) {
		pr_err("[Power/PMIC][pmic_read_interface] Reg[%x]= pmic_wrap read data fail\n"
			, reg_num);
		return return_value;
	}

	pmic_reg &= (mask << shift);
	*val = (pmic_reg >> shift);

	return return_value;
}

unsigned int upmu_get_reg_value(unsigned int reg)
{
	unsigned int reg_val = 0;
	unsigned int ret = 0;

	ret = pmic_read_interface(reg, &reg_val, 0xFFFF, 0x0);
	return reg_val;
}

unsigned short pmic_set_register_value(PMU_FLAGS_LIST_ENUM flagname,
				       unsigned int val)
{
	const PMU_FLAG_TABLE_ENTRY *pFlag = &pmu_flags_table[flagname];
	unsigned int ret = 0;

	if (pFlag->flagname != flagname) {
		pr_err("[%s]pmic flag idx error\n", __func__);
		return 1;
	}

	ret = pmic_config_interface((unsigned int)(pFlag->offset), val,
		(unsigned int)(pFlag->mask), (unsigned int)(pFlag->shift));
	if (ret != 0) {
		pr_err("[%s] error ret: %d when set Reg[0x%x]=0x%x\n", __func__,
			 ret, (pFlag->offset), val);
		return ret;
	}

	return 0;
}
unsigned short pmic_get_register_value(PMU_FLAGS_LIST_ENUM flagname)
{
	const PMU_FLAG_TABLE_ENTRY *pFlag = &pmu_flags_table[flagname];
	unsigned int val = 0;
	unsigned int ret = 0;

	ret = pmic_read_interface((unsigned int)pFlag->offset, &val,
		(unsigned int)(pFlag->mask), (unsigned int)(pFlag->shift));
	if (ret != 0) {
		pr_err("[%s] error ret: %d when get Reg[0x%x]\n", __func__,
			ret, (pFlag->offset));
		return ret;
	}

	return val;
}


unsigned int wk_auxadc_ch3_bif_on(unsigned char en)
{
	if (en < 2) {
		pmic_set_register_value(PMIC_RG_LDO_VBIF28_EN, en);
		pmic_set_register_value(PMIC_RG_LDO_VBIF28_SW_OP_EN, 1);
		if (!en)
			pmic_set_register_value(PMIC_RG_LDO_VBIF28_SW_OP_EN, 0);
	}

	return pmic_get_register_value(PMIC_DA_QI_VBIF28_EN);
}

unsigned int wk_auxadc_vsen_tdet_ctrl(unsigned char en_check)
{
	unsigned int ret = 0;

	if (en_check) {
		if ((!pmic_get_register_value(PMIC_RG_ADCIN_VSEN_MUX_EN)) &&
			(pmic_get_register_value(PMIC_BATON_TDET_EN))) {
			PMICLOG("[%s] vbif %d\n"
				, __func__, g_pmic_pad_vbif28_vol);
			return g_pmic_pad_vbif28_vol;
		}
		pr_err("[%s] baton switch off! vsen_mux_en = %d, tdet_en = %d\n",
			__func__
			, pmic_get_register_value(PMIC_RG_ADCIN_VSEN_MUX_EN),
			pmic_get_register_value(PMIC_BATON_TDET_EN));
		ret = 0;
	} else {
		pmic_set_register_value(PMIC_RG_ADCIN_VSEN_MUX_EN, 0);
		pmic_set_register_value(PMIC_BATON_TDET_EN, 1);
		pr_err("[%s] baton switch on! vsen_mux_en = %d, tdet_en = %d\n",
			__func__
			, pmic_get_register_value(PMIC_RG_ADCIN_VSEN_MUX_EN),
			pmic_get_register_value(PMIC_BATON_TDET_EN));
		ret = 1;
	}
	return ret;
}

void mt6355_auxadc_lock(void)
{
	#ifdef WAKELOCK
	wake_lock(&mt6355_auxadc_wake_lock);
	#else
	__pm_stay_awake(&mt6355_auxadc_wake_lock);
	#endif
	mutex_lock(&mt6355_adc_mutex);
}

void mt6355_auxadc_unlock(void)
{
	mutex_unlock(&mt6355_adc_mutex);
	#ifdef WAKELOCK
	wake_unlock(&mt6355_auxadc_wake_lock);
	#else
	__pm_relax(&mt6355_auxadc_wake_lock);
	#endif
}

struct pmic_auxadc_channel {
	u8 resolution;
	u8 r_val;
	unsigned int channel_rqst;
	unsigned int channel_rdy;
	unsigned int channel_out;
};

struct pmic_auxadc_channel mt6355_auxadc_channel[] = {
	{15, 3, PMIC_AUXADC_RQST_CH0, /* BATADC */
		PMIC_AUXADC_ADC_RDY_CH0_BY_AP, PMIC_AUXADC_ADC_OUT_CH0_BY_AP},
	{12, 1, PMIC_AUXADC_RQST_CH2, /* VCDT */
		PMIC_AUXADC_ADC_RDY_CH2, PMIC_AUXADC_ADC_OUT_CH2},
	{12, 2, PMIC_AUXADC_RQST_CH3, /* BAT TEMP */
		PMIC_AUXADC_ADC_RDY_CH3, PMIC_AUXADC_ADC_OUT_CH3},
	{12, 2, PMIC_AUXADC_RQST_BATID, /* BATID */
		PMIC_AUXADC_ADC_RDY_BATID, PMIC_AUXADC_ADC_OUT_BATID},
	{12, 2, PMIC_AUXADC_RQST_CH11, /* VBIF */
		PMIC_AUXADC_ADC_RDY_CH11, PMIC_AUXADC_ADC_OUT_CH11},
	{12, 1, PMIC_AUXADC_RQST_CH4, /* CHIP TEMP */
		PMIC_AUXADC_ADC_RDY_CH4, PMIC_AUXADC_ADC_OUT_CH4},
	{12, 1, PMIC_AUXADC_RQST_CH4, /* DCXO */
		PMIC_AUXADC_ADC_RDY_CH4, PMIC_AUXADC_ADC_OUT_CH4},
	{12, 1, PMIC_AUXADC_RQST_CH5, /* ACCDET MULTI-KEY */
		PMIC_AUXADC_ADC_RDY_CH5, PMIC_AUXADC_ADC_OUT_CH5},
	{15, 1, PMIC_AUXADC_RQST_CH7, /* TSX */
		PMIC_AUXADC_ADC_RDY_CH7_BY_AP, PMIC_AUXADC_ADC_OUT_CH7_BY_AP},
	{15, 1, PMIC_AUXADC_RQST_CH9, /* HP OFFSET CAL */
		PMIC_AUXADC_ADC_RDY_CH9, PMIC_AUXADC_ADC_OUT_CH9},
};
#define MT6355_AUXADC_CHANNEL_MAX	ARRAY_SIZE(mt6355_auxadc_channel)

static int mt6355_auxadc_get_auxadc_value_batmp(void)
{
	int count = 0;
	signed int adc_result = 0, reg_val = 0;
	struct pmic_auxadc_channel *auxadc_channel;
	u8 channel = AUXADC_LIST_BATTEMP;

	auxadc_channel =
		&mt6355_auxadc_channel[channel-AUXADC_LIST_MT6355_START];

	mt6355_auxadc_lock();
	mutex_lock(&auxadc_ch3_mutex);

	pmic_set_register_value(auxadc_channel->channel_rqst, 1);
	udelay(10);

	while (pmic_get_register_value(auxadc_channel->channel_rdy) != 1) {
		usleep_range(1300, 1500);
		if ((count++) > count_time_out) {
			pr_err("[%s] (%d) Time out!\n", __func__, channel);
			break;
		}
	}
	reg_val = pmic_get_register_value(auxadc_channel->channel_out);

	mutex_unlock(&auxadc_ch3_mutex);
	mt6355_auxadc_unlock();

	adc_result = (reg_val * auxadc_channel->r_val *
				VOLTAGE_FULL_RANGE) / 4096;

	pr_err("reg_val = 0x%x, adc_result = %d\n", reg_val, adc_result);

	return adc_result;
}

static int mt6355_auxadc_recv_batmp(void)
{
	int count = 0;
	signed int adc_result = 0, all_adc_result = 0;

	for (count = 0; count < 5; count++)
		all_adc_result += mt6355_auxadc_get_auxadc_value_batmp();

	if (all_adc_result < 1000) {
		pr_err("adc_recv_batmp\n");
		pmic_set_register_value(PMIC_RG_STRUP_AUXADC_RSTB_SW, 0);
		pmic_set_register_value(PMIC_RG_STRUP_AUXADC_RSTB_SW, 1);
		adc_result = mt6355_auxadc_get_auxadc_value_batmp();
		pr_err("adc_recv_batmp %d\n", adc_result);
		return adc_result;
	} else
		return (all_adc_result/5);
}
int mt6355_get_auxadc_value(u8 channel)
{
	int count = 0;
	signed int adc_result = 0, reg_val = 0;
	struct pmic_auxadc_channel *auxadc_channel;
	static DEFINE_RATELIMIT_STATE(ratelimit, 1 * HZ, 5);

	if (channel - AUXADC_LIST_MT6355_START < 0 ||
			channel - AUXADC_LIST_MT6355_END > 0) {
		pr_err("[%s] Invalid channel(%d)\n", __func__, channel);
		return -EINVAL;
	}
	auxadc_channel =
		&mt6355_auxadc_channel[channel-AUXADC_LIST_MT6355_START];

	if (channel == AUXADC_LIST_VBIF) {
		if (wk_auxadc_vsen_tdet_ctrl(1))
			return g_pmic_pad_vbif28_vol;
	}

	mt6355_auxadc_lock();

	if (channel == AUXADC_LIST_DCXO)
		pmic_set_register_value(PMIC_AUXADC_DCXO_CH4_MUX_AP_SEL, 1);
	if (channel == AUXADC_LIST_MT6355_CHIP_TEMP)
		pmic_set_register_value(PMIC_AUXADC_DCXO_CH4_MUX_AP_SEL, 0);
	if (channel == AUXADC_LIST_BATTEMP
		|| channel == AUXADC_LIST_BATID
		|| channel == AUXADC_LIST_VBIF) {
		if (!wk_auxadc_ch3_bif_on(2)) {
			pr_err("ch3 bif off abnormal\n");
			wk_auxadc_ch3_bif_on(1);
		}
		if (channel == AUXADC_LIST_BATTEMP) {
			if (!wk_auxadc_vsen_tdet_ctrl(1)) {
				pr_err("ch3 tdet ctrl abnormal\n");
				wk_auxadc_vsen_tdet_ctrl(0);
			}
			mutex_lock(&auxadc_ch3_mutex);
		}
	}

	pmic_set_register_value(auxadc_channel->channel_rqst, 1);
	udelay(10);

	while (pmic_get_register_value(auxadc_channel->channel_rdy) != 1) {
		usleep_range(1300, 1500);
		if ((count++) > count_time_out) {
			pr_err("[%s] (%d) Time out!\n", __func__, channel);
			break;
		}
	}
	reg_val = pmic_get_register_value(auxadc_channel->channel_out);

	if (channel == AUXADC_LIST_BATTEMP
		|| channel == AUXADC_LIST_BATID
		|| channel == AUXADC_LIST_VBIF) {
		if (channel == AUXADC_LIST_BATTEMP)
			mutex_unlock(&auxadc_ch3_mutex);
	}

	mt6355_auxadc_unlock();

	if (channel == AUXADC_LIST_VBIF)
		wk_auxadc_vsen_tdet_ctrl(0);

	if (auxadc_channel->resolution == 12)
		adc_result = (reg_val * auxadc_channel->r_val *
					VOLTAGE_FULL_RANGE) / 4096;
	else if (auxadc_channel->resolution == 15)
		adc_result = (reg_val * auxadc_channel->r_val *
					VOLTAGE_FULL_RANGE) / 32768;

	if (channel == AUXADC_LIST_BATTEMP) {
		if (adc_result > 2000 || adc_result < 300) {
			pr_err("[bif] %d\n", wk_auxadc_ch3_bif_on(2));
			pr_err("[baton] vsen_mux_en = %d, tdet_en = %d\n",
			pmic_get_register_value(PMIC_RG_ADCIN_VSEN_MUX_EN),
			pmic_get_register_value(PMIC_BATON_TDET_EN));
			if (adc_result < 200
				&& wk_auxadc_ch3_bif_on(2)
				&& wk_auxadc_vsen_tdet_ctrl(1))
				adc_result = mt6355_auxadc_recv_batmp();
		}
	}

	if (__ratelimit(&ratelimit))
		pr_err("[%s] ch = %d, reg_val = 0x%x, adc_result = %d\n",
					__func__, channel, reg_val, adc_result);

	/*--Monitor MTS Thread--*/
	if (channel == AUXADC_LIST_BATADC)
		wake_up_auxadc_detect();

	/* Audio request HPOPS to return raw data */
	if (channel == AUXADC_LIST_HPOFS_CAL)
		return reg_val * auxadc_channel->r_val;
	else
		return adc_result;
}

static unsigned int mts_count;
/*--Monitor MTS Thread Start--*/
void mt6355_auxadc_monitor_mts_regs(void)
{
	int mts_adc_tmp = 0;

	mts_adc_tmp = pmic_get_register_value(PMIC_AUXADC_ADC_OUT_MDRT);
	pr_debug("[MTS_ADC] OLD = 0x%x, NOW = 0x%x, CNT = %d\n"
		, mts_adc, mts_adc_tmp, mts_count);

	if (mts_adc ==  mts_adc_tmp)
		mts_count++;
	else
		mts_count = 0;

	if ((mts_count > 15)) {
		pr_err("DEW_READ_TEST = 0x%x\n"
			, pmic_get_register_value(PMIC_DEW_READ_TEST));
		/*--AUXADC MDRT--*/
		pr_err("AUXADC_ADC36  = 0x%x\n"
			, upmu_get_reg_value(MT6355_AUXADC_ADC36));
		pr_err("AUXADC_ADC42  = 0x%x\n"
			, upmu_get_reg_value(MT6355_AUXADC_ADC42));
		pr_err("AUXADC_MDRT_0 = 0x%x\n"
			, upmu_get_reg_value(MT6355_AUXADC_MDRT_0));
		pr_err("AUXADC_MDRT_1 = 0x%x\n"
			, upmu_get_reg_value(MT6355_AUXADC_MDRT_1));
		pr_err("AUXADC_MDRT_2 = 0x%x\n"
			, upmu_get_reg_value(MT6355_AUXADC_MDRT_2));
		pr_err("AUXADC_MDRT_3 = 0x%x\n"
			, upmu_get_reg_value(MT6355_AUXADC_MDRT_3));
		pr_err("AUXADC_MDRT_4 = 0x%x\n"
			, upmu_get_reg_value(MT6355_AUXADC_MDRT_4));
		/*--AUXADC SPI AVG SEL--*/
		pr_err("AUXADC_CON2  = 0x%x\n"
			, upmu_get_reg_value(MT6355_AUXADC_CON2));
		pr_err("AUXADC_CON5  = 0x%x\n"
			, upmu_get_reg_value(MT6355_AUXADC_CON5));
		pr_err("AUXADC_CON8  = 0x%x\n"
			, upmu_get_reg_value(MT6355_AUXADC_CON8));
		pr_err("AUXADC_CON9  = 0x%x\n"
			, upmu_get_reg_value(MT6355_AUXADC_CON9));
		/*--AUXADC CLK--*/
		pr_err("TOP_CKPDN_CON0  = 0x%x\n"
			, upmu_get_reg_value(MT6355_TOP_CKPDN_CON0));
		pr_err("TOP_CKHWEN_CON0 = 0x%x\n"
			, upmu_get_reg_value(MT6355_TOP_CKHWEN_CON0));
		pr_err("TOP_CKHWEN_CON1 = 0x%x\n"
			, upmu_get_reg_value(MT6355_TOP_CKHWEN_CON1));

		/*--AUXADC CH7--*/
		pr_err("AUXADC_LIST_TSX = %d\n"
			, mt6355_get_auxadc_value(AUXADC_LIST_TSX));
		mts_count = 0;
	}
	mts_adc = mts_adc_tmp;
}

int mt6355_auxadc_kthread(void *x)
{
	set_current_state(TASK_INTERRUPTIBLE);

	PMICLOG("mt6355 auxadc thread enter\n");

	/* Run on a process content */
	while (1) {
		mutex_lock(&adc_monitor_mutex);

		mt6355_auxadc_monitor_mts_regs();

		mutex_unlock(&adc_monitor_mutex);
		#ifdef WAKELOCK
		wake_unlock(&adc_monitor_wake_lock);
		#else
		__pm_relax(&adc_monitor_wake_lock);
		#endif

		set_current_state(TASK_INTERRUPTIBLE);
		schedule();
	}

	return 0;
}

void mt6355_auxadc_thread_init(void)
{
	adc_thread_handle
		= kthread_create(mt6355_auxadc_kthread
		, (void *)NULL, "adc_thread");
	if (IS_ERR(adc_thread_handle)) {
		adc_thread_handle = NULL;
		pr_err(PMICTAG "[adc_kthread] creation fails\n");
	} else {
		PMICLOG("[adc_kthread] kthread_create Done\n");
	}
}

/*--Monitor MTS Thread End--*/
void pmic_auxadc_init(struct regmap *map)
{
	pwrap_regmap = map;

	pr_err("%s\n", __func__);

	#ifdef WAKELOCK
	wake_lock_init(&mt6355_auxadc_wake_lock,
			WAKE_LOCK_SUSPEND, "MT6355 AuxADC wakelock");
	wake_lock_init(&adc_monitor_wake_lock,
			WAKE_LOCK_SUSPEND, "MT6355 AuxADC Monitor wakelock");
	#else
	wakeup_source_init(&mt6355_auxadc_wake_lock, "MT6355 AuxADC wakelock");
	wakeup_source_init(&adc_monitor_wake_lock
			   , "MT6355 AuxADC Monitor wakelock");
	#endif

	mutex_init(&mt6355_adc_mutex);
	mutex_init(&adc_monitor_mutex);

	/* set channel 0, 7 as 15 bits, others = 12 bits  000001000001*/
	pmic_set_register_value(PMIC_RG_STRUP_AUXADC_RSTB_SEL, 1);
	pmic_set_register_value(PMIC_RG_STRUP_AUXADC_RSTB_SW, 1);

	/* 4/11, Ricky, Remove initial setting due to MT6353 issue */
	/* pmic_set_register_value(PMIC_RG_STRUP_AUXADC_START_SEL, 1); */

	pmic_set_register_value(PMIC_AUXADC_MDBG_DET_EN, 0);
	pmic_set_register_value(PMIC_AUXADC_MDBG_DET_PRD, 0x40);
	pmic_set_register_value(PMIC_AUXADC_MDRT_DET_EN, 1);
	pmic_set_register_value(PMIC_AUXADC_MDRT_DET_PRD, 0x40);
	pmic_set_register_value(PMIC_AUXADC_MDRT_DET_WKUP_EN, 1);
	pmic_set_register_value(PMIC_AUXADC_MDRT_DET_SRCLKEN_IND, 0);
	pmic_set_register_value(PMIC_AUXADC_MDRT_DET_START_SEL, 1);
	pmic_set_register_value(PMIC_AUXADC_CK_AON, 0);
	pmic_set_register_value(PMIC_AUXADC_DATA_REUSE_SEL, 0);
	pmic_set_register_value(PMIC_AUXADC_DATA_REUSE_EN, 1);
	pmic_set_register_value(PMIC_AUXADC_TRIM_CH0_SEL, 0);
	/*IMP DCM WK Peter-SW 12/21--*/
	pmic_config_interface(0x3370, 0x1, 0x1, 0);

	mt6355_auxadc_thread_init();

	pr_info("****[%s] DONE\n", __func__);

	/* update VBIF28 by AUXADC */
	g_pmic_pad_vbif28_vol = mt6355_get_auxadc_value(AUXADC_LIST_VBIF);
	/* update TSX by AUXADC */
	mts_adc = pmic_get_register_value(PMIC_AUXADC_ADC_OUT_MDRT);
	/* pr_info("****[%s] VBIF28 = %d
	 * , MTS_ADC = 0x%x\n", __func__, pmic_get_vbif28_volt(), mts_adc);
	 */
}
EXPORT_SYMBOL(pmic_auxadc_init);

#define MT6355_AUXADC_DEBUG(_reg)                                       \
{                                                                       \
	value = pmic_get_register_value(_reg);				\
	snprintf(buf+strlen(buf), 1024, "%s = 0x%x\n", #_reg, value);	\
	pr_err("[%s] %s = 0x%x\n", __func__, #_reg,			\
		pmic_get_register_value(_reg));			\
}

void mt6355_auxadc_dump_regs(char *buf)
{
	int value;

	snprintf(buf+strlen(buf), 1024, "====| %s |====\n", __func__);
	MT6355_AUXADC_DEBUG(PMIC_RG_STRUP_AUXADC_RSTB_SEL);
	MT6355_AUXADC_DEBUG(PMIC_RG_STRUP_AUXADC_RSTB_SW);
	MT6355_AUXADC_DEBUG(PMIC_RG_STRUP_AUXADC_START_SEL);
	MT6355_AUXADC_DEBUG(PMIC_AUXADC_MDRT_DET_EN);
	MT6355_AUXADC_DEBUG(PMIC_AUXADC_MDRT_DET_PRD);
	MT6355_AUXADC_DEBUG(PMIC_AUXADC_MDRT_DET_WKUP_EN);
	MT6355_AUXADC_DEBUG(PMIC_AUXADC_MDRT_DET_SRCLKEN_IND);
	MT6355_AUXADC_DEBUG(PMIC_AUXADC_CK_AON);
	MT6355_AUXADC_DEBUG(PMIC_AUXADC_DATA_REUSE_SEL);
	MT6355_AUXADC_DEBUG(PMIC_AUXADC_DATA_REUSE_EN);
	MT6355_AUXADC_DEBUG(PMIC_AUXADC_TRIM_CH0_SEL);
}
EXPORT_SYMBOL(mt6355_auxadc_dump_regs);

int pmic_get_auxadc_value(u8 list)
{
	int value = 0;

	if (list <= AUXADC_LIST_MT6355_END) {
		value = mt6355_get_auxadc_value(list);
		return value;
	}
	return -EINVAL;
}

void pmic_auxadc_dump_regs(char *buf)
{
	snprintf(buf+strlen(buf), 1024, "====%s====\n", __func__);
	mt6355_auxadc_dump_regs(buf);
}



