#ifndef __VPUSYS_CORE_CONFIG_REG_H__
#define __VPUSYS_CORE_CONFIG_REG_H__

/* ----------------- Register Definitions ------------------- */
#define VPU_CG_CON					0x00000000
	#define VPU_CG_CON_VPU_CG			BIT(0)
	#define VPU_CG_CON_AXI_M_CG			BIT(1)
	#define VPU_CG_CON_JTAG_CG			BIT(2)
#define VPU_CG_SET					0x00000004
	#define VPU_CG_SET_VPU_CG_SET			BIT(0)
	#define VPU_CG_SET_AXI_M_CG_SET			BIT(1)
	#define VPU_CG_SET_JTAG_CG_SET			BIT(2)
#define VPU_CG_CLR					0x00000008
	#define VPU_CG_CLR_VPU_CG_CLR			BIT(0)
	#define VPU_CG_CLR_AXI_M_CG_CLR			BIT(1)
	#define VPU_CG_CLR_JTAG_CG_CLR			BIT(2)
/* #define VPU_RESET					IVP_SW_RESET */
	#define VPU_B_RST				BIT(4)
	#define VPU_D_RST				BIT(8)
	#define VPU_OCD_HALT_ON_RST			BIT(12)
#define VPU_MBIST_MODE					0x00000010
	#define VPU_MBIST_MODE_VPU_MBIST_MODE		GENMASK(8, 0)
#define VPU_MBIST_CTL					0x00000014
	#define VPU_MBIST_CTL_VPU_MBIST_BSEL		GENMASK(16, 0)
	#define VPU_MBIST_CTL_VPU_MBIST_BACKGROUND	GENMASK(19, 17)
	#define VPU_MBIST_CTL_VPU_MBIST_RSTB		BIT(20)
#define VPU_MBIST_RP_OK_0				0x00000018
	#define VPU_MBIST_RP_OK_0_VPU_MBIST_RP_OK_0	GENMASK(31, 0)
#define VPU_MBIST_RP_OK_1				0x0000001c
	#define VPU_MBIST_RP_OK_1_VPU_MBIST_RP_OK_1	GENMASK(10, 0)
#define VPU_MBIST_RP_FAIL_0				0x00000024
	#define VPU_MBIST_RP_FAIL_0_VPU_MBIST_RP_FAIL_0	GENMASK(31, 0)
#define VPU_MBIST_RP_FAIL_1				0x00000028
	#define VPU_MBIST_RP_FAIL_1_VPU_MBIST_RP_FAIL_1	GENMASK(12, 0)
#define VPU_MBIST_FAIL_0				0x00000030
	#define VPU_MBIST_FAIL_0_VPU_MBIST_FAIL_0	GENMASK(31, 0)
#define VPU_MBIST_FAIL_1				0x00000034
	#define VPU_MBIST_FAIL_1_VPU_MBIST_FAIL_1	GENMASK(17, 0)
#define VPU_MBIST_DONE					0x0000003c
	#define VPU_MBIST_DONE_VPU_MBIST_DONE		GENMASK(8, 0)
#define VPU_SRAM_DELSEL_0				0x00000040
	#define VPU_SRAM_DELSEL_0_VPU_SRAM_DELSEL_0	GENMASK(31, 0)
#define VPU_SRAM_DELSEL_1				0x00000044
	#define VPU_SRAM_DELSEL_1_VPU_SRAM_DELSEL_1	GENMASK(31, 0)
#define VPU_SRAM_DELSEL_2				0x00000048
	#define VPU_SRAM_DELSEL_2_VPU_SRAM_DELSEL_2	GENMASK(31, 0)
#define VPU_RP_RSTB					0x0000004c
	#define VPU_RP_RSTB_VPU_RP_RSTB			BIT(0)
#define VPU_RP_CON					0x00000050
	#define VPU_RP_CON_VPU_RP_LOAD_FUSE		BIT(0)
	#define VPU_RP_CON_VPU_RP_FUSE_SEL		BIT(1)
#define VPU_RP_PRE_FUSE					0x00000054
	#define VPU_RP_PRE_FUSE_VPU_RP_PRE_FUSE_1	GENMASK(6, 0)
	#define VPU_RP_PRE_FUSE_VPU_RP_PRE_FUSE_2	GENMASK(12, 7)
	#define VPU_RP_PRE_FUSE_VPU_RP_PRE_FUSE_3	GENMASK(18, 13)
	#define VPU_RP_PRE_FUSE_VPU_DMEM_GP1_PD_ACK	BIT(19)
#define VPU_SLEEP_SRAM_CTL				0x00000058
	#define VPU_SLEEP_SRAM_CTL_VPU_SRAM_HDEN	BIT(0)
	#define VPU_SLEEP_SRAM_CTL_VPU_SRAM_SLEEP_TEST	BIT(1)
	#define VPU_SLEEP_SRAM_CTL_VPU_SRAM_SLEEP_INV	BIT(2)
	#define VPU_SLEEP_SRAM_CTL_VPU_SRAM_SLEEP_R	GENMASK(4, 3)
	#define VPU_SLEEP_SRAM_CTL_VPU_SRAM_SLEEP_W	GENMASK(6, 5)
	#define VPU_SLEEP_SRAM_CTL_VPU_DMEM_GP1_PD_COND	GENMASK(8, 7)
#define VPU_SRAM_CS_CTL					0x0000005c
	#define VPU_SRAM_CS_CTL_VPU_SRAM_CS_MODE	GENMASK(1, 0)
	#define VPU_SRAM_CS_CTL_VPU_SRAM_CS_RISE_T	GENMASK(4, 2)
	#define VPU_SRAM_CS_CTL_VPU_SRAM_CS_FALL_T	GENMASK(7, 5)
	#define VPU_SRAM_CS_CTL_VPU_DMEM_GP1_PD		BIT(16)
#define VPU_MBIST_DEFAULT_DELSEL			0x00000060
	#define VPU_MBIST_DEFAULT_DELSEL_VPU_MBIST_DEFAULT_DELSEL	BIT(0)
#define VPU_DONE_ST					0x0000010c
	#define VPU_DONE_ST_XOCDMODE			BIT(4)
	#define VPU_DONE_ST_PWAITMODE			BIT(7)
#define VPU_CTRL					0x00000110
	#define BUS_PIF_GATED				BIT(17)
	#define STAT_VECTOR_SEL				BIT(19)
	#define RUN_STALL				BIT(23)
	#define PCLK_GATED_EN				BIT(25)
	#define PBCLK_EN				BIT(26)
	#define P_DEBUG_ENABLE				BIT(31)
#define VPU_XTENSA_INT					0x00000114
	#define VPU_XTENSA_INT_APMCU_INT		BIT(0)
#define VPU_CTL_XTENSA_INT				0x00000118
	#define VPU_CTL_XTENSA_INT_CTL_INT_0		BIT(0)
	#define VPU_CTL_XTENSA_INT_CTL_INT_1		BIT(1)
	#define VPU_CTL_XTENSA_INT_CTL_INT_2		BIT(2)
	#define VPU_CTL_XTENSA_INT_CTL_INT_3		BIT(3)
	#define VPU_CTL_XTENSA_INT_CTL_INT_4		BIT(4)
	#define VPU_CTL_XTENSA_INT_CTL_INT_5		BIT(5)
	#define VPU_CTL_XTENSA_INT_CTL_INT_6		BIT(6)
	#define VPU_CTL_XTENSA_INT_CTL_INT_7		BIT(7)
	#define VPU_CTL_XTENSA_INT_CTL_INT_8		BIT(8)
	#define VPU_CTL_XTENSA_INT_CTL_INT_9		BIT(9)
	#define VPU_CTL_XTENSA_INT_CTL_INT_10		BIT(10)
	#define VPU_CTL_XTENSA_INT_CTL_INT_11		BIT(11)
	#define VPU_CTL_XTENSA_INT_CTL_INT_12		BIT(12)
	#define VPU_CTL_XTENSA_INT_CTL_INT_13		BIT(13)
	#define VPU_CTL_XTENSA_INT_CTL_INT_14		BIT(14)
	#define VPU_CTL_XTENSA_INT_CTL_INT_15		BIT(15)
	#define VPU_CTL_XTENSA_INT_CTL_INT_16		BIT(16)
	#define VPU_CTL_XTENSA_INT_CTL_INT_17		BIT(17)
	#define VPU_CTL_XTENSA_INT_CTL_INT_18		BIT(18)
	#define VPU_CTL_XTENSA_INT_CTL_INT_19		BIT(19)
	#define VPU_CTL_XTENSA_INT_CTL_INT_20		BIT(20)
	#define VPU_CTL_XTENSA_INT_CTL_INT_21		BIT(21)
	#define VPU_CTL_XTENSA_INT_CTL_INT_22		BIT(22)
#define VPU_CTL_XTENSA_INT_CLR				0x0000011c
	#define VPU_CTL_XTENSA_INT_CLR_CTL_INT_CLR_0	BIT(0)
	#define VPU_CTL_XTENSA_INT_CLR_CTL_INT_CLR_1	BIT(1)
	#define VPU_CTL_XTENSA_INT_CLR_CTL_INT_CLR_2	BIT(2)
	#define VPU_CTL_XTENSA_INT_CLR_CTL_INT_CLR_3	BIT(3)
	#define VPU_CTL_XTENSA_INT_CLR_CTL_INT_CLR_4	BIT(4)
	#define VPU_CTL_XTENSA_INT_CLR_CTL_INT_CLR_5	BIT(5)
	#define VPU_CTL_XTENSA_INT_CLR_CTL_INT_CLR_6	BIT(6)
	#define VPU_CTL_XTENSA_INT_CLR_CTL_INT_CLR_7	BIT(7)
	#define VPU_CTL_XTENSA_INT_CLR_CTL_INT_CLR_8	BIT(8)
	#define VPU_CTL_XTENSA_INT_CLR_CTL_INT_CLR_9	BIT(9)
	#define VPU_CTL_XTENSA_INT_CLR_CTL_INT_CLR_10	BIT(10)
	#define VPU_CTL_XTENSA_INT_CLR_CTL_INT_CLR_11	BIT(11)
	#define VPU_CTL_XTENSA_INT_CLR_CTL_INT_CLR_16	BIT(16)
	#define VPU_CTL_XTENSA_INT_CLR_CTL_INT_CLR_17	BIT(17)
	#define VPU_CTL_XTENSA_INT_CLR_CTL_INT_CLR_20	BIT(20)
#define VPU_INT_MASK					0x0000012c
	#define VPU_INT_MASK_CTL_INT_MASK		GENMASK(22, 0)
	#define VPU_INT_MASK_APMCU_INT_MASK		BIT(23)
	#define VPU_INT_MASK_IPU2CAM_INT_MASK		BIT(24)
#define VPU_AXI_DEFAULT0				0x0000013c   /* add */
	#define AW_USER_IDMA_8_4			GENMASK(12, 8)
	#define AR_USER_IDMA_8_4			GENMASK(17, 13)
	#define AW_USER_CORE_8_4			GENMASK(24, 20)
	#define AR_USER_CORE_8_4			GENMASK(29, 25)
/* VPU_DEFAULT2 rename to VPU_AXI_DEFAULT3 */
#define VPU_AXI_DEFAULT3				0x00000144
	#define SPIDEN					BIT(0)
	#define SPNIDEN					BIT(1)
	#define NIDEN					BIT(2)
	#define DBG_EN					BIT(3)
#define VPU_XTENSA_INFO00				0x00000150
	#define VPU_XTENSA_INFO00_VPU_XTENSA_INFO00	GENMASK(31, 0)
#define VPU_XTENSA_INFO01				0x00000154
	#define VPU_XTENSA_INFO01_VPU_XTENSA_INFO01	GENMASK(31, 0)
#define VPU_XTENSA_INFO02				0x00000158
	#define VPU_XTENSA_INFO02_VPU_XTENSA_INFO02	GENMASK(31, 0)
#define VPU_XTENSA_INFO03				0x0000015c
	#define VPU_XTENSA_INFO03_VPU_XTENSA_INFO03	GENMASK(31, 0)
#define VPU_XTENSA_INFO04				0x00000160
	#define VPU_XTENSA_INFO04_VPU_XTENSA_INFO04	GENMASK(31, 0)
#define VPU_XTENSA_INFO05				0x00000164
	#define VPU_XTENSA_INFO05_VPU_XTENSA_INFO05	GENMASK(31, 0)
#define VPU_XTENSA_INFO06				0x00000168
	#define VPU_XTENSA_INFO06_VPU_XTENSA_INFO06	GENMASK(31, 0)
#define VPU_XTENSA_INFO07				0x0000016c
	#define VPU_XTENSA_INFO07_VPU_XTENSA_INFO07	GENMASK(31, 0)
#define VPU_XTENSA_INFO08				0x00000170
	#define VPU_XTENSA_INFO08_VPU_XTENSA_INFO08	GENMASK(31, 0)
#define VPU_XTENSA_INFO09				0x00000174
	#define VPU_XTENSA_INFO09_VPU_XTENSA_INFO09	GENMASK(31, 0)
#define VPU_XTENSA_INFO10				0x00000178
	#define VPU_XTENSA_INFO10_VPU_XTENSA_INFO10	GENMASK(31, 0)
#define VPU_XTENSA_INFO11				0x0000017c
	#define VPU_XTENSA_INFO11_VPU_XTENSA_INFO11	GENMASK(31, 0)
#define VPU_XTENSA_INFO12				0x00000180
	#define VPU_XTENSA_INFO12_VPU_XTENSA_INFO12	GENMASK(31, 0)
#define VPU_XTENSA_INFO13				0x00000184
	#define VPU_XTENSA_INFO13_VPU_XTENSA_INFO13	GENMASK(31, 0)
#define VPU_XTENSA_INFO14				0x00000188
	#define VPU_XTENSA_INFO14_VPU_XTENSA_INFO14	GENMASK(31, 0)
#define VPU_XTENSA_INFO15				0x0000018c
	#define VPU_XTENSA_INFO15_VPU_XTENSA_INFO15	GENMASK(31, 0)
#define VPU_XTENSA_INFO16				0x00000190
	#define VPU_XTENSA_INFO16_VPU_XTENSA_INFO16	GENMASK(31, 0)
#define VPU_XTENSA_INFO17				0x00000194
	#define VPU_XTENSA_INFO17_VPU_XTENSA_INFO17	GENMASK(31, 0)
#define VPU_XTENSA_INFO18				0x00000198
	#define VPU_XTENSA_INFO18_VPU_XTENSA_INFO18	GENMASK(31, 0)
#define VPU_XTENSA_INFO19				0x0000019c
	#define VPU_XTENSA_INFO19_VPU_XTENSA_INFO19	GENMASK(31, 0)
#define VPU_XTENSA_INFO20				0x000001a0
	#define VPU_XTENSA_INFO20_VPU_XTENSA_INFO20	GENMASK(31, 0)
#define VPU_XTENSA_INFO21				0x000001a4
	#define VPU_XTENSA_INFO21_VPU_XTENSA_INFO21	GENMASK(31, 0)
#define VPU_XTENSA_INFO22				0x000001a8
	#define VPU_XTENSA_INFO22_VPU_XTENSA_INFO22	GENMASK(31, 0)
#define VPU_XTENSA_INFO23				0x000001ac
	#define VPU_XTENSA_INFO23_VPU_XTENSA_INFO23	GENMASK(31, 0)
#define VPU_XTENSA_INFO24				0x000001b0
	#define VPU_XTENSA_INFO24_VPU_XTENSA_INFO24	GENMASK(31, 0)
#define VPU_XTENSA_INFO25				0x000001b4
	#define VPU_XTENSA_INFO25_VPU_XTENSA_INFO25	GENMASK(31, 0)
#define VPU_XTENSA_INFO26				0x000001b8
	#define VPU_XTENSA_INFO26_VPU_XTENSA_INFO26	GENMASK(31, 0)
#define VPU_XTENSA_INFO27				0x000001bc
	#define VPU_XTENSA_INFO27_VPU_XTENSA_INFO27	GENMASK(31, 0)
#define VPU_XTENSA_INFO28				0x000001c0
	#define VPU_XTENSA_INFO28_VPU_XTENSA_INFO28	GENMASK(31, 0)
#define VPU_XTENSA_INFO29				0x000001c4
	#define VPU_XTENSA_INFO29_VPU_XTENSA_INFO29	GENMASK(31, 0)
#define VPU_XTENSA_INFO30				0x000001c8
	#define VPU_XTENSA_INFO30_VPU_XTENSA_INFO30	GENMASK(31, 0)
#define VPU_XTENSA_INFO31				0x000001cc
	#define VPU_XTENSA_INFO31_VPU_XTENSA_INFO31	GENMASK(31, 0)
#define VPU_DEBUG_INFO00				0x000001d0
	#define VPU_DEBUG_INFO000_P_DEBUG_DATA		GENMASK(31, 0)
#define VPU_DEBUG_INFO01				0x000001d4
	#define VPU_DEBUG_INFO001_P_DEBUG_INB_PIF	GENMASK(7, 0)
	#define VPU_DEBUG_INFO001_P_DEBUG_STATUS	GENMASK(23, 16)
	#define VPU_DEBUG_INFO001_RESERVED_0		GENMASK(31, 24)
#define VPU_DEBUG_INFO02				0x000001d8
	#define VPU_DEBUG_INFO002_P_DEBUG_INST		GENMASK(31, 0)
#define VPU_DEBUG_INFO03				0x000001dc
	#define VPU_DEBUG_INFO003_P_DEBUG_LS0_STAT	GENMASK(31, 0)
#define VPU_DEBUG_INFO04				0x000001e0
	#define VPU_DEBUG_INFO004_P_DEBUG_LS1_STAT	GENMASK(31, 0)
#define VPU_DEBUG_INFO05				0x000001e4
	#define VPU_DEBUG_INFO005_P_DEBUG_PC		GENMASK(31, 0)
#define VPU_XTENSA_ALTRESETVEC				0x000001f8
	#define VPU_XTENSA_ALTRESETVEC_VPU_XTENSA_ALTRESETVEC	GENMASK(31, 0)

#endif /*__VPUSYS_VPU_CONFIG_REG_H__*/
