/*
 * Copyright (c) 2018 MediaTek Inc.
 * Authors:
 *	leon liang <leon.liang@mediatek.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/**
 * @file mtk_wdma_reg.h
 * Register definition header of mtk_wdma.c
 */

#ifndef __MTK_WDMA_REG_H__
#define __MTK_WDMA_REG_H__

/* ----------------- Register Definitions ------------------- */
#define WDMA_INTEN					0x00000000
	#define FRAME_COMPLETE_EN			BIT(0)
	#define FRAME_UNDERRUN_EN			BIT(1)
	#define FIFO_FULL_INT_EN			BIT(2)
	#define TARGET_LINE_INT_EN			BIT(3)
#define WDMA_INTSTA					0x00000004
	#define FRAME_COMPLETE_STA			BIT(0)
	#define FRAME_UNDERRUN_STA			BIT(1)
	#define FIFO_FULL_INT_STA			BIT(2)
	#define TARGET_LINE_INT_STA			BIT(3)
#define WDMA_EN						0x00000008
	#define ENABLE					BIT(0)
	#define BYPASS_SHADOW				BIT(1)
	#define READ_SHADOW_REG				BIT(3)
	#define SOF_RESET_DISABLE			BIT(4)
	#define INPUT_CRC_ENABLE			BIT(8)
	#define INPUT_CRC_RESET				BIT(9)
	#define OUTPUT_CRC_ENABLE			BIT(10)
	#define OUTPUT_CRC_RESET			BIT(11)
	#define PVRIC_EN				BIT(16)
	#define INTERNAL_GLOBAL_CG_DISABLE		BIT(30)
	#define INTERNAL_CG_DISABLE			BIT(31)
#define WDMA_RST					0x0000000c
	#define SOFT_RESET				BIT(0)
#define WDMA_SMI_CON					0x00000010
	#define THRESHOLD				GENMASK(3, 0)
	#define SMI_Y_REPEAT_NUM			GENMASK(19, 16)
	#define SMI_U_REPEAT_NUM			GENMASK(23, 20)
	#define SMI_V_REPEAT_NUM			GENMASK(27, 24)
	#define SMI_OBUF_FULL_REQ			BIT(28)
#define WDMA_CFG					0x00000014
	#define OUT_FORMAT				GENMASK(7, 4)
	#define BYTE_SWAP				BIT(8)
	#define RGB_SWAP				BIT(9)
	#define UV_SWAP					BIT(10)
	#define CT_EN					BIT(11)
	#define VERTICAL_AVG				BIT(12)
	#define EXT_MTX_EN				BIT(13)
	#define DNSP_SEL				BIT(15)
	#define SWAP					BIT(16)
	#define UNI_CONFIG				BIT(17)
	#define YUV444_OUT				BIT(18)
	#define OVERFLOW_EN				BIT(19)
	#define TDLR_EN					BIT(20)
	#define SWAP_3DLR_ADDR				BIT(21)
	#define INT_MTX_SEL				GENMASK(27, 24)
	#define DEBUG_SEL				GENMASK(31, 28)
#define WDMA_SRC_SIZE					0x00000018
	#define WIDTH					GENMASK(13, 0)
	#define HEIGHT					GENMASK(29, 16)
#define WDMA_CLIP_SIZE					0x0000001c
	#define WIDTH					GENMASK(13, 0)
	#define HEIGHT					GENMASK(29, 16)
#define WDMA_CLIP_COORD					0x00000020
	#define X_COORD					GENMASK(13, 0)
	#define Y_COORD					GENMASK(29, 16)
#define WDMA_DST_W_IN_BYTE				0x00000028
	#define DST_W_IN_BYTE				GENMASK(15, 0)
#define WDMA_ALPHA					0x0000002c
	#define A_VALUE					GENMASK(7, 0)
	#define A_SEL					BIT(31)
#define WDMA_BUF_CON1					0x00000038
	#define FIFO_PSEUDO_SIZE			GENMASK(10, 0)
	#define ROW_UPDATE_SWAP				GENMASK(18, 16)
	#define ROW_UPDATE_WRSP_SWAP			GENMASK(22, 20)
	#define ROW_UPDATE_WRSP_FOR_TS_SWAP		GENMASK(26, 24)
	#define FRAME_END_ULTRA				BIT(28)
	#define PRE_ULTRA_ENABLE			BIT(30)
	#define ULTRA_ENABLE				BIT(31)
#define WDMA_C00					0x00000040
	#define C00					GENMASK(14, 0)
	#define C01					GENMASK(30, 16)
#define WDMA_C02					0x00000044
	#define C02					GENMASK(14, 0)
#define WDMA_C10					0x00000048
	#define C10					GENMASK(14, 0)
	#define C11					GENMASK(30, 16)
#define WDMA_C12					0x0000004c
	#define C12					GENMASK(14, 0)
#define WDMA_C20					0x00000050
	#define C20					GENMASK(14, 0)
	#define C21					GENMASK(30, 16)
#define WDMA_C22					0x00000054
	#define C22					GENMASK(14, 0)
#define WDMA_PRE_ADD0					0x00000058
	#define PRE_ADD_0				GENMASK(10, 0)
	#define PRE_ADD_1				GENMASK(26, 16)
#define WDMA_PRE_ADD2					0x0000005c
	#define PRE_ADD_2				GENMASK(10, 0)
#define WDMA_POST_ADD0					0x00000060
	#define POST_ADD_0				GENMASK(10, 0)
	#define POST_ADD_1				GENMASK(26, 16)
#define WDMA_POST_ADD2					0x00000064
	#define POST_ADD_2				GENMASK(10, 0)
#define WDMA_DST_UV_PITCH				0x00000078
	#define UV_DST_W_IN_BYTE			GENMASK(15, 0)
#define WDMA_DST_ADDR_OFFSET0				0x00000080
	#define WDMA_DESTINATION_ADDRESS_OFFSET0	GENMASK(27, 0)
#define WDMA_DST_ADDR_OFFSET1				0x00000084
	#define WDMA_DESTINATION_ADDRESS_OFFSET1	GENMASK(27, 0)
#define WDMA_DST_ADDR_OFFSET2				0x00000088
	#define WDMA_DESTINATION_ADDRESS_OFFSET2	GENMASK(27, 0)
#define WDMA_DST_ADDR_OFFSET0_TDLR			0x0000008c
	#define WDMA_DESTINATION_ADDRESS_OFFSET0_TDLR	GENMASK(27, 0)
#define WDMA_FLOW_CTRL_DBG				0x000000a0
	#define WDMA_STATE				GENMASK(9, 0)
	#define WDMA_FIFO_FULL				BIT(12)
	#define WDMA_GREQ				BIT(13)
	#define WDMA_IN_READY				BIT(14)
	#define WDMA_IN_REQ				BIT(15)
	#define FRAME_COMPLETE				BIT(16)
	#define FRAME_UNDERRUN				BIT(17)
	#define BUF_RENG_DATA_BUSY			BIT(20)
	#define SRAM_BUSY				BIT(21)
	#define BUF_WENG_BUSY				BIT(22)
	#define CT_BUSY					BIT(25)
	#define CLIP_BUSY				BIT(26)
	#define SMI_DATA_BUSY				BIT(28)
	#define SMI_CMD_BUSY				BIT(29)
	#define IDLE_ST					BIT(31)
#define WDMA_EXEC_DBG					0x000000a4
	#define WDMA_FRAME_RUN_CNT			GENMASK(5, 0)
	#define WDMA_FRAME_COMPLETE_CNT			GENMASK(21, 16)
#define WDMA_CT_DBG					0x000000a8
	#define WDMA_INPUT_CNT_X			GENMASK(13, 0)
	#define WDMA_INPUT_CNT_Y			GENMASK(29, 16)
#define WDMA_SMI_TRAFFIC_DBG				0x000000ac
	#define WDMA_SMI_TRAFFIC			GENMASK(31, 0)
#define WDMA_DEBUG					0x000000b8
	#define WDMA_STA_DEBUG				GENMASK(31, 0)
#define WDMA_DEBUG1					0x000000bc
	#define WDMA_STA_DEBUG1				GENMASK(31, 0)
#define WDMA_DEBUG2					0x000000c0
	#define WDMA_STA_DEBUG2				GENMASK(31, 0)
#define WDMA_DUMMY					0x00000100
	#define WDMA_ALPHA_MASK_EN			BIT(0)
	#define WDMA_DUMMY_0				GENMASK(31, 1)
#define WDMA_BUF_CON3					0x00000104
	#define WDMA_ISSUE_REQ_TH_Y			GENMASK(8, 0)
	#define WDMA_ISSUE_REQ_TH_U			GENMASK(24, 16)
#define WDMA_BUF_CON4					0x00000108
	#define WDMA_ISSUE_REQ_TH_V			GENMASK(8, 0)
#define WDMA_SMI_CON1					0x0000010c
	#define MASK_DIS				BIT(0)
#define WDMA_TARGET_LINE				0x00000110
	#define TARGET_LINE				GENMASK(13, 0)
#define WDMA_BUF_CON5					0x00000200
	#define WDMA_PRE_ULTRA_LOW_Y			GENMASK(9, 0)
	#define WDMA_PRE_ULTRA_LOW_Y_REDUNDANT		GENMASK(15, 10)
	#define WDMA_ULTRA_LOW_Y			GENMASK(25, 16)
	#define WDMA_ULTRA_LOW_Y_REDUNDANT		GENMASK(31, 26)
#define WDMA_BUF_CON6					0x00000204
	#define WDMA_PRE_ULTRA_HIGH_Y			GENMASK(9, 0)
	#define WDMA_PRE_ULTRA_HIGH_Y_REDUNDANT		GENMASK(15, 10)
	#define WDMA_ULTRA_HIGH_Y			GENMASK(25, 16)
	#define WDMA_ULTRA_HIGH_Y_REDUNDANT		GENMASK(31, 26)
#define WDMA_BUF_CON7					0x00000208
	#define WDMA_PRE_ULTRA_LOW_U			GENMASK(9, 0)
	#define WDMA_PRE_ULTRA_LOW_U_REDUNDANT		GENMASK(15, 10)
	#define WDMA_ULTRA_LOW_U			GENMASK(25, 16)
	#define WDMA_ULTRA_LOW_U_REDUNDANT		GENMASK(31, 26)
#define WDMA_BUF_CON8					0x0000020c
	#define WDMA_PRE_ULTRA_HIGH_U			GENMASK(9, 0)
	#define WDMA_PRE_ULTRA_HIGH_U_REDUNDANT		GENMASK(15, 10)
	#define WDMA_ULTRA_HIGH_U			GENMASK(25, 16)
	#define WDMA_ULTRA_HIGH_U_REDUNDANT		GENMASK(31, 26)
#define WDMA_BUF_CON9					0x00000210
	#define WDMA_PRE_ULTRA_LOW_V			GENMASK(9, 0)
	#define WDMA_PRE_ULTRA_LOW_V_REDUNDANT		GENMASK(15, 10)
	#define WDMA_ULTRA_LOW_V			GENMASK(25, 16)
	#define WDMA_ULTRA_LOW_V_REDUNDANT		GENMASK(31, 26)
#define WDMA_BUF_CON10					0x00000214
	#define WDMA_PRE_ULTRA_HIGH_V			GENMASK(9, 0)
	#define WDMA_PRE_ULTRA_HIGH_V_REDUNDANT		GENMASK(15, 10)
	#define WDMA_ULTRA_HIGH_V			GENMASK(25, 16)
	#define WDMA_ULTRA_HIGH_V_REDUNDANT		GENMASK(31, 26)
#define WDMA_BUF_CON11					0x00000218
	#define WDMA_PRE_ULTRA_LOW_Y_DVFS		GENMASK(9, 0)
	#define WDMA_PRE_ULTRA_LOW_Y_DVFS_REDUNDANT	GENMASK(15, 10)
	#define WDMA_ULTRA_LOW_Y_DVFS			GENMASK(25, 16)
	#define WDMA_ULTRA_LOW_Y_DVFS_REDUNDANT		GENMASK(31, 26)
#define WDMA_BUF_CON12					0x0000021c
	#define WDMA_PRE_ULTRA_HIGH_Y_DVFS		GENMASK(9, 0)
	#define WDMA_PRE_ULTRA_HIGH_Y_DVFS_REDUNDANT	GENMASK(15, 10)
	#define WDMA_ULTRA_HIGH_Y_DVFS			GENMASK(25, 16)
	#define WDMA_ULTRA_HIGH_Y_DVFS_REDUNDANT	GENMASK(31, 26)
#define WDMA_BUF_CON13					0x00000220
	#define WDMA_PRE_ULTRA_LOW_Y_DVFS		GENMASK(9, 0)
	#define WDMA_PRE_ULTRA_LOW_Y_DVFS_REDUNDANT	GENMASK(15, 10)
	#define WDMA_ULTRA_LOW_Y_DVFS			GENMASK(25, 16)
	#define WDMA_ULTRA_LOW_Y_DVFS_REDUNDANT		GENMASK(31, 26)
#define WDMA_BUF_CON14					0x00000224
	#define WDMA_PRE_ULTRA_HIGH_Y_DVFS		GENMASK(9, 0)
	#define WDMA_PRE_ULTRA_HIGH_Y_DVFS_REDUNDANT	GENMASK(15, 10)
	#define WDMA_ULTRA_HIGH_Y_DVFS			GENMASK(25, 16)
	#define WDMA_ULTRA_HIGH_Y_DVFS_REDUNDANT	GENMASK(31, 26)
#define WDMA_BUF_CON15					0x00000228
	#define WDMA_PRE_ULTRA_LOW_Y_DVFS		GENMASK(9, 0)
	#define WDMA_PRE_ULTRA_LOW_Y_DVFS_REDUNDANT	GENMASK(15, 10)
	#define WDMA_ULTRA_LOW_Y_DVFS			GENMASK(25, 16)
	#define WDMA_ULTRA_LOW_Y_DVFS_REDUNDANT		GENMASK(31, 26)
#define WDMA_BUF_CON16					0x0000022c
	#define WDMA_PRE_ULTRA_HIGH_Y_DVFS		GENMASK(9, 0)
	#define WDMA_PRE_ULTRA_HIGH_Y_DVFS_REDUNDANT	GENMASK(15, 10)
	#define WDMA_ULTRA_HIGH_Y_DVFS			GENMASK(25, 16)
	#define WDMA_ULTRA_HIGH_Y_DVFS_REDUNDANT	GENMASK(31, 26)
#define WDMA_BUF_CON17					0x00000230
	#define WDMA_DVFS_EN				BIT(0)
	#define WDMA_DVFS_EN_REDUNDANT			GENMASK(15, 1)
	#define WDMA_DVFS_TH_Y				GENMASK(25, 16)
	#define WDMA_DVFS_TH_Y_REDUNDANT		GENMASK(31, 26)
#define WDMA_BUF_CON18					0x00000234
	#define WDMA_DVFS_TH_U				GENMASK(9, 0)
	#define WDMA_DVFS_TH_U_REDUNDANT		GENMASK(15, 10)
	#define WDMA_DVFS_TH_V				GENMASK(25, 16)
	#define WDMA_DVFS_TH_V_REDUNDANT		GENMASK(31, 26)
#define WDMA_DRS_CON0					0x00000250
	#define WDMA_DRS_EN				BIT(0)
	#define WDMA_ENTER_DRS_TH_Y			GENMASK(25, 16)
#define WDMA_DRS_CON1					0x00000254
	#define WDMA_ENTER_DRS_TH_U			GENMASK(9, 0)
	#define WDMA_ENTER_DRS_TH_V			GENMASK(25, 16)
#define WDMA_DRS_CON2					0x00000258
	#define WDMA_LEAVE_DRS_TH_Y			GENMASK(25, 16)
#define WDMA_DRS_CON3					0x0000025c
	#define WDMA_LEAVE_DRS_TH_U			GENMASK(9, 0)
	#define WDMA_LEAVE_DRS_TH_V			GENMASK(25, 16)
#define WDMA_CLIP_W_10B_IN_BYTE				0x00000300
	#define WDMA_CLIP_W_IN_10B			GENMASK(15, 0)
	#define SW_SEL					BIT(16)
#define WDMA_RBFC_DBG0					0x00000304
	#define ROW_UPDATE_WRSP_Y_CNT			GENMASK(13, 0)
	#define ROW_UPDATE_Y_CNT			GENMASK(29, 16)
#define WDMA_RBFC_DBG1					0x00000308
	#define ROW_UPDATE_WRSP_U_CNT			GENMASK(13, 0)
	#define ROW_UPDATE_U_CNT			GENMASK(29, 16)
#define WDMA_RBFC_DBG2					0x0000030c
	#define ROW_UPDATE_WRSP_V_CNT			GENMASK(13, 0)
	#define ROW_UPDATE_V_CNT			GENMASK(29, 16)
#define WDMA_WENG_DEBUG0				0x00000310
	#define WDMA_WENG_STA_DEBUG0			GENMASK(31, 0)
#define WDMA_WENG_DEBUG1				0x00000314
	#define WDMA_WENG_STA_DEBUG1			GENMASK(31, 0)
#define WDMA_CRC0					0x00000318
	#define WDMA_CRC_0				GENMASK(31, 0)
#define WDMA_CRC1					0x0000031c
	#define WDMA_CRC_1				GENMASK(31, 0)
#define WDMA_CRC2					0x00000320
	#define WDMA_CRC_2				GENMASK(31, 0)
#define WDMA_CRC3					0x00000324
	#define WDMA_CRC_3				GENMASK(31, 0)
#define WDMA_DITHER_0					0x00000e00
	#define START					BIT(0)
	#define OUT_SEL					BIT(4)
	#define CRC_CEN					BIT(16)
	#define CRC_START				BIT(20)
	#define CRC_CLR					BIT(24)
	#define DITHER_10B_IN				BIT(31)
#define WDMA_DITHER_6					0x00000e18
	#define LFSR_EN					BIT(1)
	#define RDITHER_EN				BIT(2)
	#define ROUND_EN				BIT(3)
#define WDMA_DITHER_7					0x00000e1c
	#define DRMOD_R					GENMASK(1, 0)
	#define DRMOD_G					GENMASK(5, 4)
	#define DRMOD_B					GENMASK(9, 8)
#define WDMA_DITHER_17					0x00000e44
	#define CRC_OUT					GENMASK(15, 0)
	#define CRC_RDY					BIT(16)
#define WDMA_DST_ADDR0					0x00000f00
	#define ADDRESS0				GENMASK(31, 0)
#define WDMA_DST_ADDR1					0x00000f04
	#define ADDRESS1				GENMASK(31, 0)
#define WDMA_DST_ADDR2					0x00000f08
	#define ADDRESS2				GENMASK(31, 0)
#define WDMA_DST_ADDR0_TDLR				0x00000f0c
	#define ADDRESS0_TDLR				GENMASK(31, 0)
#define WDMA_FBC_FBDC_CR_CH0123_VAL0			0x00000f10
	#define FBC_FBDC_CR_CH0123_VAL0			GENMASK(31, 0)
#define WDMA_FBC_FBDC_CR_CH0123_VAL1			0x00000f14
	#define FBC_FBDC_CR_CH0123_VAL1			GENMASK(31, 0)
#define WDMA_FBC_FBDC_CR_Y_VAL0				0x00000f18
	#define FBC_FBDC_CR_Y_VAL0			GENMASK(9, 0)
#define WDMA_FBC_FBDC_CR_UV_VAL0			0x00000f1c
	#define FBC_FBDC_CR_UV_VAL0			GENMASK(9, 0)
#define WDMA_FBC_FBDC_CR_Y_VAL1				0x00000f20
	#define FBC_FBDC_CR_Y_VAL1			GENMASK(9, 0)
#define WDMA_FBC_FBDC_CR_UV_VAL1			0x00000f24
	#define FBC_FBDC_CR_UV_VAL1			GENMASK(9, 0)
#define WDMA_FBC_SETTING				0x00000f28
	#define TILE_TYPE				GENMASK(1, 0)
	#define AA_MODE					GENMASK(3, 2)
	#define ON_EDGE					BIT(5)
#define WDMA_FBC_FMT					0x00000f2c
	#define FBC_FMT					GENMASK(6, 0)
	#define FBC_FMT_AUTO				BIT(8)
	#define IN_FBC_FMT				GENMASK(22, 16)
#define WDMA_FBC_CR_CORE_ID_P				0x00000f30
	#define FBC_CR_CORE_ID_P			GENMASK(15, 0)
#define WDMA_FBC_CR_CORE_ID_B				0x00000f34
	#define FBC_CR_CORE_ID_B			GENMASK(15, 0)
#define WDMA_FBC_CR_CORE_ID_V				0x00000f38
	#define FBC_CR_CORE_ID_V			GENMASK(15, 0)
#define WDMA_FBC_CR_CORE_ID_N				0x00000f3c
	#define FBC_CR_CORE_ID_N			GENMASK(15, 0)
#define WDMA_FBC_CR_CORE_ID_C				0x00000f40
	#define FBC_CR_CORE_ID_C			GENMASK(15, 0)
#define WDMA_FBC_CR_CORE_IP_CHANGELIST			0x00000f44
	#define FBC_CR_CORE_IP_CHANGELIST		GENMASK(31, 0)
#define WDMA_FBC_DEBUG_0				0x00000f48
	#define FBC_DEBUG_0				GENMASK(31, 0)
#define WDMA_FBC_DEBUG_1				0x00000f4c
	#define FBC_DEBUG_1				GENMASK(31, 0)
#define WDMA_FBC_DEBUG_2				0x00000f50
	#define FBC_DEBUG_2				GENMASK(31, 0)
#define WDMA_PVRIC_DEBUG_0				0x00000f54
	#define PVRIC_DEBUG_0				GENMASK(31, 0)
#define WDMA_PVRIC_DEBUG_1				0x00000f58
	#define PVRIC_DEBUG_1				GENMASK(31, 0)
#define WDMA_PVRIC_DEBUG_2				0x00000f5c
	#define PVRIC_DEBUG_2				GENMASK(31, 0)
#define WDMA_PVRIC_DEBUG_3				0x00000f60
	#define PVRIC_DEBUG_3				GENMASK(31, 0)
#define WDMA_PVRIC_DEBUG_4				0x00000f64
	#define PVRIC_DEBUG_4				GENMASK(31, 0)
#define WDMA_PVRIC_DEBUG_5				0x00000f68
	#define PVRIC_DEBUG_5				GENMASK(31, 0)
#define WDMA_PVRIC_FRAME_COMP_MON_CUR			0x00000f6c
	#define PVRIC_FRAME_COMP_MON_CUR		GENMASK(31, 0)
#define WDMA_PVRIC_FRAME_COMP_MON_PRE			0x00000f70
	#define PVRIC_FRAME_COMP_MON_PRE		GENMASK(31, 0)

#endif /*__MTK_WDMA_REG_H__*/
