/*
 * Copyright (c) 2018 MediaTek Inc.
 * Authors: David Yeh <david.yeh@mediatek.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __TIMESTAMP_REG_H__
#define __TIMESTAMP_REG_H__

/* ----------------- Register Definitions ------------------- */
#define TIMESTAMP_00					0x00000000
	#define TS_TS_CLK_SEL				BIT(0)
	#define TS_VTSC_EN				BIT(1)
	#define TS_HDMI_DP_VSYNC_INV			BIT(2)
	#define TS_HDMI_DP_HSYNC_INV			BIT(3)
	#define TS_DSI_VSYNC_SEL			GENMASK(9, 8)
	#define TS_DSI_VCNT_SEL				GENMASK(11, 10)
	#define TS_SWCNT_ENA				BIT(12)
	#define TS_SWCNT_RST				BIT(13)
	#define TS_FRAME_SWCNT_ENA			BIT(14)
	#define TS_LINE_SWCNT_ENA			BIT(15)
	#define TS_SWCNT_SET				GENMASK(31, 24)
#define TIMESTAMP_01					0x00000004
	#define TS_DSI_TRIG_LATCH			BIT(0)
	#define TS_COMMON_IRQ_TRIG_LATCH		BIT(1)
	#define TS_HDMIDP_IRQ_TRIG_LATCH		BIT(2)
	#define TS_TDMOUT_IRQ_TRIG_LATCH		BIT(3)
	#define TS_DPRX_VIDEO_TRIG_LATCH		BIT(4)
	#define TS_ISP0_TRIG_LATCH			BIT(5)
	#define TS_ISP1_TRIG_LATCH			BIT(6)
	#define TS_ISP2_TRIG_LATCH			BIT(7)
	#define TS_ISP3_TRIG_LATCH			BIT(8)
	#define TS_ISP4_TRIG_LATCH			BIT(9)
	#define TS_ISP5_TRIG_LATCH			BIT(10)
	#define TS_ISP6_TRIG_LATCH			BIT(11)
	#define TS_ISP7_TRIG_LATCH			BIT(12)
	#define TS_ISP8_TRIG_LATCH			BIT(13)
	#define TS_ISP9_TRIG_LATCH			BIT(14)
	#define TS_SIDE_VS_0_TRIG_LATCH			BIT(15)
	#define TS_SIDE_VS_1_TRIG_LATCH			BIT(16)
	#define TS_GAZE_VS_0_TRIG_LATCH			BIT(17)
	#define TS_GAZE_VS_1_TRIG_LATCH			BIT(18)
	#define TS_GAZE_VS_2_TRIG_LATCH			BIT(19)
	#define TS_IMU_0_TRIG_LATCH			BIT(20)
	#define TS_IMU_1_TRIG_LATCH			BIT(21)
	#define TS_CURRENT_TRIG_LATCH			BIT(22)
#define TIMESTAMP_02					0x00000008
	#define STA_IMU1_CURRENT_CNT			GENMASK(15, 0)
	#define STA_IMU0_CURRENT_CNT			GENMASK(31, 16)
#define TIMESTAMP_03					0x0000000c
	#define STA_FRAME_CURRENT_CNT			GENMASK(15, 0)
	#define STA_LINE_CURRENT_CNT			GENMASK(31, 16)
#define TIMESTAMP_04					0x00000010
	#define TS_VTS_IN_CURRENT			GENMASK(31, 0)
#define TIMESTAMP_05					0x00000014
	#define TS_STC_IN_CURRENT_LSB			GENMASK(9, 0)
#define TIMESTAMP_06					0x00000018
	#define TS_STC_IN_CURRENT_MSB			GENMASK(31, 0)
#define TIMESTAMP_07					0x0000001c
	#define TS_LINE_CNT_ENABLE			BIT(0)
	#define TS_LINE_CNT_CLR				BIT(1)
	#define TS_FRAME_CNT_ENABLE			BIT(2)
	#define TS_FRAME_CNT_CLR			BIT(3)
	#define TS_IMU0_CNT_ENABLE			BIT(4)
	#define TS_IMU0_CNT_CLR				BIT(5)
	#define TS_IMU1_CNT_ENABLE			BIT(6)
	#define TS_IMU1_CNT_CLR				BIT(7)
	#define TS_VTS_STEP_SEL				GENMASK(10, 8)
	#define TS_VTS_BASE_SEL				GENMASK(14, 12)
	#define STA_VTS_CNT_CLR				BIT(16)
#define TIMESTAMP_08					0x00000020
	#define STA_VTS_CNT				GENMASK(31, 0)
#define TIMESTAMP_09					0x00000024
	#define TS_VTS_BASE				GENMASK(31, 0)
#define TIMESTAMP_10					0x00000028
	#define TS_VTS_STEP				GENMASK(31, 0)
#define TIMESTAMP_11					0x0000002c
	#define STC_CNTL_IN				GENMASK(1, 0)
	#define ACK_STC_CNTL				GENMASK(17, 16)
#define TIMESTAMP_12					0x00000030
	#define AUDIO_TDMOUT_IRQB_EN			BIT(0)
	#define AUDIO_HDMIDP_IRQB_EN			BIT(1)
	#define AUDIO_COMMON_IRQB_EN			BIT(2)
#define TIMESTAMP_13					0x00000034
	#define STC_LOAD_VALUE_BASE_31_0_		GENMASK(31, 0)
#define TIMESTAMP_14					0x00000038
	#define STC_LOAD_VALUE_EXT			GENMASK(8, 0)
	#define STC_LOAD_VALUE_BASE_32_			BIT(31)
#define TIMESTAMP_15					0x0000003c
	#define STC_READ_VALUE_BASE_31_0_		GENMASK(31, 0)
#define TIMESTAMP_16					0x00000040
	#define STC_READ_VALUE_EXT_8_0_			GENMASK(8, 0)
	#define STC_READ_VALUE_BASE_32_			BIT(31)
#define TIMESTAMP_17					0x00000044
	#define STC_SW_READ_VALUE_BASE_31_0_		GENMASK(31, 0)
#define TIMESTAMP_18					0x00000048
	#define STC_SW_READ_VALUE_EXT_8_0_		GENMASK(8, 0)
	#define STC_SW_READ_VALUE_BASE_32_		BIT(31)
#define TIMESTAMP_19					0x0000004c
	#define PCR_CLOCK_SW_EN				BIT(0)
	#define STC_SPEED_CHG_27M			BIT(1)
	#define CLOCK_DIV_PARAM_Q			GENMASK(31, 16)
#define FRMTRACK_01					0x00000058
	#define SC_FRM_TRK_LINE				GENMASK(15, 0)
	#define SC_FRM_MASK_O				GENMASK(19, 16)
	#define SC_FRM_MASK_I				GENMASK(23, 20)
	#define SC_FRM_MASK_OUT_LR_EN			BIT(24)
	#define SC_FRM_MASK_OUT_LR_SEL			BIT(25)
	#define SC_FRM_MASK_IN_LR_EN			BIT(26)
	#define SC_FRM_MASK_IN_LR_SEL			BIT(27)
	#define SC_FRM_TRK_DDDS				BIT(28)
	#define SC_DDDS_TRK_INV				BIT(29)
#define FRMTRACK_02					0x0000005c
	#define SC_DDDS_TURBO_RGN			GENMASK(15, 0)
	#define SC_FRM_LOCK_WIN				GENMASK(23, 16)
	#define SC_FRM_LOCK_TOR				GENMASK(31, 24)
#define FRMTRACK_03					0x00000060
	#define SC_PNL_VTOTAL_DB			GENMASK(15, 0)
	#define SC_FRM_MASK_I_SEL			GENMASK(19, 16)
	#define SC_FRM_MASK_O_SEL			GENMASK(23, 20)
	#define SC_FRM_TRK_STEP				GENMASK(31, 24)
#define FRMTRACK_04					0x00000064
	#define SC_FRM_TRK_VIN_EDGE_SEL			BIT(0)
	#define SC_FRM_TRK_ONCE_ONLY			BIT(1)
	#define SC_FRM_TRK_CROSS_VSYNC_EN		BIT(2)
	#define SC_FRM_TRK_3D_EN			BIT(3)
	#define SC_FRM_TRK_DISP_R			BIT(4)
	#define SC_FRM_TRK_DDDS_EN			BIT(5)
	#define STA_FRM_TRK_LOCK_OK			BIT(6)
#define FRMTRACK_05					0x00000068
	#define SC_STA_FRM_VSYNC_OUT_EARLY		GENMASK(15, 0)
	#define SC_STA_FRM_TRK_VTOTAL			GENMASK(31, 16)
#define FRMTRACK_06					0x0000006c
	#define SC_STA_FRM_TRK_ABS_DIS			GENMASK(31, 16)
#define TS_DSI_1					0x00000070
	#define TS_DSI_TRIG_CLR				BIT(1)
	#define TS_DSI_STC_TRIG_EN			BIT(2)
	#define TS_DSI_FRAME_TRIG_EN			BIT(3)
	#define TS_DSI_LINE_TRIG_EN			BIT(4)
	#define TS_DSI_TRIG_EDGE			GENMASK(7, 6)
#define TS_DSI_2					0x00000074
	#define STA_DSI_FRAME_CNT_LATCH			GENMASK(15, 0)
	#define STA_DSI_LINE_CNT_LATCH			GENMASK(31, 16)
#define TS_DSI_3					0x00000078
	#define TS_DSI_STC_OFSET			GENMASK(31, 0)
#define TS_DSI_4					0x0000007c
	#define STA_DSI_STC_CNT_LATCH_LSB		GENMASK(9, 0)
#define TS_DSI_5					0x00000080
	#define STA_DSI_STC_CNT_LATCH_MSB		GENMASK(31, 0)
#define TS_COMMON_IRQ_1					0x00000084
	#define TS_COMMON_IRQ_TRIG_CLR			BIT(1)
	#define TS_COMMON_IRQ_STC_TRIG_EN		BIT(2)
	#define TS_COMMON_IRQ_FRAME_TRIG_EN		BIT(3)
	#define TS_COMMON_IRQ_LINE_TRIG_EN		BIT(4)
	#define TS_COMMON_IRQ_TRIG_EDGE			GENMASK(7, 6)
#define TS_COMMON_IRQ_2					0x00000088
	#define STA_COMMON_IRQ_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_COMMON_IRQ_LINE_CNT_LATCH		GENMASK(31, 16)
#define TS_COMMON_IRQ_3					0x0000008c
	#define TS_COMMON_IRQ_STC_OFSET			GENMASK(31, 0)
#define TS_COMMON_IRQ_4					0x00000090
	#define STA_COMMON_IRQ_STC_CNT_LATCH_LSB	GENMASK(9, 0)
#define TS_COMMON_IRQ_5					0x00000094
	#define STA_COMMON_IRQ_STC_CNT_LATCH_MSB	GENMASK(31, 0)
#define TS_HDMIDP_IRQ_1					0x00000098
	#define TS_HDMIDP_IRQ_TRIG_CLR			BIT(1)
	#define TS_HDMIDP_IRQ_STC_TRIG_EN		BIT(2)
	#define TS_HDMIDP_IRQ_FRAME_TRIG_EN		BIT(3)
	#define TS_HDMIDP_IRQ_LINE_TRIG_EN		BIT(4)
	#define TS_HDMIDP_IRQ_TRIG_EDGE			GENMASK(7, 6)
#define TS_HDMIDP_IRQ_2					0x0000009c
	#define STA_HDMIDP_IRQ_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_HDMIDP_IRQ_LINE_CNT_LATCH		GENMASK(31, 16)
#define TS_HDMIDP_IRQ_3					0x00000100
	#define TS_HDMIDP_IRQ_STC_OFSET			GENMASK(31, 0)
#define TS_HDMIDP_IRQ_4					0x00000104
	#define STA_HDMIDP_IRQ_STC_CNT_LATCH_LSB	GENMASK(9, 0)
#define TS_HDMIDP_IRQ_5					0x00000108
	#define STA_HDMIDP_IRQ_STC_CNT_LATCH_MSB	GENMASK(31, 0)
#define TS_TDMOUT_IRQ_1					0x0000010c
	#define TS_TDMOUT_IRQ_TRIG_CLR			BIT(1)
	#define TS_TDMOUT_IRQ_STC_TRIG_EN		BIT(2)
	#define TS_TDMOUT_IRQ_FRAME_TRIG_EN		BIT(3)
	#define TS_TDMOUT_IRQ_LINE_TRIG_EN		BIT(4)
	#define TS_TDMOUT_IRQ_TRIG_EDGE			GENMASK(7, 6)
#define TS_TDMOUT_IRQ_2					0x00000110
	#define STA_TDMOUT_IRQ_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_TDMOUT_IRQ_LINE_CNT_LATCH		GENMASK(31, 16)
#define TS_TDMOUT_IRQ_3					0x00000114
	#define TS_TDMOUT_IRQ_STC_OFSET			GENMASK(31, 0)
#define TS_TDMOUT_IRQ_4					0x00000118
	#define STA_TDMOUT_IRQ_STC_CNT_LATCH_LSB	GENMASK(9, 0)
#define TS_TDMOUT_IRQ_5					0x0000011c
	#define STA_TDMOUT_IRQ_STC_CNT_LATCH_MSB	GENMASK(31, 0)
#define TS_DPRX_VIDEO_IRQ_1				0x00000120
	#define TS_DPRX_VIDEO_TRIG_CLR			BIT(1)
	#define TS_DPRX_VIDEO_STC_TRIG_EN		BIT(2)
	#define TS_DPRX_VIDEO_FRAME_TRIG_EN		BIT(3)
	#define TS_DPRX_VIDEO_LINE_TRIG_EN		BIT(4)
	#define TS_DPRX_VIDEO_TRIG_EDGE			GENMASK(7, 6)
#define TS_DPRX_VIDEO_IRQ_2				0x00000124
	#define STA_DPRX_VIDEO_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_DPRX_VIDEO_LINE_CNT_LATCH		GENMASK(31, 16)
#define TS_DPRX_VIDEO_IRQ_3				0x00000128
	#define TS_DPRX_VIDEO_STC_OFSET			GENMASK(31, 0)
#define TS_DPRX_VIDEO_IRQ_4				0x0000012c
	#define STA_DPRX_VIDEO_STC_CNT_LATCH_LSB	GENMASK(9, 0)
#define TS_DPRX_VIDEO_IRQ_5				0x00000130
	#define STA_DPRX_VIDEO_STC_CNT_LATCH_MSB	GENMASK(31, 0)
#define TS_ISP0_1					0x00000134
	#define TS_ISP0_TRIG_CLR			BIT(1)
	#define TS_ISP0_VTS_TRIG_EN			BIT(2)
	#define TS_ISP0_FRAME_TRIG_EN			BIT(3)
	#define TS_ISP0_LINE_TRIG_EN			BIT(4)
#define TS_ISP0_2					0x00000138
	#define STA_ISP0_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_ISP0_LINE_CNT_LATCH			GENMASK(31, 16)
#define TS_ISP0_3					0x0000013c
	#define TS_ISP0_VTS_OFSET			GENMASK(31, 0)
#define TS_ISP0_4					0x00000140
	#define STA_ISP0_VTS_CNT_LATCH			GENMASK(31, 0)
#define TS_ISP1_1					0x00000148
	#define TS_ISP1_TRIG_CLR			BIT(1)
	#define TS_ISP1_VTS_TRIG_EN			BIT(2)
	#define TS_ISP1_FRAME_TRIG_EN			BIT(3)
	#define TS_ISP1_LINE_TRIG_EN			BIT(4)
#define TS_ISP1_2					0x0000014c
	#define STA_ISP1_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_ISP1_LINE_CNT_LATCH			GENMASK(31, 16)
#define TS_ISP1_3					0x00000150
	#define TS_ISP1_VTS_OFSET			GENMASK(31, 0)
#define TS_ISP1_4					0x00000154
	#define STA_ISP1_VTS_CNT_LATCH			GENMASK(31, 0)
#define TS_ISP2_1					0x0000015c
	#define TS_ISP2_TRIG_CLR			BIT(1)
	#define TS_ISP2_VTS_TRIG_EN			BIT(2)
	#define TS_ISP2_FRAME_TRIG_EN			BIT(3)
	#define TS_ISP2_LINE_TRIG_EN			BIT(4)
#define TS_ISP2_2					0x00000160
	#define STA_ISP2_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_ISP2_LINE_CNT_LATCH			GENMASK(31, 16)
#define TS_ISP2_3					0x00000164
	#define TS_ISP2_VTS_OFSET			GENMASK(31, 0)
#define TS_ISP2_4					0x00000168
	#define STA_ISP2_VTS_CNT_LATCH			GENMASK(31, 0)
#define TS_ISP3_1					0x00000170
	#define TS_ISP3_TRIG_CLR			BIT(1)
	#define TS_ISP3_VTS_TRIG_EN			BIT(2)
	#define TS_ISP3_FRAME_TRIG_EN			BIT(3)
	#define TS_ISP3_LINE_TRIG_EN			BIT(4)
#define TS_ISP3_2					0x00000174
	#define STA_ISP3_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_ISP3_LINE_CNT_LATCH			GENMASK(31, 16)
#define TS_ISP3_3					0x00000178
	#define TS_ISP3_VTS_OFSET			GENMASK(31, 0)
#define TS_ISP3_4					0x0000017c
	#define STA_ISP3_VTS_CNT_LATCH			GENMASK(31, 0)
#define TS_ISP4_1					0x00000184
	#define TS_ISP4_TRIG_CLR			BIT(1)
	#define TS_ISP4_VTS_TRIG_EN			BIT(2)
	#define TS_ISP4_FRAME_TRIG_EN			BIT(3)
	#define TS_ISP4_LINE_TRIG_EN			BIT(4)
#define TS_ISP4_2					0x00000188
	#define STA_ISP4_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_ISP4_LINE_CNT_LATCH			GENMASK(31, 16)
#define TS_ISP4_3					0x0000018c
	#define TS_ISP4_VTS_OFSET			GENMASK(31, 0)
#define TS_ISP4_4					0x00000190
	#define STA_ISP4_VTS_CNT_LATCH			GENMASK(31, 0)
#define TS_ISP5_1					0x00000198
	#define TS_ISP5_TRIG_CLR			BIT(1)
	#define TS_ISP5_VTS_TRIG_EN			BIT(2)
	#define TS_ISP5_FRAME_TRIG_EN			BIT(3)
	#define TS_ISP5_LINE_TRIG_EN			BIT(4)
#define TS_ISP5_2					0x0000019c
	#define STA_ISP5_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_ISP5_LINE_CNT_LATCH			GENMASK(31, 16)
#define TS_ISP5_3					0x00000200
	#define TS_ISP5_VTS_OFSET			GENMASK(31, 0)
#define TS_ISP5_4					0x00000204
	#define STA_ISP5_VTS_CNT_LATCH			GENMASK(31, 0)
#define TS_ISP6_1					0x0000020c
	#define TS_ISP6_TRIG_CLR			BIT(1)
	#define TS_ISP6_VTS_TRIG_EN			BIT(2)
	#define TS_ISP6_FRAME_TRIG_EN			BIT(3)
	#define TS_ISP6_LINE_TRIG_EN			BIT(4)
#define TS_ISP6_2					0x00000210
	#define STA_ISP6_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_ISP6_LINE_CNT_LATCH			GENMASK(31, 16)
#define TS_ISP6_3					0x00000214
	#define TS_ISP6_VTS_OFSET			GENMASK(31, 0)
#define TS_ISP6_4					0x00000218
	#define STA_ISP6_VTS_CNT_LATCH			GENMASK(31, 0)
#define TS_ISP7_1					0x00000220
	#define TS_ISP7_TRIG_CLR			BIT(1)
	#define TS_ISP7_VTS_TRIG_EN			BIT(2)
	#define TS_ISP7_FRAME_TRIG_EN			BIT(3)
	#define TS_ISP7_LINE_TRIG_EN			BIT(4)
#define TS_ISP7_2					0x00000224
	#define STA_ISP7_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_ISP7_LINE_CNT_LATCH			GENMASK(31, 16)
#define TS_ISP7_3					0x00000228
	#define TS_ISP7_VTS_OFSET			GENMASK(31, 0)
#define TS_ISP7_4					0x0000022c
	#define STA_ISP7_VTS_CNT_LATCH			GENMASK(31, 0)
#define TS_ISP8_1					0x00000234
	#define TS_ISP8_TRIG_CLR			BIT(1)
	#define TS_ISP8_VTS_TRIG_EN			BIT(2)
	#define TS_ISP8_FRAME_TRIG_EN			BIT(3)
	#define TS_ISP8_LINE_TRIG_EN			BIT(4)
#define TS_ISP8_2					0x00000238
	#define STA_ISP8_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_ISP8_LINE_CNT_LATCH			GENMASK(31, 16)
#define TS_ISP8_3					0x0000023c
	#define TS_ISP8_VTS_OFSET			GENMASK(31, 0)
#define TS_ISP8_4					0x00000240
	#define STA_ISP8_VTS_CNT_LATCH			GENMASK(31, 0)
#define TS_ISP9_1					0x00000248
	#define TS_ISP9_TRIG_CLR			BIT(1)
	#define TS_ISP9_VTS_TRIG_EN			BIT(2)
	#define TS_ISP9_FRAME_TRIG_EN			BIT(3)
	#define TS_ISP9_LINE_TRIG_EN			BIT(4)
#define TS_ISP9_2					0x0000024c
	#define STA_ISP9_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_ISP9_LINE_CNT_LATCH			GENMASK(31, 16)
#define TS_ISP9_3					0x00000250
	#define TS_ISP9_VTS_OFSET			GENMASK(31, 0)
#define TS_ISP9_4					0x00000254
	#define STA_ISP9_VTS_CNT_LATCH			GENMASK(31, 0)
#define TS_SIDE_VS_0_1					0x00000260
	#define TS_SIDE_VS_0_TRIG_CLR			BIT(1)
	#define TS_SIDE_VS_0_VTS_TRIG_EN		BIT(2)
	#define TS_SIDE_VS_0_FRAME_TRIG_EN		BIT(3)
	#define TS_SIDE_VS_0_LINE_TRIG_EN		BIT(4)
#define TS_SIDE_VS_0_2					0x00000264
	#define STA_SIDE_VS_0_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_SIDE_VS_0_LINE_CNT_LATCH		GENMASK(31, 16)
#define TS_SIDE_VS_0_3					0x00000268
	#define TS_SIDE_VS_0_VTS_OFSET			GENMASK(31, 0)
#define TS_SIDE_VS_0_4					0x0000026c
	#define STA_SIDE_VS_0_VTS_CNT_LATCH		GENMASK(31, 0)
#define TS_SIDE_VS_1_1					0x00000274
	#define TS_SIDE_VS_1_TRIG_CLR			BIT(1)
	#define TS_SIDE_VS_1_VTS_TRIG_EN		BIT(2)
	#define TS_SIDE_VS_1_FRAME_TRIG_EN		BIT(3)
	#define TS_SIDE_VS_1_LINE_TRIG_EN		BIT(4)
#define TS_SIDE_VS_1_2					0x00000278
	#define STA_SIDE_VS_1_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_SIDE_VS_1_LINE_CNT_LATCH		GENMASK(31, 16)
#define TS_SIDE_VS_1_3					0x0000027c
	#define TS_SIDE_VS_1_VTS_OFSET			GENMASK(31, 0)
#define TS_SIDE_VS_1_4					0x00000280
	#define STA_SIDE_VS_1_VTS_CNT_LATCH		GENMASK(31, 0)
#define TS_GAZE_VS_0_1					0x00000288
	#define TS_GAZE_VS_0_TRIG_CLR			BIT(1)
	#define TS_GAZE_VS_0_VTS_TRIG_EN		BIT(2)
	#define TS_GAZE_VS_0_FRAME_TRIG_EN		BIT(3)
	#define TS_GAZE_VS_0_LINE_TRIG_EN		BIT(4)
#define TS_GAZE_VS_0_2					0x0000028c
	#define STA_GAZE_VS_0_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_GAZE_VS_0_LINE_CNT_LATCH		GENMASK(31, 16)
#define TS_GAZE_VS_0_3					0x00000290
	#define TS_GAZE_VS_0_VTS_OFSET			GENMASK(31, 0)
#define TS_GAZE_VS_0_4					0x00000294
	#define STA_GAZE_VS_0_VTS_CNT_LATCH		GENMASK(31, 0)
#define TS_GAZE_VS_1_1					0x0000029c
	#define TS_GAZE_VS_1_TRIG_CLR			BIT(1)
	#define TS_GAZE_VS_1_VTS_TRIG_EN		BIT(2)
	#define TS_GAZE_VS_1_FRAME_TRIG_EN		BIT(3)
	#define TS_GAZE_VS_1_LINE_TRIG_EN		BIT(4)
#define TS_GAZE_VS_1_2					0x000002a0
	#define STA_GAZE_VS_1_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_GAZE_VS_1_LINE_CNT_LATCH		GENMASK(31, 16)
#define TS_GAZE_VS_1_3					0x000002a4
	#define TS_GAZE_VS_1_VTS_OFSET			GENMASK(31, 0)
#define TS_GAZE_VS_1_4					0x000002a8
	#define STA_GAZE_VS_1_VTS_CNT_LATCH		GENMASK(31, 0)
#define TS_GAZE_VS_2_1					0x000002b0
	#define TS_GAZE_VS_2_TRIG_CLR			BIT(1)
	#define TS_GAZE_VS_2_VTS_TRIG_EN		BIT(2)
	#define TS_GAZE_VS_2_FRAME_TRIG_EN		BIT(3)
	#define TS_GAZE_VS_2_LINE_TRIG_EN		BIT(4)
#define TS_GAZE_VS_2_2					0x000002b4
	#define STA_GAZE_VS_2_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_GAZE_VS_2_LINE_CNT_LATCH		GENMASK(31, 16)
#define TS_GAZE_VS_2_3					0x000002b8
	#define TS_GAZE_VS_2_VTS_OFSET			GENMASK(31, 0)
#define TS_GAZE_VS_2_4					0x000002bc
	#define STA_GAZE_VS_2_VTS_CNT_LATCH		GENMASK(31, 0)
#define TS_IMU_0_1					0x000002c4
	#define TS_IMU_0_TRIG_CLR			BIT(1)
	#define TS_IMU_0_VTS_TRIG_EN			BIT(2)
	#define TS_IMU_0_FRAME_TRIG_EN			BIT(3)
	#define TS_IMU_0_LINE_TRIG_EN			BIT(4)
	#define TS_IMU_0_IMU_TRIG_EDGE			GENMASK(7, 6)
#define TS_IMU_0_2					0x000002c8
	#define STA_IMU_0_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_IMU_0_LINE_CNT_LATCH		GENMASK(31, 16)
#define TS_IMU_0_3					0x000002cc
	#define TS_IMU_0_VTS_OFSET			GENMASK(31, 0)
#define TS_IMU_0_4					0x000002d0
	#define STA_IMU_0_VTS_CNT_LATCH			GENMASK(31, 0)
#define TS_IMU_1_1					0x000002d8
	#define TS_IMU_1_TRIG_CLR			BIT(1)
	#define TS_IMU_1_VTS_TRIG_EN			BIT(2)
	#define TS_IMU_1_FRAME_TRIG_EN			BIT(3)
	#define TS_IMU_1_LINE_TRIG_EN			BIT(4)
	#define TS_IMU_1_IMU_TRIG_EDGE			GENMASK(7, 6)
#define TS_IMU_1_2					0x000002dc
	#define STA_IMU_1_FRAME_CNT_LATCH		GENMASK(15, 0)
	#define STA_IMU_1_LINE_CNT_LATCH		GENMASK(31, 16)
#define TS_IMU_1_3					0x000002e0
	#define TS_IMU_1_VTS_OFSET			GENMASK(31, 0)
#define TS_IMU_1_4					0x000002e4
	#define STA_IMU_1_VTS_CNT_LATCH			GENMASK(31, 0)
#define TIMESTAMP_81					0x00000314
	#define TS_SWRST_VTSC				BIT(0)
	#define TS_SWRST_STC				BIT(1)
	#define TS_SWRST_SLF				BIT(2)
	#define TS_SWRST_REG				BIT(3)
	#define TS_SWRST_CORE				BIT(4)
	#define TS_SWRST_AUDIO				BIT(5)
	#define TS_SWRST_ISP				BIT(6)
	#define TS_SWRST_IMU				BIT(7)
	#define TS_SWRST_FRAME_TRACK			BIT(8)
	#define TS_SWRST_MUX				BIT(9)
#define TIMESTAMP_RES_0					0x00000500
	#define HI_RESERVED_BITS_0			GENMASK(31, 0)
#define TIMESTAMP_RES_1					0x00000504
	#define HI_RESERVED_BITS_1			GENMASK(31, 0)
#define TIMESTAMP_RES_2					0x00000508
	#define HI_RESERVED_BITS_2			GENMASK(31, 0)
#define TIMESTAMP_RES_3					0x0000050c
	#define HI_RESERVED_BITS_3			GENMASK(31, 0)
#define TIMESTAMP_RES_4					0x00000510
	#define HI_RESERVED_BITS_4			GENMASK(31, 0)
#define TIMESTAMP_RES_5					0x00000514
	#define HI_RESERVED_BITS_5			GENMASK(31, 0)
#define TIMESTAMP_RES_6					0x00000518
	#define HI_RESERVED_BITS_6			GENMASK(31, 0)
#define TIMESTAMP_RES_7					0x0000051c
	#define HI_RESERVED_BITS_7			GENMASK(31, 0)
#define TIMESTAMP_ATPG					0x00000ff0
	#define HEADERINSERTION_ATPG_OB			BIT(0)
	#define HEADERINSERTION_ATPG_CT			BIT(1)

#endif /*__TIMESTAMP_REG_H__*/
