/*
 * Copyright (c) 2017 MediaTek Inc.
 * Author: Andrew-sh.Cheng, MediaTek
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __MFD_MT6355_CORE_H__
#define __MFD_MT6355_CORE_H__

enum mt6355_irq_numbers {
	MT6355_INT_STATUS_PWRKEY = 0,
	MT6355_INT_STATUS_HOMEKEY,
	MT6355_INT_STATUS_PWRKEY_R,
	MT6355_INT_STATUS_HOMEKEY_R,
	MT6355_INT_STATUS_NI_LBAT_INT,
	MT6355_INT_STATUS_CHRDET,
	MT6355_INT_STATUS_CHRDET_EDGE,
	MT6355_INT_STATUS_BATON_LV,
	MT6355_INT_STATUS_BATON_HV,
	MT6355_INT_STATUS_BATON_BAT_IN,
	MT6355_INT_STATUS_BATON_BAT_OUT,
	MT6355_INT_STATUS_RTC,
	MT6355_INT_STATUS_RTC_NSEC,
	MT6355_INT_STATUS_BIF,
	MT6355_INT_STATUS_VCDT_HV_DET,

	MT6355_INT_STATUS_THR_H = 16,
	MT6355_INT_STATUS_THR_L,
	MT6355_INT_STATUS_BAT_H,
	MT6355_INT_STATUS_BAT_L,
	MT6355_INT_STATUS_BAT2_H,
	MT6355_INT_STATUS_BAT2_L,
	MT6355_INT_STATUS_BAT_TEMP_H,
	MT6355_INT_STATUS_BAT_TEMP_L,
	MT6355_INT_STATUS_AUXADC_IMP,
	MT6355_INT_STATUS_NAG_C_DLTV,
	MT6355_INT_STATUS_JEITA_HOT,
	MT6355_INT_STATUS_JEITA_WARM,
	MT6355_INT_STATUS_JEITA_COOL,
	MT6355_INT_STATUS_JEITA_COLD,

	MT6355_INT_STATUS_VPROC11_OC = 32,
	MT6355_INT_STATUS_VPROC12_OC,
	MT6355_INT_STATUS_VCORE_OC,
	MT6355_INT_STATUS_VGPU_OC,
	MT6355_INT_STATUS_VDRAM1_OC,
	MT6355_INT_STATUS_VDRAM2_OC,
	MT6355_INT_STATUS_VMODEM_OC,
	MT6355_INT_STATUS_VS1_OC,
	MT6355_INT_STATUS_VS2_OC,
	MT6355_INT_STATUS_VPA_OC,
	MT6355_INT_STATUS_VCORE_PREOC,
	MT6355_INT_STATUS_VA10_OC,
	MT6355_INT_STATUS_VA12_OC,
	MT6355_INT_STATUS_VA18_OC,
	MT6355_INT_STATUS_VBIF28_OC,
	MT6355_INT_STATUS_VCAMA1_OC,

	MT6355_INT_STATUS_VCAMA2_OC = 48,
	MT6355_INT_STATUS_VXO18_OC,
	MT6355_INT_STATUS_VCAMD1_OC,
	MT6355_INT_STATUS_VCAMD2_OC,
	MT6355_INT_STATUS_VCAMIO_OC,
	MT6355_INT_STATUS_VCN18_OC,
	MT6355_INT_STATUS_VCN28_OC,
	MT6355_INT_STATUS_VCN33_OC,
	MT6355_INT_STATUS_VTCXO24_OC,
	MT6355_INT_STATUS_VEMC_OC,
	MT6355_INT_STATUS_VFE28_OC,
	MT6355_INT_STATUS_VGP_OC,
	MT6355_INT_STATUS_VLDO28_OC,
	MT6355_INT_STATUS_VIO18_OC,
	MT6355_INT_STATUS_VIO28_OC,
	MT6355_INT_STATUS_VMC_OC,

	MT6355_INT_STATUS_VMCH_OC = 64,
	MT6355_INT_STATUS_VMIPI_OC,
	MT6355_INT_STATUS_VRF12_OC,
	MT6355_INT_STATUS_VRF18_1_OC,
	MT6355_INT_STATUS_VRF18_2_OC,
	MT6355_INT_STATUS_VSIM1_OC,
	MT6355_INT_STATUS_VSIM2_OC,
	MT6355_INT_STATUS_VGP2_OC,
	MT6355_INT_STATUS_VSRAM_CORE_OC,
	MT6355_INT_STATUS_VSRAM_PROC_OC,
	MT6355_INT_STATUS_VSRAM_GPU_OC,
	MT6355_INT_STATUS_VSRAM_MD_OC,
	MT6355_INT_STATUS_VUFS18_OC,
	MT6355_INT_STATUS_VUSB33_OC,
	MT6355_INT_STATUS_VXO22_OC,

	MT6355_INT_STATUS_FG_BAT0_H = 80,
	MT6355_INT_STATUS_FG_BAT0_L,
	MT6355_INT_STATUS_FG_CUR_H,
	MT6355_INT_STATUS_FG_CUR_L,
	MT6355_INT_STATUS_FG_ZCV,
	MT6355_INT_STATUS_FG_BAT1_H,
	MT6355_INT_STATUS_FG_BAT1_L,
	MT6355_INT_STATUS_FG_N_CHARGE_L,
	MT6355_INT_STATUS_FG_IAVG_H,
	MT6355_INT_STATUS_FG_IAVG_L,
	MT6355_INT_STATUS_FG_TIME_H,
	MT6355_INT_STATUS_FG_DISCHARGE,
	MT6355_INT_STATUS_FG_CHARGE,
	MT6355_INT_STATUS_CON5,

	MT6355_INT_STATUS_AUDIO = 96,
	MT6355_INT_STATUS_MAD,
	MT6355_INT_STATUS_EINT_RTC32K_1V8_1,
	MT6355_INT_STATUS_EINT_AUD_CLK,
	MT6355_INT_STATUS_EINT_AUD_DAT_MOSI,
	MT6355_INT_STATUS_EINT_AUD_DAT_MISO,
	MT6355_INT_STATUS_EINT_VOW_CLK_MISO,
	MT6355_INT_STATUS_ACCDET,
	MT6355_INT_STATUS_ACCDET_EINT,
	MT6355_INT_STATUS_SPI_CMD_ALERT,

	MT6355_IRQ_NR,
};

struct mt6355_chip {
	struct device *dev;
	struct regmap *regmap;
	int irq;
	struct irq_domain *irq_domain;
	struct mutex irqlock;
	u16 wake_mask[7];
	u16 irq_masks_cur[7];
	u16 irq_masks_cache[7];
	u16 int_con[7];
	u16 int_status[7];
};

#endif /* __MFD_MT6355_CORE_H__ */
