/*
 * Copyright (c) 2018 MediaTek Inc.
 * Author: Enzhu Wang <enzhu.wang@mediatek.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _DT_BINDINGS_GCE_MT3612_H
#define _DT_BINDINGS_GCE_MT3612_H

#define CMDQ_NO_TIMEOUT		0xffffffff

#define CMDQ_THR_PRIO_LOWEST	0
#define CMDQ_THR_PRIO_1		1
#define CMDQ_THR_PRIO_2		2
#define CMDQ_THR_PRIO_3		3
#define CMDQ_THR_PRIO_4		4
#define CMDQ_THR_PRIO_5		5
#define CMDQ_THR_PRIO_6		6
#define CMDQ_THR_PRIO_HIGHEST	7

#define THREAD_0_TOKEN		0x1f0
#define THREAD_1_TOKEN		0x200
#define THREAD_2_TOKEN		0x210
#define THREAD_3_TOKEN		0x220
#define THREAD_4_TOKEN		0x230
#define THREAD_5_TOKEN		0x240
#define THREAD_6_TOKEN		0x250
#define THREAD_7_TOKEN		0x260
#define THREAD_8_TOKEN		0x270
#define THREAD_9_TOKEN		0x280
#define THREAD_10_TOKEN		0x290
#define THREAD_11_TOKEN		0x2a0
#define THREAD_12_TOKEN		0x2b0
#define THREAD_13_TOKEN		0x2c0
#define THREAD_14_TOKEN		0x2d0
#define THREAD_15_TOKEN		0x2e0
#define THREAD_16_TOKEN		0x2f0
#define THREAD_17_TOKEN		0x300
#define THREAD_18_TOKEN		0x310
#define THREAD_19_TOKEN		0x320
#define THREAD_20_TOKEN		0x330
#define THREAD_21_TOKEN		0x340
#define THREAD_22_TOKEN		0x350
#define THREAD_23_TOKEN		0x360
#define THREAD_24_TOKEN		0x370
#define THREAD_25_TOKEN		0x380
#define THREAD_26_TOKEN		0x390
#define THREAD_27_TOKEN		0x3a0
#define THREAD_28_TOKEN		0x3b0
#define THREAD_29_TOKEN		0x3c0
#define THREAD_30_TOKEN		0x3d0
#define THREAD_31_TOKEN		0x3e0

/* GCE0 GCE4 GCE5 SUBSYS */

#define SUBSYS_1028XXXX		0
#define SUBSYS_1031XXXX		1
#define SUBSYS_102CXXXX		2

/* For GCE0 SUBSYS */
#define SUBSYS_1400XXXX		3
#define SUBSYS_1401XXXX		4
#define SUBSYS_1402XXXX		5
#define SUBSYS_1403XXXX		6
#define SUBSYS_1450XXXX		7
#define SUBSYS_1451XXXX		8
#define SUBSYS_1440XXXX		9
#define SUBSYS_102DXXXX		10
#define SUBSYS_1120XXXX		11
#define SUBSYS_112AXXXX		12
#define SUBSYS_1023XXXX		13
#define SUBSYS_1032XXXX		14
#define SUBSYS_1700XXXX		15
#define SUBSYS_1800XXXX		16
#define SUBSYS_1804XXXX		17
#define SUBSYS_2200XXXX		18
#define SUBSYS_2300XXXX		19
#define SUBSYS_2304XXXX		20
#define SUBSYS_1114XXXX		21

/* For GCE4 SUBSYS */
#define GCE4_SUBSYS_1400XXXX		3
#define GCE4_SUBSYS_1401XXXX		4
#define GCE4_SUBSYS_1402XXXX		5
#define GCE4_SUBSYS_1403XXXX		6
#define GCE4_SUBSYS_1450XXXX		7
#define GCE4_SUBSYS_1451XXXX		8
#define GCE4_SUBSYS_1440XXXX		9
#define GCE4_SUBSYS_102DXXXX		10
#define GCE4_SUBSYS_2029XXXX		11
#define GCE4_SUBSYS_2049XXXX		12
#define GCE4_SUBSYS_1023XXXX		13
#define GCE4_SUBSYS_1032XXXX		14
#define GCE4_SUBSYS_1700XXXX		15
#define GCE4_SUBSYS_1800XXXX		16
#define GCE4_SUBSYS_1804XXXX		17
#define GCE4_SUBSYS_2200XXXX		18
#define GCE4_SUBSYS_2300XXXX		19
#define GCE4_SUBSYS_2304XXXX		20
#define GCE4_SUBSYS_1114XXXX		21
#define GCE4_SUBSYS_2069XXXX		30

/* For GCE5 SUBSYS */
#define GCE5_SUBSYS_1802XXXX		3
#define GCE5_SUBSYS_1803XXXX		4
#define GCE5_SUBSYS_1807XXXX		5
#define GCE5_SUBSYS_1500XXXX		6
#define GCE5_SUBSYS_1501XXXX		7
#define GCE5_SUBSYS_2302XXXX		8
#define GCE5_SUBSYS_2202XXXX		9
#define GCE5_SUBSYS_102DXXXX		10
#define GCE5_SUBSYS_2029XXXX		11
#define GCE5_SUBSYS_2049XXXX		12
#define GCE5_SUBSYS_1023XXXX		13
#define GCE5_SUBSYS_1032XXXX		14
#define GCE5_SUBSYS_1700XXXX		15
#define GCE5_SUBSYS_1800XXXX		16
#define GCE5_SUBSYS_1804XXXX		17
#define GCE5_SUBSYS_2200XXXX		18
#define GCE5_SUBSYS_2300XXXX		19
#define GCE5_SUBSYS_2304XXXX		20
#define GCE5_SUBSYS_2203XXXX		21
#define GCE5_SUBSYS_2208XXXX		22
#define GCE5_SUBSYS_2303XXXX		24
#define GCE5_SUBSYS_2307XXXX		25
#define GCE5_SUBSYS_2100XXXX		26
#define GCE5_SUBSYS_2101XXXX		27
#define GCE5_SUBSYS_1702XXXX		28
#define GCE5_SUBSYS_1703XXXX		29
#define GCE5_SUBSYS_2069XXXX		30

/* GCE0 HW EVENT */
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_1_SLICER	1
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_2_P2S	2
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_3_MDP_RDMA0	3
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_4_MDP_RDMA1	4
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_5_MDP_RDMA2	5
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_6_MDP_RDMA3	6
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_7_MDP_RDMA_PVRIC0	7
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_8_MDP_RDMA_PVRIC1	8
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_9_MDP_RDMA_PVRIC2	9
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_10_MDP_RDMA_PVRIC3	10
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_11_DISP_RDMA0	11
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_12_DISP_RDMA1	12
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_13_DISP_RDMA2	13
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_14_DISP_RDMA3	14
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_15_LHC0	15
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_16_LHC1	16
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_17_LHC2	17
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_18_LHC3	18
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_19_CROP0	19
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_20_CROP1	20
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_21_CROP2	21
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_22_CROP3	22
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_23_DISP_WDMA0	23
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_24_DISP_WDMA1	24
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_25_DISP_WDMA2	25
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_26_DISP_WDMA3	26
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_27_SZ0	27
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_28_RSZ1	28
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_29_DSC0_0	29
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_30_DSC0_1	30
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_31_DSC1_0	31
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_32_DSC1_1	32
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_33_DSI0	33
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_34_DSI1	34
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_35_DSI2	35
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_36_DSI3	36
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_37_RBFC0	37
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_38_RBFC1	38
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_39_RBFC2	39
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_40_RBFC3	40
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_41_SBRC	41
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_42_PAT_GEN0	42
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_43_PAT_GEN1	43
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_44_PAT_GEN2	44
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_45_PAT_GEN3	45
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_46_DISP_PWM0	46
#define	CMDQ_EVENT_MMSYS_CORE_SOF_FOR_48_EMI	48
#define	CMDQ_EVENT_MMSYS_CORE_SLICER_EVENT_0	49
#define	CMDQ_EVENT_MMSYS_CORE_SLICER_EVENT_1	50
#define	CMDQ_EVENT_MMSYS_CORE_CROP0_FRAME_DONE	51
#define	CMDQ_EVENT_MMSYS_CORE_CROP1_FRAME_DONE	52
#define	CMDQ_EVENT_MMSYS_CORE_CROP2_FRAME_DONE	53
#define	CMDQ_EVENT_MMSYS_CORE_CROP3_FRAME_DONE	54
#define	CMDQ_EVENT_MMSYS_CORE_RSZ0_FRAME_DONE	58
#define	CMDQ_EVENT_MMSYS_CORE_RSZ1_FRAME_DONE	62
#define	CMDQ_EVENT_MMSYS_CORE_DISP_WDMA0_SW_RST_DONE	64
#define	CMDQ_EVENT_MMSYS_CORE_DISP_WDMA0_TARGET_LINE_DONE	65
#define	CMDQ_EVENT_MMSYS_CORE_DISP_WDMA0_FRAME_DONE	66
#define	CMDQ_EVENT_MMSYS_CORE_DISP_WDMA1_SW_RST_DONE	68
#define	CMDQ_EVENT_MMSYS_CORE_DISP_WDMA1_TARGET_LINE_DONE	69
#define	CMDQ_EVENT_MMSYS_CORE_DISP_WDMA1_FRAME_DONE	70
#define	CMDQ_EVENT_MMSYS_CORE_DISP_WDMA2_SW_RST_DONE	72
#define	CMDQ_EVENT_MMSYS_CORE_DISP_WDMA2_TARGET_LINE_DONE	73
#define	CMDQ_EVENT_MMSYS_CORE_DISP_WDMA2_FRAME_DONE	74
#define	CMDQ_EVENT_MMSYS_CORE_DISP_WDMA3_SW_RST_DONE	76
#define	CMDQ_EVENT_MMSYS_CORE_DISP_WDMA3_TARGET_LINE_DONE	77
#define	CMDQ_EVENT_MMSYS_CORE_DISP_WDMA3_FRAME_DONE	78
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA0_SW_RST_DONE	79
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA0_FRAME_DONE	81
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA0_TARGET_LINE_DONE	82
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA1_SW_RST_DONE	83
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA1_FRAME_DONE	85
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA1_TARGET_LINE_DONE	86
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA2_SW_RST_DONE	87
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA2_FRAME_DONE	89
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA2_TARGET_LINE_DONE	90
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA3_SW_RST_DONE	91
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA3_FRAME_DONE	93
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA3_TARGET_LINE_DONE	94
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA_PVRIC0_TARGET_LINE_DONE	95
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA_PVRIC0_FRAME_DONE	96
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA_PVRIC1_TARGET_LINE_DONE	97
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA_PVRIC1_FRAME_DONE	98
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA_PVRIC2_TARGET_LINE_DONE	99
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA_PVRIC2_FRAME_DONE	100
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA_PVRIC3_TARGET_LINE_DONE	101
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA_PVRIC3_FRAME_DONE	102
#define	CMDQ_EVENT_MMSYS_CORE_DISP_RDMA0_TARGET_LINE_DOEN	103
#define	CMDQ_EVENT_MMSYS_CORE_DISP_RDMA0_FRAME_DONE	105
#define	CMDQ_EVENT_MMSYS_CORE_DISP_RDMA1_TARGET_LINE_DOEN	106
#define	CMDQ_EVENT_MMSYS_CORE_DISP_RDMA1_FRAME_DONE	108
#define	CMDQ_EVENT_MMSYS_CORE_DISP_RDMA2_TARGET_LINE_DOEN	109
#define	CMDQ_EVENT_MMSYS_CORE_DISP_RDMA2_FRAME_DONE	111
#define	CMDQ_EVENT_MMSYS_CORE_DISP_RDMA3_TARGET_LINE_DOEN	112
#define	CMDQ_EVENT_MMSYS_CORE_DISP_RDMA3_FRAME_DONE	114
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA0_RBFC_REN_W_OV_TH_EVENT	115
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA0_RBFC_REN_READ_TIMEOUT_EVENT	116
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA0_RBFC_REN_R_INCOMPLETE_EVENT	117
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA0_RBFC_REN_W_INCOMPLETE_EVENT	118
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA1_RBFC_REN_W_OV_TH_EVENT	119
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA1_RBFC_REN_READ_TIMEOUT_EVENT	120
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA1_RBFC_REN_R_INCOMPLETE_EVENT	121
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA1_RBFC_REN_W_INCOMPLETE_EVENT	122
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA2_RBFC_REN_W_OV_TH_EVENT	123
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA2_RBFC_REN_READ_TIMEOUT_EVENT	124
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA2_RBFC_REN_R_INCOMPLETE_EVENT	125
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA2_RBFC_REN_W_INCOMPLETE_EVENT	126
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA3_RBFC_REN_W_OV_TH_EVENT	127
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA3_RBFC_REN_READ_TIMEOUT_EVENT	128
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA3_RBFC_REN_R_INCOMPLETE_EVENT	129
#define	CMDQ_EVENT_MMSYS_CORE_MDP_RDMA3_RBFC_REN_W_INCOMPLETE_EVENT	130
#define	CMDQ_EVENT_MMSYS_CORE_SBRC_GCE_SETTING_CHG_INCOMPLETE	131
#define	CMDQ_EVENT_MMSYS_CORE_SBRC_GCE_W_OVER_TH	132
#define	CMDQ_EVENT_MMSYS_CORE_SBRC_GCE_GPU_CURRENT_FRAME_SKIP_DONE	133
#define	CMDQ_EVENT_MMSYS_CORE_SBRC_GCE_GPIO_TIMEOUT	134
#define	CMDQ_EVENT_MMSYS_CORE_SBRC_GCE_GPU_N_SBRC_RW_CLASH	135
#define	CMDQ_EVENT_MMSYS_CORE_SBRC_GCE_W_INCOMPLETE	136
#define	CMDQ_EVENT_MMSYS_CORE_SBRC_GCE_GPU_RENDER_FAULT	137
#define	CMDQ_EVENT_MMSYS_CORE_SBRC_GCE_URGENT_END	138
#define	CMDQ_EVENT_MMSYS_CORE_SBRC_GCE_URGENT_START	139
#define	CMDQ_EVENT_MMSYS_CORE_LHC0_FRAME_DONE	140
#define	CMDQ_EVENT_MMSYS_CORE_LHC1_FRAME_DONE	141
#define	CMDQ_EVENT_MMSYS_CORE_LHC2_FRAME_DONE	142
#define	CMDQ_EVENT_MMSYS_CORE_LHC3_FRAME_DONE	143
#define	CMDQ_EVENT_MMSYS_CORE_DSC0_FRAME_DONE_0	144
#define	CMDQ_EVENT_MMSYS_CORE_DSC0_FRAME_DONE_1	145
#define	CMDQ_EVENT_MMSYS_CORE_DSC1_FRAME_DONE_0	146
#define	CMDQ_EVENT_MMSYS_CORE_DSC1_FRAME_DONE_1	147
#define	CMDQ_EVENT_MMSYS_CORE_DSI0_VACTL_EVENT	149
#define	CMDQ_EVENT_MMSYS_CORE_DSI0_SOF_EVENT	150
#define	CMDQ_EVENT_MMSYS_CORE_DSI0_IRQ_EVENT	151
#define	CMDQ_EVENT_MMSYS_CORE_DSI0_TE_EVENT	152
#define	CMDQ_EVENT_MMSYS_CORE_DSI0_DONE_EVENT	153
#define	CMDQ_EVENT_MMSYS_CORE_DSI0_FRAME_DONE	154
#define	CMDQ_EVENT_MMSYS_CORE_DSI1_VACTL_EVENT	156
#define	CMDQ_EVENT_MMSYS_CORE_DSI1_SOF_EVENT	157
#define	CMDQ_EVENT_MMSYS_CORE_DSI1_IRQ_EVENT	158
#define	CMDQ_EVENT_MMSYS_CORE_DSI1_TE_EVENT	159
#define	CMDQ_EVENT_MMSYS_CORE_DSI1_DONE_EVENT	160
#define	CMDQ_EVENT_MMSYS_CORE_DSI1_FRAME_DONE	161
#define	CMDQ_EVENT_MMSYS_CORE_DSI2_VACTL_EVENT	163
#define	CMDQ_EVENT_MMSYS_CORE_DSI2_SOF_EVENT	164
#define	CMDQ_EVENT_MMSYS_CORE_DSI2_IRQ_EVENT	165
#define	CMDQ_EVENT_MMSYS_CORE_DSI2_TE_EVENT	166
#define	CMDQ_EVENT_MMSYS_CORE_DSI2_DONE_EVENT	167
#define	CMDQ_EVENT_MMSYS_CORE_DSI2_FRAME_DONE	168
#define	CMDQ_EVENT_MMSYS_CORE_DSI3_VACTL_EVENT	170
#define	CMDQ_EVENT_MMSYS_CORE_DSI3_SOF_EVENT	171
#define	CMDQ_EVENT_MMSYS_CORE_DSI3_IRQ_EVENT	172
#define	CMDQ_EVENT_MMSYS_CORE_DSI3_TE_EVENT	173
#define	CMDQ_EVENT_MMSYS_CORE_DSI3_DONE_EVENT	174
#define	CMDQ_EVENT_MMSYS_CORE_DSI3_FRAME_DONE	175
#define	CMDQ_EVENT_MMSYS_CORE_CAM_VSYNC_0_EVENT	176
#define	CMDQ_EVENT_MMSYS_CORE_CAM_VSYNC_1_EVENT	177
#define	CMDQ_EVENT_MMSYS_CORE_CAM_VSYNC_2_EVENT	178
#define	CMDQ_EVENT_MMSYS_CORE_CAM_VSYNC_3_EVENT	179
#define	CMDQ_EVENT_MMSYS_CORE_CAM_VSYNC_4_EVENT	180
#define	CMDQ_EVENT_MMSYS_CORE_CAM_VSYNC_0_TAIL_EVENT	181
#define	CMDQ_EVENT_MMSYS_CORE_CAM_VSYNC_1_TAIL_EVENT	182
#define	CMDQ_EVENT_MMSYS_CORE_CAM_VSYNC_2_TAIL_EVENT	183
#define	CMDQ_EVENT_MMSYS_CORE_CAM_VSYNC_3_TAIL_EVENT	184
#define	CMDQ_EVENT_MMSYS_CORE_CAM_VSYNC_4_TAIL_EVENT	185
#define	CMDQ_EVENT_MMSYS_CORE_TD_EVENT_0	186
#define	CMDQ_EVENT_MMSYS_CORE_TD_EVENT_1	187
#define	CMDQ_EVENT_MMSYS_CORE_TD_EVENT_2	188
#define	CMDQ_EVENT_MMSYS_CORE_TD_EVENT_3	189
#define	CMDQ_EVENT_MMSYS_CORE_TD_EVENT_4	190
#define	CMDQ_EVENT_MMSYS_CORE_TD_EVENT_5	191
#define	CMDQ_EVENT_MMSYS_CORE_TD_EVENT_6	192
#define	CMDQ_EVENT_MMSYS_CORE_TD_EVENT_7	193
#define	CMDQ_EVENT_MMSYS_CORE_TD_EVENT_8	194
#define	CMDQ_EVENT_MMSYS_CORE_TD_EVENT_9	195
#define	CMDQ_EVENT_MMSYS_CORE_TD_EVENT_10	196
#define	CMDQ_EVENT_MMSYS_CORE_TD_EVENT_11	197
#define	CMDQ_EVENT_MMSYS_CORE_TD_EVENT_12	198
#define	CMDQ_EVENT_MMSYS_CORE_TD_EVENT_13	199
#define	CMDQ_EVENT_MMSYS_CORE_TD_EVENT_14	200
#define	CMDQ_EVENT_MMSYS_CORE_TD_EVENT_15	201
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_0	202
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_1	203
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_2	204
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_3	205
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_4	206
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_5	207
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_6	208
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_7	209
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_8	210
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_9	211
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_10	212
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_11	213
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_12	214
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_13	215
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_14	216
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_15	217
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_16	218
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_17	219
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_18	220
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_19	221
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_20	222
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_21	223
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_22	224
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_23	225
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_24	226
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_25	227
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_26	228
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_27	229
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_28	230
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_29	231
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_30	232
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_NEG_EVENT_PIN_31	233
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_0	234
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_1	235
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_2	236
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_3	237
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_4	238
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_5	239
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_6	240
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_7	241
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_8	242
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_9	243
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_10	244
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_11	245
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_12	246
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_13	247
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_14	248
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_15	249
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_16	250
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_17	251
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_18	252
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_19	253
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_20	254
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_21	255
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_22	256
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_23	257
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_24	258
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_25	259
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_26	260
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_27	261
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_28	262
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_29	263
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_30	264
#define	CMDQ_EVENT_MMSYS_CORE_AH_ERROR_POS_EVENT_PIN_31	265
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_NEG_EVENT_PIN_0	266
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_NEG_EVENT_PIN_1	267
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_NEG_EVENT_PIN_2	268
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_NEG_EVENT_PIN_3	269
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_NEG_EVENT_PIN_4	270
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_NEG_EVENT_PIN_5	271
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_NEG_EVENT_PIN_6	272
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_NEG_EVENT_PIN_7	273
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_NEG_EVENT_PIN_8	274
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_NEG_EVENT_PIN_9	275
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_NEG_EVENT_PIN_10	276
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_NEG_EVENT_PIN_11	277
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_NEG_EVENT_PIN_12	278
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_NEG_EVENT_PIN_13	279
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_NEG_EVENT_PIN_14	280
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_NEG_EVENT_PIN_15	281
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_POS_EVENT_PIN_0	282
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_POS_EVENT_PIN_1	283
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_POS_EVENT_PIN_2	284
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_POS_EVENT_PIN_3	285
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_POS_EVENT_PIN_4	286
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_POS_EVENT_PIN_5	287
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_POS_EVENT_PIN_6	288
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_POS_EVENT_PIN_7	289
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_POS_EVENT_PIN_8	290
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_POS_EVENT_PIN_9	291
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_POS_EVENT_PIN_10	292
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_POS_EVENT_PIN_11	293
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_POS_EVENT_PIN_12	294
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_POS_EVENT_PIN_13	295
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_POS_EVENT_PIN_14	296
#define	CMDQ_EVENT_MMSYS_CORE_AH_EXT_POS_EVENT_PIN_15	297
#define	CMDQ_EVENT_MMSYS_CORE_AH_EVENT_PIN_0	298
#define	CMDQ_EVENT_MMSYS_CORE_AH_EVENT_PIN_1	299
#define	CMDQ_EVENT_MMSYS_CORE_AH_EVENT_PIN_2	300
#define	CMDQ_EVENT_MMSYS_CORE_AH_EVENT_PIN_3	301
#define	CMDQ_EVENT_MMSYS_CORE_AH_EVENT_PIN_4	302
#define	CMDQ_EVENT_MMSYS_CORE_AH_EVENT_PIN_5	303
#define	CMDQ_EVENT_MMSYS_CORE_AH_EVENT_PIN_6	304
#define	CMDQ_EVENT_MMSYS_CORE_AH_EVENT_PIN_7	305
#define	CMDQ_EVENT_MMSYS_CORE_AH_EVENT_PIN_8	306
#define	CMDQ_EVENT_MMSYS_CORE_AH_EVENT_PIN_9	307
#define	CMDQ_EVENT_MMSYS_CORE_AH_EVENT_PIN_10	308
#define	CMDQ_EVENT_MMSYS_CORE_AH_EVENT_PIN_11	309
#define	CMDQ_EVENT_MMSYS_CORE_AH_EVENT_PIN_12	310
#define	CMDQ_EVENT_MMSYS_CORE_AH_EVENT_PIN_13	311
#define	CMDQ_EVENT_MMSYS_CORE_AH_EVENT_PIN_14	312
#define	CMDQ_EVENT_MMSYS_CORE_AH_EVENT_PIN_15	313
#define	CMDQ_EVENT_MMSYS_CORE_STREAM_DONE_0	314
#define	CMDQ_EVENT_MMSYS_CORE_STREAM_DONE_1	315
#define	CMDQ_EVENT_MMSYS_CORE_STREAM_DONE_2	316
#define	CMDQ_EVENT_MMSYS_CORE_STREAM_DONE_3	317
#define	CMDQ_EVENT_MMSYS_CORE_STREAM_DONE_4	318
#define	CMDQ_EVENT_MMSYS_CORE_STREAM_DONE_5	319
#define	CMDQ_EVENT_MMSYS_CORE_STREAM_DONE_6	320
#define	CMDQ_EVENT_MMSYS_CORE_STREAM_DONE_7	321
#define	CMDQ_EVENT_MMSYS_CORE_STREAM_DONE_8	322
#define	CMDQ_EVENT_MMSYS_CORE_STREAM_DONE_9	323
#define	CMDQ_EVENT_MMSYS_CORE_STREAM_DONE_10	324
#define	CMDQ_EVENT_MMSYS_CORE_STREAM_DONE_11	325
#define	CMDQ_EVENT_MMSYS_CORE_STREAM_DONE_12	326
#define	CMDQ_EVENT_MMSYS_CORE_STREAM_DONE_13	327
#define	CMDQ_EVENT_MMSYS_CORE_STREAM_DONE_14	328
#define	CMDQ_EVENT_MMSYS_CORE_STREAM_DONE_15	329
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_1_SLICER	331
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_2_P2S	332
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_3_MDP_RDMA0	333
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_4_MDP_RDMA1	334
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_5_MDP_RDMA2	335
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_6_MDP_RDMA3	336
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_7_MDP_RDMA_PVRIC0	337
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_8_MDP_RDMA_PVRIC1	338
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_9_MDP_RDMA_PVRIC2	339
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_10_MDP_RDMA_PVRIC3	340
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_11_DISP_RDMA0	341
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_12_DISP_RDMA1	342
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_13_DISP_RDMA2	343
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_14_DISP_RDMA3	344
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_15_LHC0	345
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_16_LHC1	346
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_17_LHC2	347
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_18_LHC3	348
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_19_CROP0	349
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_20_CROP1	350
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_21_CROP2	351
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_22_CROP3	352
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_23_DISP_WDMA0	353
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_24_DISP_WDMA1	354
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_25_DISP_WDMA2	355
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_26_DISP_WDMA3	356
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_27_RSZ0	357
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_28_RSZ1	358
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_29_DSC0_0	359
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_30_DSC0_1	360
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_31_DSC1_0	361
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_32_DSC1_1	362
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_33_DSI0	363
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_34_DSI1	364
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_35_DSI2	365
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_36_DSI3	366
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_37_RBFC0	367
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_38_RBFC1	368
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_39_RBFC2	369
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_40_RBFC3	370
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_41_SBRC	371
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_42_PAT_GEN0	372
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_43_PAT_GEN1	373
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_44_PAT_GEN2	374
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_45_PAT_GEN3	375
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_46_DISP_PWM0	376
#define	CMDQ_EVENT_MMSYS_CORE_EOF_FOR_48_EMI	378
#define	CMDQ_EVENT_MMSYS_CORE_DISP_MUTEX_ALL_MODULE_UPDATE_0	379
#define	CMDQ_EVENT_MMSYS_CORE_DISP_MUTEX_ALL_MODULE_UPDATE_1	380
#define	CMDQ_EVENT_MMSYS_CORE_DISP_MUTEX_ALL_MODULE_UPDATE_2	381
#define	CMDQ_EVENT_MMSYS_CORE_DISP_MUTEX_ALL_MODULE_UPDATE_3	382
#define	CMDQ_EVENT_MMSYS_CORE_DISP_MUTEX_ALL_MODULE_UPDATE_4	383
#define	CMDQ_EVENT_MMSYS_CORE_DISP_MUTEX_ALL_MODULE_UPDATE_5	384
#define	CMDQ_EVENT_MMSYS_CORE_DISP_MUTEX_ALL_MODULE_UPDATE_6	385
#define	CMDQ_EVENT_MMSYS_CORE_DISP_MUTEX_ALL_MODULE_UPDATE_7	386
#define	CMDQ_EVENT_MMSYS_CORE_DISP_MUTEX_ALL_MODULE_UPDATE_8	387
#define	CMDQ_EVENT_MMSYS_CORE_DISP_MUTEX_ALL_MODULE_UPDATE_9	388
#define	CMDQ_EVENT_MMSYS_CORE_DISP_MUTEX_ALL_MODULE_UPDATE_10	389
#define	CMDQ_EVENT_MMSYS_CORE_DISP_MUTEX_ALL_MODULE_UPDATE_11	390
#define	CMDQ_EVENT_MMSYS_CORE_DISP_MUTEX_ALL_MODULE_UPDATE_12	391
#define	CMDQ_EVENT_MMSYS_CORE_DISP_MUTEX_ALL_MODULE_UPDATE_13	392
#define	CMDQ_EVENT_MMSYS_CORE_DISP_MUTEX_ALL_MODULE_UPDATE_14	393
#define	CMDQ_EVENT_MMSYS_CORE_DISP_MUTEX_ALL_MODULE_UPDATE_15	394

/* GCE4 GCE5 HW EVENT */
#define	CMDQ_EVENT_MMSYS_COMMON_SOF_0_PADDING_0	0
#define	CMDQ_EVENT_MMSYS_COMMON_SOF_1_PADDING_1	1
#define	CMDQ_EVENT_MMSYS_COMMON_SOF_2_PADDING_2	2
#define	CMDQ_EVENT_MMSYS_COMMON_SOF_3_WPE_1	3
#define	CMDQ_EVENT_MMSYS_COMMON_SOF_4_FE	4
#define	CMDQ_EVENT_MMSYS_COMMON_SOF_5_WDMA_0	5
#define	CMDQ_EVENT_MMSYS_COMMON_SOF_6_WDMA_1	6
#define	CMDQ_EVENT_MMSYS_COMMON_SOF_7_WDMA_2	7
#define	CMDQ_EVENT_MMSYS_COMMON_SOF_8_FM	8
#define	CMDQ_EVENT_MMSYS_COMMON_SOF_9_RBFC_WPE_1	9
#define	CMDQ_EVENT_MMSYS_COMMON_SOF_10_RESIZER_0	10
#define	CMDQ_EVENT_MMSYS_COMMON_SOF_11_RESIZER_1	11
#define	CMDQ_EVENT_MMSYS_COMMON_FRAME_DONE_0_PADDING_0	12
#define	CMDQ_EVENT_MMSYS_COMMON_FRAME_DONE_1_PADDING_1	13
#define	CMDQ_EVENT_MMSYS_COMMON_FRAME_DONE_2_PADDING_2	14
#define	CMDQ_EVENT_MMSYS_COMMON_FRAME_DONE_3_WPE_1	15
#define	CMDQ_EVENT_MMSYS_COMMON_FRAME_DONE_4_FE	16
#define	CMDQ_EVENT_MMSYS_COMMON_FRAME_DONE_5_WDMA_0	17
#define	CMDQ_EVENT_MMSYS_COMMON_FRAME_DONE_6_WDMA_1	18
#define	CMDQ_EVENT_MMSYS_COMMON_FRAME_DONE_7_WDMA_2	19
#define	CMDQ_EVENT_MMSYS_COMMON_FRAME_DONE_8_FM	20
#define	CMDQ_EVENT_MMSYS_COMMON_FRAME_DONE_9_RBFC_WPE_1	21
#define	CMDQ_EVENT_MMSYS_COMMON_FRAME_DONE_10_RESIZER_0	22
#define	CMDQ_EVENT_MMSYS_COMMON_FRAME_DONE_11_RESIZER_1	23
#define	CMDQ_EVENT_MMSYS_COMMON_EOF_3_WPE_1	27
#define	CMDQ_EVENT_MMSYS_COMMON_EOF_4_FE	28
#define	CMDQ_EVENT_MMSYS_COMMON_EOF_5_WDMA_0	29
#define	CMDQ_EVENT_MMSYS_COMMON_EOF_6_WDMA_1	30
#define	CMDQ_EVENT_MMSYS_COMMON_EOF_7_WDMA_2	31
#define	CMDQ_EVENT_MMSYS_COMMON_EOF_8_FM	32
#define	CMDQ_EVENT_MMSYS_COMMON_EOF_9_RBFC_WPE_1	33
#define	CMDQ_EVENT_MMSYS_COMMON_STREAM_DONE_MUTEX0	36
#define	CMDQ_EVENT_MMSYS_COMMON_STREAM_DONE_MUTEX1	37
#define	CMDQ_EVENT_MMSYS_COMMON_STREAM_DONE_MUTEX2	38
#define	CMDQ_EVENT_MMSYS_COMMON_STREAM_DONE_MUTEX3	39
#define	CMDQ_EVENT_MMSYS_COMMON_STREAM_DONE_MUTEX4	40
#define	CMDQ_EVENT_MMSYS_COMMON_STREAM_DONE_MUTEX5	41
#define	CMDQ_EVENT_MMSYS_COMMON_STREAM_DONE_MUTEX6	42
#define	CMDQ_EVENT_MMSYS_COMMON_STREAM_DONE_MUTEX7	43
#define	CMDQ_EVENT_MMSYS_COMMON_STREAM_DONE_MUTEX8	44
#define	CMDQ_EVENT_MMSYS_COMMON_STREAM_DONE_MUTEX9	45
#define	CMDQ_EVENT_MMSYS_COMMON_STREAM_DONE_MUTEX10	46
#define	CMDQ_EVENT_MMSYS_COMMON_STREAM_DONE_MUTEX11	47
#define	CMDQ_EVENT_MMSYS_COMMON_STREAM_DONE_MUTEX12	48
#define	CMDQ_EVENT_MMSYS_COMMON_STREAM_DONE_MUTEX13	49
#define	CMDQ_EVENT_MMSYS_COMMON_STREAM_DONE_MUTEX14	50
#define	CMDQ_EVENT_MMSYS_COMMON_STREAM_DONE_MUTEX15	51
#define	CMDQ_EVENT_MMSYS_COMMON_DISP_WDMA_0_SW_RST_DONE	52
#define	CMDQ_EVENT_MMSYS_COMMON_DISP_WDMA_1_SW_RST_DONE	53
#define	CMDQ_EVENT_MMSYS_COMMON_DISP_WDMA_2_SW_RST_DONE	54
#define	CMDQ_EVENT_MMSYS_COMMON_WPE_1_FRAME_INCOMPLETE	55
#define	CMDQ_EVENT_MMSYS_COMMON_RBFC_REN_WPE_1_RBFC_W_OV_TH_EVENT	56
#define	CMDQ_EVENT_MMSYS_COMMON_RBFC_REN_WPE_1_RBFC_READ_TIMEOUT_EVENT	57
#define	CMDQ_EVENT_MMSYS_COMMON_RBFC_REN_WPE_1_RBFC_R_INCOMPLETE_EVENT	58
#define	CMDQ_EVENT_MMSYS_COMMON_RBFC_REN_WPE_1_RBFC_W_INCOMPLETE_EVENT	59
#define	CMDQ_EVENT_MMSYS_COMMON_ALL_MODULE_UPDATE_MUTEX0	60
#define	CMDQ_EVENT_MMSYS_COMMON_ALL_MODULE_UPDATE_MUTEX1	61
#define	CMDQ_EVENT_MMSYS_COMMON_ALL_MODULE_UPDATE_MUTEX2	62
#define	CMDQ_EVENT_MMSYS_COMMON_ALL_MODULE_UPDATE_MUTEX3	63
#define	CMDQ_EVENT_MMSYS_COMMON_ALL_MODULE_UPDATE_MUTEX4	64
#define	CMDQ_EVENT_MMSYS_COMMON_ALL_MODULE_UPDATE_MUTEX5	65
#define	CMDQ_EVENT_MMSYS_COMMON_ALL_MODULE_UPDATE_MUTEX6	66
#define	CMDQ_EVENT_MMSYS_COMMON_ALL_MODULE_UPDATE_MUTEX7	67
#define	CMDQ_EVENT_MMSYS_COMMON_ALL_MODULE_UPDATE_MUTEX8	68
#define	CMDQ_EVENT_MMSYS_COMMON_ALL_MODULE_UPDATE_MUTEX9	69
#define	CMDQ_EVENT_MMSYS_COMMON_ALL_MODULE_UPDATE_MUTEX10	70
#define	CMDQ_EVENT_MMSYS_COMMON_ALL_MODULE_UPDATE_MUTEX11	71
#define	CMDQ_EVENT_MMSYS_COMMON_ALL_MODULE_UPDATE_MUTEX12	72
#define	CMDQ_EVENT_MMSYS_COMMON_ALL_MODULE_UPDATE_MUTEX13	73
#define	CMDQ_EVENT_MMSYS_COMMON_ALL_MODULE_UPDATE_MUTEX14	74
#define	CMDQ_EVENT_MMSYS_COMMON_ALL_MODULE_UPDATE_MUTEX15	75
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_TD_EVENT_0	76
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_TD_EVENT_1	77
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_TD_EVENT_2	78
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_TD_EVENT_3	79
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_TD_EVENT_4	80
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_TD_EVENT_5	81
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_TD_EVENT_6	82
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_TD_EVENT_7	83
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_TD_EVENT_8	84
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_TD_EVENT_9	85
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_TD_EVENT_10	86
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_TD_EVENT_11	87
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_TD_EVENT_12	88
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_TD_EVENT_13	89
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_TD_EVENT_14	90
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_TD_EVENT_15	91
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_0	92
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_1	93
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_2	94
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_3	95
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_4	96
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_5	97
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_6	98
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_7	99
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_8	100
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_9	101
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_10	102
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_11	103
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_12	104
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_13	105
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_14	106
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_15	107
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_16	108
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_17	109
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_18	110
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_19	111
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_20	112
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_21	113
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_22	114
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_23	115
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_24	116
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_25	117
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_26	118
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_27	119
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_28	120
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_29	121
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_30	122
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_NEG_EVENT_31	123
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_0	124
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_1	125
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_2	126
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_3	127
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_4	128
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_5	129
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_6	130
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_7	131
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_8	132
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_9	133
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_10	134
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_11	135
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_12	136
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_13	137
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_14	138
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_15	139
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_16	140
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_17	141
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_18	142
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_19	143
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_20	144
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_21	145
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_22	146
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_23	147
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_24	148
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_25	149
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_26	150
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_27	151
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_28	152
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_29	153
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_30	154
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_ERR_POS_EVENT_31	155
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EXT_NEG_EVENT_0	156
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EXT_NEG_EVENT_1	157
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EXT_NEG_EVENT_2	158
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EXT_NEG_EVENT_3	159
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EXT_NEG_EVENT_4	160
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EXT_NEG_EVENT_5	161
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EXT_NEG_EVENT_6	162
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EXT_NEG_EVENT_7	163
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EXT_POS_EVENT_0	164
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EXT_POS_EVENT_1	165
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EXT_POS_EVENT_2	166
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EXT_POS_EVENT_3	167
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EXT_POS_EVENT_4	168
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EXT_POS_EVENT_5	169
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EXT_POS_EVENT_6	170
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EXT_POS_EVENT_7	171
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EVENT_0	172
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EVENT_1	173
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EVENT_2	174
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EVENT_3	175
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EVENT_4	176
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EVENT_5	177
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EVENT_6	178
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EVENT_7	179
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EVENT_8	180
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EVENT_9	181
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EVENT_10	182
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EVENT_11	183
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EVENT_12	184
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EVENT_13	185
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EVENT_14	186
#define	CMDQ_EVENT_MMSYS_COMMON_MUTEX_AH_EVENT_15	187
#define	CMDQ_EVENT_MMSYS_GAZE_SOF_0_WPE_0	256
#define	CMDQ_EVENT_MMSYS_GAZE_SOF_1_WDMA_GAZE	257
#define	CMDQ_EVENT_MMSYS_GAZE_SOF_2_RBFC_WPE_0	258
#define	CMDQ_EVENT_MMSYS_GAZE_FRAME_DONE_0_WPE_0	259
#define	CMDQ_EVENT_MMSYS_GAZE_FRAME_DONE_1_WDMA_GAZE	260
#define	CMDQ_EVENT_MMSYS_GAZE_EOF_0_WPE_0	262
#define	CMDQ_EVENT_MMSYS_GAZE_EOF_1_WDMA_GAZE	263
#define	CMDQ_EVENT_MMSYS_GAZE_EOF_2_RBFC_WPE_0	264
#define	CMDQ_EVENT_MMSYS_GAZE_STREAM_DONE_MUTEX0	265
#define	CMDQ_EVENT_MMSYS_GAZE_STREAM_DONE_MUTEX1	266
#define	CMDQ_EVENT_MMSYS_GAZE_STREAM_DONE_MUTEX2	267
#define	CMDQ_EVENT_MMSYS_GAZE_STREAM_DONE_MUTEX3	268
#define	CMDQ_EVENT_MMSYS_GAZE_STREAM_DONE_MUTEX4	269
#define	CMDQ_EVENT_MMSYS_GAZE_STREAM_DONE_MUTEX5	270
#define	CMDQ_EVENT_MMSYS_GAZE_STREAM_DONE_MUTEX6	271
#define	CMDQ_EVENT_MMSYS_GAZE_STREAM_DONE_MUTEX7	272
#define	CMDQ_EVENT_MMSYS_GAZE_STREAM_DONE_MUTEX8	273
#define	CMDQ_EVENT_MMSYS_GAZE_STREAM_DONE_MUTEX9	274
#define	CMDQ_EVENT_MMSYS_GAZE_STREAM_DONE_MUTEX10	275
#define	CMDQ_EVENT_MMSYS_GAZE_STREAM_DONE_MUTEX11	276
#define	CMDQ_EVENT_MMSYS_GAZE_STREAM_DONE_MUTEX12	277
#define	CMDQ_EVENT_MMSYS_GAZE_STREAM_DONE_MUTEX13	278
#define	CMDQ_EVENT_MMSYS_GAZE_STREAM_DONE_MUTEX14	279
#define	CMDQ_EVENT_MMSYS_GAZE_STREAM_DONE_MUTEX15	280
#define	CMDQ_EVENT_MMSYS_GAZE_DISP_WDMA_GAZE_SW_RST_DONE	281
#define	CMDQ_EVENT_MMSYS_GAZE_WPE_0_FRAME_INCOMPLETE	282
#define	CMDQ_EVENT_MMSYS_GAZE_RBFC_REN_WPE_0_RBFC_W_OV_TH_EVENT	283
#define	CMDQ_EVENT_MMSYS_GAZE_RBFC_REN_WPE_0_RBFC_READ_TIMEOUT_EVENT	284
#define	CMDQ_EVENT_MMSYS_GAZE_RBFC_REN_WPE_0_RBFC_R_INCOMPLETE_EVENT	285
#define	CMDQ_EVENT_MMSYS_GAZE_RBFC_REN_WPE_0_RBFC_W_INCOMPLETE_EVENT	286
#define	CMDQ_EVENT_MMSYS_GAZE_ALL_MODULE_UPDATE_MUTEX0	287
#define	CMDQ_EVENT_MMSYS_GAZE_ALL_MODULE_UPDATE_MUTEX1	288
#define	CMDQ_EVENT_MMSYS_GAZE_ALL_MODULE_UPDATE_MUTEX2	289
#define	CMDQ_EVENT_MMSYS_GAZE_ALL_MODULE_UPDATE_MUTEX3	290
#define	CMDQ_EVENT_MMSYS_GAZE_ALL_MODULE_UPDATE_MUTEX4	291
#define	CMDQ_EVENT_MMSYS_GAZE_ALL_MODULE_UPDATE_MUTEX5	292
#define	CMDQ_EVENT_MMSYS_GAZE_ALL_MODULE_UPDATE_MUTEX6	293
#define	CMDQ_EVENT_MMSYS_GAZE_ALL_MODULE_UPDATE_MUTEX7	294
#define	CMDQ_EVENT_MMSYS_GAZE_ALL_MODULE_UPDATE_MUTEX8	295
#define	CMDQ_EVENT_MMSYS_GAZE_ALL_MODULE_UPDATE_MUTEX9	296
#define	CMDQ_EVENT_MMSYS_GAZE_ALL_MODULE_UPDATE_MUTEX10	297
#define	CMDQ_EVENT_MMSYS_GAZE_ALL_MODULE_UPDATE_MUTEX11	298
#define	CMDQ_EVENT_MMSYS_GAZE_ALL_MODULE_UPDATE_MUTEX12	299
#define	CMDQ_EVENT_MMSYS_GAZE_ALL_MODULE_UPDATE_MUTEX13	300
#define	CMDQ_EVENT_MMSYS_GAZE_ALL_MODULE_UPDATE_MUTEX14	301
#define	CMDQ_EVENT_MMSYS_GAZE_ALL_MODULE_UPDATE_MUTEX15	302
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_TD_EVENT_0	303
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_TD_EVENT_1	304
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_TD_EVENT_2	305
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_TD_EVENT_3	306
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_TD_EVENT_4	307
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_TD_EVENT_5	308
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_TD_EVENT_6	309
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_TD_EVENT_7	310
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_TD_EVENT_8	311
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_TD_EVENT_9	312
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_TD_EVENT_10	313
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_TD_EVENT_11	314
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_TD_EVENT_12	315
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_TD_EVENT_13	316
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_TD_EVENT_14	317
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_TD_EVENT_15	318
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_0	319
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_1	320
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_2	321
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_3	322
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_4	323
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_5	324
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_6	325
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_7	326
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_8	327
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_9	328
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_10	329
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_11	330
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_12	331
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_13	332
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_14	333
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_15	334
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_16	335
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_17	336
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_18	337
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_19	338
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_20	339
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_21	340
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_22	341
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_23	342
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_24	343
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_25	344
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_26	345
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_27	346
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_28	347
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_29	348
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_30	349
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_NEG_EVENT_31	350
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_0	351
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_1	352
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_2	353
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_3	354
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_4	355
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_5	356
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_6	357
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_7	358
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_8	359
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_9	360
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_10	361
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_11	362
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_12	363
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_13	364
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_14	365
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_15	366
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_16	367
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_17	368
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_18	369
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_19	370
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_20	371
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_21	372
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_22	373
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_23	374
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_24	375
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_25	376
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_26	377
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_27	378
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_28	379
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_29	380
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_30	381
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_ERR_POS_EVENT_31	382
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EXT_NEG_EVENT_0	383
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EXT_NEG_EVENT_1	384
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EXT_NEG_EVENT_2	385
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EXT_NEG_EVENT_3	386
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EXT_NEG_EVENT_4	387
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EXT_NEG_EVENT_5	388
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EXT_NEG_EVENT_6	389
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EXT_NEG_EVENT_7	390
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EXT_POS_EVENT_0	391
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EXT_POS_EVENT_1	392
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EXT_POS_EVENT_2	393
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EXT_POS_EVENT_3	394
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EXT_POS_EVENT_4	395
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EXT_POS_EVENT_5	396
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EXT_POS_EVENT_6	397
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EXT_POS_EVENT_7	398
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EVENT_0	399
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EVENT_1	400
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EVENT_2	401
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EVENT_3	402
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EVENT_4	403
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EVENT_5	404
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EVENT_6	405
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EVENT_7	406
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EVENT_8	407
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EVENT_9	408
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EVENT_10	409
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EVENT_11	410
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EVENT_12	411
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EVENT_13	412
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EVENT_14	413
#define	CMDQ_EVENT_MMSYS_GAZE_MUTEX_AH_EVENT_15	414
#define	CMDQ_EVENT_CAM_SIDE0_CAM0_IR_P1_SOF	512
#define	CMDQ_EVENT_CAM_SIDE0_CAM0_W_P1_SOF	513
#define	CMDQ_EVENT_CAM_SIDE0_CAM1_IR_P1_SOF	514
#define	CMDQ_EVENT_CAM_SIDE0_CAM1_W_P1_SOF	515
#define	CMDQ_EVENT_CAM_SIDE0_CAM0_BE_SOF	516
#define	CMDQ_EVENT_CAM_SIDE0_CAM1_BE_SOF	517
#define	CMDQ_EVENT_CAM_SIDE0_CAM0_IR_FRAME_DONE	518
#define	CMDQ_EVENT_CAM_SIDE0_CAM0_W_FRAME_DONE	519
#define	CMDQ_EVENT_CAM_SIDE0_CAM1_IR_FRAME_DONE	520
#define	CMDQ_EVENT_CAM_SIDE0_CAM1_W_FRAME_DONE	521
#define	CMDQ_EVENT_CAM_SIDE0_CAM0_CAMSV_FRAME_DONE	522
#define	CMDQ_EVENT_CAM_SIDE0_CAM1_CAMSV_FRAME_DONE	523
#define	CMDQ_EVENT_CAM_SIDE0_CAM0_BE_FRAME_DONE	524
#define	CMDQ_EVENT_CAM_SIDE0_CAM1_BE_FRAME_DONE	525
#define	CMDQ_EVENT_CAM_SIDE0_CAM0_RRZO_W_GCE_RGFC_FULL_EVENT	538
#define	CMDQ_EVENT_CAM_SIDE0_CAM0_RRZO_W_RBFC_W_INCOMPLETE_EVENT	539
#define	CMDQ_EVENT_CAM_SIDE0_CAM0_RRZO_W_RBFC_R_INCOMPLETE_EVENT	540
#define	CMDQ_EVENT_CAM_SIDE0_CAM0_RRZO_W_RBFC_W_OV_TH_EVENT	542
#define	CMDQ_EVENT_CAM_SIDE0_CAM1_RRZO_W_RBFC_FULL_EVENT	543
#define	CMDQ_EVENT_CAM_SIDE0_CAM1_RRZO_W_RBFC_W_INCOMPLETE_EVENT	544
#define	CMDQ_EVENT_CAM_SIDE0_CAM1_RRZO_W_RBFC_R_INCOMPLETE_EVENT	545
#define	CMDQ_EVENT_CAM_SIDE0_CAM1_RRZO_W_RBFC_W_OV_TH_EVENT	547
#define	CMDQ_EVENT_CAM_SIDE0_CAM0_BE_REACH_LIM	548
#define	CMDQ_EVENT_CAM_SIDE0_CAM1_BE_REACH_LIM	549
#define	CMDQ_EVENT_CAM_SIDE1_CAM0_IR_P1_SOF	576
#define	CMDQ_EVENT_CAM_SIDE1_CAM0_W_P1_SOF	577
#define	CMDQ_EVENT_CAM_SIDE1_CAM1_IR_P1_SOF	578
#define	CMDQ_EVENT_CAM_SIDE1_CAM1_W_P1_SOF	579
#define	CMDQ_EVENT_CAM_SIDE1_CAM0_BE_SOF	580
#define	CMDQ_EVENT_CAM_SIDE1_CAM1_BE_SOF	581
#define	CMDQ_EVENT_CAM_SIDE1_CAM0_IR_FRAME_DONE	582
#define	CMDQ_EVENT_CAM_SIDE1_CAM0_W_FRAME_DONE	583
#define	CMDQ_EVENT_CAM_SIDE1_CAM1_IR_FRAME_DONE	584
#define	CMDQ_EVENT_CAM_SIDE1_CAM1_W_FRAME_DONE	585
#define	CMDQ_EVENT_CAM_SIDE1_CAM0_CAMSV_FRAME_DONE	586
#define	CMDQ_EVENT_CAM_SIDE1_CAM1_CAMSV_FRAME_DONE	587
#define	CMDQ_EVENT_CAM_SIDE1_CAM0_BE_FRAME_DONE	588
#define	CMDQ_EVENT_CAM_SIDE1_CAM1_BE_FRAME_DONE	589
#define	CMDQ_EVENT_CAM_SIDE1_CAM0_RRZO_W_GCE_RGFC_FULL_EVENT	602
#define	CMDQ_EVENT_CAM_SIDE1_CAM0_RRZO_W_RBFC_W_INCOMPLETE_EVENT	603
#define	CMDQ_EVENT_CAM_SIDE1_CAM0_RRZO_W_RBFC_R_INCOMPLETE_EVENT	604
#define	CMDQ_EVENT_CAM_SIDE1_CAM0_RRZO_W_RBFC_W_OV_TH_EVENT	606
#define	CMDQ_EVENT_CAM_SIDE1_CAM1_RRZO_W_RBFC_FULL_EVENT	607
#define	CMDQ_EVENT_CAM_SIDE1_CAM1_RRZO_W_RBFC_W_INCOMPLETE_EVENT	608
#define	CMDQ_EVENT_CAM_SIDE1_CAM1_RRZO_W_RBFC_R_INCOMPLETE_EVENT	609
#define	CMDQ_EVENT_CAM_SIDE1_CAM1_RRZO_W_RBFC_W_OV_TH_EVENT	611
#define	CMDQ_EVENT_CAM_SIDE1_CAM0_BE_REACH_LIM	612
#define	CMDQ_EVENT_CAM_SIDE1_CAM1_BE_REACH_LIM	613
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_P2_SOF	640
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_P2_SOF	641
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_P2_CQ_LOAD_DONE_0	642
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_P2_CQ_LOAD_DONE_1	643
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_P2_CQ_LOAD_DONE_2	644
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_P2_CQ_LOAD_DONE_3	645
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_P2_CQ_LOAD_DONE_4	646
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_P2_CQ_LOAD_DONE_5	647
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_P2_CQ_LOAD_DONE_6	648
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_P2_CQ_LOAD_DONE_7	649
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_P2_CQ_LOAD_DONE_8	650
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_P2_CQ_LOAD_DONE_9	651
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_P2_CQ_LOAD_DONE_10	652
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_P2_CQ_LOAD_DONE_11	653
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_P2_CQ_LOAD_DONE_12	654
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_P2_CQ_LOAD_DONE_13	655
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_P2_CQ_LOAD_DONE_0	661
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_P2_CQ_LOAD_DONE_1	662
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_P2_CQ_LOAD_DONE_2	663
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_P2_CQ_LOAD_DONE_3	664
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_P2_CQ_LOAD_DONE_4	665
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_P2_CQ_LOAD_DONE_5	666
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_P2_CQ_LOAD_DONE_6	667
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_P2_CQ_LOAD_DONE_7	668
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_P2_CQ_LOAD_DONE_8	669
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_P2_CQ_LOAD_DONE_9	670
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_P2_CQ_LOAD_DONE_10	671
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_P2_CQ_LOAD_DONE_11	672
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_P2_CQ_LOAD_DONE_12	673
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_P2_CQ_LOAD_DONE_13	674
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_P2_CQ_TRIG	680
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_P2_CQ_TRIG	681
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_IMGI_R_RBFC_W_INCOMPLETE_EVENT	682
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_IMGI_R_RBFC_R_INCOMPLETE_EVENT	683
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_IMGI_R_RBFC_W_OV_TH_EVENT	685
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_IMGI_R_RBFC_W_INCOMPLETE_EVENT	686
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_IMGI_R_RBFC_R_INCOMPLETE_EVENT	687
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_IMGI_R_RBFC_W_OV_TH_EVENT	689
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_IMG3O_W_RBFC_FULL_EVENT	690
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_IMG3O_W_RBFC_W_INCOMPLETE_EVENT	691
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_IMG3O_W_RBFC_R_INCOMPLETE_EVENT	692
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_IMG3O_W_RBFC_MODE_CHANGE_EVENT	693
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_IMG3O_W_RBFC_W_OV_TH_EVENT	694
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_IMG3O_W_RBFC_FULL_EVENT	695
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_IMG3O_W_RBFC_W_INCOMPLETE_EVENT	696
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_IMG3O_W_RBFC_R_INCOMPLETE_EVENT	697
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_IMG3O_W_RBFC_MODE_CHANGE_EVENT	698
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_IMG3O_W_RBFC_W_OV_TH_EVENT	699
#define	CMDQ_EVENT_IMG_SIDE0_CAM0_P2_DONE	700
#define	CMDQ_EVENT_IMG_SIDE0_CAM1_P2_DONE	701
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_P2_SOF	704
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_P2_SOF	705
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_P2_CQ_LOAD_DONE_0	706
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_P2_CQ_LOAD_DONE_1	707
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_P2_CQ_LOAD_DONE_2	708
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_P2_CQ_LOAD_DONE_3	709
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_P2_CQ_LOAD_DONE_4	710
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_P2_CQ_LOAD_DONE_5	711
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_P2_CQ_LOAD_DONE_6	712
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_P2_CQ_LOAD_DONE_7	713
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_P2_CQ_LOAD_DONE_8	714
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_P2_CQ_LOAD_DONE_9	715
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_P2_CQ_LOAD_DONE_10	716
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_P2_CQ_LOAD_DONE_11	717
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_P2_CQ_LOAD_DONE_12	718
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_P2_CQ_LOAD_DONE_13	719
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_P2_CQ_LOAD_DONE_0	725
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_P2_CQ_LOAD_DONE_1	726
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_P2_CQ_LOAD_DONE_2	727
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_P2_CQ_LOAD_DONE_3	728
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_P2_CQ_LOAD_DONE_4	729
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_P2_CQ_LOAD_DONE_5	730
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_P2_CQ_LOAD_DONE_6	731
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_P2_CQ_LOAD_DONE_7	732
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_P2_CQ_LOAD_DONE_8	733
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_P2_CQ_LOAD_DONE_9	734
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_P2_CQ_LOAD_DONE_10	735
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_P2_CQ_LOAD_DONE_11	736
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_P2_CQ_LOAD_DONE_12	737
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_P2_CQ_LOAD_DONE_13	738
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_P2_CQ_TRIG	744
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_P2_CQ_TRIG	745
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_IMGI_R_RBFC_W_INCOMPLETE_EVENT	746
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_IMGI_R_RBFC_R_INCOMPLETE_EVENT	747
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_IMGI_R_RBFC_W_OV_TH_EVENT	749
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_IMGI_R_RBFC_W_INCOMPLETE_EVENT	750
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_IMGI_R_RBFC_R_INCOMPLETE_EVENT	751
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_IMGI_R_RBFC_W_OV_TH_EVENT	753
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_IMG3O_W_RBFC_FULL_EVENT	754
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_IMG3O_W_RBFC_W_INCOMPLETE_EVENT	755
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_IMG3O_W_RBFC_R_INCOMPLETE_EVENT	756
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_IMG3O_W_RBFC_MODE_CHANGE_EVENT	757
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_IMG3O_W_RBFC_W_OV_TH_EVENT	758
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_IMG3O_W_RBFC_FULL_EVENT	759
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_IMG3O_W_RBFC_W_INCOMPLETE_EVENT	760
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_IMG3O_W_RBFC_R_INCOMPLETE_EVENT	761
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_IMG3O_W_RBFC_MODE_CHANGE_EVENT	762
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_IMG3O_W_RBFC_W_OV_TH_EVENT	763
#define	CMDQ_EVENT_IMG_SIDE1_CAM0_P2_DONE	764
#define	CMDQ_EVENT_IMG_SIDE1_CAM1_P2_DONE	765
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P1_SOF	768
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_SOF	769
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_FRAME_DONE	770
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_CAMSV_FRAME_DONE	771
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_0	773
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_1	774
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_2	775
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_3	776
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_4	777
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_5	778
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_6	779
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_7	780
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_8	781
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_9	782
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_10	783
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_11	784
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_12	785
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_13	786
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_14	787
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_15	788
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_16	789
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_17	790
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_LOAD_DONE_18	791
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_SOF_DONE	792
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_RBFC_RRZO_W_RBFC_FULL_EVENT	795
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_RBFC_RRZO_W_RBFC_W_INCOMPLETE_EVENT	796
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_RBFC_RRZO_W_RBFC_R_INCOMPLETE_EVENT	797
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_RBFC_RRZO_W_RBFC_W_OV_TH_EVENT	799
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_P2_CQ_TRIG	800
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_RBFC_IMGI_R_RBFC_W_INCOMPLETE_EVENT	801
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_RBFC_IMGI_R_RBFC_R_INCOMPLETE_EVENT	802
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_RBFC_IMGI_R_RBFC_W_OV_TH_EVENT	804
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_RBFC_IMG3O_W_RBFC_FULL_EVENT	805
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_RBFC_IMG3O_W_RBFC_W_INCOMPLETE_EVENT	806
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_RBFC_IMG3O_W_RBFC_R_INCOMPLETE_EVENT	807
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_RBFC_IMG3O_W_RBFC_MODE_CHANGE_EVENT	808
#define	CMDQ_EVENT_ISP_GAZE0_CAM0_RBFC_IMG3O_W_RBFC_W_OV_TH_EVENT	809
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P1_SOF	832
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_SOF	833
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_FRAME_DONE	834
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_CAMSV_FRAME_DONE	835
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_0	837
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_1	838
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_2	839
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_3	840
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_4	841
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_5	842
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_6	843
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_7	844
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_8	845
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_9	846
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_10	847
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_11	848
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_12	849
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_13	850
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_14	851
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_15	852
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_16	853
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_17	854
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_LOAD_DONE_18	855
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_SOF_DONE	856
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_RBFC_RRZO_W_RBFC_FULL_EVENT	859
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_RBFC_RRZO_W_RBFC_W_INCOMPLETE_EVENT	860
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_RBFC_RRZO_W_RBFC_R_INCOMPLETE_EVENT	861
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_RBFC_RRZO_W_RBFC_W_OV_TH_EVENT	863
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_P2_CQ_TRIG	864
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_RBFC_IMGI_R_RBFC_W_INCOMPLETE_EVENT	865
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_RBFC_IMGI_R_RBFC_R_INCOMPLETE_EVENT	866
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_RBFC_IMGI_R_RBFC_W_OV_TH_EVENT	868
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_RBFC_IMG3O_W_RBFC_FULL_EVENT	869
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_RBFC_IMG3O_W_RBFC_W_INCOMPLETE_EVENT	870
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_RBFC_IMG3O_W_RBFC_R_INCOMPLETE_EVENT	871
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_RBFC_IMG3O_W_RBFC_MODE_CHANGE_EVENT	872
#define	CMDQ_EVENT_ISP_GAZE1_CAM1_RBFC_IMG3O_W_RBFC_W_OV_TH_EVENT	873
#define	CMDQ_EVENT_CAM_VSYNC_EMI_SOF	896
#define	CMDQ_EVENT_CAM_VSYNC_0_EVENT	897
#define	CMDQ_EVENT_CAM_VSYNC_1_EVENT	898
#define	CMDQ_EVENT_CAM_VSYNC_2_EVENT	899
#define	CMDQ_EVENT_CAM_VSYNC_3_EVENT	900
#define	CMDQ_EVENT_CAM_VSYNC_4_EVENT	901
#define	CMDQ_EVENT_CAM_VSYNC_0_TAIL_EVENT	902
#define	CMDQ_EVENT_CAM_VSYNC_1_TAIL_EVENT	903
#define	CMDQ_EVENT_CAM_VSYNC_2_TAIL_EVENT	904
#define	CMDQ_EVENT_CAM_VSYNC_3_TAIL_EVENT	905
#define	CMDQ_EVENT_CAM_VSYNC_4_TAIL_EVENT	906
#define	CMDQ_EVENT_CAM_VSYNC_EMI_EOF	907
#define	CMDQ_EVENT_CAM_VSYNC_DSI0_VACTL_EVENT	908
#define	CMDQ_EVENT_CAM_VSYNC_DSI1_VACTL_EVENT	909
#define	CMDQ_EVENT_CAM_VSYNC_DSI2_VACTL_EVENT	910
#define	CMDQ_EVENT_CAM_VSYNC_DSI3_VACTL_EVENT	911
#define	CMDQ_EVENT_VPU_0_IRQ	928
#define	CMDQ_EVENT_VPU_1_IRQ	929
#define	CMDQ_EVENT_VPU_2_IRQ	930


#endif /* _DT_BINDINGS_GCE_MT3612_H */

