/*
 * Copyright (c) 2018 MediaTek Inc.
 * Authors:
 *	Houlong Wei <houlong.wei@mediatek.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/**
 * @file mtk_mutex_reg.h
 * Register definition header of mtk_mutex.c
 */

#ifndef __MTK_MUTEX_REG_H__
#define __MTK_MUTEX_REG_H__

/* ----------------- Register Definitions ------------------- */
#define DISP_MUTEX_INTEN				0x00000000
	#define MUTEX_INTEN				GENMASK(31, 0)
#define DISP_MUTEX_INTSTA				0x00000004
	#define MUTEX_INTSTA				GENMASK(31, 0)
#define DISP_MUTEX_CFG					0x00000008
	#define MUTEX_CFG				BIT(0)
#define DISP_REG_UPD_TIMEOUT				0x0000000c
	#define REG_UPD_TIMEOUT				GENMASK(7, 0)
#define DISP_REG_COMMIT0				0x00000010
	#define REG_COMMIT				GENMASK(31, 0)
#define DISP_REG_COMMIT1				0x00000014
	#define REG_COMMIT				GENMASK(31, 0)
#define DISP_MUTEX_INTEN_1				0x00000018
	#define MUTEX_INTEN_1				GENMASK(31, 0)
#define DISP_MUTEX_INTSTA_1				0x0000001c
	#define MUTEX_INTSTA_1				GENMASK(31, 0)
#define DISP_MUTEX0_EN					0x00000020
	#define MUTEX_EN				BIT(0)
	#define AH_EN					BIT(1)
	#define AH_REF_EN				BIT(2)
	#define AH_AUTO_OFF_MUTEX_EN			BIT(3)
	#define AH_EVENT_EN				BIT(4)
	#define AH_REF_EVENT_EN				BIT(5)
	#define AH_EXT_SIGNAL_EN			BIT(6)
	#define AH_CUR_ACTIVE_REGION			BIT(7)
	#define AH_REF_MUTEX				GENMASK(11, 8)
	#define SOF_MOD_CNT				GENMASK(15, 12)
	#define AH_NOT_AUTO_CLEAR_ERROR_BIT		BIT(16)
	#define AH_NOT_AUTO_CLEAR_REF_ERROR_BIT		BIT(17)
	#define AH_ERROR_BIT				BIT(18)
	#define AH_REF_ERROR_BIT			BIT(19)
	#define AH_EXT_SIGNAL_BIT			BIT(20)
	#define MUTEX_SOFEOF_MASK			BIT(21)
#define DISP_MUTEX0_GET					0x00000024
	#define MUTEX_GET				BIT(0)
	#define INT_MUTEX_GET				BIT(1)
	#define MUTEX_GET_DUMMY				GENMASK(15, 2)
	#define AH_STATE				GENMASK(23, 16)
	#define AH_REF_STATE				GENMASK(31, 24)
#define DISP_MUTEX0_RST					0x00000028
	#define MUTEX_RST				BIT(0)
	#define MUTEX_RST_DUMMY				GENMASK(15, 1)
	#define AH_ERR_MASK_MSB				GENMASK(31, 16)
#define DISP_MUTEX0_CTL					0x0000002c
	#define MUTEX_SOF				GENMASK(5, 0)
	#define MUTEX_SOF_TIMING			GENMASK(7, 6)
	#define MUTEX_EOF				GENMASK(13, 8)
	#define MUTEX_EOF_TIMING			GENMASK(15, 14)
	#define AH_REF_ERR_MASK_MSB			GENMASK(31, 16)
#define DISP_MUTEX0_MOD0				0x00000030
	#define MUTEX_MOD0				GENMASK(31, 0)
#define DISP_MUTEX0_MOD1				0x00000034
	#define MUTEX_MOD1				GENMASK(31, 0)
#define DISP_MUTEX0_AH_ERR_MASK				0x00000038
	#define AH_ERR_MASK_LSB				GENMASK(15, 0)
	#define AH_REF_ERR_MASK_LSB			GENMASK(31, 16)
#define DISP_MUTEX0_SOF_TSTAMP				0x0000003c
	#define AH_SOF_TSTAMP				GENMASK(19, 0)
#define DISP_MUTEX1_EN					0x00000040
#define DISP_MUTEX1_GET					0x00000044
#define DISP_MUTEX1_RST					0x00000048
#define DISP_MUTEX1_CTL					0x0000004c
#define DISP_MUTEX1_MOD0				0x00000050
#define DISP_MUTEX1_MOD1				0x00000054
#define DISP_MUTEX1_AH_ERR_MASK				0x00000058
#define DISP_MUTEX1_SOF_TSTAMP				0x0000005c
#define DISP_MUTEX2_EN					0x00000060
#define DISP_MUTEX2_GET					0x00000064
#define DISP_MUTEX2_RST					0x00000068
#define DISP_MUTEX2_CTL					0x0000006c
#define DISP_MUTEX2_MOD0				0x00000070
#define DISP_MUTEX2_MOD1				0x00000074
#define DISP_MUTEX2_AH_ERR_MASK				0x00000078
#define DISP_MUTEX2_SOF_TSTAMP				0x0000007c
#define DISP_MUTEX3_EN					0x00000080
#define DISP_MUTEX3_GET					0x00000084
#define DISP_MUTEX3_RST					0x00000088
#define DISP_MUTEX3_CTL					0x0000008c
#define DISP_MUTEX3_MOD0				0x00000090
#define DISP_MUTEX3_MOD1				0x00000094
#define DISP_MUTEX3_AH_ERR_MASK				0x00000098
#define DISP_MUTEX3_SOF_TSTAMP				0x0000009c
#define DISP_MUTEX4_EN					0x000000a0
#define DISP_MUTEX4_GET					0x000000a4
#define DISP_MUTEX4_RST					0x000000a8
#define DISP_MUTEX4_CTL					0x000000ac
#define DISP_MUTEX4_MOD0				0x000000b0
#define DISP_MUTEX4_MOD1				0x000000b4
#define DISP_MUTEX4_AH_ERR_MASK				0x000000b8
#define DISP_MUTEX4_SOF_TSTAMP				0x000000bc
#define DISP_MUTEX5_EN					0x000000c0
#define DISP_MUTEX5_GET					0x000000c4
#define DISP_MUTEX5_RST					0x000000c8
#define DISP_MUTEX5_CTL					0x000000cc
#define DISP_MUTEX5_MOD0				0x000000d0
#define DISP_MUTEX5_MOD1				0x000000d4
#define DISP_MUTEX5_AH_ERR_MASK				0x000000d8
#define DISP_MUTEX5_SOF_TSTAMP				0x000000dc
#define DISP_MUTEX6_EN					0x000000e0
#define DISP_MUTEX6_GET					0x000000e4
#define DISP_MUTEX6_RST					0x000000e8
#define DISP_MUTEX6_CTL					0x000000ec
#define DISP_MUTEX6_MOD0				0x000000f0
#define DISP_MUTEX6_MOD1				0x000000f4
#define DISP_MUTEX6_AH_ERR_MASK				0x000000f8
#define DISP_MUTEX6_SOF_TSTAMP				0x000000fc
#define DISP_MUTEX7_EN					0x00000100
#define DISP_MUTEX7_GET					0x00000104
#define DISP_MUTEX7_RST					0x00000108
#define DISP_MUTEX7_CTL					0x0000010c
#define DISP_MUTEX7_MOD0				0x00000110
#define DISP_MUTEX7_MOD1				0x00000114
#define DISP_MUTEX7_AH_ERR_MASK				0x00000118
#define DISP_MUTEX7_SOF_TSTAMP				0x0000011c
#define DISP_MUTEX8_EN					0x00000120
#define DISP_MUTEX8_GET					0x00000124
#define DISP_MUTEX8_RST					0x00000128
#define DISP_MUTEX8_CTL					0x0000012c
#define DISP_MUTEX8_MOD0				0x00000130
#define DISP_MUTEX8_MOD1				0x00000134
#define DISP_MUTEX8_AH_ERR_MASK				0x00000138
#define DISP_MUTEX8_SOF_TSTAMP				0x0000013c
#define DISP_MUTEX9_EN					0x00000140
#define DISP_MUTEX9_GET					0x00000144
#define DISP_MUTEX9_RST					0x00000148
#define DISP_MUTEX9_CTL					0x0000014c
#define DISP_MUTEX9_MOD0				0x00000150
#define DISP_MUTEX9_MOD1				0x00000154
#define DISP_MUTEX9_AH_ERR_MASK				0x00000158
#define DISP_MUTEX9_SOF_TSTAMP				0x0000015c
#define DISP_MUTEX10_EN					0x00000160
#define DISP_MUTEX10_GET				0x00000164
#define DISP_MUTEX10_RST				0x00000168
#define DISP_MUTEX10_CTL				0x0000016c
#define DISP_MUTEX10_MOD0				0x00000170
#define DISP_MUTEX10_MOD1				0x00000174
#define DISP_MUTEX10_AH_ERR_MASK			0x00000178
#define DISP_MUTEX10_SOF_TSTAMP				0x0000017c
#define DISP_MUTEX11_EN					0x00000180
#define DISP_MUTEX11_GET				0x00000184
#define DISP_MUTEX11_RST				0x00000188
#define DISP_MUTEX11_CTL				0x0000018c
#define DISP_MUTEX11_MOD0				0x00000190
#define DISP_MUTEX11_MOD1				0x00000194
#define DISP_MUTEX11_AH_ERR_MASK			0x00000198
#define DISP_MUTEX11_SOF_TSTAMP				0x0000019c
#define DISP_MUTEX12_EN					0x000001a0
#define DISP_MUTEX12_GET				0x000001a4
#define DISP_MUTEX12_RST				0x000001a8
#define DISP_MUTEX12_CTL				0x000001ac
#define DISP_MUTEX12_MOD0				0x000001b0
#define DISP_MUTEX12_MOD1				0x000001b4
#define DISP_MUTEX12_AH_ERR_MASK			0x000001b8
#define DISP_MUTEX12_SOF_TSTAMP				0x000001bc
#define DISP_MUTEX13_EN					0x000001c0
#define DISP_MUTEX13_GET				0x000001c4
#define DISP_MUTEX13_RST				0x000001c8
#define DISP_MUTEX13_CTL				0x000001cc
#define DISP_MUTEX13_MOD0				0x000001d0
#define DISP_MUTEX13_MOD1				0x000001d4
#define DISP_MUTEX13_AH_ERR_MASK			0x000001d8
#define DISP_MUTEX13_SOF_TSTAMP				0x000001dc
#define DISP_MUTEX14_EN					0x000001e0
#define DISP_MUTEX14_GET				0x000001e4
#define DISP_MUTEX14_RST				0x000001e8
#define DISP_MUTEX14_CTL				0x000001ec
#define DISP_MUTEX14_MOD0				0x000001f0
#define DISP_MUTEX14_MOD1				0x000001f4
#define DISP_MUTEX14_AH_ERR_MASK			0x000001f8
#define DISP_MUTEX14_SOF_TSTAMP				0x000001fc
#define DISP_MUTEX15_EN					0x00000200
#define DISP_MUTEX15_GET				0x00000204
#define DISP_MUTEX15_RST				0x00000208
#define DISP_MUTEX15_CTL				0x0000020c
#define DISP_MUTEX15_MOD0				0x00000210
#define DISP_MUTEX15_MOD1				0x00000214
#define DISP_MUTEX15_AH_ERR_MASK			0x00000218
#define DISP_MUTEX15_SOF_TSTAMP				0x0000021c
#define DISP_MUTEX_DUMMY0				0x00000300
	#define MUTEX_DUMMY0				GENMASK(31, 0)
#define DISP_MUTEX_DUMMY1				0x00000304
	#define MUTEX_DUMMY1				GENMASK(31, 0)
#define DISP_MUTEX_DUMMY2				0x00000308
	#define MUTEX_DUMMY2				GENMASK(31, 0)
#define DISP_MUTEX_DEBUG_OUT_SEL			0x0000030c
	#define DEBUG_SYNC_DLY_SUB_SEL			GENMASK(7, 4)
	#define DEBUG_SYNC_DLY_SEL			GENMASK(12, 8)
	#define DEBUG_OUT_SEL				GENMASK(20, 16)
	#define DEBUG_EN				BIT(24)
#define DISP_MUTEX_DEBUG_SYNC_DLY_INFO			0x00000310
	#define DEBUG_SYNC_DLY_FIFO_TSTAMP		GENMASK(19, 0)
	#define DEBUG_SYNC_DLY_FIFO_SYNC		GENMASK(21, 20)
	#define DEBUG_SYNC_DLY_FIFO_VALID		BIT(22)
#define DISP_MUTEX_F26M_CNT_CFG				0x00000314
	#define F26M_SW_RST				BIT(0)
	#define F26M_ENABLE				BIT(1)
#define DISP_MUTEX_F26M_CNT_INFO			0x00000318
	#define F26M_CNT_VALUE				GENMASK(19, 0)
#define DISP_MUTEX_INTEN_2				0x0000031c
	#define MUTEX_INTEN_2				GENMASK(31, 0)
#define DISP_MUTEX_INTSTA_2				0x00000320
	#define MUTEX_INTSTA_2				GENMASK(31, 0)
#define DISP_MUTEX_INTEN_3				0x00000324
	#define MUTEX_INTEN_3				GENMASK(31, 0)
#define DISP_MUTEX_INTSTA_3				0x00000328
	#define MUTEX_INTSTA_3				GENMASK(31, 0)
#define DISP_MUTEX_INTEN_4				0x0000032c
	#define MUTEX_INTEN_4				GENMASK(31, 0)
#define DISP_MUTEX_INTSTA_4				0x00000330
	#define MUTEX_INTSTA_4				GENMASK(31, 0)
#define DISP_MUTEX_INTEN_5				0x00000334
	#define MUTEX_INTEN_5				GENMASK(31, 0)
#define DISP_MUTEX_INTSTA_5				0x00000338
	#define MUTEX_INTSTA_5				GENMASK(31, 0)
#define DISP_MUTEX_INTEN_6				0x0000033c
	#define MUTEX_INTEN_6				GENMASK(31, 0)
#define DISP_MUTEX_INTSTA_6				0x00000340
	#define MUTEX_INTSTA_6				GENMASK(31, 0)
#define DISP_MUTEX_INTEN_7				0x00000344
	#define MUTEX_INTEN_7				GENMASK(31, 0)
#define DISP_MUTEX_INTSTA_7				0x00000348
	#define MUTEX_INTSTA_7				GENMASK(31, 0)
#define DISP_MUTEX_INTEN_8				0x0000034c
	#define MUTEX_INTEN_8				GENMASK(31, 0)
#define DISP_MUTEX_INTSTA_8				0x00000350
	#define MUTEX_INTSTA_8				GENMASK(31, 0)
#define DISP_MUTEX_INTEN_9				0x00000354
	#define MUTEX_INTEN_9				GENMASK(31, 0)
#define DISP_MUTEX_INTSTA_9				0x00000358
	#define MUTEX_INTSTA_9				GENMASK(31, 0)
#define DISP_MUTEX_INTEN_A				0x0000035c
	#define MUTEX_INTEN_A				GENMASK(31, 0)
#define DISP_MUTEX_INTSTA_A				0x00000360
	#define MUTEX_INTSTA_A				GENMASK(31, 0)
#define DISP_MUTEX_DUMMY3				0x00000364
	#define MUTEX_DUMMY3				GENMASK(31, 0)
#define DISP_MUTEX_DUMMY4				0x00000368
	#define MUTEX_DUMMY4				GENMASK(31, 0)
#define DISP_MUTEX_DUMMY5				0x0000036c
	#define MUTEX_DUMMY5				GENMASK(31, 0)
#define DISP_MUTEX_ERR_CFG				0x00000370
	#define MUTEX_ERR_CFG				GENMASK(31, 0)
#define DISP_MUTEX_ERR_INFO				0x00000374
	#define MUTEX_ERR_INFO				GENMASK(31, 0)
#define DISP_MUTEX_EXT_INFO				0x00000378
	#define MUTEX_EXT_INFO				GENMASK(7, 0)
#define DISP_MUTEX_SYNC_DLY_RST				0x0000037c
	#define MUTEX_SYNC_DLY_RST			GENMASK(7, 0)
#define DISP_MUTEX_SYNC_DLY_EN				0x00000380
	#define MUTEX_SYNC_DLY_EN			GENMASK(7, 0)
#define DISP_MUTEX_SYNC_DLY_0_CFG			0x00000384
	#define MUTEX_SYNC_DLY_0_DLY_VALUE		GENMASK(19, 0)
	#define MUTEX_SYNC_DLY_0_SYNC_SEL		GENMASK(29, 24)
#define DISP_MUTEX_SYNC_DLY_1_CFG			0x00000388
	#define MUTEX_SYNC_DLY_1_DLY_VALUE		GENMASK(19, 0)
	#define MUTEX_SYNC_DLY_1_SYNC_SEL		GENMASK(29, 24)
#define DISP_MUTEX_SYNC_DLY_2_CFG			0x0000038c
	#define MUTEX_SYNC_DLY_2_DLY_VALUE		GENMASK(19, 0)
	#define MUTEX_SYNC_DLY_2_SYNC_SEL		GENMASK(29, 24)
#define DISP_MUTEX_SYNC_DLY_3_CFG			0x00000390
	#define MUTEX_SYNC_DLY_3_DLY_VALUE		GENMASK(19, 0)
	#define MUTEX_SYNC_DLY_3_SYNC_SEL		GENMASK(29, 24)
#define DISP_MUTEX_SYNC_DLY_4_CFG			0x00000394
	#define MUTEX_SYNC_DLY_4_DLY_VALUE		GENMASK(19, 0)
	#define MUTEX_SYNC_DLY_4_SYNC_SEL		GENMASK(29, 24)
#define DISP_MUTEX_SYNC_DLY_5_CFG			0x00000398
	#define MUTEX_SYNC_DLY_5_DLY_VALUE		GENMASK(19, 0)
	#define MUTEX_SYNC_DLY_5_SYNC_SEL		GENMASK(29, 24)
#define DISP_MUTEX_SYNC_DLY_6_CFG			0x0000039c
	#define MUTEX_SYNC_DLY_6_DLY_VALUE		GENMASK(19, 0)
	#define MUTEX_SYNC_DLY_6_SYNC_SEL		GENMASK(29, 24)
#define DISP_MUTEX_SYNC_DLY_7_CFG			0x000003a0
	#define MUTEX_SYNC_DLY_7_DLY_VALUE		GENMASK(19, 0)
	#define MUTEX_SYNC_DLY_7_SYNC_SEL		GENMASK(29, 24)
#define DISP_MUTEX_TDEBUG_0_CFG0			0x00000404
	#define MUTEX_TDEBUG_0_CFG			GENMASK(23, 0)
	#define MUTEX_TDEBUG_0_STATE			GENMASK(31, 24)
#define DISP_MUTEX_TDEBUG_0_CFG1			0x00000408
	#define MUTEX_TDEBUG_0_SRC_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_0_CFG2			0x0000040c
	#define MUTEX_TDEBUG_0_REF_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_0_CFG3			0x00000410
	#define MUTEX_TDEBUG_0_SRC_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_0_CFG4			0x00000414
	#define MUTEX_TDEBUG_0_REF_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_1_CFG0			0x00000418
	#define MUTEX_TDEBUG_1_CFG			GENMASK(23, 0)
	#define MUTEX_TDEBUG_1_STATE			GENMASK(31, 24)
#define DISP_MUTEX_TDEBUG_1_CFG1			0x0000041c
	#define MUTEX_TDEBUG_1_SRC_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_1_CFG2			0x00000420
	#define MUTEX_TDEBUG_1_REF_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_1_CFG3			0x00000424
	#define MUTEX_TDEBUG_1_SRC_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_1_CFG4			0x00000428
	#define MUTEX_TDEBUG_1_REF_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_2_CFG0			0x0000042c
	#define MUTEX_TDEBUG_2_CFG			GENMASK(23, 0)
	#define MUTEX_TDEBUG_2_STATE			GENMASK(31, 24)
#define DISP_MUTEX_TDEBUG_2_CFG1			0x00000430
	#define MUTEX_TDEBUG_2_SRC_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_2_CFG2			0x00000434
	#define MUTEX_TDEBUG_2_REF_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_2_CFG3			0x00000438
	#define MUTEX_TDEBUG_2_SRC_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_2_CFG4			0x0000043c
	#define MUTEX_TDEBUG_2_REF_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_3_CFG0			0x00000440
	#define MUTEX_TDEBUG_3_CFG			GENMASK(23, 0)
	#define MUTEX_TDEBUG_3_STATE			GENMASK(31, 24)
#define DISP_MUTEX_TDEBUG_3_CFG1			0x00000444
	#define MUTEX_TDEBUG_3_SRC_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_3_CFG2			0x00000448
	#define MUTEX_TDEBUG_3_REF_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_3_CFG3			0x0000044c
	#define MUTEX_TDEBUG_3_SRC_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_3_CFG4			0x00000450
	#define MUTEX_TDEBUG_3_REF_TIME			GENMASK(31, 0)
#define DISP_MUTEX_EXTSIG0_MUTEX_MASK			0x000004a4
	#define MUTEX_EXTSIG_0_MUTEX_MASK		GENMASK(15, 0)
#define DISP_MUTEX_EXTSIG_0_ERR_MASK			0x000004a8
	#define MUTEX_EXTSIG_0_ERR_MASK			GENMASK(31, 0)
#define DISP_MUTEX_EXTSIG_1_MUTEX_MASK			0x000004ac
	#define MUTEX_EXTSIG_1_MUTEX_MASK		GENMASK(15, 0)
#define DISP_MUTEX_EXTSIG_1_ERR_MASK			0x000004b0
	#define MUTEX_EXTSIG_1_ERR_MASK			GENMASK(31, 0)
#define DISP_MUTEX_EXTSIG_2_MUTEX_MASK			0x000004b4
	#define MUTEX_EXTSIG_2_MUTEX_MASK		GENMASK(15, 0)
#define DISP_MUTEX_EXTSIG_2_ERR_MASK			0x000004b8
	#define MUTEX_EXTSIG_2_ERR_MASK			GENMASK(31, 0)
#define DISP_MUTEX_EXTSIG_3_MUTEX_MASK			0x000004bc
	#define MUTEX_EXTSIG_3_MUTEX_MASK		GENMASK(15, 0)
#define DISP_MUTEX_EXTSIG_3_ERR_MASK			0x000004c0
	#define MUTEX_EXTSIG_3_ERR_MASK			GENMASK(31, 0)
#define DISP_MUTEX_EXTSIG_4_MUTEX_MASK			0x000004c4
	#define MUTEX_EXTSIG_4_MUTEX_MASK		GENMASK(15, 0)
#define DISP_MUTEX_EXTSIG_4_ERR_MASK			0x000004c8
	#define MUTEX_EXTSIG_4_ERR_MASK			GENMASK(31, 0)
#define DISP_MUTEX_EXTSIG_5_MUTEX_MASK			0x000004cc
	#define MUTEX_EXTSIG_5_MUTEX_MASK		GENMASK(15, 0)
#define DISP_MUTEX_EXTSIG_5_ERR_MASK			0x000004d0
	#define MUTEX_EXTSIG_5_ERR_MASK			GENMASK(31, 0)
#define DISP_MUTEX_EXTSIG_6_MUTEX_MASK			0x000004d4
	#define MUTEX_EXTSIG_6_MUTEX_MASK		GENMASK(15, 0)
#define DISP_MUTEX_EXTSIG_6_ERR_MASK			0x000004d8
	#define MUTEX_EXTSIG_6_ERR_MASK			GENMASK(31, 0)
#define DISP_MUTEX_EXTSIG_7_MUTEX_MASK			0x000004dc
	#define MUTEX_EXTSIG_7_MUTEX_MASK		GENMASK(15, 0)
#define DISP_MUTEX_EXTSIG_7_ERR_MASK			0x000004e0
	#define MUTEX_EXTSIG_7_ERR_MASK			GENMASK(31, 0)
#define DISP_MUTEX_EOF_MASK_LSB				0x000005a4
#define DISP_MUTEX_EOF_MASK_MSB				0x000005a8
#define DISP_MUTEX_TDEBUG_4_CFG0			0x000005ac
	#define MUTEX_TDEBUG_4_CFG			GENMASK(23, 0)
	#define MUTEX_TDEBUG_4_STATE			GENMASK(31, 24)
#define DISP_MUTEX_TDEBUG_4_CFG1			0x000005b0
	#define MUTEX_TDEBUG_4_SRC_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_4_CFG2			0x000005b4
	#define MUTEX_TDEBUG_4_REF_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_4_CFG3			0x000005b8
	#define MUTEX_TDEBUG_4_SRC_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_4_CFG4			0x000005bc
	#define MUTEX_TDEBUG_4_REF_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_5_CFG0			0x000005c0
	#define MUTEX_TDEBUG_5_CFG			GENMASK(23, 0)
	#define MUTEX_TDEBUG_5_STATE			GENMASK(31, 24)
#define DISP_MUTEX_TDEBUG_5_CFG1			0x000005c4
	#define MUTEX_TDEBUG_5_SRC_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_5_CFG2			0x000005c8
	#define MUTEX_TDEBUG_5_REF_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_5_CFG3			0x000005cc
	#define MUTEX_TDEBUG_5_SRC_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_5_CFG4			0x000005d0
	#define MUTEX_TDEBUG_5_REF_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_6_CFG0			0x000005d4
	#define MUTEX_TDEBUG_6_CFG			GENMASK(23, 0)
	#define MUTEX_TDEBUG_6_STATE			GENMASK(31, 24)
#define DISP_MUTEX_TDEBUG_6_CFG1			0x000005d8
	#define MUTEX_TDEBUG_6_SRC_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_6_CFG2			0x000005dc
	#define MUTEX_TDEBUG_6_REF_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_6_CFG3			0x000005e0
	#define MUTEX_TDEBUG_6_SRC_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_6_CFG4			0x000005e4
	#define MUTEX_TDEBUG_6_REF_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_7_CFG0			0x000005e8
	#define MUTEX_TDEBUG_7_CFG			GENMASK(23, 0)
	#define MUTEX_TDEBUG_7_STATE			GENMASK(31, 24)
#define DISP_MUTEX_TDEBUG_7_CFG1			0x000005ec
	#define MUTEX_TDEBUG_7_SRC_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_7_CFG2			0x000005f0
	#define MUTEX_TDEBUG_7_REF_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_7_CFG3			0x000005f4
	#define MUTEX_TDEBUG_7_SRC_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_7_CFG4			0x000005f8
	#define MUTEX_TDEBUG_7_REF_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_8_CFG0			0x000005fc
	#define MUTEX_TDEBUG_8_CFG			GENMASK(23, 0)
	#define MUTEX_TDEBUG_8_STATE			GENMASK(31, 24)
#define DISP_MUTEX_TDEBUG_8_CFG1			0x00000600
	#define MUTEX_TDEBUG_8_SRC_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_8_CFG2			0x00000604
	#define MUTEX_TDEBUG_8_REF_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_8_CFG3			0x00000608
	#define MUTEX_TDEBUG_8_SRC_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_8_CFG4			0x0000060c
	#define MUTEX_TDEBUG_8_REF_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_9_CFG0			0x00000610
	#define MUTEX_TDEBUG_9_CFG			GENMASK(23, 0)
	#define MUTEX_TDEBUG_9_STATE			GENMASK(31, 24)
#define DISP_MUTEX_TDEBUG_9_CFG1			0x00000614
	#define MUTEX_TDEBUG_9_SRC_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_9_CFG2			0x00000618
	#define MUTEX_TDEBUG_9_REF_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_9_CFG3			0x0000061c
	#define MUTEX_TDEBUG_9_SRC_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_9_CFG4			0x00000620
	#define MUTEX_TDEBUG_9_REF_TIME			GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_10_CFG0			0x00000624
	#define MUTEX_TDEBUG_10_CFG			GENMASK(23, 0)
	#define MUTEX_TDEBUG_10_STATE			GENMASK(31, 24)
#define DISP_MUTEX_TDEBUG_10_CFG1			0x00000628
	#define MUTEX_TDEBUG_10_SRC_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_10_CFG2			0x0000062c
	#define MUTEX_TDEBUG_10_REF_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_10_CFG3			0x00000630
	#define MUTEX_TDEBUG_10_SRC_TIME		GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_10_CFG4			0x00000634
	#define MUTEX_TDEBUG_10_REF_TIME		GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_11_CFG0			0x00000638
	#define MUTEX_TDEBUG_11_CFG			GENMASK(23, 0)
	#define MUTEX_TDEBUG_11_STATE			GENMASK(31, 24)
#define DISP_MUTEX_TDEBUG_11_CFG1			0x0000063c
	#define MUTEX_TDEBUG_11_SRC_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_11_CFG2			0x00000640
	#define MUTEX_TDEBUG_11_REF_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_11_CFG3			0x00000644
	#define MUTEX_TDEBUG_11_SRC_TIME		GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_11_CFG4			0x00000648
	#define MUTEX_TDEBUG_11_REF_TIME		GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_12_CFG0			0x0000064c
	#define MUTEX_TDEBUG_12_CFG			GENMASK(23, 0)
	#define MUTEX_TDEBUG_12_STATE			GENMASK(31, 24)
#define DISP_MUTEX_TDEBUG_12_CFG1			0x00000650
	#define MUTEX_TDEBUG_12_SRC_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_12_CFG2			0x00000654
	#define MUTEX_TDEBUG_12_REF_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_12_CFG3			0x00000658
	#define MUTEX_TDEBUG_12_SRC_TIME		GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_12_CFG4			0x0000065c
	#define MUTEX_TDEBUG_12_REF_TIME		GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_13_CFG0			0x00000660
	#define MUTEX_TDEBUG_13_CFG			GENMASK(23, 0)
	#define MUTEX_TDEBUG_13_STATE			GENMASK(31, 24)
#define DISP_MUTEX_TDEBUG_13_CFG1			0x00000664
	#define MUTEX_TDEBUG_13_SRC_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_13_CFG2			0x00000668
	#define MUTEX_TDEBUG_13_REF_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_13_CFG3			0x0000066c
	#define MUTEX_TDEBUG_13_SRC_TIME		GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_13_CFG4			0x00000670
	#define MUTEX_TDEBUG_13_REF_TIME		GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_14_CFG0			0x00000674
	#define MUTEX_TDEBUG_14_CFG			GENMASK(23, 0)
	#define MUTEX_TDEBUG_14_STATE			GENMASK(31, 24)
#define DISP_MUTEX_TDEBUG_14_CFG1			0x00000678
	#define MUTEX_TDEBUG_14_SRC_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_14_CFG2			0x0000067c
	#define MUTEX_TDEBUG_14_REF_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_14_CFG3			0x00000680
	#define MUTEX_TDEBUG_14_SRC_TIME		GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_14_CFG4			0x00000684
	#define MUTEX_TDEBUG_14_REF_TIME		GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_15_CFG0			0x00000688
	#define MUTEX_TDEBUG_15_CFG			GENMASK(23, 0)
	#define MUTEX_TDEBUG_15_STATE			GENMASK(31, 24)
#define DISP_MUTEX_TDEBUG_15_CFG1			0x0000068c
	#define MUTEX_TDEBUG_15_SRC_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_15_CFG2			0x00000690
	#define MUTEX_TDEBUG_15_REF_TIMEOUT		GENMASK(29, 0)
#define DISP_MUTEX_TDEBUG_15_CFG3			0x00000694
	#define MUTEX_TDEBUG_15_SRC_TIME		GENMASK(31, 0)
#define DISP_MUTEX_TDEBUG_15_CFG4			0x00000698
	#define MUTEX_TDEBUG_15_REF_TIME		GENMASK(31, 0)
#define DISP_MUTEX_SOF_COUNT0				0x00000800
	#define MODULE0_SOF_COUNT			GENMASK(3, 0)
	#define MODULE1_SOF_COUNT			GENMASK(7, 4)
	#define MODULE2_SOF_COUNT			GENMASK(11, 8)
	#define MODULE3_SOF_COUNT			GENMASK(15, 12)
	#define MODULE4_SOF_COUNT			GENMASK(19, 16)
	#define MODULE5_SOF_COUNT			GENMASK(23, 20)
	#define MODULE6_SOF_COUNT			GENMASK(27, 24)
	#define MODULE7_SOF_COUNT			GENMASK(31, 28)
#define DISP_MUTEX_SOF_COUNT1				0x00000804
	#define MODULE8_SOF_COUNT			GENMASK(3, 0)
	#define MODULE9_SOF_COUNT			GENMASK(7, 4)
	#define MODULE10_SOF_COUNT			GENMASK(11, 8)
	#define MODULE11_SOF_COUNT			GENMASK(15, 12)
	#define MODULE12_SOF_COUNT			GENMASK(19, 16)
	#define MODULE13_SOF_COUNT			GENMASK(23, 20)
	#define MODULE14_SOF_COUNT			GENMASK(27, 24)
	#define MODULE15_SOF_COUNT			GENMASK(31, 28)
#define DISP_MUTEX_SOF_COUNT2				0x00000808
	#define MODULE16_SOF_COUNT			GENMASK(3, 0)
	#define MODULE17_SOF_COUNT			GENMASK(7, 4)
	#define MODULE18_SOF_COUNT			GENMASK(11, 8)
	#define MODULE19_SOF_COUNT			GENMASK(15, 12)
	#define MODULE20_SOF_COUNT			GENMASK(19, 16)
	#define MODULE21_SOF_COUNT			GENMASK(23, 20)
	#define MODULE22_SOF_COUNT			GENMASK(27, 24)
	#define MODULE23_SOF_COUNT			GENMASK(31, 28)
#define DISP_MUTEX_SOF_COUNT3				0x0000080c
	#define MODULE24_SOF_COUNT			GENMASK(3, 0)
	#define MODULE25_SOF_COUNT			GENMASK(7, 4)
	#define MODULE26_SOF_COUNT			GENMASK(11, 8)
	#define MODULE27_SOF_COUNT			GENMASK(15, 12)
	#define MODULE28_SOF_COUNT			GENMASK(19, 16)
	#define MODULE29_SOF_COUNT			GENMASK(23, 20)
	#define MODULE30_SOF_COUNT			GENMASK(27, 24)
	#define MODULE31_SOF_COUNT			GENMASK(31, 28)
#define DISP_MUTEX_SOF_COUNT4				0x00000810
	#define MODULE32_SOF_COUNT			GENMASK(3, 0)
	#define MODULE33_SOF_COUNT			GENMASK(7, 4)
	#define MODULE34_SOF_COUNT			GENMASK(11, 8)
	#define MODULE35_SOF_COUNT			GENMASK(15, 12)
	#define MODULE36_SOF_COUNT			GENMASK(19, 16)
	#define MODULE37_SOF_COUNT			GENMASK(23, 20)
	#define MODULE38_SOF_COUNT			GENMASK(27, 24)
	#define MODULE39_SOF_COUNT			GENMASK(31, 28)
#define DISP_MUTEX_SOF_COUNT5				0x00000814
	#define MODULE40_SOF_COUNT			GENMASK(3, 0)
	#define MODULE41_SOF_COUNT			GENMASK(7, 4)
	#define MODULE42_SOF_COUNT			GENMASK(11, 8)
	#define MODULE43_SOF_COUNT			GENMASK(15, 12)
	#define MODULE44_SOF_COUNT			GENMASK(19, 16)
	#define MODULE45_SOF_COUNT			GENMASK(23, 20)
	#define MODULE46_SOF_COUNT			GENMASK(27, 24)
	#define MODULE47_SOF_COUNT			GENMASK(31, 28)
#define DISP_MUTEX_SOF_COUNT6				0x00000818
	#define MODULE48_SOF_COUNT			GENMASK(3, 0)
	#define MODULE49_SOF_COUNT			GENMASK(7, 4)
	#define MODULE50_SOF_COUNT			GENMASK(11, 8)
	#define MODULE51_SOF_COUNT			GENMASK(15, 12)
	#define MODULE52_SOF_COUNT			GENMASK(19, 16)
	#define MODULE53_SOF_COUNT			GENMASK(23, 20)
	#define MODULE54_SOF_COUNT			GENMASK(27, 24)
	#define MODULE55_SOF_COUNT			GENMASK(31, 28)
#define DISP_MUTEX_SOF_COUNT7				0x0000081c
	#define MODULE56_SOF_COUNT			GENMASK(3, 0)
	#define MODULE57_SOF_COUNT			GENMASK(7, 4)
	#define MODULE58_SOF_COUNT			GENMASK(11, 8)
	#define MODULE59_SOF_COUNT			GENMASK(15, 12)
	#define MODULE60_SOF_COUNT			GENMASK(19, 16)
	#define MODULE61_SOF_COUNT			GENMASK(23, 20)
	#define MODULE62_SOF_COUNT			GENMASK(27, 24)
	#define MODULE63_SOF_COUNT			GENMASK(31, 28)

#endif /*__MTK_MUTEX_REG_H__*/
