/*
 * Copyright (C) 2018 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _MTK_MM_SYSRAM_REG_H_
#define _MTK_MM_SYSRAM_REG_H_

/* ----------------- SYSRAM0 Register Definitions ------------------- */
#define SYS0_MAIN_CTRL					0x00000804
	#define SYSRAM0_FW_RST				BIT(0)
	#define SYSRAM0_GALS_FW_RST			GENMASK(4, 1)
	#define SYSRAM0_AXI_PRIORITY_MODE		GENMASK(25, 24)
#define SYS0_COMMON_CTRL_SET				0x00000808
	#define SYSRAM0_MBIST_MODE			BIT(0)
	#define SYSRAM0_MBIST_HOLDB			BIT(1)
	#define SYSRAM0_BIST_RST			BIT(2)
	#define RG_SYSRAM_BIST_RP_RST_B			BIT(3)
	#define RG_SMI_SLV_CK_ON			BIT(16)
	#define FW_FILL_SRAM_MODE			BIT(24)
	#define FW_FAST_ACCESS_MODE			BIT(25)
#define SYS0_MBIST_PARAM_SET_1				0x0000080c
	#define SYSRAM0_MBIST_BACKGROUND		GENMASK(15, 0)
#define SYS0_MBIST_PARAM_SET_2				0x00000810
	#define SYSRAM0_MBIST_BSEL			GENMASK(7, 0)
#define SYS0_1K2K_MBIST_DONE_RESULT			0x00000818
	#define SYSRAM0_2KX64_SRAM_MBIST_DONE		BIT(16)
#define SYS0_1K2K_MBIST_FAIL_RESULT			0x0000081c
	#define SYSRAM0_2KX64_SRAM_MBIST_FAIL		GENMASK(17, 16)
#define SYS0_2K_MBIST_PARAM_DELSEL			0x00000844
	#define SYSRAM0_2KX64_SRAM_DELSEL		GENMASK(5, 0)
#define SYS0_GALS1_PARAM				0x00000860
	#define MST_SYNC_SEL_1				GENMASK(1, 0)
	#define SLV_SYNC_SEL_1				GENMASK(3, 2)
	#define SAMPLE_SEL_1				BIT(4)
#define SYS0_GALS2_PARAM				0x00000864
	#define MST_SYNC_SEL_2				GENMASK(1, 0)
	#define SLV_SYNC_SEL_2				GENMASK(3, 2)
	#define SAMPLE_SEL_2				BIT(4)
#define SYS0_GALS3_PARAM				0x00000868
	#define MST_SYNC_SEL_3				GENMASK(1, 0)
	#define SLV_SYNC_SEL_3				GENMASK(3, 2)
	#define SAMPLE_SEL_3				BIT(4)
#define SYS0_GALS4_PARAM				0x0000086c
	#define MST_SYNC_SEL_4				GENMASK(1, 0)
	#define SLV_SYNC_SEL_4				GENMASK(3, 2)
	#define SAMPLE_SEL_4				BIT(4)
#define SYS0_FW_ACCESS_SRAM_DONE			0x00000884
	#define FW_RD_SRAM_DONE				BIT(0)
	#define FW_FILL_SRAM_DONE			BIT(1)
#define SYS0_FW_RD_SRAM_ADDR				0x00000888
	#define FW_RD_SRAM_ADDR				GENMASK(31, 0)
#define SYS0_FW_RD_SRAM_DAT_1				0x0000088c
	#define FW_RD_SRAM_RDATA_LAT_0			GENMASK(31, 0)
#define SYS0_FW_RD_SRAM_DAT_2				0x00000890
	#define FW_RD_SRAM_RDATA_LAT_1			GENMASK(31, 0)
#define SYS0_FW_RD_SRAM_DAT_3				0x00000894
	#define FW_RD_SRAM_RDATA_LAT_2			GENMASK(31, 0)
#define SYS0_FW_RD_SRAM_DAT_4				0x00000898
	#define FW_RD_SRAM_RDATA_LAT_3			GENMASK(31, 0)
#define SYS0_ERR_SRAM_EVENT_VLD				0x0000089c
	#define ERR_SRAM_ACCESS_EVENT_VALID		BIT(0)
#define SYS0_ERR_SRAM_ACCESS_1				0x000008a0
	#define ERR_SRAM_ACCESS_ADDR			GENMASK(31, 0)
#define SYS0_ERR_SRAM_ACCESS_2				0x000008a4
	#define ERR_SRAM_ACCESS_ID			GENMASK(9, 0)
	#define ERR_SRAM_ACCESS_WR			BIT(24)
#define SYS0_FW_ACTION_TRIG				0x000008b0
	#define FW_RD_SRAM_DONE_CLR			BIT(0)
	#define FW_FILL_SRAM_DONE_CLR			BIT(1)
	#define FW_FILL_SRAM_TRIGGER			BIT(8)
	#define FW_FAST_FILL_LOAD_ADDR_TRIGGER		BIT(9)
	#define FW_RD_SRAM_TRIGGER			BIT(16)
	#define ERR_SRAM_ACCESS_EVENT_CLR		BIT(17)
	#define FW_FAST_RD_LOAD_ADDR_TRIGGER		BIT(18)
#define SYS0_SRAM_SLEEP_SET				0x000008b4
	#define SRAM_SLEEP_TEST				BIT(0)
	#define SRAM_SLEEP_INV				BIT(1)
	#define SRAM_SLEEP_W				BIT(2)
	#define SRAM_SLEEP_R				BIT(3)
	#define SRAM_HDEN				BIT(8)
	#define RG_LOAD_FUSE				BIT(16)
#define SYS0_FW_FILL_SRAM_ADDR				0x000008b8
	#define FW_FILL_SRAM_START_ADDR			GENMASK(31, 0)
#define SYS0_FW_FILL_SRAM_LEN				0x000008bc
	#define FW_FILL_SRAM_LEN			GENMASK(31, 0)
#define SYS0_FW_FILL_SRAM_DAT				0x000008c0
	#define FW_FILL_SRAM_DAT			GENMASK(7, 0)
#define SYS0_GALS_CTRL					0x000008c8
	#define RG_GALS_CG				GENMASK(3, 0)
	#define RG_GALS_DCM_DIS				GENMASK(11, 8)
#define SYS0_CMDFF_PARAM				0x000008cc
	#define RG_AXI_WR_CMDFF_WEIGHTED		GENMASK(4, 0)
	#define RG_AXI_RD_CMDFF_WEIGHTED		GENMASK(12, 8)
#define SYS0_CMDFF_CTRL					0x000008d0
	#define CMDFF_AXI_PRIORITY_MODE			GENMASK(1, 0)
#define SYS0_DBG_CTRL					0x000008d4
	#define SYSRAM_DBG_SEL				GENMASK(7, 0)
#define SYS0_SRAM_PWR_SLP_ACK				0x000008d8
	#define SYSRAM_SRAM_SLPB_ACK			BIT(0)
#define SYS0_1K2K4K_RPOK				0x000008dc
	#define SYSRAM_2K_MBIST_RP_OK			GENMASK(9, 8)
#define SYS0_1K2K4K_RPFAIL				0x000008e0
	#define SYSRAM_2K_MBIST_RP_FAIL			GENMASK(9, 8)
#define SYS0_FUSE_SEL_1					0x000008ec
	#define SYSRAM_MBIST_FUSE_SEL_LSB		GENMASK(1, 0)
#define SYS0_FW_FILL_DATA_128B_0			0x00000920
	#define FW_FILL_SRAM_DATA_128B_0		GENMASK(31, 0)
#define SYS0_FW_FILL_DATA_128B_1			0x00000924
	#define FW_FILL_SRAM_DATA_128B_1		GENMASK(31, 0)
#define SYS0_FW_FILL_DATA_128B_2			0x00000928
	#define FW_FILL_SRAM_DATA_128B_2		GENMASK(31, 0)
#define SYS0_FW_FILL_DATA_128B_3			0x0000092c
	#define FW_FILL_SRAM_DATA_128B_3		GENMASK(31, 0)
#define SYS0_MBIST_DBG_CTRL_1				0x00000930
	#define SYSRAM_MBIST_DEBUG			BIT(0)
#define SYS0_PRE_FUSE_VALUE				0x00000934
	#define PRE_FUSE_MERGE				GENMASK(13, 0)

/* ----------------- SYSRAM1 Register Definitions ------------------- */
#define SYS1_MAIN_CTRL					0x00000804
	#define SYSRAM1_FW_RST				BIT(0)
	#define SYSRAM1_GALS_FW_RST			GENMASK(3, 1)
	#define SYSRAM1_AXI_PRIORITY_MODE		GENMASK(25, 24)
#define SYS1_COMMON_CTRL_SET				0x00000808
	#define SYSRAM1_MBIST_MODE			BIT(0)
	#define SYSRAM1_MBIST_HOLDB			BIT(1)
	#define SYSRAM1_BIST_RST			BIT(2)
	#define RG_SYSRAM_BIST_RP_RST_B			BIT(3)
	#define RG_SMI_SLV_CK_ON			BIT(16)
	#define FW_FILL_SRAM_MODE			BIT(24)
	#define FW_FAST_ACCESS_MODE			BIT(25)
#define SYS1_MBIST_PARAM_SET_1				0x0000080c
	#define SYSRAM1_MBIST_BACKGROUND		GENMASK(15, 0)
#define SYS1_MBIST_PARAM_SET_2				0x00000810
	#define SYSRAM1_MBIST_BSEL			GENMASK(7, 0)
#define SYS1_8K_MBIST_DONE_RESULT_1			0x00000830
	#define SYSRAM1_8KX64_MBIST_DONE_0		GENMASK(5, 0)
#define SYS1_8K_MBIST_FAIL_RESULT_1			0x00000838
	#define SYSRAM1_8KX64_MBIST_FAIL_0		GENMASK(5, 0)
#define SYS1_8K_MBIST_PARAM_DELSEL			0x0000084c
	#define SYSRAM1_8KX64_SRAM_DELSEL		GENMASK(11, 0)
#define SYS1_GALS1_PARAM				0x00000860
	#define MST_SYNC_SEL_1				GENMASK(1, 0)
	#define SLV_SYNC_SEL_1				GENMASK(3, 2)
	#define SAMPLE_SEL_1				BIT(4)
#define SYS1_GALS2_PARAM				0x00000864
	#define MST_SYNC_SEL_2				GENMASK(1, 0)
	#define SLV_SYNC_SEL_2				GENMASK(3, 2)
	#define SAMPLE_SEL_2				BIT(4)
#define SYS1_GALS3_PARAM				0x00000868
	#define MST_SYNC_SEL_3				GENMASK(1, 0)
	#define SLV_SYNC_SEL_3				GENMASK(3, 2)
	#define SAMPLE_SEL_3				BIT(4)
#define SYS1_FW_ACCESS_SRAM_DONE			0x00000884
	#define FW_RD_SRAM_DONE				BIT(0)
	#define FW_FILL_SRAM_DONE			BIT(1)
#define SYS1_FW_RD_SRAM_ADDR				0x00000888
	#define FW_RD_SRAM_ADDR				GENMASK(31, 0)
#define SYS1_FW_RD_SRAM_DAT_1				0x0000088c
	#define FW_RD_SRAM_RDATA_LAT_0			GENMASK(31, 0)
#define SYS1_FW_RD_SRAM_DAT_2				0x00000890
	#define FW_RD_SRAM_RDATA_LAT_1			GENMASK(31, 0)
#define SYS1_FW_RD_SRAM_DAT_3				0x00000894
	#define FW_RD_SRAM_RDATA_LAT_2			GENMASK(31, 0)
#define SYS1_FW_RD_SRAM_DAT_4				0x00000898
	#define FW_RD_SRAM_RDATA_LAT_3			GENMASK(31, 0)
#define SYS1_ERR_SRAM_EVENT_VLD				0x0000089c
	#define ERR_SRAM_ACCESS_EVENT_VALID		BIT(0)
#define SYS1_ERR_SRAM_ACCESS_1				0x000008a0
	#define ERR_SRAM_ACCESS_ADDR			GENMASK(31, 0)
#define SYS1_ERR_SRAM_ACCESS_2				0x000008a4
	#define ERR_SRAM_ACCESS_ID			GENMASK(9, 0)
	#define ERR_SRAM_ACCESS_WR			BIT(24)
#define SYS1_FW_ACTION_TRIG				0x000008b0
	#define FW_RD_SRAM_DONE_CLR			BIT(0)
	#define FW_FILL_SRAM_DONE_CLR			BIT(1)
	#define FW_FILL_SRAM_TRIGGER			BIT(8)
	#define FW_FAST_FILL_LOAD_ADDR_TRIGGER		BIT(9)
	#define FW_RD_SRAM_TRIGGER			BIT(16)
	#define ERR_SRAM_ACCESS_EVENT_CLR		BIT(17)
	#define FW_FAST_RD_LOAD_ADDR_TRIGGER		BIT(18)
#define SYS1_SRAM_SLEEP_SET				0x000008b4
	#define SRAM_SLEEP_TEST				BIT(0)
	#define SRAM_SLEEP_INV				BIT(1)
	#define SRAM_SLEEP_W				BIT(2)
	#define SRAM_SLEEP_R				BIT(3)
	#define SRAM_HDEN				BIT(8)
	#define RG_LOAD_FUSE				BIT(16)
#define SYS1_FW_FILL_SRAM_ADDR				0x000008b8
	#define FW_FILL_SRAM_START_ADDR			GENMASK(31, 0)
#define SYS1_FW_FILL_SRAM_LEN				0x000008bc
	#define FW_FILL_SRAM_LEN			GENMASK(31, 0)
#define SYS1_FW_FILL_SRAM_DAT				0x000008c0
	#define FW_FILL_SRAM_DAT			GENMASK(7, 0)
#define SYS1_GALS_CTRL					0x000008c8
	#define SYS1_RG_GALS_CG				GENMASK(2, 0)
	#define SYS1_RG_GALS_DCM_DIS			GENMASK(10, 8)
#define SYS1_CMDFF_PARAM				0x000008cc
	#define RG_AXI_WR_CMDFF_WEIGHTED		GENMASK(4, 0)
	#define RG_AXI_RD_CMDFF_WEIGHTED		GENMASK(12, 8)
#define SYS1_CMDFF_CTRL					0x000008d0
	#define CMDFF_AXI_PRIORITY_MODE			GENMASK(1, 0)
#define SYS1_DBG_CTRL					0x000008d4
	#define SYSRAM_DBG_SEL				GENMASK(7, 0)
#define SYS1_SRAM_PWR_SLP_ACK				0x000008d8
	#define SYSRAM_SRAM_SLPB_ACK			BIT(0)
#define SYS1_8K_RPOK_1					0x000008e4
	#define SYSRAM_8K_MBIST_RP_OK_0			GENMASK(5, 0)
#define SYS1_FUSE_SEL_1					0x000008ec
	#define SYSRAM_MBIST_FUSE_SEL_0			GENMASK(5, 0)
#define SYS1_8K_RPFAIL_1				0x000008f4
	#define SYSRAM_8K_MBIST_RP_FAIL_0		GENMASK(5, 0)
#define SYS1_FW_FILL_DATA_128B_0			0x00000920
	#define FW_FILL_SRAM_DATA_128B_0		GENMASK(31, 0)
#define SYS1_FW_FILL_DATA_128B_1			0x00000924
	#define FW_FILL_SRAM_DATA_128B_1		GENMASK(31, 0)
#define SYS1_FW_FILL_DATA_128B_2			0x00000928
	#define FW_FILL_SRAM_DATA_128B_2		GENMASK(31, 0)
#define SYS1_FW_FILL_DATA_128B_3			0x0000092c
	#define FW_FILL_SRAM_DATA_128B_3		GENMASK(31, 0)
#define SYS1_MBIST_DBG_CTRL_1				0x00000930
	#define SYS1_SYSRAM_MBIST_DEBUG			GENMASK(5, 0)
#define SYS1_PRE_FUSE_VALUE_0				0x00000934
	#define PRE_FUSE_MERGE_0			GENMASK(31, 0)
#define SYS1_PRE_FUSE_VALUE_1				0x00000938
	#define PRE_FUSE_MERGE_1			GENMASK(15, 0)

/* ----------------- SYSRAM2 Register Definitions ------------------- */
#define SYS2_MAIN_CTRL					0x00000804
	#define SYSRAM2_FW_RST				BIT(0)
	#define SYSRAM2_GALS_FW_RST			GENMASK(11, 1)
	#define REG_VPU_EX_MOD				BIT(16)
	#define REG_VPU_W_EX_CHK_DIS			BIT(17)
	#define REG_INFRA_EX_MOD			BIT(18)
	#define REG_INFRA_W_EX_CHK_DIS			BIT(19)
	#define SYSRAM2_AXI_PRIORITY_MODE		GENMASK(25, 24)
	#define BANK_CHG_MODE				GENMASK(31, 30)
#define SYS2_COMMON_CTRL_SET				0x00000808
	#define SYSRAM2_MBIST_MODE			BIT(0)
	#define SYSRAM2_MBIST_HOLDB			BIT(1)
	#define SYSRAM2_BIST_RST			BIT(2)
	#define RG_SYSRAM_BIST_RP_RST_B			BIT(3)
	#define SYS2_RG_SMI_SLV_CK_ON			GENMASK(21, 16)
	#define FW_FILL_SRAM_MODE			BIT(24)
#define SYS2_MBIST_PARAM_SET_1				0x0000080c
	#define SYSRAM2_MBIST_BACKGROUND		GENMASK(15, 0)
#define SYS2_MBIST_PARAM_SET_2				0x00000810
	#define SYSRAM2_MBIST_BSEL			GENMASK(7, 0)
#define SYS2_8K_MBIST_DONE_RESULT_1			0x00000830
	#define SYSRAM2_8KX64_MBIST_DONE_0		GENMASK(31, 0)
#define SYS2_8K_MBIST_DONE_RESULT_2			0x00000834
	#define SYSRAM2_8KX64_MBIST_DONE_1		GENMASK(31, 0)
#define SYS2_8K_MBIST_FAIL_RESULT_1			0x00000838
	#define SYSRAM2_8KX64_MBIST_FAIL_0		GENMASK(31, 0)
#define SYS2_8K_MBIST_FAIL_RESULT_2			0x0000083c
	#define SYSRAM2_8KX64_MBIST_FAIL_1		GENMASK(31, 0)
#define SYS2_8K_MBIST_PARAM_DELSEL			0x0000084c
	#define SYSRAM2_8KX64_SRAM_DELSEL		GENMASK(11, 0)
#define SYS2_8K_MBIST_DONE_RESULT_3			0x00000850
	#define SYSRAM2_8KX64_MBIST_DONE_2		GENMASK(31, 0)
#define SYS2_8K_MBIST_FAIL_RESULT_3			0x00000858
	#define SYSRAM2_8KX64_MBIST_FAIL_2		GENMASK(31, 0)
#define SYS2_GALS1_PARAM				0x00000860
	#define MST_SYNC_SEL_1				GENMASK(1, 0)
	#define SLV_SYNC_SEL_1				GENMASK(3, 2)
	#define SAMPLE_SEL_1				BIT(4)
	#define MST_SYNC_SEL_6				GENMASK(9, 8)
	#define SLV_SYNC_SEL_6				GENMASK(11, 10)
	#define SAMPLE_SEL_6				BIT(12)
	#define MST_SYNC_SEL_11				GENMASK(17, 16)
	#define SLV_SYNC_SEL_11				GENMASK(19, 18)
	#define SAMPLE_SEL_11				BIT(20)
#define SYS2_GALS2_PARAM				0x00000864
	#define MST_SYNC_SEL_2				GENMASK(1, 0)
	#define SLV_SYNC_SEL_2				GENMASK(3, 2)
	#define SAMPLE_SEL_2				BIT(4)
	#define MST_SYNC_SEL_7				GENMASK(9, 8)
	#define SLV_SYNC_SEL_7				GENMASK(11, 10)
	#define SAMPLE_SEL_7				BIT(12)
#define SYS2_GALS3_PARAM				0x00000868
	#define MST_SYNC_SEL_3				GENMASK(1, 0)
	#define SLV_SYNC_SEL_3				GENMASK(3, 2)
	#define SAMPLE_SEL_3				BIT(4)
	#define MST_SYNC_SEL_8				GENMASK(9, 8)
	#define SLV_SYNC_SEL_8				GENMASK(11, 10)
	#define SAMPLE_SEL_8				BIT(12)
#define SYS2_GALS4_PARAM				0x0000086c
	#define MST_SYNC_SEL_4				GENMASK(1, 0)
	#define SLV_SYNC_SEL_4				GENMASK(3, 2)
	#define SAMPLE_SEL_4				BIT(4)
	#define MST_SYNC_SEL_9				GENMASK(9, 8)
	#define SLV_SYNC_SEL_9				GENMASK(11, 10)
	#define SAMPLE_SEL_9				BIT(12)
#define SYS2_GALS5_PARAM				0x00000870
	#define MST_SYNC_SEL_5				GENMASK(1, 0)
	#define SLV_SYNC_SEL_5				GENMASK(3, 2)
	#define SAMPLE_SEL_5				BIT(4)
	#define MST_SYNC_SEL_10				GENMASK(9, 8)
	#define SLV_SYNC_SEL_10				GENMASK(11, 10)
	#define SAMPLE_SEL_10				BIT(12)
#define SYS2_FW_ACCESS_SRAM_DONE			0x00000884
	#define FW_RD_SRAM_DONE				BIT(0)
	#define FW_FILL_SRAM_DONE			BIT(1)
#define SYS2_FW_RD_SRAM_ADDR				0x00000888
	#define FW_RD_SRAM_ADDR				GENMASK(31, 0)
#define SYS2_FW_RD_SRAM_DAT_1				0x0000088c
	#define FW_RD_SRAM_RDATA_LAT_0			GENMASK(31, 0)
#define SYS2_FW_RD_SRAM_DAT_2				0x00000890
	#define FW_RD_SRAM_RDATA_LAT_1			GENMASK(31, 0)
#define SYS2_FW_RD_SRAM_DAT_3				0x00000894
	#define FW_RD_SRAM_RDATA_LAT_2			GENMASK(31, 0)
#define SYS2_FW_RD_SRAM_DAT_4				0x00000898
	#define FW_RD_SRAM_RDATA_LAT_3			GENMASK(31, 0)
#define SYS2_ERR_SRAM_EVENT_VLD				0x0000089c
	#define SYS2_ERR_SRAM_ACCESS_EVENT_VALID	GENMASK(5, 0)
#define SYS2_ERR_SRAM_ACCESS_1				0x000008a0
	#define ERR_SRAM_ACCESS_ADDR			GENMASK(31, 0)
#define SYS2_ERR_SRAM_ACCESS_2				0x000008a4
	#define SYS2_ERR_SRAM_ACCESS_ID			GENMASK(16, 0)
	#define SYS2_ERR_SRAM_ACCESS_WR			GENMASK(29, 24)
#define SYS2_FW_ACTION_TRIG				0x000008b0
	#define FW_RD_SRAM_DONE_CLR			BIT(0)
	#define FW_FILL_SRAM_DONE_CLR			BIT(1)
	#define FW_FILL_SRAM_TRIGGER			BIT(8)
	#define FW_RD_SRAM_TRIGGER			BIT(16)
	#define SYS2_ERR_SRAM_ACCESS_EVENT_CLR		GENMASK(22, 17)
#define SYS2_SRAM_SLEEP_SET				0x000008b4
	#define SRAM_SLEEP_TEST				BIT(0)
	#define SRAM_SLEEP_INV				BIT(1)
	#define SRAM_SLEEP_W				BIT(2)
	#define SRAM_SLEEP_R				BIT(3)
	#define SRAM_HDEN				BIT(8)
	#define RG_LOAD_FUSE				BIT(16)
#define SYS2_FW_FILL_SRAM_ADDR				0x000008b8
	#define FW_FILL_SRAM_START_ADDR			GENMASK(31, 0)
#define SYS2_FW_FILL_SRAM_LEN				0x000008bc
	#define FW_FILL_SRAM_LEN			GENMASK(31, 0)
#define SYS2_FW_FILL_SRAM_DAT				0x000008c0
	#define FW_FILL_SRAM_DAT			GENMASK(7, 0)
#define SYS2_GALS_CTRL					0x000008c8
	#define SYS2_RG_GALS_CG				GENMASK(10, 0)
	#define SYS2_RG_GALS_DCM_DIS			GENMASK(26, 16)
#define SYS2_CMDFF_PARAM				0x000008cc
	#define RG_AXI_WR_CMDFF_WEIGHTED_M1		GENMASK(4, 0)
	#define RG_AXI_RD_CMDFF_WEIGHTED_M1		GENMASK(12, 8)
	#define RG_AXI_WR_CMDFF_WEIGHTED_M2		GENMASK(20, 16)
	#define RG_AXI_RD_CMDFF_WEIGHTED_M2		GENMASK(28, 24)
#define SYS2_CMDFF_CTRL					0x000008d0
	#define CMDFF_AXI_PRIORITY_MODE			GENMASK(1, 0)
#define SYS2_DBG_CTRL					0x000008d4
	#define SYSRAM_DBG_SEL				GENMASK(7, 0)
	#define SYSRAM_ERR_AXI_DUMP_SEL			GENMASK(26, 24)
#define SYS2_SRAM_PWR_SLP_ACK				0x000008d8
	#define SYSRAM_SRAM_SLPB_ACK			BIT(0)
#define SYS2_8K_RPOK_1					0x000008e4
	#define SYS2_SYSRAM_8K_MBIST_RP_OK_0		GENMASK(31, 0)
#define SYS2_8K_RPOK_2					0x000008e8
	#define SYSRAM_8K_MBIST_RP_OK_1			GENMASK(31, 0)
#define SYS2_FUSE_SEL_1					0x000008ec
	#define SYS2_SYSRAM_MBIST_FUSE_SEL_0		GENMASK(31, 0)
#define SYS2_FUSE_SEL_2					0x000008f0
	#define SYSRAM_MBIST_FUSE_SEL_1			GENMASK(31, 0)
#define SYS2_8K_RPFAIL_1				0x000008f4
	#define SYS2_SYSRAM_8K_MBIST_RP_FAIL_0		GENMASK(31, 0)
#define SYS2_8K_RPFAIL_2				0x000008f8
	#define SYSRAM_8K_MBIST_RP_FAIL_1		GENMASK(31, 0)
#define SYS2_8K_RPOK_3					0x000008fc
	#define SYSRAM_8K_MBIST_RP_OK_2			GENMASK(31, 0)
#define SYS2_FUSE_SEL_3					0x00000900
	#define SYSRAM_MBIST_FUSE_SEL_2			GENMASK(31, 0)
#define SYS2_8K_RPFAIL_3				0x00000904
	#define SYSRAM_8K_MBIST_RP_FAIL_2		GENMASK(31, 0)
#define SYS2_FW_FILL_DATA_128B_0			0x00000920
	#define FW_FILL_SRAM_DATA_128B_0		GENMASK(31, 0)
#define SYS2_FW_FILL_DATA_128B_1			0x00000924
	#define FW_FILL_SRAM_DATA_128B_1		GENMASK(31, 0)
#define SYS2_FW_FILL_DATA_128B_2			0x00000928
	#define FW_FILL_SRAM_DATA_128B_2		GENMASK(31, 0)
#define SYS2_FW_FILL_DATA_128B_3			0x0000092c
	#define FW_FILL_SRAM_DATA_128B_3		GENMASK(31, 0)
#define SYS2_MBIST_DBG_CTRL_1				0x00000930
	#define SYSRAM_MBIST_DEBUG_1			GENMASK(31, 0)
#define SYS2_MBIST_DBG_CTRL_2				0x00000934
	#define SYSRAM_MBIST_DEBUG_2			GENMASK(31, 0)
#define SYS2_MBIST_DBG_CTRL_3				0x00000938
	#define SYSRAM_MBIST_DEBUG_3			GENMASK(31, 0)
#define SYS2_LOCAL_SRAM_PD_1				0x00000940
	#define SYSRAM_LOCAL_PD_1			GENMASK(31, 0)
#define SYS2_LOCAL_SRAM_PD_2				0x00000944
	#define SYSRAM_LOCAL_PD_2			GENMASK(15, 0)
#define SYS2_LOCAL_SRAM_SLEEPB_1			0x00000950
	#define SYSRAM_LOCAL_SLPB_1			GENMASK(31, 0)
#define SYS2_LOCAL_SRAM_SLEEPB_2			0x00000954
	#define SYSRAM_LOCAL_SLPB_2			GENMASK(15, 0)
#define SYS2_GALS_SLPPROT_CTRL				0x00000960
	#define SYS_SLPPROT_BUSY_I			GENMASK(2, 0)
	#define SYS_SLPPROT_CLK_RDY_ON_DCM		GENMASK(10, 8)
	#define SYS_SLPPROT_GATED_EN			GENMASK(18, 16)
	#define SYS_ERROR_FLAG_EN			GENMASK(26, 24)
#define SYS2_GALS_SLPPROT_STATE				0x00000964
	#define SYS_SLPPROT_AXI_IDLE			GENMASK(2, 0)
	#define SYS_SLPPROT_AXI_IDLE_ASYNC		GENMASK(6, 4)
	#define SYS_GALS_SLPPROT_RDY			GENMASK(10, 8)
	#define SYS_GALS_SLPPROT_RX_IDLE		GENMASK(18, 16)
	#define SYS_PDN_PROTECT_DECERR			GENMASK(26, 24)
#define SYS2_LOCAL_SRAM_ISOINTB_1			0x00000968
	#define SYSRAM_LOCAL_ISOINTB_1			GENMASK(31, 0)
#define SYS2_LOCAL_SRAM_ISOINTB_2			0x0000096c
	#define SYSRAM_LOCAL_ISOINTB_2			GENMASK(15, 0)
#define SYS2_CMDFF_PARAM_2				0x00000970
	#define RG_AXI_WR_CMDFF_WEIGHTED_M3		GENMASK(4, 0)
	#define RG_AXI_RD_CMDFF_WEIGHTED_M3		GENMASK(12, 8)
	#define RG_AXI_WR_CMDFF_WEIGHTED_M4		GENMASK(20, 16)
	#define RG_AXI_RD_CMDFF_WEIGHTED_M4		GENMASK(28, 24)
#define SYS2_CMDFF_PARAM_3				0x00000974
	#define RG_AXI_WR_CMDFF_WEIGHTED_M5		GENMASK(4, 0)
	#define RG_AXI_RD_CMDFF_WEIGHTED_M5		GENMASK(12, 8)
	#define RG_AXI_WR_CMDFF_WEIGHTED_M6		GENMASK(20, 16)
	#define RG_AXI_RD_CMDFF_WEIGHTED_M6		GENMASK(28, 24)
#define SYS2_SRAM_WEIGHTED_M1				0x00000978
	#define RG_SRAM_ARBITER_WEIGHTED_M1_B0		GENMASK(4, 0)
	#define RG_SRAM_ARBITER_WEIGHTED_M1_B1		GENMASK(9, 5)
	#define RG_SRAM_ARBITER_WEIGHTED_M1_B2		GENMASK(14, 10)
	#define RG_SRAM_ARBITER_WEIGHTED_M1_B3		GENMASK(19, 15)
#define SYS2_SRAM_WEIGHTED_M2				0x0000097c
	#define RG_SRAM_ARBITER_WEIGHTED_M2_B0		GENMASK(4, 0)
	#define RG_SRAM_ARBITER_WEIGHTED_M2_B1		GENMASK(9, 5)
	#define RG_SRAM_ARBITER_WEIGHTED_M2_B2		GENMASK(14, 10)
	#define RG_SRAM_ARBITER_WEIGHTED_M2_B3		GENMASK(19, 15)
#define SYS2_SRAM_WEIGHTED_M3				0x00000980
	#define RG_SRAM_ARBITER_WEIGHTED_M3_B0		GENMASK(4, 0)
	#define RG_SRAM_ARBITER_WEIGHTED_M3_B1		GENMASK(9, 5)
	#define RG_SRAM_ARBITER_WEIGHTED_M3_B2		GENMASK(14, 10)
	#define RG_SRAM_ARBITER_WEIGHTED_M3_B3		GENMASK(19, 15)
#define SYS2_SRAM_WEIGHTED_M4				0x00000984
	#define RG_SRAM_ARBITER_WEIGHTED_M4_B0		GENMASK(4, 0)
	#define RG_SRAM_ARBITER_WEIGHTED_M4_B1		GENMASK(9, 5)
	#define RG_SRAM_ARBITER_WEIGHTED_M4_B2		GENMASK(14, 10)
	#define RG_SRAM_ARBITER_WEIGHTED_M4_B3		GENMASK(19, 15)
#define SYS2_SRAM_WEIGHTED_M5				0x00000988
	#define RG_SRAM_ARBITERF_WEIGHTED_M5_B0		GENMASK(4, 0)
	#define RG_SRAM_ARBITER_WEIGHTED_M5_B1		GENMASK(9, 5)
	#define RG_SRAM_ARBITER_WEIGHTED_M5_B2		GENMASK(14, 10)
	#define RG_SRAM_ARBITER_WEIGHTED_M5_B3		GENMASK(19, 15)
#define SYS2_SRAM_WEIGHTED_M6				0x0000098c
	#define RG_SRAM_ARBITER_WEIGHTED_M6_B0		GENMASK(4, 0)
	#define RG_SRAM_ARBITER_WEIGHTED_M6_B1		GENMASK(9, 5)
	#define RG_SRAM_ARBITER_WEIGHTED_M6_B2		GENMASK(14, 10)
	#define RG_SRAM_ARBITER_WEIGHTED_M6_B3		GENMASK(19, 15)
#define SYS2_SRAM_WEIGHTED_M7				0x00000990
	#define RG_SRAM_ARBITER_WEIGHTED_M7_B0		GENMASK(4, 0)
	#define RG_SRAM_ARBITER_WEIGHTED_M7_B1		GENMASK(9, 5)
	#define RG_SRAM_ARBITER_WEIGHTED_M7_B2		GENMASK(14, 10)
	#define RG_SRAM_ARBITER_WEIGHTED_M7_B3		GENMASK(19, 15)
#define SYS2_SRAM_WEIGHTED_M8				0x00000994
	#define RG_SRAM_ARBITER_WEIGHTED_M8_B0		GENMASK(4, 0)
	#define RG_SRAM_ARBITER_WEIGHTED_M8_B1		GENMASK(9, 5)
	#define RG_SRAM_ARBITER_WEIGHTED_M8_B2		GENMASK(14, 10)
	#define RG_SRAM_ARBITER_WEIGHTED_M8_B3		GENMASK(19, 15)
#define SYS2_PRE_FUSE_VALUE_0				0x00000998
	#define PRE_FUSE_MERGE_0			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_1				0x0000099c
	#define SYS2_PRE_FUSE_MERGE_1			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_2				0x000009a0
	#define PRE_FUSE_MERGE_2			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_3				0x000009a4
	#define PRE_FUSE_MERGE_3			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_4				0x000009a8
	#define PRE_FUSE_MERGE_4			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_5				0x000009ac
	#define PRE_FUSE_MERGE_5			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_6				0x000009b0
	#define PRE_FUSE_MERGE_6			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_7				0x000009b4
	#define PRE_FUSE_MERGE_7			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_8				0x000009b8
	#define PRE_FUSE_MERGE_8			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_9				0x000009bc
	#define PRE_FUSE_MERGE_9			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_10				0x000009c0
	#define PRE_FUSE_MERGE_10			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_11				0x000009c4
	#define PRE_FUSE_MERGE_11			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_12				0x000009c8
	#define PRE_FUSE_MERGE_12			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_13				0x000009cc
	#define PRE_FUSE_MERGE_13			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_14				0x000009d0
	#define PRE_FUSE_MERGE_14			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_15				0x000009d4
	#define PRE_FUSE_MERGE_15			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_16				0x000009d8
	#define PRE_FUSE_MERGE_16			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_17				0x000009dc
	#define PRE_FUSE_MERGE_17			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_18				0x000009e0
	#define PRE_FUSE_MERGE_18			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_19				0x000009e4
	#define PRE_FUSE_MERGE_19			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_20				0x000009e8
	#define PRE_FUSE_MERGE_20			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_21				0x000009ec
	#define PRE_FUSE_MERGE_21			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_22				0x000009f0
	#define PRE_FUSE_MERGE_22			GENMASK(31, 0)
#define SYS2_PRE_FUSE_VALUE_23				0x000009f4
	#define PRE_FUSE_MERGE_23			GENMASK(31, 0)

#endif /* #ifndef _MTK_MM_SYSRAM_REG_H_*/

