/* -*- mode: c; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* vi: set ts=8 sw=8 sts=8: */
/*************************************************************************/ /*!
@File
@Codingstyle    LinuxKernel
@Copyright      Copyright (c) Imagination Technologies Ltd. All Rights Reserved
@License        Dual MIT/GPLv2

The contents of this file are subject to the MIT license as set out below.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

Alternatively, the contents of this file may be used under the terms of
the GNU General Public License Version 2 ("GPL") in which case the provisions
of GPL are applicable instead of those above.

If you wish to allow use of your version of this file only under the terms of
GPL, and not to allow others to use your version of this file under the terms
of the MIT license, indicate your decision by deleting the provisions above
and replace them with the notice and other provisions required by GPL as set
out in the file called "GPL-COPYING" included in this distribution. If you do
not delete the provisions above, a recipient may use your version of this file
under the terms of either the MIT license or GPL.

This License is also included in this distribution in the file called
"MIT-COPYING".

EXCEPT AS OTHERWISE STATED IN A NEGOTIATED AGREEMENT: (A) THE SOFTWARE IS
PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT; AND (B) IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/ /**************************************************************************/

#ifndef __DRM_NULLDISP_DRV_H__
#define __DRM_NULLDISP_DRV_H__

#include <linux/version.h>

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(4, 11, 0))
#include <drm/drm_fourcc.h>
#endif

struct drm_framebuffer;

/******************************************************************************
 * Linux compatibility functions
 ******************************************************************************/
static inline u32 nulldisp_drm_fb_format(struct drm_framebuffer *fb)
{
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(4, 11, 0))
	return fb->format->format;
#else	/* (LINUX_VERSION_CODE >= KERNEL_VERSION(4, 11, 0)) */
	return fb->pixel_format;
#endif	/* (LINUX_VERSION_CODE >= KERNEL_VERSION(4, 11, 0)) */
}

static inline u64 nulldisp_drm_fb_modifier(struct drm_framebuffer *fb)
{
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(4, 10, 0))
	return fb->modifier;
#elif (LINUX_VERSION_CODE >= KERNEL_VERSION(4, 1, 0))
	return fb->modifier[0];
#else
	/* 0 represents DRM_FORMAT_MOD_NONE, doesn't exist before 4.1 */
	return 0;
#endif
}

/******************************************************************************
 * DRM framebuffer support functions
 ******************************************************************************/
static inline int nulldisp_drm_fb_num_planes(struct drm_framebuffer *fb)
{
	return drm_format_num_planes(nulldisp_drm_fb_format(fb));
}
#endif /* __DRM_NULLDISP_DRV_H__ */
