/*
 * Copyright (c) 2015 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/**
 * @file panel_truly_bd0598U40010.c
 * Panel Driver.\n
 * This driver is used to initial truly bd0598U40010 panel module.\n
 */

#include <linux/init.h>
#include <linux/module.h>
#include <linux/interrupt.h>
#include <linux/types.h>
#include <linux/cdev.h>
#include <linux/platform_device.h>
#include <linux/delay.h>
#include <linux/uaccess.h>
#include <linux/io.h>
#include <video/videomode.h>
#include <video/mipi_display.h>
#include <drm/drm_mipi_dsi.h>

#include "mtk_dsi_int.h"
#include <soc/mediatek/mtk_dsi.h>

/** @ingroup IP_group_dsi_internal_def_panel
 * @{
 */
#define REGFLAG_DELAY		0xfffc
#define REGFLAG_UDELAY		0xfffb
#define REGFLAG_END_OF_TABLE	0xfffd
#define REGFLAG_RESET_LOW	0xfffe
#define REGFLAG_RESET_HIGH	0xffff
/**
 * @}
 */

/**
 * @brief This is panel init parameter.
 */
static const struct lcm_setting_table init_setting[] = {
	{0xff, 1, {0x24} },
	{0x6e, 1, {0x10} },
	{0xfb, 1, {0x01} },
	{0xff, 1, {0x10} },
	{0xff, 1, {0x10} },
	{REGFLAG_UDELAY, 1, {} },
	{0xbb, 1, {0x03} }, /* Video mode */
	{0x3b, 5, {0x03, 0x0a, 0x0a, 0x0a, 0x0a} },
	{0x53, 1, {0x24} },
	{0x55, 1, {0x00} },
	{0x5e, 1, {0x00} },
	{0x11, 0, {} },
	{REGFLAG_DELAY, 120, {} },
	{0xff, 1, {0x24} },
	{REGFLAG_UDELAY, 1, {} },
	{0xfb, 1, {0x01} },
	{0x9d, 1, {0xb0} },
	{0x72, 1, {0x00} },
	{0x93, 1, {0x04} },
	{0x94, 1, {0x04} },
	{0x9b, 1, {0x0f} },
	{0x8a, 1, {0x33} },
	{0x86, 1, {0x1b} },
	{0x87, 1, {0x39} },
	{0x88, 1, {0x1b} },
	{0x89, 1, {0x39} },
	{0x8b, 1, {0xf4} },
	{0x8c, 1, {0x01} },
	{0x90, 1, {0x79} },
	{0x91, 1, {0x4c} },
	/* modify to 0x77 to see whether fps is higher */
	/* {0x92,1,{0x79}}, */
	{0x92, 1, {0x77} },
	{0x95, 1, {0xe4} },

	{0xde, 1, {0xff} },
	{0xdf, 1, {0x82} },

	{0x00, 1, {0x0f} },
	{0x01, 1, {0x00} },
	{0x02, 1, {0x00} },
	{0x03, 1, {0x00} },
	{0x04, 1, {0x0b} },
	{0x05, 1, {0x0c} },
	{0x06, 1, {0x00} },
	{0x07, 1, {0x00} },
	{0x08, 1, {0x00} },
	{0x09, 1, {0x00} },
	{0x0a, 1, {0x03} },
	{0x0b, 1, {0x04} },
	{0x0c, 1, {0x01} },
	{0x0d, 1, {0x13} },
	{0x0e, 1, {0x15} },
	{0x0f, 1, {0x17} },
	{0x10, 1, {0x0f} },
	{0x11, 1, {0x00} },
	{0x12, 1, {0x00} },
	{0x13, 1, {0x00} },
	{0x14, 1, {0x0b} },
	{0x15, 1, {0x0c} },
	{0x16, 1, {0x00} },
	{0x17, 1, {0x00} },
	{0x18, 1, {0x00} },
	{0x19, 1, {0x00} },
	{0x1a, 1, {0x03} },
	{0x1b, 1, {0x04} },
	{0x1c, 1, {0x01} },
	{0x1d, 1, {0x13} },
	{0x1e, 1, {0x15} },
	{0x1f, 1, {0x17} },

	{0x20, 1, {0x09} },
	{0x21, 1, {0x01} },
	{0x22, 1, {0x00} },
	{0x23, 1, {0x00} },
	{0x24, 1, {0x00} },
	{0x25, 1, {0x6d} },
	{0x26, 1, {0x00} },
	{0x27, 1, {0x00} },

	{0x2f, 1, {0x02} },
	{0x30, 1, {0x04} },
	{0x31, 1, {0x49} },
	{0x32, 1, {0x23} },
	{0x33, 1, {0x01} },
	{0x34, 1, {0x00} },
	{0x35, 1, {0x69} },
	{0x36, 1, {0x00} },
	{0x37, 1, {0x2d} },
	{0x38, 1, {0x08} },
	{0x39, 1, {0x00} },
	{0x3a, 1, {0x69} },

	{0x29, 1, {0x58} },
	{0x2a, 1, {0x16} },

	{0x5b, 1, {0x00} },
	{0x5f, 1, {0x75} },
	{0x63, 1, {0x00} },
	{0x67, 1, {0x04} },

	{0x7b, 1, {0x80} },
	{0x7c, 1, {0xd8} },
	{0x7d, 1, {0x60} },
	{0x7e, 1, {0x10} },
	{0x7f, 1, {0x19} },
	{0x80, 1, {0x00} },
	{0x81, 1, {0x06} },
	{0x82, 1, {0x03} },
	{0x83, 1, {0x00} },
	{0x84, 1, {0x03} },
	{0x85, 1, {0x07} },
	{0x74, 1, {0x10} },
	{0x75, 1, {0x19} },
	{0x76, 1, {0x06} },
	{0x77, 1, {0x03} },

	{0x78, 1, {0x00} },
	{0x79, 1, {0x00} },
	{0x99, 1, {0x33} },
	{0x98, 1, {0x00} },
	{0xb3, 1, {0x28} },
	{0xb4, 1, {0x05} },
	{0xb5, 1, {0x10} },

	{0xff, 1, {0x20} },
	{REGFLAG_UDELAY, 1, {} },
	{0x00, 1, {0x01} },
	{0x01, 1, {0x55} },
	{0x02, 1, {0x45} },
	{0x03, 1, {0x55} },
	{0x05, 1, {0x50} },
	{0x06, 1, {0x9e} },
	{0x07, 1, {0xa8} },
	{0x08, 1, {0x0c} },
	{0x0b, 1, {0x96} },
	{0x0c, 1, {0x96} },
	{0x0e, 1, {0x00} },
	{0x0f, 1, {0x00} },
	{0x11, 1, {0x29} },
	{0x12, 1, {0x29} },
	{0x13, 1, {0x03} },
	{0x14, 1, {0x0a} },
	{0x15, 1, {0x99} },
	{0x16, 1, {0x99} },
	{0x6d, 1, {0x44} },
	{0x58, 1, {0x05} },
	{0x59, 1, {0x05} },
	{0x5a, 1, {0x05} },
	{0x5b, 1, {0x05} },
	{0x5c, 1, {0x00} },
	{0x5d, 1, {0x00} },
	{0x5e, 1, {0x00} },
	{0x5f, 1, {0x00} },

	{0x1b, 1, {0x39} },
	{0x1c, 1, {0x39} },
	{0x1d, 1, {0x47} },

	{0xff, 1, {0x20} },
	{REGFLAG_UDELAY, 1, {} },
	/* R+   ,1,{}}, */
	{0x75, 1, {0x00} },
	{0x76, 1, {0x00} },
	{0x77, 1, {0x00} },
	{0x78, 1, {0x22} },
	{0x79, 1, {0x00} },
	{0x7a, 1, {0x46} },
	{0x7b, 1, {0x00} },
	{0x7c, 1, {0x5c} },
	{0x7d, 1, {0x00} },
	{0x7e, 1, {0x76} },
	{0x7f, 1, {0x00} },
	{0x80, 1, {0x8d} },
	{0x81, 1, {0x00} },
	{0x82, 1, {0xa6} },
	{0x83, 1, {0x00} },
	{0x84, 1, {0xb8} },
	{0x85, 1, {0x00} },
	{0x86, 1, {0xc7} },
	{0x87, 1, {0x00} },
	{0x88, 1, {0xf6} },
	{0x89, 1, {0x01} },
	{0x8a, 1, {0x1d} },
	{0x8b, 1, {0x01} },
	{0x8c, 1, {0x54} },
	{0x8d, 1, {0x01} },
	{0x8e, 1, {0x81} },
	{0x8f, 1, {0x01} },
	{0x90, 1, {0xcb} },
	{0x91, 1, {0x02} },
	{0x92, 1, {0x05} },
	{0x93, 1, {0x02} },
	{0x94, 1, {0x07} },
	{0x95, 1, {0x02} },
	{0x96, 1, {0x47} },
	{0x97, 1, {0x02} },
	{0x98, 1, {0x82} },
	{0x99, 1, {0x02} },
	{0x9a, 1, {0xab} },
	{0x9b, 1, {0x02} },
	{0x9c, 1, {0xdc} },
	{0x9d, 1, {0x03} },
	{0x9e, 1, {0x01} },
	{0x9f, 1, {0x03} },
	{0xa0, 1, {0x3a} },
	{0xa2, 1, {0x03} },
	{0xa3, 1, {0x56} },
	{0xa4, 1, {0x03} },
	{0xa5, 1, {0x6d} },
	{0xa6, 1, {0x03} },
	{0xa7, 1, {0x89} },
	{0xa9, 1, {0x03} },
	{0xaa, 1, {0xa3} },
	{0xab, 1, {0x03} },
	{0xac, 1, {0xc9} },
	{0xad, 1, {0x03} },
	{0xae, 1, {0xdd} },
	{0xaf, 1, {0x03} },
	{0xb0, 1, {0xf5} },
	{0xb1, 1, {0x03} },
	{0xb2, 1, {0xff} },
	/* R-   ,1,{}}, */
	{0xb3, 1, {0x00} },
	{0xb4, 1, {0x00} },
	{0xb5, 1, {0x00} },
	{0xb6, 1, {0x22} },
	{0xb7, 1, {0x00} },
	{0xb8, 1, {0x46} },
	{0xb9, 1, {0x00} },
	{0xba, 1, {0x5c} },
	{0xbb, 1, {0x00} },
	{0xbc, 1, {0x76} },
	{0xbd, 1, {0x00} },
	{0xbe, 1, {0x8d} },
	{0xbf, 1, {0x00} },
	{0xc0, 1, {0xa6} },
	{0xc1, 1, {0x00} },
	{0xc2, 1, {0xb8} },
	{0xc3, 1, {0x00} },
	{0xc4, 1, {0xc7} },
	{0xc5, 1, {0x00} },
	{0xc6, 1, {0xf6} },
	{0xc7, 1, {0x01} },
	{0xc8, 1, {0x1d} },
	{0xc9, 1, {0x01} },
	{0xca, 1, {0x54} },
	{0xcb, 1, {0x01} },
	{0xcc, 1, {0x81} },
	{0xcd, 1, {0x01} },
	{0xce, 1, {0xcb} },
	{0xcf, 1, {0x02} },
	{0xd0, 1, {0x05} },
	{0xd1, 1, {0x02} },
	{0xd2, 1, {0x07} },
	{0xd3, 1, {0x02} },
	{0xd4, 1, {0x47} },
	{0xd5, 1, {0x02} },
	{0xd6, 1, {0x82} },
	{0xd7, 1, {0x02} },
	{0xd8, 1, {0xab} },
	{0xd9, 1, {0x02} },
	{0xda, 1, {0xdc} },
	{0xdb, 1, {0x03} },
	{0xdc, 1, {0x01} },
	{0xdd, 1, {0x03} },
	{0xde, 1, {0x3a} },
	{0xdf, 1, {0x03} },
	{0xe0, 1, {0x56} },
	{0xe1, 1, {0x03} },
	{0xe2, 1, {0x6d} },
	{0xe3, 1, {0x03} },
	{0xe4, 1, {0x89} },
	{0xe5, 1, {0x03} },
	{0xe6, 1, {0xa3} },
	{0xe7, 1, {0x03} },
	{0xe8, 1, {0xc9} },
	{0xe9, 1, {0x03} },
	{0xea, 1, {0xdd} },
	{0xeb, 1, {0x03} },
	{0xec, 1, {0xf5} },
	{0xed, 1, {0x03} },
	{0xee, 1, {0xff} },
	/* G+   ,1,{}}, */
	{0xef, 1, {0x00} },
	{0xf0, 1, {0x00} },
	{0xf1, 1, {0x00} },
	{0xf2, 1, {0x22} },
	{0xf3, 1, {0x00} },
	{0xf4, 1, {0x46} },
	{0xf5, 1, {0x00} },
	{0xf6, 1, {0x5c} },
	{0xf7, 1, {0x00} },
	{0xf8, 1, {0x76} },
	{0xf9, 1, {0x00} },
	{0xfa, 1, {0x8d} },

	{0xff, 1, {0x21} },
	{REGFLAG_UDELAY, 1, {} },
	{0x00, 1, {0x00} },
	{0x01, 1, {0xa6} },
	{0x02, 1, {0x00} },
	{0x03, 1, {0xb8} },
	{0x04, 1, {0x00} },
	{0x05, 1, {0xc7} },
	{0x06, 1, {0x00} },
	{0x07, 1, {0xf6} },
	{0x08, 1, {0x01} },
	{0x09, 1, {0x1d} },
	{0x0a, 1, {0x01} },
	{0x0b, 1, {0x54} },
	{0x0c, 1, {0x01} },
	{0x0d, 1, {0x81} },
	{0x0e, 1, {0x01} },
	{0x0f, 1, {0xcb} },
	{0x10, 1, {0x02} },
	{0x11, 1, {0x05} },
	{0x12, 1, {0x02} },
	{0x13, 1, {0x07} },
	{0x14, 1, {0x02} },
	{0x15, 1, {0x47} },
	{0x16, 1, {0x02} },
	{0x17, 1, {0x82} },
	{0x18, 1, {0x02} },
	{0x19, 1, {0xab} },
	{0x1a, 1, {0x02} },
	{0x1b, 1, {0xdc} },
	{0x1c, 1, {0x03} },
	{0x1d, 1, {0x01} },
	{0x1e, 1, {0x03} },
	{0x1f, 1, {0x3a} },
	{0x20, 1, {0x03} },
	{0x21, 1, {0x56} },
	{0x22, 1, {0x03} },
	{0x23, 1, {0x6d} },
	{0x24, 1, {0x03} },
	{0x25, 1, {0x89} },
	{0x26, 1, {0x03} },
	{0x27, 1, {0xa3} },
	{0x28, 1, {0x03} },
	{0x29, 1, {0xc9} },
	{0x2a, 1, {0x03} },
	{0x2b, 1, {0xdd} },
	{0x2d, 1, {0x03} },
	{0x2f, 1, {0xf5} },
	{0x30, 1, {0x03} },
	{0x31, 1, {0xff} },
	/* G-   ,1,{}}, */
	{0x32, 1, {0x00} },
	{0x33, 1, {0x00} },
	{0x34, 1, {0x00} },
	{0x35, 1, {0x22} },
	{0x36, 1, {0x00} },
	{0x37, 1, {0x46} },
	{0x38, 1, {0x00} },
	{0x39, 1, {0x5c} },
	{0x3a, 1, {0x00} },
	{0x3b, 1, {0x76} },
	{0x3d, 1, {0x00} },
	{0x3f, 1, {0x8d} },
	{0x40, 1, {0x00} },
	{0x41, 1, {0xa6} },
	{0x42, 1, {0x00} },
	{0x43, 1, {0xb8} },
	{0x44, 1, {0x00} },
	{0x45, 1, {0xc7} },
	{0x46, 1, {0x00} },
	{0x47, 1, {0xf6} },
	{0x48, 1, {0x01} },
	{0x49, 1, {0x1d} },
	{0x4a, 1, {0x01} },
	{0x4b, 1, {0x54} },
	{0x4c, 1, {0x01} },
	{0x4d, 1, {0x81} },
	{0x4e, 1, {0x01} },
	{0x4f, 1, {0xcb} },
	{0x50, 1, {0x02} },
	{0x51, 1, {0x05} },
	{0x52, 1, {0x02} },
	{0x53, 1, {0x07} },
	{0x54, 1, {0x02} },
	{0x55, 1, {0x47} },
	{0x56, 1, {0x02} },
	{0x58, 1, {0x82} },
	{0x59, 1, {0x02} },
	{0x5a, 1, {0xab} },
	{0x5b, 1, {0x02} },
	{0x5c, 1, {0xdc} },
	{0x5d, 1, {0x03} },
	{0x5e, 1, {0x01} },
	{0x5f, 1, {0x03} },
	{0x60, 1, {0x3a} },
	{0x61, 1, {0x03} },
	{0x62, 1, {0x56} },
	{0x63, 1, {0x03} },
	{0x64, 1, {0x6d} },
	{0x65, 1, {0x03} },
	{0x66, 1, {0x89} },
	{0x67, 1, {0x03} },
	{0x68, 1, {0xa3} },
	{0x69, 1, {0x03} },
	{0x6a, 1, {0xc9} },
	{0x6b, 1, {0x03} },
	{0x6c, 1, {0xdd} },
	{0x6d, 1, {0x03} },
	{0x6e, 1, {0xf5} },
	{0x6f, 1, {0x03} },
	{0x70, 1, {0xff} },
	/* B+   ,1,{}}, */
	{0x71, 1, {0x00} },
	{0x72, 1, {0x00} },
	{0x73, 1, {0x00} },
	{0x74, 1, {0x22} },
	{0x75, 1, {0x00} },
	{0x76, 1, {0x46} },
	{0x77, 1, {0x00} },
	{0x78, 1, {0x5c} },
	{0x79, 1, {0x00} },
	{0x7a, 1, {0x76} },
	{0x7b, 1, {0x00} },
	{0x7c, 1, {0x8d} },
	{0x7d, 1, {0x00} },
	{0x7e, 1, {0xa6} },
	{0x7f, 1, {0x00} },
	{0x80, 1, {0xb8} },
	{0x81, 1, {0x00} },
	{0x82, 1, {0xc7} },
	{0x83, 1, {0x00} },
	{0x84, 1, {0xf6} },
	{0x85, 1, {0x01} },
	{0x86, 1, {0x1d} },
	{0x87, 1, {0x01} },
	{0x88, 1, {0x54} },
	{0x89, 1, {0x01} },
	{0x8a, 1, {0x81} },
	{0x8b, 1, {0x01} },
	{0x8c, 1, {0xcb} },
	{0x8d, 1, {0x02} },
	{0x8e, 1, {0x05} },
	{0x8f, 1, {0x02} },
	{0x90, 1, {0x07} },
	{0x91, 1, {0x02} },
	{0x92, 1, {0x47} },
	{0x93, 1, {0x02} },
	{0x94, 1, {0x82} },
	{0x95, 1, {0x02} },
	{0x96, 1, {0xab} },
	{0x97, 1, {0x02} },
	{0x98, 1, {0xdc} },
	{0x99, 1, {0x03} },
	{0x9a, 1, {0x01} },
	{0x9b, 1, {0x03} },
	{0x9c, 1, {0x3a} },
	{0x9d, 1, {0x03} },
	{0x9e, 1, {0x56} },
	{0x9f, 1, {0x03} },
	{0xa0, 1, {0x6d} },
	{0xa2, 1, {0x03} },
	{0xa3, 1, {0x89} },
	{0xa4, 1, {0x03} },
	{0xa5, 1, {0xa3} },
	{0xa6, 1, {0x03} },
	{0xa7, 1, {0xc9} },
	{0xa9, 1, {0x03} },
	{0xaa, 1, {0xdd} },
	{0xab, 1, {0x03} },
	{0xac, 1, {0xf5} },
	{0xad, 1, {0x03} },
	{0xae, 1, {0xff} },
	/* B-   ,1,{}}, */
	{0xaf, 1, {0x00} },
	{0xb0, 1, {0x00} },
	{0xb1, 1, {0x00} },
	{0xb2, 1, {0x22} },
	{0xb3, 1, {0x00} },
	{0xb4, 1, {0x46} },
	{0xb5, 1, {0x00} },
	{0xb6, 1, {0x5c} },
	{0xb7, 1, {0x00} },
	{0xb8, 1, {0x76} },
	{0xb9, 1, {0x00} },
	{0xba, 1, {0x8d} },
	{0xbb, 1, {0x00} },
	{0xbc, 1, {0xa6} },
	{0xbd, 1, {0x00} },
	{0xbe, 1, {0xb8} },
	{0xbf, 1, {0x00} },
	{0xc0, 1, {0xc7} },
	{0xc1, 1, {0x00} },
	{0xc2, 1, {0xf6} },
	{0xc3, 1, {0x01} },
	{0xc4, 1, {0x1d} },
	{0xc5, 1, {0x01} },
	{0xc6, 1, {0x54} },
	{0xc7, 1, {0x01} },
	{0xc8, 1, {0x81} },
	{0xc9, 1, {0x01} },
	{0xca, 1, {0xcb} },
	{0xcb, 1, {0x02} },
	{0xcc, 1, {0x05} },
	{0xcd, 1, {0x02} },
	{0xce, 1, {0x07} },
	{0xcf, 1, {0x02} },
	{0xd0, 1, {0x47} },
	{0xd1, 1, {0x02} },
	{0xd2, 1, {0x82} },
	{0xd3, 1, {0x02} },
	{0xd4, 1, {0xab} },
	{0xd5, 1, {0x02} },
	{0xd6, 1, {0xdc} },
	{0xd7, 1, {0x03} },
	{0xd8, 1, {0x01} },
	{0xd9, 1, {0x03} },
	{0xda, 1, {0x3a} },
	{0xdb, 1, {0x03} },
	{0xdc, 1, {0x56} },
	{0xdd, 1, {0x03} },
	{0xde, 1, {0x6d} },
	{0xdf, 1, {0x03} },
	{0xe0, 1, {0x89} },
	{0xe1, 1, {0x03} },
	{0xe2, 1, {0xa3} },
	{0xe3, 1, {0x03} },
	{0xe4, 1, {0xc9} },
	{0xe5, 1, {0x03} },
	{0xe6, 1, {0xdd} },
	{0xe7, 1, {0x03} },
	{0xe8, 1, {0xf5} },
	{0xe9, 1, {0x03} },
	{0xea, 1, {0xff} },

	{0xff, 1, {0x21} },
	{REGFLAG_UDELAY, 1, {} },
	{0xeb, 1, {0x30} },
	{0xec, 1, {0x17} },
	{0xed, 1, {0x20} },
	{0xee, 1, {0x0f} },
	{0xef, 1, {0x1f} },
	{0xf0, 1, {0x0f} },
	{0xf1, 1, {0x0f} },
	{0xf2, 1, {0x07} },

	{0xff, 1, {0x23} },
	{REGFLAG_UDELAY, 1, {} },
	{0x08, 1, {0x04} },

	/* image.first */
	{0xff, 1, {0x10} },
	{REGFLAG_UDELAY, 1, {} },
	{0x35, 1, {0x00} },
	/* {0x29, 0, {} }, */
	/* {0x51,1,{0xFF}},     //      write   display brightness */
};

/**
 * @brief This is panel init parameter (nt35695B_fhd_vdo_auo).
 */
static const struct lcm_setting_table init_setting_nt35695B_fhd_vdo_auo[] = {
	{0xff, 1, {0x24} },
	{0xfb, 1, {0x01} },
	{0xc5, 1, {0x31} },
	{0xff, 1, {0x20} },
	{0x00, 1, {0x01} },
	{0x01, 1, {0x55} },
	{0x02, 1, {0x45} },
	{0x03, 1, {0x55} },
	{0x05, 1, {0x40} },/* VGH=2xAVDD, VGL=2xAVEE */
	{0x06, 1, {0x99} },
	{0x07, 1, {0x9e} },
	{0x08, 1, {0x0c} },
	{0x0b, 1, {0x87} },
	{0x0c, 1, {0x87} },
	{0x0e, 1, {0xab} },
	{0x0f, 1, {0xa9} },
	{0x11, 1, {0x0d} },/* VCOM */
	{0x12, 1, {0x10} },/* VCOM */
	{0x13, 1, {0x03} },
	{0x14, 1, {0x4a} },
	{0x15, 1, {0x12} },
	{0x16, 1, {0x12} },
	{0x30, 1, {0x01} },
	{0x58, 1, {0x00} },
	{0x59, 1, {0x00} },
	{0x5a, 1, {0x02} },
	{0x5b, 1, {0x00} },
	{0x5c, 1, {0x00} },
	{0x5d, 1, {0x00} },
	{0x5e, 1, {0x02} },
	{0x5f, 1, {0x02} },
	{0x72, 1, {0x31} },
	{0xfb, 1, {0x01} },
	{0xff, 1, {0x24} },
	{0x00, 1, {0x01} },
	{0x01, 1, {0x0b} },
	{0x02, 1, {0x0c} },
	{0x03, 1, {0x03} },
	{0x04, 1, {0x05} },
	{0x05, 1, {0x1c} },
	{0x06, 1, {0x10} },
	{0x07, 1, {0x00} },
	{0x08, 1, {0x1c} },
	{0x09, 1, {0x00} },
	{0x0a, 1, {0x00} },
	{0x0b, 1, {0x00} },
	{0x0c, 1, {0x00} },
	{0x0d, 1, {0x13} },
	{0x0e, 1, {0x15} },
	{0x0f, 1, {0x17} },
	{0x10, 1, {0x01} },
	{0x11, 1, {0x0b} },
	{0x12, 1, {0x0c} },
	{0x13, 1, {0x04} },
	{0x14, 1, {0x06} },
	{0x15, 1, {0x1c} },
	{0x16, 1, {0x10} },
	{0x17, 1, {0x00} },
	{0x18, 1, {0x1c} },
	{0x19, 1, {0x00} },
	{0x1a, 1, {0x00} },
	{0x1b, 1, {0x00} },
	{0x1c, 1, {0x00} },
	{0x1d, 1, {0x13} },
	{0x1e, 1, {0x15} },
	{0x1f, 1, {0x17} },
	{0x20, 1, {0x00} },/* STV */
	{0x21, 1, {0x03} },
	{0x22, 1, {0x01} },
	{0x23, 1, {0x4a} },
	{0x24, 1, {0x4a} },
	{0x25, 1, {0x6d} },
	{0x26, 1, {0x40} },
	{0x27, 1, {0x40} },
	{0x32, 1, {0x7b} },
	{0x33, 1, {0x00} },
	{0x34, 1, {0x01} },
	{0x35, 1, {0x8e} },
	{0x39, 1, {0x01} },
	{0x3a, 1, {0x8e} },
	{0xbd, 1, {0x20} },/* VEND */
	{0xb6, 1, {0x22} },
	{0xb7, 1, {0x24} },
	{0xb8, 1, {0x07} },
	{0xb9, 1, {0x07} },
	{0xc1, 1, {0x6d} },
	/* disable Vblank protection for low fps power saving (for vdo mode)*/
	{0xc2, 1, {0x00} },
	{0xc4, 1, {0x24} },/* updated */
	{0xbe, 1, {0x07} },
	{0xbf, 1, {0x07} },
	{0x29, 1, {0xd8} },/* UD */
	{0x2a, 1, {0x2a} },
	{0x5b, 1, {0x43} },/* CTRL */
	{0x5c, 1, {0x00} },
	{0x5f, 1, {0x73} },
	{0x60, 1, {0x73} },
	{0x63, 1, {0x22} },
	{0x64, 1, {0x00} },
	{0x67, 1, {0x08} },
	{0x68, 1, {0x04} },
	{0x7a, 1, {0x80} },/* MUX */
	{0x7b, 1, {0x91} },
	{0x7c, 1, {0xd8} },
	{0x7d, 1, {0x60} },
	{0x74, 1, {0x09} },
	{0x7e, 1, {0x09} },
	{0x75, 1, {0x21} },
	{0x7f, 1, {0x21} },
	{0x76, 1, {0x05} },
	{0x81, 1, {0x05} },
	{0x77, 1, {0x04} },
	{0x82, 1, {0x04} },
	{0x93, 1, {0x06} },/* FP,BP */
	{0x94, 1, {0x06} },
	{0xb3, 1, {0x00} },
	{0xb4, 1, {0x00} },
	{0xb5, 1, {0x00} },
	{0x78, 1, {0x00} },/* SOURCE EQ */
	{0x79, 1, {0x00} },
	{0x80, 1, {0x00} },
	{0x83, 1, {0x00} },
	{0x84, 1, {0x04} },
	{0x8a, 1, {0x33} },/* /Inversion Type// pixel column driving */
	{0x8b, 1, {0xf0} },
	{0x9b, 1, {0x0f} },
	{0xc6, 1, {0x09} },
	{0xfb, 1, {0x01} },
	{0xec, 1, {0x00} },
	{0xff, 1, {0x20} },
	{0xfb, 1, {0x01} },
	{0x75, 1, {0x00} },
	{0x76, 1, {0x49} },
	{0x77, 1, {0x00} },
	{0x78, 1, {0x78} },
	{0x79, 1, {0x00} },
	{0x7a, 1, {0xa4} },
	{0x7b, 1, {0x00} },
	{0x7c, 1, {0xc2} },
	{0x7d, 1, {0x00} },
	{0x7e, 1, {0xda} },
	{0x7f, 1, {0x00} },
	{0x80, 1, {0xed} },
	{0x81, 1, {0x00} },
	{0x82, 1, {0xfe} },
	{0x83, 1, {0x01} },
	{0x84, 1, {0x0e} },
	{0x85, 1, {0x01} },
	{0x86, 1, {0x1b} },
	{0x87, 1, {0x01} },
	{0x88, 1, {0x48} },
	{0x89, 1, {0x01} },
	{0x8a, 1, {0x6c} },
	{0x8b, 1, {0x01} },
	{0x8c, 1, {0xa2} },
	{0x8d, 1, {0x01} },
	{0x8e, 1, {0xcd} },
	{0x8f, 1, {0x02} },
	{0x90, 1, {0x0f} },
	{0x91, 1, {0x02} },
	{0x92, 1, {0x42} },
	{0x93, 1, {0x02} },
	{0x94, 1, {0x43} },
	{0x95, 1, {0x02} },
	{0x96, 1, {0x71} },
	{0x97, 1, {0x02} },
	{0x98, 1, {0xa3} },
	{0x99, 1, {0x02} },
	{0x9a, 1, {0xc5} },
	{0x9b, 1, {0x02} },
	{0x9c, 1, {0xf3} },
	{0x9d, 1, {0x03} },
	{0x9e, 1, {0x12} },
	{0x9f, 1, {0x03} },
	{0xa0, 1, {0x3a} },
	{0xa2, 1, {0x03} },
	{0xa3, 1, {0x46} },
	{0xa4, 1, {0x03} },
	{0xa5, 1, {0x52} },
	{0xa6, 1, {0x03} },
	{0xa7, 1, {0x60} },
	{0xa9, 1, {0x03} },
	{0xaa, 1, {0x6e} },
	{0xab, 1, {0x03} },
	{0xac, 1, {0x7d} },
	{0xad, 1, {0x03} },
	{0xae, 1, {0x8b} },
	{0xaf, 1, {0x03} },
	{0xb0, 1, {0x91} },
	{0xb1, 1, {0x03} },
	{0xb2, 1, {0xcf} },
	{0xb3, 1, {0x00} },/* RN GAMMA SETTING */
	{0xb4, 1, {0x49} },
	{0xb5, 1, {0x00} },
	{0xb6, 1, {0x78} },
	{0xb7, 1, {0x00} },
	{0xb8, 1, {0xa4} },
	{0xb9, 1, {0x00} },
	{0xba, 1, {0xc2} },
	{0xbb, 1, {0x00} },
	{0xbc, 1, {0xda} },
	{0xbd, 1, {0x00} },
	{0xbe, 1, {0xed} },
	{0xbf, 1, {0x00} },
	{0xc0, 1, {0xfe} },
	{0xc1, 1, {0x01} },
	{0xc2, 1, {0x0e} },
	{0xc3, 1, {0x01} },
	{0xc4, 1, {0x1b} },
	{0xc5, 1, {0x01} },
	{0xc6, 1, {0x48} },
	{0xc7, 1, {0x01} },
	{0xc8, 1, {0x6c} },
	{0xc9, 1, {0x01} },
	{0xca, 1, {0xa2} },
	{0xcb, 1, {0x01} },
	{0xcc, 1, {0xcd} },
	{0xcd, 1, {0x02} },
	{0xce, 1, {0x0f} },
	{0xcf, 1, {0x02} },
	{0xd0, 1, {0x42} },
	{0xd1, 1, {0x02} },
	{0xd2, 1, {0x43} },
	{0xd3, 1, {0x02} },
	{0xd4, 1, {0x71} },
	{0xd5, 1, {0x02} },
	{0xd6, 1, {0xa3} },
	{0xd7, 1, {0x02} },
	{0xd8, 1, {0xc5} },
	{0xd9, 1, {0x02} },
	{0xda, 1, {0xf3} },
	{0xdb, 1, {0x03} },
	{0xdc, 1, {0x12} },
	{0xdd, 1, {0x03} },
	{0xde, 1, {0x3a} },
	{0xdf, 1, {0x03} },
	{0xe0, 1, {0x46} },
	{0xe1, 1, {0x03} },
	{0xe2, 1, {0x52} },
	{0xe3, 1, {0x03} },
	{0xe4, 1, {0x60} },
	{0xe5, 1, {0x03} },
	{0xe6, 1, {0x6e} },
	{0xe7, 1, {0x03} },
	{0xe8, 1, {0x7d} },
	{0xe9, 1, {0x03} },
	{0xea, 1, {0x8b} },
	{0xeb, 1, {0x03} },
	{0xec, 1, {0x91} },
	{0xed, 1, {0x03} },
	{0xee, 1, {0xcf} },
	{0xef, 1, {0x00} },/* GP GAMMA SETTING */
	{0xf0, 1, {0x49} },
	{0xf1, 1, {0x00} },
	{0xf2, 1, {0x78} },
	{0xf3, 1, {0x00} },
	{0xf4, 1, {0xa4} },
	{0xf5, 1, {0x00} },
	{0xf6, 1, {0xc2} },
	{0xf7, 1, {0x00} },
	{0xf8, 1, {0xda} },
	{0xf9, 1, {0x00} },
	{0xfa, 1, {0xed} },
	{0xff, 1, {0x21} },/* CMD2 PAGE1 */
	{0xfb, 1, {0x01} },
	{0x00, 1, {0x00} },
	{0x01, 1, {0xfe} },
	{0x02, 1, {0x01} },
	{0x03, 1, {0x0e} },
	{0x04, 1, {0x01} },
	{0x05, 1, {0x1b} },
	{0x06, 1, {0x01} },
	{0x07, 1, {0x48} },
	{0x08, 1, {0x01} },
	{0x09, 1, {0x6c} },
	{0x0a, 1, {0x01} },
	{0x0b, 1, {0xa2} },
	{0x0c, 1, {0x01} },
	{0x0d, 1, {0xcd} },
	{0x0e, 1, {0x02} },
	{0x0f, 1, {0x0f} },
	{0x10, 1, {0x02} },
	{0x11, 1, {0x42} },
	{0x12, 1, {0x02} },
	{0x13, 1, {0x43} },
	{0x14, 1, {0x02} },
	{0x15, 1, {0x71} },
	{0x16, 1, {0x02} },
	{0x17, 1, {0xa3} },
	{0x18, 1, {0x02} },
	{0x19, 1, {0xc5} },
	{0x1a, 1, {0x02} },
	{0x1b, 1, {0xf3} },
	{0x1c, 1, {0x03} },
	{0x1d, 1, {0x12} },
	{0x1e, 1, {0x03} },
	{0x1f, 1, {0x3a} },
	{0x20, 1, {0x03} },
	{0x21, 1, {0x46} },
	{0x22, 1, {0x03} },
	{0x23, 1, {0x52} },
	{0x24, 1, {0x03} },
	{0x25, 1, {0x60} },
	{0x26, 1, {0x03} },
	{0x27, 1, {0x6e} },
	{0x28, 1, {0x03} },
	{0x29, 1, {0x7d} },
	{0x2a, 1, {0x03} },
	{0x2b, 1, {0x8b} },
	{0x2d, 1, {0x03} },
	{0x2f, 1, {0x91} },
	{0x30, 1, {0x03} },
	{0x31, 1, {0xcf} },
	{0x32, 1, {0x00} },
	{0x33, 1, {0x49} },
	{0x34, 1, {0x00} },
	{0x35, 1, {0x78} },
	{0x36, 1, {0x00} },
	{0x37, 1, {0xa4} },
	{0x38, 1, {0x00} },
	{0x39, 1, {0xc2} },
	{0x3a, 1, {0x00} },
	{0x3b, 1, {0xda} },
	{0x3d, 1, {0x00} },
	{0x3f, 1, {0xed} },
	{0x40, 1, {0x00} },
	{0x41, 1, {0xfe} },
	{0x42, 1, {0x01} },
	{0x43, 1, {0x0e} },
	{0x44, 1, {0x01} },
	{0x45, 1, {0x1b} },
	{0x46, 1, {0x01} },
	{0x47, 1, {0x48} },
	{0x48, 1, {0x01} },
	{0x49, 1, {0x6c} },
	{0x4a, 1, {0x01} },
	{0x4b, 1, {0xa2} },
	{0x4c, 1, {0x01} },
	{0x4d, 1, {0xcd} },
	{0x4e, 1, {0x02} },
	{0x4f, 1, {0x0f} },
	{0x50, 1, {0x02} },
	{0x51, 1, {0x42} },
	{0x52, 1, {0x02} },
	{0x53, 1, {0x43} },
	{0x54, 1, {0x02} },
	{0x55, 1, {0x71} },
	{0x56, 1, {0x02} },
	{0x58, 1, {0xa3} },
	{0x59, 1, {0x02} },
	{0x5a, 1, {0xc5} },
	{0x5b, 1, {0x02} },
	{0x5c, 1, {0xf3} },
	{0x5d, 1, {0x03} },
	{0x5e, 1, {0x12} },
	{0x5f, 1, {0x03} },
	{0x60, 1, {0x3a} },
	{0x61, 1, {0x03} },
	{0x62, 1, {0x46} },
	{0x63, 1, {0x03} },
	{0x64, 1, {0x52} },
	{0x65, 1, {0x03} },
	{0x66, 1, {0x60} },
	{0x67, 1, {0x03} },
	{0x68, 1, {0x6e} },
	{0x69, 1, {0x03} },
	{0x6a, 1, {0x7d} },
	{0x6b, 1, {0x03} },
	{0x6c, 1, {0x8b} },
	{0x6d, 1, {0x03} },
	{0x6e, 1, {0x91} },
	{0x6f, 1, {0x03} },
	{0x70, 1, {0xcf} },
	{0x71, 1, {0x00} },/* BP GAMMA SETTING */
	{0x72, 1, {0x49} },
	{0x73, 1, {0x00} },
	{0x74, 1, {0x78} },
	{0x75, 1, {0x00} },
	{0x76, 1, {0xa4} },
	{0x77, 1, {0x00} },
	{0x78, 1, {0xc2} },
	{0x79, 1, {0x00} },
	{0x7a, 1, {0xda} },
	{0x7b, 1, {0x00} },
	{0x7c, 1, {0xed} },
	{0x7d, 1, {0x00} },
	{0x7e, 1, {0xfe} },
	{0x7f, 1, {0x01} },
	{0x80, 1, {0x0e} },
	{0x81, 1, {0x01} },
	{0x82, 1, {0x1b} },
	{0x83, 1, {0x01} },
	{0x84, 1, {0x48} },
	{0x85, 1, {0x01} },
	{0x86, 1, {0x6c} },
	{0x87, 1, {0x01} },
	{0x88, 1, {0xa2} },
	{0x89, 1, {0x01} },
	{0x8a, 1, {0xcd} },
	{0x8b, 1, {0x02} },
	{0x8c, 1, {0x0f} },
	{0x8d, 1, {0x02} },
	{0x8e, 1, {0x42} },
	{0x8f, 1, {0x02} },
	{0x90, 1, {0x43} },
	{0x91, 1, {0x02} },
	{0x92, 1, {0x71} },
	{0x93, 1, {0x02} },
	{0x94, 1, {0xa3} },
	{0x95, 1, {0x02} },
	{0x96, 1, {0xc5} },
	{0x97, 1, {0x02} },
	{0x98, 1, {0xf3} },
	{0x99, 1, {0x03} },
	{0x9a, 1, {0x12} },
	{0x9b, 1, {0x03} },
	{0x9c, 1, {0x3a} },
	{0x9d, 1, {0x03} },
	{0x9e, 1, {0x46} },
	{0x9f, 1, {0x03} },
	{0xa0, 1, {0x52} },
	{0xa2, 1, {0x03} },
	{0xa3, 1, {0x60} },
	{0xa4, 1, {0x03} },
	{0xa5, 1, {0x6e} },
	{0xa6, 1, {0x03} },
	{0xa7, 1, {0x7d} },
	{0xa9, 1, {0x03} },
	{0xaa, 1, {0x8b} },
	{0xab, 1, {0x03} },
	{0xac, 1, {0x91} },
	{0xad, 1, {0x03} },
	{0xae, 1, {0xcf} },
	{0xaf, 1, {0x00} },
	{0xb0, 1, {0x49} },
	{0xb1, 1, {0x00} },
	{0xb2, 1, {0x78} },
	{0xb3, 1, {0x00} },
	{0xb4, 1, {0xa4} },
	{0xb5, 1, {0x00} },
	{0xb6, 1, {0xc2} },
	{0xb7, 1, {0x00} },
	{0xb8, 1, {0xda} },
	{0xb9, 1, {0x00} },
	{0xba, 1, {0xed} },
	{0xbb, 1, {0x00} },
	{0xbc, 1, {0xfe} },
	{0xbd, 1, {0x01} },
	{0xbe, 1, {0x0e} },
	{0xbf, 1, {0x01} },
	{0xc0, 1, {0x1b} },
	{0xc1, 1, {0x01} },
	{0xc2, 1, {0x48} },
	{0xc3, 1, {0x01} },
	{0xc4, 1, {0x6c} },
	{0xc5, 1, {0x01} },
	{0xc6, 1, {0xa2} },
	{0xc7, 1, {0x01} },
	{0xc8, 1, {0xcd} },
	{0xc9, 1, {0x02} },
	{0xca, 1, {0x0f} },
	{0xcb, 1, {0x02} },
	{0xcc, 1, {0x42} },
	{0xcd, 1, {0x02} },
	{0xce, 1, {0x43} },
	{0xcf, 1, {0x02} },
	{0xd0, 1, {0x71} },
	{0xd1, 1, {0x02} },
	{0xd2, 1, {0xa3} },
	{0xd3, 1, {0x02} },
	{0xd4, 1, {0xc5} },
	{0xd5, 1, {0x02} },
	{0xd6, 1, {0xf3} },
	{0xd7, 1, {0x03} },
	{0xd8, 1, {0x12} },
	{0xd9, 1, {0x03} },
	{0xda, 1, {0x3a} },
	{0xdb, 1, {0x03} },
	{0xdc, 1, {0x46} },
	{0xdd, 1, {0x03} },
	{0xde, 1, {0x52} },
	{0xdf, 1, {0x03} },
	{0xe0, 1, {0x60} },
	{0xe1, 1, {0x03} },
	{0xe2, 1, {0x6e} },
	{0xe3, 1, {0x03} },
	{0xe4, 1, {0x7d} },
	{0xe5, 1, {0x03} },
	{0xe6, 1, {0x8b} },
	{0xe7, 1, {0x03} },
	{0xe8, 1, {0x91} },
	{0xe9, 1, {0x03} },
	{0xea, 1, {0xcf} },
	{0xff, 1, {0x10} }, /* Return  To CMD1 */
	{REGFLAG_UDELAY, 1, {} },
	{0x3b, 3, {0x03, 0x0a, 0x0a} },
	{0x35, 1, {0x00} },
	/* set TE event @ line 0x778(1912) for partial update */
	{0x44, 2, {0x07, 0x78} },
	/* don't reload cmd1 setting from MTP when exit sleep. */
	{0xfb, 1, {0x01} },
	/* set partial update option */
	{0xc9, 11,
	 {0x49, 0x02, 0x05, 0x00, 0x0f, 0x06, 0x67, 0x03, 0x2e, 0x10, 0xf0} },
	{0xbb, 1, {0x03} },/* 0x03:video mode  0x10:command mode */
	{0x11, 0, {} },
	{REGFLAG_DELAY, 120, {} },
	/* {0x29, 0, {} }, */
	/* CABC SETTING */
	{0x51, 1, {0x00} },
	{0x5e, 1, {0x00} },
	{0x53, 1, {0x24} },
	{0x55, 1, {0x00} },
};

/**
 * @brief This is SIE panel init parameter for dsc disable.
 * resolution 4000*2040, RGB888.
 */
static const struct lcm_setting_table init_setting_ams336rp01_0[] = {
	/* reset deasserted */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0x01, 0, {} },
	{REGFLAG_DELAY, 10, {} },
	{0x9d, 1, {0x00} },
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* lane control */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xc4, 1, {0x02} },	/* 8 lanes/panel */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	{REGFLAG_DELAY, 25, {} },
	{0x00, 0, {} },
	/* refresh rate setting */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x50} },
	{0xc3, 1, {0x00} },	/* frame rate = 120Hz */
	{0xf7, 1, {0x02} },
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* sleep out */
	{0x11, 0, {} },
	/* hs settle time control */
	{REGFLAG_DELAY, 25, {} },
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xe8, 4,
	 {0x64, 0x88, 0x00, 0x14} },	/* settle time > 1.45Gbps/lane */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	{REGFLAG_DELAY, 225, {} },
	/* brightness control */
	{0x53, 1, {0x28} },
	{0x51, 2,
	 {0xff, 0x03} },
	/* sdc ip off */
	{0x80, 1, {0x00} },
	/* 8 bit enable control */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x2e} },
	{0xeb, 1, {0x05} },	/* 8 bit enable on */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* color coding select */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x08} },
	{0xf2, 1, {0x40} },	/* 8 bit mode */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* send rgb data at least 1 frame */
	/* end with short packet - nop */
	{0x00, 0, {} }
};

/**
 * @brief This is SIE panel init parameter for dsc enable.
 * resolution 4000*2040, RGB888, 1/3 compression.
 */
static const struct lcm_setting_table init_setting_ams336rp01_1[] = {
	/* reset deasserted */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0x01, 0, {} },
	{REGFLAG_DELAY, 7, {} },
	{0x9d, 1, {0x01} },
	/* dsc setting if dsc on*/
	/* 88 parameters for pps setting */
	{0x9e, 88,		/* 8 lanes/panel, 8bpc/8bpp, slice h=102 */
	 {0x11, 0x00, 0x00, 0x89, 0x30, 0x80, 0x07, 0xF8,
	  0x03, 0xE8, 0x00, 0x66, 0x03, 0xE8, 0x03, 0xE8,
	  0x02, 0x00, 0x03, 0x73, 0x00, 0x20, 0x0B, 0x2F,
	  0x00, 0x0D, 0x00, 0x0F, 0x01, 0x31, 0x00, 0x8A,
	  0x18, 0x00, 0x10, 0xF0, 0x03, 0x0C, 0x20, 0x00,
	  0x06, 0x0B, 0x0B, 0x33, 0x0E, 0x1C, 0x2A, 0x38,
	  0x46, 0x54, 0x62, 0x69, 0x70, 0x77, 0x79, 0x7B,
	  0x7D, 0x7E, 0x01, 0x02, 0x01, 0x00, 0x09, 0x40,
	  0x09, 0xBE, 0x19, 0xFC, 0x19, 0xFA, 0x19, 0xF8,
	  0x1A, 0x38, 0x1A, 0x78, 0x1A, 0xB6, 0x2A, 0xB6,
	  0x2A, 0xF4, 0x2A, 0xF4, 0x4B, 0x34, 0x63, 0x74} },
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* lane control */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xc4, 1, {0x02} },	/* 8 lanes/panel */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	{REGFLAG_DELAY, 25, {} },
	{0x00, 0, {} },
	/* refresh rate setting */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x50} },
	{0xc3, 1, {0x00} },	/* frame rate = 120Hz */
	{0xf7, 1, {0x02} },
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* sleep out */
	{0x11, 0, {} },
	/* hs settle time control */
	{REGFLAG_DELAY, 25, {} },
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xe8, 4,
	 {0x64, 0x88, 0x00, 0x14} },	/* settle time > 1.45Gbps/lane */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	{REGFLAG_DELAY, 225, {} },
	/* brightness control */
	{0x53, 1, {0x28} },
	{0x51, 2,
	 {0xff, 0x03} },
	/* sdc ip off */
	{0x80, 1, {0x00} },
	/* 8 bit enable control */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x2e} },
	{0xeb, 1, {0x05} },	/* 8 bit enable on */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* color coding select */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x08} },
	{0xf2, 1, {0x00} },	/* dsc on */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* send rgb data at least 1 frame */
	/* end with short packet - nop */
	{0x00, 0, {} }
};

/**
 * @brief This is SIE panel init parameter for dsc enable.
 * resolution 4000*2040, RGB888, 1/2 compression.
 */
static const struct lcm_setting_table init_setting_ams336rp01_2[] = {
	/* reset deasserted */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0x01, 0, {} },
	{REGFLAG_DELAY, 7, {} },
	{0x9d, 1, {0x01} },
	/* dsc setting if dsc on*/
	/* 88 parameters for pps setting */
	{0x9e, 88,		/* 8 lanes/panel, 8bpc/12bpp, slice h=102 */
	 {0x11, 0x00, 0x00, 0x89, 0x30, 0xC0, 0x07, 0xF8,
	  0x03, 0xE8, 0x00, 0x66, 0x03, 0xE8, 0x05, 0xDC,
	  0x01, 0x55, 0x03, 0xA2, 0x00, 0x0A, 0x06, 0x4C,
	  0x00, 0xA7, 0x00, 0x0F, 0x01, 0x31, 0x01, 0x80,
	  0x08, 0x00, 0x10, 0xF4, 0x03, 0x0C, 0x20, 0x00,
	  0x06, 0x0B, 0x0B, 0x33, 0x0E, 0x1C, 0x2A, 0x38,
	  0x46, 0x54, 0x62, 0x69, 0x70, 0x77, 0x79, 0x7B,
	  0x7D, 0x7E, 0x00, 0x82, 0x01, 0x00, 0x09, 0x40,
	  0x09, 0xBE, 0x19, 0xFC, 0x19, 0xFA, 0x19, 0xF8,
	  0x1A, 0x38, 0x1A, 0x38, 0x1A, 0x76, 0x2A, 0x76,
	  0x2A, 0x74, 0x2A, 0x74, 0x3A, 0xB4, 0x52, 0xF4} },
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* lane control */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xc4, 1, {0x02} },	/* 8 lanes/panel */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	{REGFLAG_DELAY, 25, {} },
	{0x00, 0, {} },
	/* refresh rate setting */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x50} },
	{0xc3, 1, {0x00} }, /* frame rate = 120Hz */
	{0xf7, 1, {0x02} },
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* sleep out */
	{0x11, 0, {} },
	/* hs settle time control */
	{REGFLAG_DELAY, 25, {} },
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xe8, 4,
	 {0x64, 0x88, 0x00, 0x14} },	/* settle time > 1.45Gbps/lane */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	{REGFLAG_DELAY, 225, {} },
	/* brightness control */
	{0x53, 1, {0x28} },
	{0x51, 2,
	 {0xff, 0x03} },
	/* sdc ip off */
	{0x80, 1, {0x00} },
	/* 8 bit enable control */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x2e} },
	{0xeb, 1, {0x05} },	/* 8 bit enable on */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* color coding select */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x08} },
	{0xf2, 1, {0x00} },	/* dsc on */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* send rgb data at least 1 frame */
	/* end with short packet - nop */
	{0x00, 0, {} }
};

/**
 * @brief This is SIE panel init parameter for dsc enable.
 * resolution 4000*2040, RGB101010, 1/3 compression.
 */
static const struct lcm_setting_table init_setting_ams336rp01_3[] = {
	/* reset deasserted */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0x01, 0, {} },
	{REGFLAG_DELAY, 7, {} },
	{0x9d, 1, {0x01} },
	/* dsc setting if dsc on*/
	/* 88 parameters for pps setting */
	{0x9e, 88,		/* 8 lanes/panel, 10bpc/10bpp, slice h=102 */
	 {0x11, 0x00, 0x00, 0xAB, 0x30, 0xA0, 0x07, 0xF8,
	  0x03, 0xE8, 0x00, 0x66, 0x03, 0xE8, 0x04, 0xE2,
	  0x01, 0x9A, 0x02, 0xF5, 0x00, 0x19, 0x0A, 0x71,
	  0x00, 0x13, 0x00, 0x0F, 0x01, 0x31, 0x00, 0xA9,
	  0x16, 0x00, 0x10, 0xEC, 0x07, 0x10, 0x20, 0x00,
	  0x06, 0x0F, 0x0F, 0x33, 0x0E, 0x1C, 0x2A, 0x38,
	  0x46, 0x54, 0x62, 0x69, 0x70, 0x77, 0x79, 0x7B,
	  0x7D, 0x7E, 0x01, 0xC2, 0x22, 0x00, 0x2A, 0x40,
	  0x32, 0xBE, 0x3A, 0xFC, 0x3A, 0xFA, 0x3A, 0xF8,
	  0x3B, 0x38, 0x3B, 0x78, 0x3B, 0x76, 0x4B, 0xB6,
	  0x4B, 0xB6, 0x4B, 0xF4, 0x5B, 0xF4, 0x7C, 0x34} },
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* lane control */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xc4, 1, {0x02} },	/* 8 lanes/panel */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	{REGFLAG_DELAY, 25, {} },
	{0x00, 0, {} },
	/* refresh rate setting */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x50} },
	{0xc3, 1, {0x00} },	/* frame rate = 120Hz */
	{0xf7, 1, {0x02} },
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* sleep out */
	{0x11, 0, {} },
	/* hs settle time control */
	{REGFLAG_DELAY, 25, {} },
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xe8, 4,
	 {0x64, 0x88, 0x00, 0x14} },	/* settle time > 1.45Gbps/lane */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	{REGFLAG_DELAY, 225, {} },
	/* brightness control */
	{0x53, 1, {0x28} },
	{0x51, 2,
	 {0xff, 0x03} },
	/* sdc ip off */
	{0x80, 1, {0x00} },
	/* color coding select */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x08} },
	{0xf2, 1, {0x00} },	/* dsc on */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* send rgb data at least 1 frame */
	/* end with short packet - nop */
	{0x00, 0, {} }
};

/**
 * @brief This is SIE panel init parameter for dsc enable.
 * resolution 4000*2040, RGB101010, 1/2 compression.
 */
static const struct lcm_setting_table init_setting_ams336rp01_4[] = {
	/* reset deasserted */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0x01, 0, {} },
	{REGFLAG_DELAY, 7, {} },
	{0x9d, 1, {0x01} },
	/* dsc setting if dsc on*/
	/* 88 parameters for pps setting */
	{0x9e, 88,		/* 8 lanes/panel, 10bpc/15bpp, slice h=102 */
	 {0x11, 0x00, 0x00, 0xAB, 0x30, 0xF0, 0x07, 0xF8,
	  0x03, 0xE8, 0x00, 0x66, 0x03, 0xE8, 0x07, 0x53,
	  0x01, 0x11, 0x02, 0xE8, 0x00, 0x0A, 0x06, 0x4B,
	  0x00, 0xA7, 0x00, 0x0F, 0x01, 0x31, 0x01, 0x80,
	  0x08, 0x00, 0x10, 0xF1, 0x07, 0x10, 0x20, 0x00,
	  0x06, 0x0F, 0x0F, 0x33, 0x0E, 0x1C, 0x2A, 0x38,
	  0x46, 0x54, 0x62, 0x69, 0x70, 0x77, 0x79, 0x7B,
	  0x7D, 0x7E, 0x00, 0x8A, 0x11, 0x48, 0x19, 0x46,
	  0x21, 0x84, 0x29, 0x82, 0x29, 0xC0, 0x29, 0xFE,
	  0x32, 0x3C, 0x32, 0x7A, 0x3A, 0x78, 0x42, 0xB6,
	  0x42, 0xF6, 0x4A, 0xF4, 0x5B, 0x34, 0x63, 0x74} },
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* lane control */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xc4, 1, {0x02} },	/* 8 lanes/panel */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	{REGFLAG_DELAY, 25, {} },
	{0x00, 0, {} },
	/* refresh rate setting */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x50} },
	{0xc3, 1, {0x00} },	/* frame rate = 120Hz */
	{0xf7, 1, {0x02} },
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* sleep out */
	{0x11, 0, {} },
	/* hs settle time control */
	{REGFLAG_DELAY, 25, {} },
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xe8, 4,
	 {0x64, 0x88, 0x00, 0x14} },	/* settle time > 1.45Gbps/lane */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	{REGFLAG_DELAY, 225, {} },
	/* brightness control */
	{0x53, 1, {0x28} },
	{0x51, 2,
	 {0xff, 0x03} },
	/* sdc ip off */
	{0x80, 1, {0x00} },
	/* color coding select */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x08} },
	{0xf2, 1, {0x00} },	/* dsc on */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* send rgb data at least 1 frame */
	/* end with short packet - nop */
	{0x00, 0, {} }
};

/**
 * @brief This is SIE panel init parameter for dsc enable.
 * resolution 3840*2160, RGB888, 1/3 compression.
 */
static const struct lcm_setting_table init_setting_ams336rp01_5[] = {
	/* reset deasserted */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0x01, 0, {} },
	{REGFLAG_DELAY, 7, {} },
	{0x9d, 1, {0x01} },
	/* dsc setting if dsc on*/
	/* 88 parameters for pps setting */
	{0x9e, 88,		/* 8 lanes/panel, 8bpc/8bpp, slice h=144 */
	 {0x11, 0x00, 0x00, 0x89, 0x30, 0x80, 0x08, 0x70,
	  0x03, 0xC0, 0x00, 0x90, 0x03, 0xC0, 0x03, 0xC0,
	  0x02, 0x00, 0x03, 0x58, 0x00, 0x20, 0x0F, 0xA1,
	  0x00, 0x0D, 0x00, 0x0F, 0x00, 0xD7, 0x00, 0x66,
	  0x18, 0x00, 0x10, 0xF0, 0x03, 0x0C, 0x20, 0x00,
	  0x06, 0x0B, 0x0B, 0x33, 0x0E, 0x1C, 0x2A, 0x38,
	  0x46, 0x54, 0x62, 0x69, 0x70, 0x77, 0x79, 0x7B,
	  0x7D, 0x7E, 0x01, 0x02, 0x01, 0x00, 0x09, 0x40,
	  0x09, 0xBE, 0x19, 0xFC, 0x19, 0xFA, 0x19, 0xF8,
	  0x1A, 0x38, 0x1A, 0x78, 0x1A, 0xB6, 0x2A, 0xB6,
	  0x2A, 0xF4, 0x2A, 0xF4, 0x4B, 0x34, 0x63, 0x74} },
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* lane control */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xc4, 1, {0x02} },	/* 8 lanes/panel */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	{REGFLAG_DELAY, 25, {} },
	{0x00, 0, {} },
	/* refresh rate setting */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x50} },
	{0xc3, 1, {0x00} },	/* frame rate = 120Hz */
	{0xf7, 1, {0x02} },
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* sleep out */
	{0x11, 0, {} },
	/* hs settle time control */
	{REGFLAG_DELAY, 25, {} },
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xe8, 4,
	 {0x64, 0x88, 0x00, 0x14} },	/* settle time > 1.45Gbps/lane */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	{REGFLAG_DELAY, 225, {} },
	/* brightness control */
	{0x53, 1, {0x28} },
	{0x51, 2,
	 {0xff, 0x03} },
	/* sdc ip off */
	{0x80, 1, {0x00} },
	/* 8 bit enable control */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x2e} },
	{0xeb, 1, {0x05} },	/* 8 bit enable on */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* color coding select */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x08} },
	{0xf2, 1, {0x00} },	/* dsc on */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* send rgb data at least 1 frame */
	/* end with short packet - nop */
	{0x00, 0, {} }
};

/**
 * @brief This is SIE panel init parameter for dsc enable.
 * resolution 3840*2160, RGB101010, 1/3 compression.
 */
static const struct lcm_setting_table init_setting_ams336rp01_6[] = {
	/* reset deasserted */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0x01, 0, {} },
	{REGFLAG_DELAY, 7, {} },
	{0x9d, 1, {0x01} },
	/* dsc setting if dsc on*/
	/* 88 parameters for pps setting */
	{0x9e, 88,		/* 8 lanes/panel, 10bpc/10bpp, slice h=144 */
	 {0x11, 0x00, 0x00, 0xAB, 0x30, 0xA0, 0x08, 0x70,
	  0x03, 0xC0, 0x00, 0x90, 0x03, 0xC0, 0x04, 0xB0,
	  0x01, 0x9A, 0x02, 0xE0, 0x00, 0x19, 0x0E, 0x8F,
	  0x00, 0x12, 0x00, 0x0F, 0x00, 0xD7, 0x00, 0x7D,
	  0x16, 0x00, 0x10, 0xEC, 0x07, 0x10, 0x20, 0x00,
	  0x06, 0x0F, 0x0F, 0x33, 0x0E, 0x1C, 0x2A, 0x38,
	  0x46, 0x54, 0x62, 0x69, 0x70, 0x77, 0x79, 0x7B,
	  0x7D, 0x7E, 0x01, 0xC2, 0x22, 0x00, 0x2A, 0x40,
	  0x32, 0xBE, 0x3A, 0xFC, 0x3A, 0xFA, 0x3A, 0xF8,
	  0x3B, 0x38, 0x3B, 0x78, 0x3B, 0x76, 0x4B, 0xB6,
	  0x4B, 0xB6, 0x4B, 0xF4, 0x5B, 0xF4, 0x7C, 0x34} },
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* lane control */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xc4, 1, {0x02} },	/* 8 lanes/panel */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	{REGFLAG_DELAY, 25, {} },
	{0x00, 0, {} },
	/* refresh rate setting */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x50} },
	{0xc3, 1, {0x00} },	/* frame rate = 120Hz */
	{0xf7, 1, {0x02} },
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* sleep out */
	{0x11, 0, {} },
	/* hs settle time control */
	{REGFLAG_DELAY, 25, {} },
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xe8, 4,
	 {0x64, 0x88, 0x00, 0x14} },	/* settle time > 1.45Gbps/lane */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	{REGFLAG_DELAY, 225, {} },
	/* brightness control */
	{0x53, 1, {0x28} },
	{0x51, 2,
	 {0xff, 0x03} },
	/* sdc ip off */
	{0x80, 1, {0x00} },
	/* color coding select */
	{0xf0, 2,
	 {0x5a, 0x5a} },
	{0xb0, 1, {0x08} },
	{0xf2, 1, {0x00} },	/* dsc on */
	{0xf0, 2,
	 {0xa5, 0xa5} },
	/* send rgb data at least 1 frame */
	/* end with short packet - nop */
	{0x00, 0, {} }
};

/**
 * @brief This is SIE panel init parameter for RGB888 and dsc disable.
 */
static const struct lcm_setting_table ams336rp01_rgb8_without_dsc[] = {
	/* refresh rate setting */
	{0xf0, 3,
	 {0xf0, 0x5a, 0x5a} },
	{0xb0, 1, {0x50} },
	{0xc3, 1, {0x00} },	/* frame rate = 120Hz */
	{0xf7, 1, {0x02} },
	{0xf0, 3,
	 {0xf0, 0xa5, 0xa5} },
	/* sleep out */
	{0x11, 0, {} },
	/* hs settle time control */
	{REGFLAG_DELAY, 25, {} },
	{0xf0, 3,
	 {0xf0, 0x5a, 0x5a} },
	{0xe8, 5,
	 {0xe8, 0x64, 0x88, 0x00, 0x14} },
	{0xf0, 3,
	 {0xf0, 0xa5, 0xa5} },
	{REGFLAG_DELAY, 225, {} },
	/* brightness control */
	{0x53, 1, {0x28} },
	{0x51, 3,
	 {0x51, 0xff, 0x03} },
	/* sdc ip off */
	{0x80, 1, {0x00} },
	/* 8 bit enable control */
	{0xf0, 3,
	 {0xf0, 0x5a, 0x5a} },
	{0xb0, 1, {0x2e} },
	{0xeb, 1, {0x05} },	/* 8 bit enable on */
	{0xf0, 3,
	 {0xf0, 0xa5, 0xa5} },
	/* color coding select */
	{0xf0, 3,
	 {0xf0, 0x5a, 0x5a} },
	{0xb0, 1, {0x08} },
	{0xf2, 1, {0x40} },	/* 8 bit mode */
	{0xf0, 3,
	 {0xf0, 0xa5, 0xa5} },
	/* send rgb data at least 1 frame */
	/* end with short packet - nop */
	{0x00, 0, {} }
};

/**
 * @brief This is SIE panel init parameter for RGB888 and dsc enable.
 */
static const struct lcm_setting_table ams336rp01_rgb8_with_dsc[] = {
	/* refresh rate setting */
	{0xf0, 3,
	 {0xf0, 0x5a, 0x5a} },
	{0xb0, 1, {0x50} },
	{0xc3, 1, {0x00} },	/* frame rate = 120Hz */
	{0xf7, 1, {0x02} },
	{0xf0, 3,
	 {0xf0, 0xa5, 0xa5} },
	/* sleep out */
	{0x11, 0, {} },
	/* hs settle time control */
	{REGFLAG_DELAY, 25, {} },
	{0xf0, 3,
	 {0xf0, 0x5a, 0x5a} },
	{0xe8, 5,
	 {0xe8, 0x64, 0x88, 0x00, 0x14} },
	{0xf0, 3,
	 {0xf0, 0xa5, 0xa5} },
	{REGFLAG_DELAY, 225, {} },
	/* brightness control */
	{0x53, 1, {0x28} },
	{0x51, 3,
	 {0x51, 0xff, 0x03} },
	/* sdc ip off */
	{0x80, 1, {0x00} },
	/* 8 bit enable control */
	{0xf0, 3,
	 {0xf0, 0x5a, 0x5a} },
	{0xb0, 1, {0x2e} },
	{0xeb, 1, {0x05} },	/* 8 bit enable on */
	{0xf0, 3,
	 {0xf0, 0xa5, 0xa5} },
	/* color coding select */
	{0xf0, 3,
	 {0xf0, 0x5a, 0x5a} },
	{0xb0, 1, {0x08} },
	{0xf2, 1, {0x00} },	/* dsc on */
	{0xf0, 3,
	 {0xf0, 0xa5, 0xa5} },
	/* send rgb data at least 1 frame */
	/* end with short packet - nop */
	{0x00, 0, {} }
};

/**
 * @brief This is SIE panel init parameter for RGB101010 and dsc enable.
 */
static const struct lcm_setting_table ams336rp01_rgb10_with_dsc[] = {
	/* refresh rate setting */
	{0xf0, 3,
	 {0xf0, 0x5a, 0x5a} },
	{0xb0, 1, {0x50} },
	{0xc3, 1, {0x00} },	/* frame rate = 120Hz */
	{0xf7, 1, {0x02} },
	{0xf0, 3,
	 {0xf0, 0xa5, 0xa5} },
	/* sleep out */
	{0x11, 0, {} },
	/* hs settle time control */
	{REGFLAG_DELAY, 25, {} },
	{0xf0, 3,
	 {0xf0, 0x5a, 0x5a} },
	{0xe8, 5,
	 {0xe8, 0x64, 0x88, 0x00, 0x14} },
	{0xf0, 3,
	 {0xf0, 0xa5, 0xa5} },
	{REGFLAG_DELAY, 225, {} },
	/* brightness control */
	{0x53, 1, {0x28} },
	{0x51, 3,
	 {0x51, 0xff, 0x03} },
	/* sdc ip off */
	{0x80, 1, {0x00} },
	/* color coding select */
	{0xf0, 3,
	 {0xf0, 0x5a, 0x5a} },
	{0xb0, 1, {0x08} },
	{0xf2, 1, {0x00} },	/* dsc on */
	{0xf0, 3,
	 {0xf0, 0xa5, 0xa5} },
	/* send rgb data at least 1 frame */
	/* end with short packet - nop */
	{0x00, 0, {} }
};

/**
 * @brief This is panel lane setting parameter.
 */
static const struct lcm_setting_table lane_setting[] = {
	{0xba, 1, {0x03} }, /* 4 lanes */
	{0xba, 1, {0x03} }, /* 4 lanes, no supoort 1 lane */
	{0xba, 1, {0x01} }, /* 2 lanes */
	{0xba, 1, {0x02} }, /* 3 lanes */
	{0xba, 1, {0x03} }  /* 4 lanes */
};

/** @ingroup IP_group_dsi_internal_function_panel
 * @par Description
 *     This function is used to send panel init parameter to panel.
 * @param[in] dsi: dsi driver data struct
 * @param[in] table: panel init patameter table
 * @param[in] count: number of init patameter
 * @return none
 * @par Boundary case and Limitation
 *     none
 * @par Error case and Error handling
 *     none
 * @par Call graph and Caller graph (refer to the graph below)
 * @par Refer to the source code
 */
void push_table(const struct mtk_dsi *dsi,
		const struct lcm_setting_table *table, unsigned int count)
{
	unsigned int i;
	unsigned int cmd;

	for (i = 0; i < count; i++) {
		cmd = table[i].cmd;

		switch (cmd) {
		case REGFLAG_DELAY:
			if (table[i].count <= 10)
				mdelay(table[i].count);
			else
				mdelay(table[i].count);
			break;

		case REGFLAG_UDELAY:
			udelay(table[i].count);
			break;

		case REGFLAG_END_OF_TABLE:
			break;

		default:
			mtk_dsi_host_write_cmd(dsi, cmd, table[i].count,
					       table[i].para_list);
		}
	}
}

/** @ingroup IP_group_dsi_internal_function_panel
 * @par Description
 *     This function is used to send init parameter to panel by vm cmd mode.
 * @param[in] dsi: dsi driver data struct
 * @param[in] table: panel init patameter table
 * @param[in] count: number of init patameter
 * @return none
 * @par Boundary case and Limitation
 *     none
 * @par Error case and Error handling
 *     none
 * @par Call graph and Caller graph (refer to the graph below)
 * @par Refer to the source code
 */
void push_table2(const struct mtk_dsi *dsi,
		 const struct lcm_setting_table *table, unsigned int count)
{
	unsigned int i;
	unsigned int cmd;

	for (i = 0; i < count; i++) {
		cmd = table[i].cmd;

		switch (cmd) {
		case REGFLAG_DELAY:
			if (table[i].count <= 10)
				mdelay(table[i].count);
			else
				mdelay(table[i].count);
			break;

		case REGFLAG_UDELAY:
			udelay(table[i].count);
			break;

		case REGFLAG_END_OF_TABLE:
			break;

		default:
			if (table[i].count > 1) {
				mtk_dsi_send_vm_cmd(
						dsi->dev,
						MIPI_DSI_DCS_LONG_WRITE,
						table[i].count,
						0,
						table[i].para_list);
			} else if (table[i].count == 1) {
				mtk_dsi_send_vm_cmd(
						dsi->dev,
						MIPI_DSI_DCS_SHORT_WRITE_PARAM,
						cmd,
						(u8)table[i].para_list[0],
						NULL);
			} else {
				mtk_dsi_send_vm_cmd(
						dsi->dev,
						MIPI_DSI_DCS_SHORT_WRITE,
						cmd,
						0,
						NULL);
			}
			break;
		}
	}
}

/** @ingroup IP_group_dsi_internal_function_panel
 * @par Description
 *     LCM initial function.
 * @param[in] dsi: dsi driver data struct
 * @return none
 * @par Boundary case and Limitation
 *     none
 * @par Error case and Error handling
 *     none
 * @par Call graph and Caller graph (refer to the graph below)
 * @par Refer to the source code
 */
void lcm_init(const struct mtk_dsi *dsi)
{
	pr_info("lcm_init, panel_sel=%d\n", dsi->panel_sel);
	if (dsi->panel_sel == MTK_LCM_35595) {
		if (dsi->lanes <= 4)
			mtk_dsi_host_write_cmd(
					dsi,
					lane_setting[dsi->lanes].cmd,
					lane_setting[dsi->lanes].count,
					lane_setting[dsi->lanes].para_list);

		push_table(
		    dsi,
		    init_setting,
		    sizeof(init_setting) / sizeof(struct lcm_setting_table));
	} else if (dsi->panel_sel == MTK_LCM_35695B) {
		push_table(
		    dsi,
		    init_setting_nt35695B_fhd_vdo_auo,
		    sizeof(init_setting_nt35695B_fhd_vdo_auo) /
		    sizeof(struct lcm_setting_table));
	} else if (dsi->panel_sel == MTK_LCM_RGB888) {
		push_table(
		    dsi,
		    init_setting_ams336rp01_0, 10);
	} else if (dsi->panel_sel == MTK_LCM_COMPRESSION_24_8) {
		push_table(
		    dsi,
		    init_setting_ams336rp01_1, 11);
	} else if (dsi->panel_sel == MTK_LCM_COMPRESSION_24_12) {
		push_table(
		    dsi,
		    init_setting_ams336rp01_2, 11);
	} else if (dsi->panel_sel == MTK_LCM_COMPRESSION_30_10) {
		push_table(
		    dsi,
		    init_setting_ams336rp01_3, 11);
	} else if (dsi->panel_sel == MTK_LCM_COMPRESSION_30_15) {
		push_table(
		    dsi,
		    init_setting_ams336rp01_4, 11);
	} else if (dsi->panel_sel == MTK_LCM_3840_DSC_24_8) {
		push_table(
		    dsi,
		    init_setting_ams336rp01_5, 11);
	} else if (dsi->panel_sel == MTK_LCM_3840_DSC_30_10) {
		push_table(
		    dsi,
		    init_setting_ams336rp01_6, 11);
	}
}

/** @ingroup IP_group_dsi_internal_function_panel
 * @par Description
 *     LCM initial function by vm cmd mode.
 * @param[in] dsi: dsi driver data struct
 * @return none
 * @par Boundary case and Limitation
 *     none
 * @par Error case and Error handling
 *     none
 * @par Call graph and Caller graph (refer to the graph below)
 * @par Refer to the source code
 */
void lcm_init2(const struct mtk_dsi *dsi)
{
	if (dsi->panel_sel == MTK_LCM_35595) {
	} else if (dsi->panel_sel == MTK_LCM_35695B) {
	} else if (dsi->panel_sel == MTK_LCM_RGB888) {
		push_table2(
		    dsi,
		    ams336rp01_rgb8_without_dsc,
		    sizeof(ams336rp01_rgb8_without_dsc) /
		    sizeof(struct lcm_setting_table));
	} else if (dsi->panel_sel == MTK_LCM_COMPRESSION_24_8) {
		push_table2(
		    dsi,
		    ams336rp01_rgb8_with_dsc,
		    sizeof(ams336rp01_rgb8_with_dsc) /
		    sizeof(struct lcm_setting_table));
	} else if (dsi->panel_sel == MTK_LCM_COMPRESSION_24_12) {
		push_table2(
		    dsi,
		    ams336rp01_rgb8_with_dsc,
		    sizeof(ams336rp01_rgb8_with_dsc) /
		    sizeof(struct lcm_setting_table));
	} else if (dsi->panel_sel == MTK_LCM_COMPRESSION_30_10) {
		push_table2(
		    dsi,
		    ams336rp01_rgb10_with_dsc,
		    sizeof(ams336rp01_rgb10_with_dsc) /
		    sizeof(struct lcm_setting_table));
	} else if (dsi->panel_sel == MTK_LCM_COMPRESSION_30_15) {
		push_table2(
		    dsi,
		    ams336rp01_rgb10_with_dsc,
		    sizeof(ams336rp01_rgb10_with_dsc) /
		    sizeof(struct lcm_setting_table));
	} else if (dsi->panel_sel == MTK_LCM_3840_DSC_24_8) {
		push_table2(
		    dsi,
		    ams336rp01_rgb8_with_dsc,
		    sizeof(ams336rp01_rgb8_with_dsc) /
		    sizeof(struct lcm_setting_table));
	} else if (dsi->panel_sel == MTK_LCM_3840_DSC_30_10) {
		push_table2(
		    dsi,
		    ams336rp01_rgb10_with_dsc,
		    sizeof(ams336rp01_rgb10_with_dsc) /
		    sizeof(struct lcm_setting_table));
	}
}

/** @ingroup IP_group_dsi_internal_function_panel
 * @par Description
 *     Get LCM parameter function.\n
 *     DSI Driver will call this function to get lcm parameter, \n
 *     include lcm height, width, blanking information, support pixel format...
 * @param[in,out] dsi: dsi driver data struct
 * @return none
 * @par Boundary case and Limitation
 *     Call this function to get panel parameter before setting dsi hw.
 * @par Error case and Error handling
 *     none
 * @par Call graph and Caller graph (refer to the graph below)
 * @par Refer to the source code
 */
void lcm_get_params(struct mtk_dsi *dsi)
{
	if (dsi->panel_sel == MTK_LCM_35595) {
		dsi->mode_flags = MIPI_DSI_MODE_VIDEO |
				  MIPI_DSI_MODE_VIDEO_SYNC_PULSE |
				  MIPI_DSI_MODE_EOT_PACKET;
		dsi->format = MTK_DSI_FMT_RGB888;
		if (dsi->lanes < 2)
			dsi->lanes = 2;

		dsi->max_fps = 60;

		dsi->vm.hactive = 1080;
		dsi->vm.vactive = 1920;
		dsi->vm.vsync_len = 5;
		dsi->vm.vback_porch = 5;
		dsi->vm.vfront_porch = 5;
		dsi->vm.hsync_len = 0x1a;
		dsi->vm.hback_porch = 0x94;
		dsi->vm.hfront_porch = 0x94;

		dsi->dsc_cfg.pic_format = dsi->format;
		dsi->dsc_cfg.slice_h = 16;
		dsi->dsc_cfg.version = DSC_V1P2;
		dsi->dsc_cfg.ich_line_clear = 0;
		if (dsi->hw_nr == 2)
			dsi->dsc_cfg.inout_sel = DSC_2_IN_1_OUT;
		else
			dsi->dsc_cfg.inout_sel = DSC_2_IN_2_OUT;
	} else if (dsi->panel_sel == MTK_LCM_35695B) {
		dsi->mode_flags = MIPI_DSI_MODE_VIDEO |
				  MIPI_DSI_MODE_VIDEO_SYNC_PULSE |
				  MIPI_DSI_MODE_EOT_PACKET;
		dsi->format = MTK_DSI_FMT_RGB888;

		dsi->max_fps = 60;

		dsi->vm.hactive = 1080;
		dsi->vm.vactive = 1920;
		dsi->vm.vsync_len = 2;
		dsi->vm.vback_porch = 6;
		dsi->vm.vfront_porch = 8;
		dsi->vm.hsync_len = 0x1a;
		dsi->vm.hback_porch = 0x1a;
		dsi->vm.hfront_porch = 0x40;

		dsi->dsc_cfg.pic_format = dsi->format;
		dsi->dsc_cfg.slice_h = 16;
		dsi->dsc_cfg.version = DSC_V1P2;
		dsi->dsc_cfg.ich_line_clear = 0;
		if (dsi->hw_nr == 2)
			dsi->dsc_cfg.inout_sel = DSC_2_IN_1_OUT;
		else
			dsi->dsc_cfg.inout_sel = DSC_2_IN_2_OUT;
	} else if (dsi->panel_sel == MTK_LCM_RGB888) {
		dsi->mode_flags = MIPI_DSI_MODE_VIDEO;
		dsi->format = MTK_DSI_FMT_RGB888;

		dsi->max_fps = 120;

		dsi->vm.hactive = 1000;
		dsi->vm.vactive = 2040;
		dsi->vm.vsync_len = 1;
		dsi->vm.vback_porch = 151;
		dsi->vm.vfront_porch = 8;
		dsi->vm.hsync_len = 22;		/* HSW > 70ns  */
		dsi->vm.hback_porch = 38;	/* HBP > 110ns */
		dsi->vm.hfront_porch = 292;	/* HFP > 250ns */

		dsi->dsc_cfg.pic_format = dsi->format;
		dsi->dsc_cfg.slice_h = 102;
		dsi->dsc_cfg.version = DSC_V1P1;
		dsi->dsc_cfg.ich_line_clear = 1;
		if (dsi->hw_nr == 2)
			dsi->dsc_cfg.inout_sel = DSC_2_IN_1_OUT;
		else
			dsi->dsc_cfg.inout_sel = DSC_2_IN_2_OUT;
	} else if (dsi->panel_sel == MTK_LCM_COMPRESSION_24_8) {
		dsi->mode_flags = MIPI_DSI_MODE_VIDEO;
		dsi->format = MTK_DSI_FMT_COMPRESSION_24_8;

		dsi->max_fps = 120;

		dsi->vm.hactive = 1000;
		dsi->vm.vactive = 2040;
		dsi->vm.vsync_len = 1;
		dsi->vm.vback_porch = 151;
		dsi->vm.vfront_porch = 8;
		dsi->vm.hsync_len = 22;		/* HSW > 70ns  */
		dsi->vm.hback_porch = 38;	/* HBP > 110ns */
		dsi->vm.hfront_porch = 970;	/* HFP > 250ns */

		dsi->dsc_cfg.pic_format = dsi->format;
		dsi->dsc_cfg.slice_h = 102;
		dsi->dsc_cfg.version = DSC_V1P1;
		dsi->dsc_cfg.ich_line_clear = 1;
		if (dsi->hw_nr == 2)
			dsi->dsc_cfg.inout_sel = DSC_2_IN_1_OUT;
		else
			dsi->dsc_cfg.inout_sel = DSC_2_IN_2_OUT;
	} else if (dsi->panel_sel == MTK_LCM_COMPRESSION_24_12) {
		dsi->mode_flags = MIPI_DSI_MODE_VIDEO;
		dsi->format = MTK_DSI_FMT_COMPRESSION_24_12;

		dsi->max_fps = 120;

		dsi->vm.hactive = 1000;
		dsi->vm.vactive = 2040;
		dsi->vm.vsync_len = 1;
		dsi->vm.vback_porch = 151;
		dsi->vm.vfront_porch = 8;
		dsi->vm.hsync_len = 22;		/* HSW > 70ns  */
		dsi->vm.hback_porch = 38;	/* HBP > 110ns */
		dsi->vm.hfront_porch = 900;	/* HFP > 250ns */

		dsi->dsc_cfg.pic_format = dsi->format;
		dsi->dsc_cfg.slice_h = 102;
		dsi->dsc_cfg.version = DSC_V1P1;
		dsi->dsc_cfg.ich_line_clear = 1;
		if (dsi->hw_nr == 2)
			dsi->dsc_cfg.inout_sel = DSC_2_IN_1_OUT;
		else
			dsi->dsc_cfg.inout_sel = DSC_2_IN_2_OUT;
	} else if (dsi->panel_sel == MTK_LCM_COMPRESSION_30_10) {
		dsi->mode_flags = MIPI_DSI_MODE_VIDEO;
		dsi->format = MTK_DSI_FMT_COMPRESSION_30_10;

		dsi->max_fps = 120;

		dsi->vm.hactive = 1000;
		dsi->vm.vactive = 2040;
		dsi->vm.vsync_len = 1;
		dsi->vm.vback_porch = 151;
		dsi->vm.vfront_porch = 8;
		dsi->vm.hsync_len = 22;		/* HSW > 70ns  */
		dsi->vm.hback_porch = 38;	/* HBP > 110ns */
		dsi->vm.hfront_porch = 850;	/* HFP > 250ns */

		dsi->dsc_cfg.pic_format = dsi->format;
		dsi->dsc_cfg.slice_h = 102;
		dsi->dsc_cfg.version = DSC_V1P1;
		dsi->dsc_cfg.ich_line_clear = 1;
		if (dsi->hw_nr == 2)
			dsi->dsc_cfg.inout_sel = DSC_2_IN_1_OUT;
		else
			dsi->dsc_cfg.inout_sel = DSC_2_IN_2_OUT;
	} else if (dsi->panel_sel == MTK_LCM_COMPRESSION_30_15) {
		dsi->mode_flags = MIPI_DSI_MODE_VIDEO;
		dsi->format = MTK_DSI_FMT_COMPRESSION_30_15;

		dsi->max_fps = 120;

		dsi->vm.hactive = 1000;
		dsi->vm.vactive = 2040;
		dsi->vm.vsync_len = 1;
		dsi->vm.vback_porch = 151;
		dsi->vm.vfront_porch = 8;
		dsi->vm.hsync_len = 22;		/* HSW > 70ns  */
		dsi->vm.hback_porch = 38;	/* HBP > 110ns */
		dsi->vm.hfront_porch = 700;	/* HFP > 250ns */

		dsi->dsc_cfg.pic_format = dsi->format;
		dsi->dsc_cfg.slice_h = 102;
		dsi->dsc_cfg.version = DSC_V1P1;
		dsi->dsc_cfg.ich_line_clear = 1;
		if (dsi->hw_nr == 2)
			dsi->dsc_cfg.inout_sel = DSC_2_IN_1_OUT;
		else
			dsi->dsc_cfg.inout_sel = DSC_2_IN_2_OUT;
	} else if (dsi->panel_sel == MTK_LCM_3840_DSC_24_8) {
		dsi->mode_flags = MIPI_DSI_MODE_VIDEO;
		dsi->format = MTK_DSI_FMT_COMPRESSION_24_8;

		dsi->max_fps = 120;

		dsi->vm.hactive = 960;
		dsi->vm.vactive = 2160;
		dsi->vm.vsync_len = 1;
		dsi->vm.vback_porch = 79;
		dsi->vm.vfront_porch = 10;
		dsi->vm.hsync_len = 22;		/* HSW > 70ns  */
		dsi->vm.hback_porch = 38;	/* HBP > 110ns */
		dsi->vm.hfront_porch = 970;	/* HFP > 250ns */

		dsi->dsc_cfg.pic_format = dsi->format;
		dsi->dsc_cfg.slice_h = 144;
		dsi->dsc_cfg.version = DSC_V1P1;
		dsi->dsc_cfg.ich_line_clear = 1;
		if (dsi->hw_nr == 2)
			dsi->dsc_cfg.inout_sel = DSC_2_IN_1_OUT;
		else
			dsi->dsc_cfg.inout_sel = DSC_2_IN_2_OUT;
	} else if (dsi->panel_sel == MTK_LCM_3840_DSC_30_10) {
		dsi->mode_flags = MIPI_DSI_MODE_VIDEO;
		dsi->format = MTK_DSI_FMT_COMPRESSION_30_10;

		dsi->max_fps = 120;

		dsi->vm.hactive = 960;
		dsi->vm.vactive = 2160;
		dsi->vm.vsync_len = 1;
		dsi->vm.vback_porch = 79;
		dsi->vm.vfront_porch = 10;
		dsi->vm.hsync_len = 22;		/* HSW > 70ns  */
		dsi->vm.hback_porch = 38;	/* HBP > 110ns */
		dsi->vm.hfront_porch = 850;	/* HFP > 250ns */

		dsi->dsc_cfg.pic_format = dsi->format;
		dsi->dsc_cfg.slice_h = 144;
		dsi->dsc_cfg.version = DSC_V1P1;
		dsi->dsc_cfg.ich_line_clear = 1;
		if (dsi->hw_nr == 2)
			dsi->dsc_cfg.inout_sel = DSC_2_IN_1_OUT;
		else
			dsi->dsc_cfg.inout_sel = DSC_2_IN_2_OUT;
	}
}
