/*
 * Copyright (c) 2017 MediaTek Inc.
 * Author: Andrew-sh.Cheng, MediaTek
 *
 * This	program	is free	software; you can redistribute it and/or modify
 * it under the	terms of the GNU General Public License version 2 as
 * published by	the Free Software Foundation.
 *
 * This	program	is distributed in the hope that	it will	be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __MFD_MT3615_REGISTERS_H__
#define __MFD_MT3615_REGISTERS_H__

#define REG_BASE (0x0000)
#define pmic_uint unsigned int
#define MT3615_HWCID				((pmic_uint)(REG_BASE+0x8))
#define MT3615_SWCID				((pmic_uint)(REG_BASE+0xa))
#define MT3615_TOP_CKPDN_CON0			((pmic_uint)(REG_BASE+0x10c))
#define MT3615_TOP_CKPDN_CON0_SET		((pmic_uint)(REG_BASE+0x10e))
#define MT3615_TOP_CKPDN_CON0_CLR		((pmic_uint)(REG_BASE+0x110))
#define MT3615_TOP2_ELR1				((pmic_uint)(REG_BASE+0x154))
#define MT3615_PMIC_MEM_0			((pmic_uint)(REG_BASE+0x208))
#define MT3615_PSEQ2_W1C_STATUS0		((pmic_uint)(REG_BASE+0x888))
#define MT3615_PSEQ2_W1C_STATUS1		((pmic_uint)(REG_BASE+0x88a))
#define MT3615_PSEQ2_W1C_STATUS2		((pmic_uint)(REG_BASE+0x88c))
#define MT3615_PSEQ2_RO_STATUS			((pmic_uint)(REG_BASE+0x88e))
#define MT3615_PSEQ2_CON0			((pmic_uint)(REG_BASE+0x890))
#define MT3615_PSEQ2_CON1			((pmic_uint)(REG_BASE+0x892))
#define MT3615_PSEQ2_CON2			((pmic_uint)(REG_BASE+0x894))
#define MT3615_PSEQ2_CON3			((pmic_uint)(REG_BASE+0x896))
#define MT3615_PSEQ2_ELR0			((pmic_uint)(REG_BASE+0x8a6))
#define MT3615_CPS_GPOCFG_ELR			((pmic_uint)(REG_BASE+0x8a8))
#define MT3615_BUCK_TOP_PAM0			((pmic_uint)(REG_BASE+0xd88))
#define MT3615_BUCK_TOP_PAM1			((pmic_uint)(REG_BASE+0xd8a))
#define MT3615_BUCK_TOP_CLK_CON0		((pmic_uint)(REG_BASE+0xd8c))
#define MT3615_BUCK_TOP_CLK_CON0_SET		((pmic_uint)(REG_BASE+0xd8e))
#define MT3615_BUCK_TOP_CLK_CON0_CLR		((pmic_uint)(REG_BASE+0xd90))
#define MT3615_BUCK_TOP_CLK_HWEN_CON0		((pmic_uint)(REG_BASE+0xd92))
#define MT3615_BUCK_TOP_CLK_HWEN_CON0_SET	((pmic_uint)(REG_BASE+0xd94))
#define MT3615_BUCK_TOP_CLK_HWEN_CON0_CLR	((pmic_uint)(REG_BASE+0xd96))
#define MT3615_BUCK_TOP_INT_STATUS0		((pmic_uint)(REG_BASE+0xda4))
#define MT3615_BUCK_TOP_RSV			((pmic_uint)(REG_BASE+0xda8))
#define MT3615_BUCK_TOP_STB_CON			((pmic_uint)(REG_BASE+0xdaa))
#define MT3615_BUCK_TOP_VGP3_MINFREQ_CON	((pmic_uint)(REG_BASE+0xdac))
#define MT3615_BUCK_TOP_VGP3_MINFREQ_CON1	((pmic_uint)(REG_BASE+0xdae))
#define MT3615_BUCK_TOP_OC_CON0			((pmic_uint)(REG_BASE+0xdb0))
#define MT3615_BUCK_TOP_KEY_PROT		((pmic_uint)(REG_BASE+0xdb2))
#define MT3615_BUCK_TOP_WDTDBG0			((pmic_uint)(REG_BASE+0xdb4))
#define MT3615_BUCK_TOP_WDTDBG1			((pmic_uint)(REG_BASE+0xdb6))
#define MT3615_BUCK_TOP_WDTDBG2			((pmic_uint)(REG_BASE+0xdb8))
#define MT3615_BUCK_TOP_WDTDBG3			((pmic_uint)(REG_BASE+0xdba))
#define MT3615_BUCK_TOP_WDTDBG4			((pmic_uint)(REG_BASE+0xdbc))
#define MT3615_BUCK_TOP_WDTDBG5			((pmic_uint)(REG_BASE+0xdbe))
#define MT3615_BUCK_TOP_WDTDBG6			((pmic_uint)(REG_BASE+0xdc0))
#define MT3615_BUCK_VPROC_CON0			((pmic_uint)(REG_BASE+0xe08))
#define MT3615_BUCK_VPROC_CON0_SET		((pmic_uint)(REG_BASE+0xe0a))
#define MT3615_BUCK_VPROC_CON0_CLR		((pmic_uint)(REG_BASE+0xe0c))
#define MT3615_BUCK_VPROC_CON1			((pmic_uint)(REG_BASE+0xe0e))
#define MT3615_BUCK_VPROC_CFG0			((pmic_uint)(REG_BASE+0xe10))
#define MT3615_BUCK_VPROC_DBG0			((pmic_uint)(REG_BASE+0xe12))
#define MT3615_BUCK_VPROC_DBG1			((pmic_uint)(REG_BASE+0xe14))
#define MT3615_BUCK_VPROC_STALL_TRACK0		((pmic_uint)(REG_BASE+0xe16))
#define MT3615_BUCK_VPROC_ELR0			((pmic_uint)(REG_BASE+0xe1a))
#define MT3615_BUCK_VGPU11_CON0			((pmic_uint)(REG_BASE+0xe88))
#define MT3615_BUCK_VGPU11_CON0_SET		((pmic_uint)(REG_BASE+0xe8a))
#define MT3615_BUCK_VGPU11_CON0_CLR		((pmic_uint)(REG_BASE+0xe8c))
#define MT3615_BUCK_VGPU11_CON1			((pmic_uint)(REG_BASE+0xe8e))
#define MT3615_BUCK_VGPU11_CFG0			((pmic_uint)(REG_BASE+0xe90))
#define MT3615_BUCK_VGPU11_DBG0			((pmic_uint)(REG_BASE+0xe92))
#define MT3615_BUCK_VGPU11_DBG1			((pmic_uint)(REG_BASE+0xe94))
#define MT3615_BUCK_VGPU11_STALL_TRACK0		((pmic_uint)(REG_BASE+0xe96))
#define MT3615_BUCK_VGPU11_ELR0			((pmic_uint)(REG_BASE+0xe9a))
#define MT3615_BUCK_VGPU12_CON0			((pmic_uint)(REG_BASE+0xf08))
#define MT3615_BUCK_VGPU12_CON0_SET		((pmic_uint)(REG_BASE+0xf0a))
#define MT3615_BUCK_VGPU12_CON0_CLR		((pmic_uint)(REG_BASE+0xf0c))
#define MT3615_BUCK_VGPU12_CON1			((pmic_uint)(REG_BASE+0xf0e))
#define MT3615_BUCK_VGPU12_CFG0			((pmic_uint)(REG_BASE+0xf10))
#define MT3615_BUCK_VGPU12_DBG0			((pmic_uint)(REG_BASE+0xf12))
#define MT3615_BUCK_VGPU12_DBG1			((pmic_uint)(REG_BASE+0xf14))
#define MT3615_BUCK_VGPU12_ELR0			((pmic_uint)(REG_BASE+0xf18))
#define MT3615_BUCK_VPU_CON0			((pmic_uint)(REG_BASE+0xf88))
#define MT3615_BUCK_VPU_CON0_SET		((pmic_uint)(REG_BASE+0xf8a))
#define MT3615_BUCK_VPU_CON0_CLR		((pmic_uint)(REG_BASE+0xf8c))
#define MT3615_BUCK_VPU_CON1			((pmic_uint)(REG_BASE+0xf8e))
#define MT3615_BUCK_VPU_CFG0			((pmic_uint)(REG_BASE+0xf90))
#define MT3615_BUCK_VPU_DBG0			((pmic_uint)(REG_BASE+0xf92))
#define MT3615_BUCK_VPU_DBG1			((pmic_uint)(REG_BASE+0xf94))
#define MT3615_BUCK_VPU_STALL_TRACK0		((pmic_uint)(REG_BASE+0xf96))
#define MT3615_BUCK_VPU_ELR0			((pmic_uint)(REG_BASE+0xf9a))
#define MT3615_BUCK_VCORE1_CON0			((pmic_uint)(REG_BASE+0x1008))
#define MT3615_BUCK_VCORE1_CON0_SET		((pmic_uint)(REG_BASE+0x100a))
#define MT3615_BUCK_VCORE1_CON0_CLR		((pmic_uint)(REG_BASE+0x100c))
#define MT3615_BUCK_VCORE1_CON1			((pmic_uint)(REG_BASE+0x100e))
#define MT3615_BUCK_VCORE1_CFG0			((pmic_uint)(REG_BASE+0x1010))
#define MT3615_BUCK_VCORE1_DBG0			((pmic_uint)(REG_BASE+0x1012))
#define MT3615_BUCK_VCORE1_DBG1			((pmic_uint)(REG_BASE+0x1014))
#define MT3615_BUCK_VCORE1_ELR0			((pmic_uint)(REG_BASE+0x1018))
#define MT3615_BUCK_VCORE2_CON0			((pmic_uint)(REG_BASE+0x1088))
#define MT3615_BUCK_VCORE2_CON0_SET		((pmic_uint)(REG_BASE+0x108a))
#define MT3615_BUCK_VCORE2_CON0_CLR		((pmic_uint)(REG_BASE+0x108c))
#define MT3615_BUCK_VCORE2_CON1			((pmic_uint)(REG_BASE+0x108e))
#define MT3615_BUCK_VCORE2_CFG0			((pmic_uint)(REG_BASE+0x1090))
#define MT3615_BUCK_VCORE2_DBG0			((pmic_uint)(REG_BASE+0x1092))
#define MT3615_BUCK_VCORE2_DBG1			((pmic_uint)(REG_BASE+0x1094))
#define MT3615_BUCK_VCORE2_STALL_TRACK0		((pmic_uint)(REG_BASE+0x1096))
#define MT3615_BUCK_VCORE2_ELR0			((pmic_uint)(REG_BASE+0x109a))
#define MT3615_BUCK_VCORE4_CON0			((pmic_uint)(REG_BASE+0x1108))
#define MT3615_BUCK_VCORE4_CON0_SET		((pmic_uint)(REG_BASE+0x110a))
#define MT3615_BUCK_VCORE4_CON0_CLR		((pmic_uint)(REG_BASE+0x110c))
#define MT3615_BUCK_VCORE4_CON1			((pmic_uint)(REG_BASE+0x110e))
#define MT3615_BUCK_VCORE4_CFG0			((pmic_uint)(REG_BASE+0x1110))
#define MT3615_BUCK_VCORE4_DBG0			((pmic_uint)(REG_BASE+0x1112))
#define MT3615_BUCK_VCORE4_DBG1			((pmic_uint)(REG_BASE+0x1114))
#define MT3615_BUCK_VCORE4_ELR0			((pmic_uint)(REG_BASE+0x1118))
#define MT3615_BUCK_VS1_CON0			((pmic_uint)(REG_BASE+0x1188))
#define MT3615_BUCK_VS1_CON0_SET		((pmic_uint)(REG_BASE+0x118a))
#define MT3615_BUCK_VS1_CON0_CLR		((pmic_uint)(REG_BASE+0x118c))
#define MT3615_BUCK_VS1_CON1			((pmic_uint)(REG_BASE+0x118e))
#define MT3615_BUCK_VS1_CFG0			((pmic_uint)(REG_BASE+0x1190))
#define MT3615_BUCK_VS1_DBG0			((pmic_uint)(REG_BASE+0x1192))
#define MT3615_BUCK_VS1_DBG1			((pmic_uint)(REG_BASE+0x1194))
#define MT3615_BUCK_VS1_ELR0			((pmic_uint)(REG_BASE+0x1198))
#define MT3615_BUCK_VS2_CON0			((pmic_uint)(REG_BASE+0x1208))
#define MT3615_BUCK_VS2_CON0_SET		((pmic_uint)(REG_BASE+0x120a))
#define MT3615_BUCK_VS2_CON0_CLR		((pmic_uint)(REG_BASE+0x120c))
#define MT3615_BUCK_VS2_CON1			((pmic_uint)(REG_BASE+0x120e))
#define MT3615_BUCK_VS2_CFG0			((pmic_uint)(REG_BASE+0x1210))
#define MT3615_BUCK_VS2_DBG0			((pmic_uint)(REG_BASE+0x1212))
#define MT3615_BUCK_VS2_DBG1			((pmic_uint)(REG_BASE+0x1214))
#define MT3615_BUCK_VS2_ELR0			((pmic_uint)(REG_BASE+0x1218))
#define MT3615_BUCK_VS3_CON0			((pmic_uint)(REG_BASE+0x1288))
#define MT3615_BUCK_VS3_CON0_SET		((pmic_uint)(REG_BASE+0x128a))
#define MT3615_BUCK_VS3_CON0_CLR		((pmic_uint)(REG_BASE+0x128c))
#define MT3615_BUCK_VS3_CON1			((pmic_uint)(REG_BASE+0x128e))
#define MT3615_BUCK_VS3_CFG0			((pmic_uint)(REG_BASE+0x1290))
#define MT3615_BUCK_VS3_DBG0			((pmic_uint)(REG_BASE+0x1292))
#define MT3615_BUCK_VS3_DBG1			((pmic_uint)(REG_BASE+0x1294))
#define MT3615_BUCK_VS3_ELR0			((pmic_uint)(REG_BASE+0x1298))
#define MT3615_BUCK_VDRAM1_CON0			((pmic_uint)(REG_BASE+0x1308))
#define MT3615_BUCK_VDRAM1_CON0_SET		((pmic_uint)(REG_BASE+0x130a))
#define MT3615_BUCK_VDRAM1_CON0_CLR		((pmic_uint)(REG_BASE+0x130c))
#define MT3615_BUCK_VDRAM1_CON1			((pmic_uint)(REG_BASE+0x130e))
#define MT3615_BUCK_VDRAM1_CFG0			((pmic_uint)(REG_BASE+0x1310))
#define MT3615_BUCK_VDRAM1_DBG0			((pmic_uint)(REG_BASE+0x1312))
#define MT3615_BUCK_VDRAM1_DBG1			((pmic_uint)(REG_BASE+0x1314))
#define MT3615_BUCK_VDRAM1_ELR0			((pmic_uint)(REG_BASE+0x1318))
#define MT3615_BUCK_VDRAM2_CON0			((pmic_uint)(REG_BASE+0x1388))
#define MT3615_BUCK_VDRAM2_CON0_SET		((pmic_uint)(REG_BASE+0x138a))
#define MT3615_BUCK_VDRAM2_CON0_CLR		((pmic_uint)(REG_BASE+0x138c))
#define MT3615_BUCK_VDRAM2_CON1			((pmic_uint)(REG_BASE+0x138e))
#define MT3615_BUCK_VDRAM2_CFG0			((pmic_uint)(REG_BASE+0x1390))
#define MT3615_BUCK_VDRAM2_DBG0			((pmic_uint)(REG_BASE+0x1392))
#define MT3615_BUCK_VDRAM2_DBG1			((pmic_uint)(REG_BASE+0x1394))
#define MT3615_BUCK_VDRAM2_ELR0			((pmic_uint)(REG_BASE+0x1398))
#define MT3615_BUCK_VIO18_CON0			((pmic_uint)(REG_BASE+0x1408))
#define MT3615_BUCK_VIO18_CON0_SET		((pmic_uint)(REG_BASE+0x140a))
#define MT3615_BUCK_VIO18_CON0_CLR		((pmic_uint)(REG_BASE+0x140c))
#define MT3615_BUCK_VIO18_CON1			((pmic_uint)(REG_BASE+0x140e))
#define MT3615_BUCK_VIO18_CFG0			((pmic_uint)(REG_BASE+0x1410))
#define MT3615_BUCK_VIO18_DBG0			((pmic_uint)(REG_BASE+0x1412))
#define MT3615_BUCK_VIO18_DBG1			((pmic_uint)(REG_BASE+0x1414))
#define MT3615_BUCK_VIO18_ELR0			((pmic_uint)(REG_BASE+0x1418))
#define MT3615_BUCK_VIO31_CON0			((pmic_uint)(REG_BASE+0x1488))
#define MT3615_BUCK_VIO31_CON0_SET		((pmic_uint)(REG_BASE+0x148a))
#define MT3615_BUCK_VIO31_CON0_CLR		((pmic_uint)(REG_BASE+0x148c))
#define MT3615_BUCK_VIO31_CON1			((pmic_uint)(REG_BASE+0x148e))
#define MT3615_BUCK_VIO31_CFG0			((pmic_uint)(REG_BASE+0x1490))
#define MT3615_BUCK_VIO31_DBG0			((pmic_uint)(REG_BASE+0x1492))
#define MT3615_BUCK_VIO31_DBG1			((pmic_uint)(REG_BASE+0x1494))
#define MT3615_BUCK_VIO31_ELR0			((pmic_uint)(REG_BASE+0x1498))
#define MT3615_BUCK_ANA0_DSN_REV0		((pmic_uint)(REG_BASE+0x1502))
#define MT3615_SMPS_ANA_CON0			((pmic_uint)(REG_BASE+0x1508))
#define MT3615_VGPUVPROC_ANA_CON0		((pmic_uint)(REG_BASE+0x150a))
#define MT3615_VGPUVPROC_ANA_CON1		((pmic_uint)(REG_BASE+0x150c))
#define MT3615_VGPUVPROC_ANA_CON2		((pmic_uint)(REG_BASE+0x150e))
#define MT3615_VGPUVPROC_ANA_CON3		((pmic_uint)(REG_BASE+0x1510))
#define MT3615_VGPUVPROC_ANA_CON4		((pmic_uint)(REG_BASE+0x1512))
#define MT3615_VGPUVPROC_ANA_CON5		((pmic_uint)(REG_BASE+0x1514))
#define MT3615_VGPUVPROC_ANA_CON6		((pmic_uint)(REG_BASE+0x1516))
#define MT3615_VGPUVPROC_ANA_CON7		((pmic_uint)(REG_BASE+0x1518))
#define MT3615_VGPUVPROC_ANA_CON8		((pmic_uint)(REG_BASE+0x151a))
#define MT3615_VGPUVPROC_ANA_CON9		((pmic_uint)(REG_BASE+0x151c))
#define MT3615_VGPUVPROC_ANA_CON10		((pmic_uint)(REG_BASE+0x151e))
#define MT3615_VGPUVPROC_ANA_CON11		((pmic_uint)(REG_BASE+0x1520))
#define MT3615_VGPUVPROC_ANA_CON12		((pmic_uint)(REG_BASE+0x1522))
#define MT3615_VGPUVPROC_ANA_CON13		((pmic_uint)(REG_BASE+0x1524))
#define MT3615_VGPUVPROC_ANA_CON14		((pmic_uint)(REG_BASE+0x1526))
#define MT3615_VGPUVPROC_ANA_CON15		((pmic_uint)(REG_BASE+0x1528))
#define MT3615_VPU_ANA_CON0			((pmic_uint)(REG_BASE+0x152a))
#define MT3615_VPU_ANA_CON1			((pmic_uint)(REG_BASE+0x152c))
#define MT3615_VPU_ANA_CON2			((pmic_uint)(REG_BASE+0x152e))
#define MT3615_VPU_ANA_CON3			((pmic_uint)(REG_BASE+0x1530))
#define MT3615_VPU_ANA_CON4			((pmic_uint)(REG_BASE+0x1532))
#define MT3615_VPU_ANA_CON5			((pmic_uint)(REG_BASE+0x1534))
#define MT3615_VCORE1_ANA_CON0			((pmic_uint)(REG_BASE+0x1536))
#define MT3615_VCORE1_ANA_CON1			((pmic_uint)(REG_BASE+0x1538))
#define MT3615_VCORE1_ANA_CON2			((pmic_uint)(REG_BASE+0x153a))
#define MT3615_VCORE1_ANA_CON3			((pmic_uint)(REG_BASE+0x153c))
#define MT3615_VCORE1_ANA_CON4			((pmic_uint)(REG_BASE+0x153e))
#define MT3615_VCORE1_ANA_CON5			((pmic_uint)(REG_BASE+0x1540))
#define MT3615_VCORE2_ANA_CON0			((pmic_uint)(REG_BASE+0x1588))
#define MT3615_VCORE2_ANA_CON1			((pmic_uint)(REG_BASE+0x158a))
#define MT3615_VCORE2_ANA_CON2			((pmic_uint)(REG_BASE+0x158c))
#define MT3615_VCORE2_ANA_CON3			((pmic_uint)(REG_BASE+0x158e))
#define MT3615_VCORE2_ANA_CON4			((pmic_uint)(REG_BASE+0x1590))
#define MT3615_VCORE2_ANA_CON5			((pmic_uint)(REG_BASE+0x1592))
#define MT3615_VCORE4_ANA_CON0			((pmic_uint)(REG_BASE+0x1594))
#define MT3615_VCORE4_ANA_CON1			((pmic_uint)(REG_BASE+0x1596))
#define MT3615_VCORE4_ANA_CON2			((pmic_uint)(REG_BASE+0x1598))
#define MT3615_VCORE4_ANA_CON3			((pmic_uint)(REG_BASE+0x159a))
#define MT3615_VCORE4_ANA_CON4			((pmic_uint)(REG_BASE+0x159c))
#define MT3615_VCORE4_ANA_CON5			((pmic_uint)(REG_BASE+0x159e))
#define MT3615_VS1_ANA_CON0			((pmic_uint)(REG_BASE+0x15a0))
#define MT3615_VS1_ANA_CON1			((pmic_uint)(REG_BASE+0x15a2))
#define MT3615_VS1_ANA_CON2			((pmic_uint)(REG_BASE+0x15a4))
#define MT3615_VS1_ANA_CON3			((pmic_uint)(REG_BASE+0x15a6))
#define MT3615_VS1_ANA_CON4			((pmic_uint)(REG_BASE+0x15a8))
#define MT3615_VS1_ANA_CON5			((pmic_uint)(REG_BASE+0x15aa))
#define MT3615_VS2_ANA_CON0			((pmic_uint)(REG_BASE+0x15ac))
#define MT3615_VS2_ANA_CON1			((pmic_uint)(REG_BASE+0x15ae))
#define MT3615_VS2_ANA_CON2			((pmic_uint)(REG_BASE+0x15b0))
#define MT3615_VS2_ANA_CON3			((pmic_uint)(REG_BASE+0x15b2))
#define MT3615_VS2_ANA_CON4			((pmic_uint)(REG_BASE+0x15b4))
#define MT3615_VS2_ANA_CON5			((pmic_uint)(REG_BASE+0x15b6))
#define MT3615_VS3_ANA_CON0			((pmic_uint)(REG_BASE+0x15b8))
#define MT3615_VS3_ANA_CON1			((pmic_uint)(REG_BASE+0x15ba))
#define MT3615_VS3_ANA_CON2			((pmic_uint)(REG_BASE+0x15bc))
#define MT3615_VS3_ANA_CON3			((pmic_uint)(REG_BASE+0x15be))
#define MT3615_VS3_ANA_CON4			((pmic_uint)(REG_BASE+0x15c0))
#define MT3615_VS3_ANA_CON5			((pmic_uint)(REG_BASE+0x15c2))
#define MT3615_VDRAM1_ANA_CON0			((pmic_uint)(REG_BASE+0x1608))
#define MT3615_VDRAM1_ANA_CON1			((pmic_uint)(REG_BASE+0x160a))
#define MT3615_VDRAM1_ANA_CON2			((pmic_uint)(REG_BASE+0x160c))
#define MT3615_VDRAM1_ANA_CON3			((pmic_uint)(REG_BASE+0x160e))
#define MT3615_VDRAM1_ANA_CON4			((pmic_uint)(REG_BASE+0x1610))
#define MT3615_VDRAM1_ANA_CON5			((pmic_uint)(REG_BASE+0x1612))
#define MT3615_VDRAM2_ANA_CON0			((pmic_uint)(REG_BASE+0x1614))
#define MT3615_VDRAM2_ANA_CON1			((pmic_uint)(REG_BASE+0x1616))
#define MT3615_VDRAM2_ANA_CON2			((pmic_uint)(REG_BASE+0x1618))
#define MT3615_VDRAM2_ANA_CON3			((pmic_uint)(REG_BASE+0x161a))
#define MT3615_VDRAM2_ANA_CON4			((pmic_uint)(REG_BASE+0x161c))
#define MT3615_VDRAM2_ANA_CON5			((pmic_uint)(REG_BASE+0x161e))
#define MT3615_VIO18_ANA_CON0			((pmic_uint)(REG_BASE+0x1620))
#define MT3615_VIO18_ANA_CON1			((pmic_uint)(REG_BASE+0x1622))
#define MT3615_VIO18_ANA_CON2			((pmic_uint)(REG_BASE+0x1624))
#define MT3615_VIO18_ANA_CON3			((pmic_uint)(REG_BASE+0x1626))
#define MT3615_VIO18_ANA_CON4			((pmic_uint)(REG_BASE+0x1628))
#define MT3615_VIO18_ANA_CON5			((pmic_uint)(REG_BASE+0x162a))
#define MT3615_VIO31_ANA_CON0			((pmic_uint)(REG_BASE+0x162c))
#define MT3615_VIO31_ANA_CON1			((pmic_uint)(REG_BASE+0x162e))
#define MT3615_VIO31_ANA_CON2			((pmic_uint)(REG_BASE+0x1630))
#define MT3615_VIO31_ANA_CON3			((pmic_uint)(REG_BASE+0x1632))
#define MT3615_VIO31_ANA_CON4			((pmic_uint)(REG_BASE+0x1634))
#define MT3615_LDO_TPM0				((pmic_uint)(REG_BASE+0x1788))
#define MT3615_LDO_TPM1				((pmic_uint)(REG_BASE+0x178a))
#define MT3615_LDO_TOP_CKPDN_CON0		((pmic_uint)(REG_BASE+0x178c))
#define MT3615_TOP_TOP_CKHWEN_CON0		((pmic_uint)(REG_BASE+0x178e))
#define MT3615_LDO_TOP_CLK_DCM_CON0		((pmic_uint)(REG_BASE+0x1790))
#define MT3615_LDO_TOP_INT_STATUS0		((pmic_uint)(REG_BASE+0x179e))
#define MT3615_LDO_TEST_CON0			((pmic_uint)(REG_BASE+0x17a2))
#define MT3615_LDO_TOP_CON			((pmic_uint)(REG_BASE+0x17a4))
#define MT3615_LDO_VAUX18_CON0			((pmic_uint)(REG_BASE+0x1808))
#define MT3615_LDO_VAUX18_CON1			((pmic_uint)(REG_BASE+0x180a))
#define MT3615_LDO_VAUX18_MON			((pmic_uint)(REG_BASE+0x180c))
#define MT3615_LDO_VAUX18_OP_EN			((pmic_uint)(REG_BASE+0x180e))
#define MT3615_LDO_VXO_CON0			((pmic_uint)(REG_BASE+0x1810))
#define MT3615_LDO_VXO_CON1			((pmic_uint)(REG_BASE+0x1812))
#define MT3615_LDO_VXO_MON			((pmic_uint)(REG_BASE+0x1814))
#define MT3615_LDO_VXO_OP_EN			((pmic_uint)(REG_BASE+0x1816))
#define MT3615_LDO_VEFUSE_CON0			((pmic_uint)(REG_BASE+0x1818))
#define MT3615_LDO_VEFUSE_CON1			((pmic_uint)(REG_BASE+0x181a))
#define MT3615_LDO_VEFUSE_MON			((pmic_uint)(REG_BASE+0x181c))
#define MT3615_LDO_VEFUSE_OP_EN			((pmic_uint)(REG_BASE+0x181e))
#define MT3615_LDO_VM18_CON0			((pmic_uint)(REG_BASE+0x1820))
#define MT3615_LDO_VM18_CON1			((pmic_uint)(REG_BASE+0x1822))
#define MT3615_LDO_VM18_MON			((pmic_uint)(REG_BASE+0x1824))
#define MT3615_LDO_VM18_OP_EN			((pmic_uint)(REG_BASE+0x1826))
#define MT3615_LDO_VUSB_CON0			((pmic_uint)(REG_BASE+0x1828))
#define MT3615_LDO_VUSB_CON1			((pmic_uint)(REG_BASE+0x182a))
#define MT3615_LDO_VUSB_MON			((pmic_uint)(REG_BASE+0x182c))
#define MT3615_LDO_VUSB_OP_EN			((pmic_uint)(REG_BASE+0x182e))
#define MT3615_LDO_VA18_CON0			((pmic_uint)(REG_BASE+0x1830))
#define MT3615_LDO_VA18_CON1			((pmic_uint)(REG_BASE+0x1832))
#define MT3615_LDO_VA18_MON			((pmic_uint)(REG_BASE+0x1834))
#define MT3615_LDO_VA18_OP_EN			((pmic_uint)(REG_BASE+0x1836))
#define MT3615_LDO_VA12_CON0			((pmic_uint)(REG_BASE+0x1888))
#define MT3615_LDO_VA12_CON1			((pmic_uint)(REG_BASE+0x188a))
#define MT3615_LDO_VA12_MON			((pmic_uint)(REG_BASE+0x188c))
#define MT3615_LDO_VA12_OP_EN			((pmic_uint)(REG_BASE+0x188e))
#define MT3615_LDO_VA09_CON0			((pmic_uint)(REG_BASE+0x1890))
#define MT3615_LDO_VA09_CON1			((pmic_uint)(REG_BASE+0x1892))
#define MT3615_LDO_VA09_MON			((pmic_uint)(REG_BASE+0x1894))
#define MT3615_LDO_VA09_OP_EN			((pmic_uint)(REG_BASE+0x1896))
#define MT3615_LDO_VPIO31_CON0			((pmic_uint)(REG_BASE+0x1898))
#define MT3615_LDO_VPIO31_CON1			((pmic_uint)(REG_BASE+0x189a))
#define MT3615_LDO_VPIO31_MON			((pmic_uint)(REG_BASE+0x189c))
#define MT3615_LDO_VPIO31_OP_EN			((pmic_uint)(REG_BASE+0x189e))
#define MT3615_LDO_VBBCK_CON0			((pmic_uint)(REG_BASE+0x18a0))
#define MT3615_LDO_VBBCK_CON1			((pmic_uint)(REG_BASE+0x18a2))
#define MT3615_LDO_VBBCK_MON			((pmic_uint)(REG_BASE+0x18a4))
#define MT3615_LDO_VBBCK_OP_EN			((pmic_uint)(REG_BASE+0x18a6))
#define MT3615_LDO_VPIO18_CON0			((pmic_uint)(REG_BASE+0x18a8))
#define MT3615_LDO_VPIO18_CON1			((pmic_uint)(REG_BASE+0x18aa))
#define MT3615_LDO_VPIO18_MON			((pmic_uint)(REG_BASE+0x18ac))
#define MT3615_LDO_VPIO18_OP_EN			((pmic_uint)(REG_BASE+0x18ae))
#define MT3615_LDO_VSRAM_PROC_CON0		((pmic_uint)(REG_BASE+0x1908))
#define MT3615_LDO_VSRAM_PROC_CON1		((pmic_uint)(REG_BASE+0x190a))
#define MT3615_LDO_VSRAM_PROC_MON		((pmic_uint)(REG_BASE+0x190c))
#define MT3615_LDO_VSRAM_PROC_VOSEL0		((pmic_uint)(REG_BASE+0x190e))
#define MT3615_LDO_VSRAM_PROC_VOSEL1		((pmic_uint)(REG_BASE+0x1910))
#define MT3615_LDO_VSRAM_PROC_SFCHG		((pmic_uint)(REG_BASE+0x1912))
#define MT3615_LDO_VSRAM_PROC_DVS		((pmic_uint)(REG_BASE+0x1914))
#define MT3615_LDO_VSRAM_PROC_OP_EN		((pmic_uint)(REG_BASE+0x1916))
#define MT3615_LDO_VSRAM_PROC_TRACK0		((pmic_uint)(REG_BASE+0x1918))
#define MT3615_LDO_VSRAM_PROC_TRACK1		((pmic_uint)(REG_BASE+0x191a))
#define MT3615_LDO_VSRAM_PROC_TRACK2		((pmic_uint)(REG_BASE+0x191c))
#define MT3615_LDO_VSRAM_COREX_CON0		((pmic_uint)(REG_BASE+0x191e))
#define MT3615_LDO_VSRAM_COREX_CON1		((pmic_uint)(REG_BASE+0x1920))
#define MT3615_LDO_VSRAM_COREX_MON		((pmic_uint)(REG_BASE+0x1922))
#define MT3615_LDO_VSRAM_COREX_VOSEL0		((pmic_uint)(REG_BASE+0x1924))
#define MT3615_LDO_VSRAM_COREX_VOSEL1		((pmic_uint)(REG_BASE+0x1926))
#define MT3615_LDO_VSRAM_COREX_SFCHG		((pmic_uint)(REG_BASE+0x1928))
#define MT3615_LDO_VSRAM_COREX_DVS		((pmic_uint)(REG_BASE+0x192a))
#define MT3615_LDO_VSRAM_COREX_OP_EN		((pmic_uint)(REG_BASE+0x192c))
#define MT3615_LDO_VSRAM_COREX_TRACK0		((pmic_uint)(REG_BASE+0x192e))
#define MT3615_LDO_VSRAM_COREX_TRACK1		((pmic_uint)(REG_BASE+0x1930))
#define MT3615_LDO_VSRAM_COREX_TRACK2		((pmic_uint)(REG_BASE+0x1932))
#define MT3615_LDO_VSRAM_PROC_ELR		((pmic_uint)(REG_BASE+0x1936))
#define MT3615_LDO_VSRAM_COREX_ELR		((pmic_uint)(REG_BASE+0x1938))
#define MT3615_LDO_VSRAM_GPU_CON0		((pmic_uint)(REG_BASE+0x1988))
#define MT3615_LDO_VSRAM_GPU_CON1		((pmic_uint)(REG_BASE+0x198a))
#define MT3615_LDO_VSRAM_GPU_MON		((pmic_uint)(REG_BASE+0x198c))
#define MT3615_LDO_VSRAM_GPU_VOSEL0		((pmic_uint)(REG_BASE+0x198e))
#define MT3615_LDO_VSRAM_GPU_VOSEL1		((pmic_uint)(REG_BASE+0x1990))
#define MT3615_LDO_VSRAM_GPU_SFCHG		((pmic_uint)(REG_BASE+0x1992))
#define MT3615_LDO_VSRAM_GPU_DVS		((pmic_uint)(REG_BASE+0x1994))
#define MT3615_LDO_VSRAM_GPU_OP_EN		((pmic_uint)(REG_BASE+0x1996))
#define MT3615_LDO_VSRAM_GPU_TRACK0		((pmic_uint)(REG_BASE+0x1998))
#define MT3615_LDO_VSRAM_GPU_TRACK1		((pmic_uint)(REG_BASE+0x199a))
#define MT3615_LDO_VSRAM_GPU_TRACK2		((pmic_uint)(REG_BASE+0x199c))
#define MT3615_LDO_VSRAM_VPU_CON0		((pmic_uint)(REG_BASE+0x199e))
#define MT3615_LDO_VSRAM_VPU_CON1		((pmic_uint)(REG_BASE+0x19a0))
#define MT3615_LDO_VSRAM_VPU_MON		((pmic_uint)(REG_BASE+0x19a2))
#define MT3615_LDO_VSRAM_VPU_VOSEL0		((pmic_uint)(REG_BASE+0x19a4))
#define MT3615_LDO_VSRAM_VPU_VOSEL1		((pmic_uint)(REG_BASE+0x19a6))
#define MT3615_LDO_VSRAM_VPU_SFCHG		((pmic_uint)(REG_BASE+0x19a8))
#define MT3615_LDO_VSRAM_VPU_DVS		((pmic_uint)(REG_BASE+0x19aa))
#define MT3615_LDO_VSRAM_VPU_OP_EN		((pmic_uint)(REG_BASE+0x19ac))
#define MT3615_LDO_VSRAM_VPU_TRACK0		((pmic_uint)(REG_BASE+0x19ae))
#define MT3615_LDO_VSRAM_VPU_TRACK1		((pmic_uint)(REG_BASE+0x19b0))
#define MT3615_LDO_VSRAM_VPU_TRACK2		((pmic_uint)(REG_BASE+0x19b2))
#define MT3615_LDO_VSRAM_GPU_ELR		((pmic_uint)(REG_BASE+0x19b6))
#define MT3615_LDO_VSRAM_VPU_ELR		((pmic_uint)(REG_BASE+0x19b8))
#define MT3615_VAUX18_ANA_CON0			((pmic_uint)(REG_BASE+0x1a08))
#define MT3615_VAUX18_ANA_CON1			((pmic_uint)(REG_BASE+0x1a0a))
#define MT3615_VUSB_ANA_CON0			((pmic_uint)(REG_BASE+0x1a0c))
#define MT3615_VUSB_ANA_CON1			((pmic_uint)(REG_BASE+0x1a0e))
#define MT3615_VPIO31_ANA_CON0			((pmic_uint)(REG_BASE+0x1a10))
#define MT3615_VPIO31_ANA_CON1			((pmic_uint)(REG_BASE+0x1a12))
#define MT3615_VPIO18_ANA_CON0			((pmic_uint)(REG_BASE+0x1a14))
#define MT3615_VPIO18_ANA_CON1			((pmic_uint)(REG_BASE+0x1a16))
#define MT3615_ADLDO_ANA_CON0			((pmic_uint)(REG_BASE+0x1a18))
#define MT3615_VEFUSE_ANA_CON0			((pmic_uint)(REG_BASE+0x1a88))
#define MT3615_VEFUSE_ANA_CON1			((pmic_uint)(REG_BASE+0x1a8a))
#define MT3615_VM18_ANA_CON0			((pmic_uint)(REG_BASE+0x1a8c))
#define MT3615_VM18_ANA_CON1			((pmic_uint)(REG_BASE+0x1a8e))
#define MT3615_VA18_ANA_CON0			((pmic_uint)(REG_BASE+0x1a90))
#define MT3615_VA18_ANA_CON1			((pmic_uint)(REG_BASE+0x1a92))
#define MT3615_VA12_ANA_CON0			((pmic_uint)(REG_BASE+0x1a94))
#define MT3615_VA12_ANA_CON1			((pmic_uint)(REG_BASE+0x1a96))
#define MT3615_VA09_ANA_CON0			((pmic_uint)(REG_BASE+0x1a98))
#define MT3615_VA09_ANA_CON1			((pmic_uint)(REG_BASE+0x1a9a))
#define MT3615_SLDO_ANA_CON0			((pmic_uint)(REG_BASE+0x1a9c))
#define MT3615_VSRAM_PROC_ANA_CON0		((pmic_uint)(REG_BASE+0x1b08))
#define MT3615_VSRAM_PROC_ANA_CON1		((pmic_uint)(REG_BASE+0x1b0a))
#define MT3615_VSRAM_COREX_ANA_CON0		((pmic_uint)(REG_BASE+0x1b0c))
#define MT3615_VSRAM_COREX_ANA_CON1		((pmic_uint)(REG_BASE+0x1b0e))
#define MT3615_VSRAM_GPU_ANA_CON0		((pmic_uint)(REG_BASE+0x1b10))
#define MT3615_VSRAM_GPU_ANA_CON1		((pmic_uint)(REG_BASE+0x1b12))
#define MT3615_VSRAM_VPU_ANA_CON0		((pmic_uint)(REG_BASE+0x1b14))
#define MT3615_VSRAM_VPU_ANA_CON1		((pmic_uint)(REG_BASE+0x1b16))
#define MT3615_VXO_ANA_CON0			((pmic_uint)(REG_BASE+0x1b18))
#define MT3615_VXO_ANA_CON1			((pmic_uint)(REG_BASE+0x1b1a))
#define MT3615_VBBCK_ANA_CON0			((pmic_uint)(REG_BASE+0x1b1c))
#define MT3615_VBBCK_ANA_CON1			((pmic_uint)(REG_BASE+0x1b1e))

#define PMIC_HWCID_ADDR				MT3615_HWCID
#define PMIC_HWCID_MASK				0xffff
#define PMIC_HWCID_SHIFT			0

#define MT3615_PMIC_STANDBY_IN_ADDR		MT3615_PSEQ2_CON0
#define MT3615_PMIC_STANDBY_IN_MASK		0x1
#define MT3615_PMIC_STANDBY_IN_SHIFT		0
#define MT3615_PMIC_REBOOT_ADDR			MT3615_PSEQ2_CON0
#define MT3615_PMIC_REBOOT_MASK			0x1
#define MT3615_PMIC_REBOOT_SHIFT		1
#define MT3615_SOC_READY_STATUS_ADDR		MT3615_PSEQ2_CON0
#define MT3615_SOC_READY_STATUS_MASK		0x1
#define MT3615_SOC_READY_STATUS_SHIFT		2
#define MT3615_PMIC_ALERT_B_EN_ADDR		MT3615_PSEQ2_CON0
#define MT3615_PMIC_ALERT_B_EN_MASK		0x1
#define MT3615_PMIC_ALERT_B_EN_SHIFT		3
#define MT3615_PMIC_REBOOT_INTV_ADDR		MT3615_PSEQ2_CON0
#define MT3615_PMIC_REBOOT_INTV_MASK		0x3
#define MT3615_PMIC_REBOOT_INTV_SHIFT		4
#define MT3615_CABLE_DET_DEB_SEL_ADDR		MT3615_PSEQ2_CON1
#define MT3615_CABLE_DET_DEB_SEL_MASK		0xF
#define MT3615_CABLE_DET_DEB_SEL_SHIFT		0
#define MT3615_SHUTDOWN3B_DEB_ADDR		MT3615_PSEQ2_CON1
#define MT3615_SHUTDOWN3B_DEB_MASK		0x1
#define MT3615_SHUTDOWN3B_DEB_SHIFT		4
#define MT3615_TIMER_OUT2_EN_ADDR		MT3615_PSEQ2_CON1
#define MT3615_TIMER_OUT2_EN_MASK		0x1
#define MT3615_TIMER_OUT2_EN_SHIFT		5
#define MT3615_KP_DEB_ADDR			MT3615_PSEQ2_ELR0
#define MT3615_KP_DEB_MASK			0x3
#define MT3615_KP_DEB_SHIFT			0
#define MT3615_SPT_SEL_ADDR			MT3615_PSEQ2_ELR0
#define MT3615_SPT_SEL_MASK			0xF
#define MT3615_SPT_SEL_SHIFT			2
#define MT3615_LPT_SEL_ADDR			MT3615_PSEQ2_ELR0
#define MT3615_LPT_SEL_MASK			0x1F
#define MT3615_LPT_SEL_SHIFT			8
#define MT3615_PMIC_SHUTDOWN1_EN_ADDR		MT3615_PSEQ2_ELR0
#define MT3615_PMIC_SHUTDOWN1_EN_MASK		0x1
#define MT3615_PMIC_SHUTDOWN1_EN_SHIFT		13
#define MT3615_PMIC_SHUTDOWN2_EN_ADDR		MT3615_PSEQ2_ELR0
#define MT3615_PMIC_SHUTDOWN2_EN_MASK		0x1
#define MT3615_PMIC_SHUTDOWN2_EN_SHIFT		14
#define MT3615_PMIC_SHUTDOWN3_EN_ADDR		MT3615_PSEQ2_ELR0
#define MT3615_PMIC_SHUTDOWN3_EN_MASK		0x1
#define MT3615_PMIC_SHUTDOWN3_EN_SHIFT		15
#define MT3615_TIMER_OUT1_SET_ADDR		MT3615_CPS_GPOCFG_ELR
#define MT3615_TIMER_OUT1_SET_MASK		0x1F
#define MT3615_TIMER_OUT1_SET_SHIFT		2
#define MT3615_TIMER_OUT1_EN_ADDR		MT3615_CPS_GPOCFG_ELR
#define MT3615_TIMER_OUT1_EN_MASK		0x1
#define MT3615_TIMER_OUT1_EN_SHIFT		7

#endif /* __MFD_MT3615_REGISTERS_H__ */
