/*
 * Copyright (c) 2014 MediaTek Inc.
 * Author: Hongzhou.Yang <hongzhou.yang@mediatek.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __PINCTRL_MTK_MT3615_H
#define __PINCTRL_MTK_MT3615_H

#include <linux/pinctrl/pinctrl.h>
#include <pinctrl-mtk-common.h>

/** @ingroup IP_group_gpio_internal_struct
 * @brief define mt3615 gpio pin description struct.
 */
static const struct mtk_desc_pin mtk_pins_mt3615[] = {
	MTK_PIN(
		PINCTRL_PIN(0, "PMIC_SHUTDOWN2_B"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO0"),
		MTK_FUNCTION(1, "PMIC_SHUTDOWN2_B")
	),
	MTK_PIN(
		PINCTRL_PIN(1, "CABLE_OUT_B"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO1"),
		MTK_FUNCTION(1, "CABLE_OUT_B")
	),
	MTK_PIN(
		PINCTRL_PIN(2, "KEY_OUT_B"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO2"),
		MTK_FUNCTION(1, "KEY_OUT_B")
	),
	MTK_PIN(
		PINCTRL_PIN(3, "HW_TRAPPING"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO3"),
		MTK_FUNCTION(1, "HW_TRAPPING"),
		MTK_FUNCTION(5, "TEST_CK0")
	),
	MTK_PIN(
		PINCTRL_PIN(4, "SPI_CLK"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO4"),
		MTK_FUNCTION(1, "SPI_CLK")
	),
	MTK_PIN(
		PINCTRL_PIN(5, "SPI_CSN"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO5")
	),
	MTK_PIN(
		PINCTRL_PIN(6, "SPI_MOSI"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO6"),
		MTK_FUNCTION(1, "SPI_MOSI")
	),
	MTK_PIN(
		PINCTRL_PIN(7, "SPI_MISO"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO7"),
		MTK_FUNCTION(1, "SPI_MISO")
	),
	MTK_PIN(
		PINCTRL_PIN(8, "GPO_A1"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO8"),
		MTK_FUNCTION(1, "GPO_A1")
	),
	MTK_PIN(
		PINCTRL_PIN(9, "GPO_A2"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO9"),
		MTK_FUNCTION(1, "GPO_A2"),
		MTK_FUNCTION(5, "TEST_CK1")
	),
	MTK_PIN(
		PINCTRL_PIN(10, "GPO_A3"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO10"),
		MTK_FUNCTION(1, "GPO_A3"),
		MTK_FUNCTION(3, "dummy0"),
		MTK_FUNCTION(5, "TEST_CK2")
	),
	MTK_PIN(
		PINCTRL_PIN(11, "GPO_A4"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO11"),
		MTK_FUNCTION(3, "dummy1"),
		MTK_FUNCTION(1, "GPO_A4")
	),
	MTK_PIN(
		PINCTRL_PIN(12, "GPO_B1"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO12"),
		MTK_FUNCTION(1, "GPO_B1"),
		MTK_FUNCTION(6, "TEST_IN0"),
		MTK_FUNCTION(7, "TEST_OUT0")
	),
	MTK_PIN(
		PINCTRL_PIN(13, "GPO_B2"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO13"),
		MTK_FUNCTION(1, "GPO_B2"),
		MTK_FUNCTION(6, "TEST_IN1"),
		MTK_FUNCTION(7, "TEST_OUT1")
	),
	MTK_PIN(
		PINCTRL_PIN(14, "GPO_B3"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO14"),
		MTK_FUNCTION(1, "GPO_B3"),
		MTK_FUNCTION(6, "TEST_IN2"),
		MTK_FUNCTION(7, "TEST_OUT2")
	),
	MTK_PIN(
		PINCTRL_PIN(15, "GPO_B4"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO15"),
		MTK_FUNCTION(1, "GPO_B4"),
		MTK_FUNCTION(6, "TEST_IN3"),
		MTK_FUNCTION(7, "TEST_OUT3")
	),
	MTK_PIN(
		PINCTRL_PIN(16, "PWM_LED1"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO16"),
		MTK_FUNCTION(1, "PWM_LED1"),
		MTK_FUNCTION(6, "TEST_IN4"),
		MTK_FUNCTION(7, "TEST_OUT4")
	),
	MTK_PIN(
		PINCTRL_PIN(17, "PWM_LED2"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO17"),
		MTK_FUNCTION(1, "PWM_LED2"),
		MTK_FUNCTION(6, "TEST_IN5"),
		MTK_FUNCTION(7, "TEST_OUT5")
	),
	MTK_PIN(
		PINCTRL_PIN(18, "PWM_LED3"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO18"),
		MTK_FUNCTION(1, "PWM_LED3"),
		MTK_FUNCTION(6, "TEST_IN6"),
		MTK_FUNCTION(7, "TEST_OUT6")
	),
	MTK_PIN(
		PINCTRL_PIN(19, "PWM1"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO19"),
		MTK_FUNCTION(1, "PWM1"),
		MTK_FUNCTION(6, "TEST_IN7"),
		MTK_FUNCTION(7, "TEST_OUT7")
	),
	MTK_PIN(
		PINCTRL_PIN(20, "PWM2"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO20"),
		MTK_FUNCTION(1, "PWM2"),
		MTK_FUNCTION(6, "TEST_IN8"),
		MTK_FUNCTION(7, "TEST_OUT8")
	),
	MTK_PIN(
		PINCTRL_PIN(21, "TIMER_OUTPUT1"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO21"),
		MTK_FUNCTION(1, "TIMER_OUTPUT1"),
		MTK_FUNCTION(6, "TEST_IN9"),
		MTK_FUNCTION(7, "TEST_OUT9")
	),
	MTK_PIN(
		PINCTRL_PIN(22, "TIMER_OUTPUT2"),
		"NULL", "mt3615",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO22"),
		MTK_FUNCTION(1, "TIMER_OUTPUT2"),
		MTK_FUNCTION(6, "TEST_IN10"),
		MTK_FUNCTION(7, "TEST_OUT10")
	),
};

#endif /* __PINCTRL_MTK_MT3615_H */
