/*
 * Copyright (c) 2018 MediaTek Inc.
 * Authors:
 *	Houlong Wei <houlong.wei@mediatek.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/**
 * @file mtk_mmsys_cfg_reg.h
 * Register definition header of mtk_mmsys_cfg.c
 */

#ifndef __MTK_MMSYS_CFG_REG_H__
#define __MTK_MMSYS_CFG_REG_H__

/* ----------------- Register Definitions ------------------- */
#define MMSYS_CG0					0x00000000
	#define CG0_B0					BIT(0)
	#define CG0_B1					BIT(1)
	#define CG0_B2					BIT(2)
	#define CG0_B3					BIT(3)
	#define CG0_B4					BIT(4)
	#define CG0_B5					BIT(5)
	#define CG0_B6					BIT(6)
	#define CG0_B7					BIT(7)
	#define CG0_B8					BIT(8)
	#define CG0_B9					BIT(9)
	#define CG0_B10					BIT(10)
	#define CG0_B11					BIT(11)
	#define CG0_B12					BIT(12)
	#define CG0_B13					BIT(13)
	#define CG0_B14					BIT(14)
	#define CG0_B15					BIT(15)
	#define CG0_B16					BIT(16)
	#define CG0_B17					BIT(17)
	#define CG0_B18					BIT(18)
	#define CG0_B19					BIT(19)
	#define CG0_B20					BIT(20)
	#define CG0_B21					BIT(21)
	#define CG0_B22					BIT(22)
	#define CG0_B23					BIT(23)
	#define CG0_B24					BIT(24)
	#define CG0_B25					BIT(25)
	#define CG0_B26					BIT(26)
	#define CG0_B27					BIT(27)
	#define CG0_B28					BIT(28)
	#define CG0_B29					BIT(29)
	#define CG0_B30					BIT(30)
	#define CG0_B31					BIT(31)
#define MMSYS_CG1					0x00000004
	#define CG1_B0					BIT(0)
	#define CG1_B1					BIT(1)
	#define CG1_B2					BIT(2)
	#define CG1_B3					BIT(3)
	#define CG1_B4					BIT(4)
	#define CG1_B5					BIT(5)
	#define CG1_B6					BIT(6)
	#define CG1_B7					BIT(7)
	#define CG1_B8					BIT(8)
	#define CG1_B9					BIT(9)
	#define CG1_B10					BIT(10)
	#define CG1_B11					BIT(11)
	#define CG1_B12					BIT(12)
	#define CG1_B13					BIT(13)
	#define CG1_B14					BIT(14)
	#define CG1_B15					BIT(15)
	#define CG1_B16					BIT(16)
	#define CG1_B17					BIT(17)
	#define CG1_B18					BIT(18)
	#define CG1_B19					BIT(19)
	#define CG1_B20					BIT(20)
	#define CG1_B21					BIT(21)
	#define CG1_B22					BIT(22)
	#define CG1_B23					BIT(23)
	#define CG1_B24					BIT(24)
	#define CG1_B25					BIT(25)
	#define CG1_B26					BIT(26)
	#define CG1_B27					BIT(27)
	#define CG1_B28					BIT(28)
	#define CG1_B29					BIT(29)
	#define CG1_B30					BIT(30)
	#define CG1_B31					BIT(31)
#define MMSYS_CG2					0x00000008
	#define CG2_B0					BIT(0)
	#define CG2_B1					BIT(1)
	#define CG2_B2					BIT(2)
	#define CG2_B3					BIT(3)
	#define CG2_B4					BIT(4)
	#define CG2_B5					BIT(5)
	#define CG2_B6					BIT(6)
	#define CG2_B7					BIT(7)
	#define CG2_B8					BIT(8)
	#define CG2_B9					BIT(9)
	#define CG2_B10					BIT(10)
	#define CG2_B11					BIT(11)
	#define CG2_B12					BIT(12)
	#define CG2_B13					BIT(13)
	#define CG2_B14					BIT(14)
	#define CG2_B15					BIT(15)
	#define CG2_B16					BIT(16)
	#define CG2_B17					BIT(17)
	#define CG2_B18					BIT(18)
	#define CG2_B19					BIT(19)
	#define CG2_B20					BIT(20)
	#define CG2_B21					BIT(21)
	#define CG2_B22					BIT(22)
	#define CG2_B23					BIT(23)
	#define CG2_B24					BIT(24)
	#define CG2_B25					BIT(25)
	#define CG2_B26					BIT(26)
	#define CG2_B27					BIT(27)
	#define CG2_B28					BIT(28)
	#define CG2_B29					BIT(29)
	#define CG2_B30					BIT(30)
	#define CG2_B31					BIT(31)
#define MMSYS_HW_DIS0					0x0000000c
	#define HW_DCM_DIS0_B0				BIT(0)
	#define HW_DCM_DIS0_B1				BIT(1)
	#define HW_DCM_DIS0_B2				BIT(2)
	#define HW_DCM_DIS0_B3				BIT(3)
	#define HW_DCM_DIS0_B4				BIT(4)
	#define HW_DCM_DIS0_B5				BIT(5)
	#define HW_DCM_DIS0_B6				BIT(6)
	#define HW_DCM_DIS0_B7				BIT(7)
	#define HW_DCM_DIS0_B8				BIT(8)
	#define HW_DCM_DIS0_B9				BIT(9)
	#define HW_DCM_DIS0_B10				BIT(10)
	#define HW_DCM_DIS0_B11				BIT(11)
	#define HW_DCM_DIS0_B12				BIT(12)
	#define HW_DCM_DIS0_B13				BIT(13)
	#define HW_DCM_DIS0_B14				BIT(14)
	#define HW_DCM_DIS0_B15				BIT(15)
	#define HW_DCM_DIS0_B16				BIT(16)
	#define HW_DCM_DIS0_B17				BIT(17)
	#define HW_DCM_DIS0_B18				BIT(18)
	#define HW_DCM_DIS0_B19				BIT(19)
	#define HW_DCM_DIS0_B20				BIT(20)
	#define HW_DCM_DIS0_B21				BIT(21)
	#define HW_DCM_DIS0_B22				BIT(22)
	#define HW_DCM_DIS0_B23				BIT(23)
	#define HW_DCM_DIS0_B24				BIT(24)
	#define HW_DCM_DIS0_B25				BIT(25)
	#define HW_DCM_DIS0_B26				BIT(26)
	#define HW_DCM_DIS0_B27				BIT(27)
	#define HW_DCM_DIS0_B28				BIT(28)
	#define HW_DCM_DIS0_B29				BIT(29)
	#define HW_DCM_DIS0_B30				BIT(30)
	#define HW_DCM_DIS0_B31				BIT(31)
#define MMSYS_HW_DIS1					0x00000010
	#define HW_DCM_DIS1_B0				BIT(0)
	#define HW_DCM_DIS1_B1				BIT(1)
	#define HW_DCM_DIS1_B2				BIT(2)
	#define HW_DCM_DIS1_B3				BIT(3)
	#define HW_DCM_DIS1_B4				BIT(4)
	#define HW_DCM_DIS1_B5				BIT(5)
	#define HW_DCM_DIS1_B6				BIT(6)
	#define HW_DCM_DIS1_B7				BIT(7)
	#define HW_DCM_DIS1_B8				BIT(8)
	#define HW_DCM_DIS1_B9				BIT(9)
	#define HW_DCM_DIS1_B10				BIT(10)
	#define HW_DCM_DIS1_B11				BIT(11)
	#define HW_DCM_DIS1_B12				BIT(12)
	#define HW_DCM_DIS1_B13				BIT(13)
	#define HW_DCM_DIS1_B14				BIT(14)
	#define HW_DCM_DIS1_B15				BIT(15)
	#define HW_DCM_DIS1_B16				BIT(16)
	#define HW_DCM_DIS1_B17				BIT(17)
	#define HW_DCM_DIS1_B18				BIT(18)
	#define HW_DCM_DIS1_B19				BIT(19)
	#define HW_DCM_DIS1_B20				BIT(20)
	#define HW_DCM_DIS1_B21				BIT(21)
	#define HW_DCM_DIS1_B22				BIT(22)
	#define HW_DCM_DIS1_B23				BIT(23)
	#define HW_DCM_DIS1_B24				BIT(24)
	#define HW_DCM_DIS1_B25				BIT(25)
	#define HW_DCM_DIS1_B26				BIT(26)
	#define HW_DCM_DIS1_B27				BIT(27)
	#define HW_DCM_DIS1_B28				BIT(28)
	#define HW_DCM_DIS1_B29				BIT(29)
	#define HW_DCM_DIS1_B30				BIT(30)
	#define HW_DCM_DIS1_B31				BIT(31)
#define MMSYS_HW_DIS2					0x00000014
	#define HW_DCM_DIS2_B0				BIT(0)
	#define HW_DCM_DIS2_B1				BIT(1)
	#define HW_DCM_DIS2_B2				BIT(2)
	#define HW_DCM_DIS2_B3				BIT(3)
	#define HW_DCM_DIS2_B4				BIT(4)
	#define HW_DCM_DIS2_B5				BIT(5)
	#define HW_DCM_DIS2_B6				BIT(6)
	#define HW_DCM_DIS2_B7				BIT(7)
	#define HW_DCM_DIS2_B8				BIT(8)
	#define HW_DCM_DIS2_B9				BIT(9)
	#define HW_DCM_DIS2_B10				BIT(10)
	#define HW_DCM_DIS2_B11				BIT(11)
	#define HW_DCM_DIS2_B12				BIT(12)
	#define HW_DCM_DIS2_B13				BIT(13)
	#define HW_DCM_DIS2_B14				BIT(14)
	#define HW_DCM_DIS2_B15				BIT(15)
	#define HW_DCM_DIS2_B16				BIT(16)
	#define HW_DCM_DIS2_B17				BIT(17)
	#define HW_DCM_DIS2_B18				BIT(18)
	#define HW_DCM_DIS2_B19				BIT(19)
	#define HW_DCM_DIS2_B20				BIT(20)
	#define HW_DCM_DIS2_B21				BIT(21)
	#define HW_DCM_DIS2_B22				BIT(22)
	#define HW_DCM_DIS2_B23				BIT(23)
	#define HW_DCM_DIS2_B24				BIT(24)
	#define HW_DCM_DIS2_B25				BIT(25)
	#define HW_DCM_DIS2_B26				BIT(26)
	#define HW_DCM_DIS2_B27				BIT(27)
	#define HW_DCM_DIS2_B28				BIT(28)
	#define HW_DCM_DIS2_B29				BIT(29)
	#define HW_DCM_DIS2_B30				BIT(30)
	#define HW_DCM_DIS2_B31				BIT(31)
#define MMSYS_HW_DIS3					0x00000018
	#define HW_DCM_DIS3_B0				BIT(0)
	#define HW_DCM_DIS3_B1				BIT(1)
	#define HW_DCM_DIS3_B2				BIT(2)
	#define HW_DCM_DIS3_B3				BIT(3)
	#define HW_DCM_DIS3_B4				BIT(4)
	#define HW_DCM_DIS3_B5				BIT(5)
	#define HW_DCM_DIS3_B6				BIT(6)
	#define HW_DCM_DIS3_B7				BIT(7)
	#define HW_DCM_DIS3_B8				BIT(8)
	#define HW_DCM_DIS3_B9				BIT(9)
	#define HW_DCM_DIS3_B10				BIT(10)
	#define HW_DCM_DIS3_B11				BIT(11)
	#define HW_DCM_DIS3_B12				BIT(12)
	#define HW_DCM_DIS3_B13				BIT(13)
	#define HW_DCM_DIS3_B14				BIT(14)
	#define HW_DCM_DIS3_B15				BIT(15)
	#define HW_DCM_DIS3_B16				BIT(16)
	#define HW_DCM_DIS3_B17				BIT(17)
	#define HW_DCM_DIS3_B18				BIT(18)
	#define HW_DCM_DIS3_B19				BIT(19)
	#define HW_DCM_DIS3_B20				BIT(20)
	#define HW_DCM_DIS3_B21				BIT(21)
	#define HW_DCM_DIS3_B22				BIT(22)
	#define HW_DCM_DIS3_B23				BIT(23)
	#define HW_DCM_DIS3_B24				BIT(24)
	#define HW_DCM_DIS3_B25				BIT(25)
	#define HW_DCM_DIS3_B26				BIT(26)
	#define HW_DCM_DIS3_B27				BIT(27)
	#define HW_DCM_DIS3_B28				BIT(28)
	#define HW_DCM_DIS3_B29				BIT(29)
	#define HW_DCM_DIS3_B30				BIT(30)
	#define HW_DCM_DIS3_B31				BIT(31)
#define MMSYS_SW_RSTB0					0x0000001c
	#define SW0_RST_B				GENMASK(31, 0)
#define MMSYS_SW_RSTB1					0x00000020
	#define SW1_RST_B				GENMASK(31, 0)
#define MMSYS_SW_RSTB2					0x00000024
	#define SW2_RST_B				GENMASK(31, 0)
#define MMSYS_GALS_CTRL					0x00000028
	#define LARB0_GALS_SLV_SYNC_SEL			GENMASK(1, 0)
	#define LARB0_GALS_MST_SYNC_SEL			GENMASK(3, 2)
	#define LARB0_GALS_SAMPLE_SEL			BIT(4)
	#define LARB1_GALS_SLV_SYNC_SEL			GENMASK(9, 8)
	#define LARB1_GALS_MST_SYNC_SEL			GENMASK(11, 10)
	#define LARB1_GALS_SAMPLE_SEL			BIT(12)
	#define LARB15_GALS_SLV_SYNC_SEL		GENMASK(17, 16)
	#define LARB15_GALS_MST_SYNC_SEL		GENMASK(19, 18)
	#define LARB15_GALS_SAMPLE_SEL			BIT(20)
	#define LARB16_GALS_SLV_SYNC_SEL		GENMASK(25, 24)
	#define LARB16_GALS_MST_SYNC_SEL		GENMASK(27, 26)
	#define LARB16_GALS_SAMPLE_SEL			BIT(28)
#define MMSYS_MISC					0x0000002c
	#define SOF_TO_MUTEX_WIDTH			GENMASK(5, 0)
	#define DRS_HALT_MASK				GENMASK(11, 8)
	#define DRS_STATUS_MASK				GENMASK(15, 12)
	#define DVFS_HALT_MASK				GENMASK(19, 16)
	#define SODI_REQ_MASK				GENMASK(23, 20)
	#define MOUT_RESET_MODE				BIT(24)
	#define MMAPB_PROTECT_EN			BIT(28)
#define MMSYS_PAT0_CTRL0				0x00000030
	#define PAT_0_PAT_GEN_EN			BIT(0)
	#define PAT_0_CURSOR_SHOW			BIT(1)
	#define PAT_0_GRID_SHOW_EN			GENMASK(3, 2)
	#define PAT_0_GRID_SIZE				GENMASK(7, 4)
	#define PAT_0_RAMP_EN				GENMASK(10, 8)
	#define PAT_0_PAT_TYPE				GENMASK(23, 16)
	#define PAT_0_PAT_FORCE_VALID			BIT(31)
#define MMSYS_PAT0_CTRL1				0x00000034
	#define PAT_0_V_ACT				GENMASK(12, 0)
	#define PAT_0_H_ACT				GENMASK(28, 16)
#define MMSYS_PAT0_CTRL2				0x00000038
	#define PAT_0_FRM_SIZE_V			GENMASK(12, 0)
	#define PAT_0_FRM_SIZE_H			GENMASK(28, 16)
#define MMSYS_PAT0_CTRL3				0x0000003c
	#define PAT_0_COLOR_Y				GENMASK(9, 0)
	#define PAT_0_COLOR_U				GENMASK(25, 16)
#define MMSYS_PAT0_CTRL4				0x00000040
	#define PAT_0_COLOR_V				GENMASK(9, 0)
	#define PAT_0_BG_COLOR_Y			GENMASK(25, 16)
#define MMSYS_PAT0_CTRL5				0x00000044
	#define PAT_0_BG_COLOR_U			GENMASK(9, 0)
	#define PAT_0_BG_COLOR_V			GENMASK(25, 16)
#define MMSYS_PAT0_CTRL6				0x00000048
	#define REG_PAT_0_POS_X				GENMASK(12, 0)
	#define REG_PAT_0_POS_Y				GENMASK(28, 16)
#define MMSYS_PAT0_CTRL7				0x0000004c
	#define PAT_0_RAMP_H_STEP			GENMASK(9, 0)
	#define PAT_0_RAMP_H_WIDTH			GENMASK(28, 16)
#define MMSYS_PAT0_CTRL8				0x00000050
	#define PAT_0_TILE_POS_X			GENMASK(12, 0)
	#define PAT_0_TILE_POS_Y			GENMASK(28, 16)
#define MMSYS_PAT0_CTRL9				0x00000054
	#define PAT_0_TILE_OV_X				GENMASK(7, 0)
	#define PAT_0_TILE_OV_Y				GENMASK(15, 8)
#define MMSYS_PAT1_CTRL0				0x00000058
	#define PAT_1_PAT_GEN_EN			BIT(0)
	#define PAT_1_CURSOR_SHOW			BIT(1)
	#define PAT_1_GRID_SHOW_EN			GENMASK(3, 2)
	#define PAT_1_GRID_SIZE				GENMASK(7, 4)
	#define PAT_1_RAMP_EN				GENMASK(10, 8)
	#define PAT_1_PAT_TYPE				GENMASK(23, 16)
	#define PAT_1_PAT_FORCE_VALID			BIT(31)
#define MMSYS_PAT1_CTRL1				0x0000005c
	#define PAT_1_V_ACT				GENMASK(12, 0)
	#define PAT_1_H_ACT				GENMASK(28, 16)
#define MMSYS_PAT1_CTRL2				0x00000060
	#define PAT_1_FRM_SIZE_V			GENMASK(12, 0)
	#define PAT_1_FRM_SIZE_H			GENMASK(28, 16)
#define MMSYS_PAT1_CTRL3				0x00000064
	#define PAT_1_COLOR_Y				GENMASK(9, 0)
	#define PAT_1_COLOR_U				GENMASK(25, 16)
#define MMSYS_PAT1_CTRL4				0x00000068
	#define PAT_1_COLOR_V				GENMASK(9, 0)
	#define PAT_1_BG_COLOR_Y			GENMASK(25, 16)
#define MMSYS_PAT1_CTRL5				0x0000006c
	#define PAT_1_BG_COLOR_U			GENMASK(9, 0)
	#define PAT_1_BG_COLOR_V			GENMASK(25, 16)
#define MMSYS_PAT1_CTRL6				0x00000070
	#define PAT_1_POS_X				GENMASK(12, 0)
	#define PAT_1_POS_Y				GENMASK(28, 16)
#define MMSYS_PAT1_CTRL7				0x00000074
	#define PAT_1_RAMP_H_STEP			GENMASK(9, 0)
	#define PAT_1_RAMP_H_WIDTH			GENMASK(28, 16)
#define MMSYS_PAT1_CTRL8				0x00000078
	#define PAT_1_TILE_POS_X			GENMASK(12, 0)
	#define PAT_1_TILE_POS_Y			GENMASK(28, 16)
#define MMSYS_PAT1_CTRL9				0x0000007c
	#define PAT_1_TILE_OV_X				GENMASK(7, 0)
	#define PAT_1_TILE_OV_Y				GENMASK(15, 8)
#define MMSYS_PAT2_CTRL0				0x00000080
	#define PAT_2_PAT_GEN_EN			BIT(0)
	#define PAT_2_CURSOR_SHOW			BIT(1)
	#define PAT_2_GRID_SHOW_EN			GENMASK(3, 2)
	#define PAT_2_GRID_SIZE				GENMASK(7, 4)
	#define PAT_2_RAMP_EN				GENMASK(10, 8)
	#define PAT_2_PAT_TYPE				GENMASK(23, 16)
	#define PAT_2_PAT_FORCE_VALID			BIT(31)
#define MMSYS_PAT2_CTRL1				0x00000084
	#define PAT_2_V_ACT				GENMASK(12, 0)
	#define PAT_2_H_ACT				GENMASK(28, 16)
#define MMSYS_PAT2_CTRL2				0x00000088
	#define PAT_2_FRM_SIZE_V			GENMASK(12, 0)
	#define PAT_2_FRM_SIZE_H			GENMASK(28, 16)
#define MMSYS_PAT2_CTRL3				0x0000008c
	#define PAT_2_COLOR_Y				GENMASK(9, 0)
	#define PAT_2_COLOR_U				GENMASK(25, 16)
#define MMSYS_PAT2_CTRL4				0x00000090
	#define PAT_2_COLOR_V				GENMASK(9, 0)
	#define PAT_2_BG_COLOR_Y			GENMASK(25, 16)
#define MMSYS_PAT2_CTRL5				0x00000094
	#define PAT_2_BG_COLOR_U			GENMASK(9, 0)
	#define PAT_2_BG_COLOR_V			GENMASK(25, 16)
#define MMSYS_PAT2_CTRL6				0x00000098
	#define PAT_2_POS_X				GENMASK(12, 0)
	#define PAT_2_POS_Y				GENMASK(28, 16)
#define MMSYS_PAT2_CTRL7				0x0000009c
	#define PAT_2_RAMP_H_STEP			GENMASK(9, 0)
	#define PAT_2_RAMP_H_WIDTH			GENMASK(28, 16)
#define MMSYS_PAT2_CTRL8				0x000000a0
	#define PAT_2_TILE_POS_X			GENMASK(12, 0)
	#define PAT_2_TILE_POS_Y			GENMASK(28, 16)
#define MMSYS_PAT2_CTRL9				0x000000a4
	#define PAT_2_TILE_OV_X				GENMASK(7, 0)
	#define PAT_2_TILE_OV_Y				GENMASK(15, 8)
#define MMSYS_PAT3_CTRL0				0x000000a8
	#define PAT_3_PAT_GEN_EN			BIT(0)
	#define PAT_3_CURSOR_SHOW			BIT(1)
	#define PAT_3_GRID_SHOW_EN			GENMASK(3, 2)
	#define PAT_3_GRID_SIZE				GENMASK(7, 4)
	#define PAT_3_RAMP_EN				GENMASK(10, 8)
	#define PAT_3_PAT_TYPE				GENMASK(23, 16)
	#define PAT_3_PAT_FORCE_VALID			BIT(31)
#define MMSYS_PAT3_CTRL1				0x000000ac
	#define PAT_3_V_ACT				GENMASK(12, 0)
	#define PAT_3_H_ACT				GENMASK(28, 16)
#define MMSYS_PAT3_CTRL2				0x000000b0
	#define PAT_3_FRM_SIZE_V			GENMASK(12, 0)
	#define PAT_3_FRM_SIZE_H			GENMASK(28, 16)
#define MMSYS_PAT3_CTRL3				0x000000b4
	#define PAT_3_COLOR_Y				GENMASK(9, 0)
	#define PAT_3_COLOR_U				GENMASK(25, 16)
#define MMSYS_PAT3_CTRL4				0x000000b8
	#define PAT_3_COLOR_V				GENMASK(9, 0)
	#define PAT_3_BG_COLOR_Y			GENMASK(25, 16)
#define MMSYS_PAT3_CTRL5				0x000000bc
	#define PAT_3_BG_COLOR_U			GENMASK(9, 0)
	#define PAT_3_BG_COLOR_V			GENMASK(25, 16)
#define MMSYS_PAT3_CTRL6				0x000000c0
	#define PAT_3_POS_X				GENMASK(12, 0)
	#define PAT_3_POS_Y				GENMASK(28, 16)
#define MMSYS_PAT3_CTRL7				0x000000c4
	#define PAT_3_RAMP_H_STEP			GENMASK(9, 0)
	#define PAT_3_RAMP_H_WIDTH			GENMASK(28, 16)
#define MMSYS_PAT3_CTRL8				0x000000c8
	#define PAT_3_TILE_POS_X			GENMASK(12, 0)
	#define PAT_3_TILE_POS_Y			GENMASK(28, 16)
#define MMSYS_PAT3_CTRL9				0x000000cc
	#define PAT_3_TILE_OV_X				GENMASK(7, 0)
	#define PAT_3_TILE_OV_Y				GENMASK(15, 8)
#define MMSYS_SLCR_MOUT_EN0				0x000000d0
	#define SLCR_MOUT0_EN				GENMASK(2, 0)
#define MMSYS_SLCR_MOUT_EN1				0x000000d4
	#define SLCR_MOUT1_EN				GENMASK(2, 0)
#define MMSYS_SLCR_MOUT_EN2				0x000000d8
	#define SLCR_MOUT2_EN				GENMASK(2, 0)
#define MMSYS_SLCR_MOUT_EN3				0x000000dc
	#define SLCR_MOUT3_EN				GENMASK(2, 0)
#define MMSYS_SLCR_MOUT_RST				0x000000e0
	#define SLCR_MOUT0_RST				BIT(0)
	#define SLCR_MOUT1_RST				BIT(1)
	#define SLCR_MOUT2_RST				BIT(2)
	#define SLCR_MOUT3_RST				BIT(3)
#define MMSYS_SLCR_MOUT_MASK				0x000000e4
	#define SLCR_MOUT0_MASK				GENMASK(2, 0)
	#define SLCR_MOUT1_MASK				GENMASK(6, 4)
	#define SLCR_MOUT2_MASK				GENMASK(10, 8)
	#define SLCR_MOUT3_MASK				GENMASK(14, 12)
#define MMSYS_RDMA_SMI_SEL				0x000000e8
	#define RDMA_SMI_SEL				BIT(0)
#define MMSYS_RDMA_IN_SEL0				0x000000ec
	#define RDMA_IN_SEL0				BIT(0)
#define MMSYS_RDMA_IN_SEL1				0x000000f0
	#define RDMA_IN_SEL1				BIT(0)
#define MMSYS_RDMA_IN_SEL2				0x000000f4
	#define RDMA_IN_SEL2				BIT(0)
#define MMSYS_RDMA_IN_SEL3				0x000000f8
	#define RDMA_IN_SEL3				BIT(0)
#define MMSYS_RDMA_OUT_SEL0				0x000000fc
	#define RDMA_OUT_SEL0				GENMASK(1, 0)
#define MMSYS_RDMA_OUT_SEL1				0x00000100
	#define RDMA_OUT_SEL1				GENMASK(1, 0)
#define MMSYS_RDMA_OUT_SEL2				0x00000104
	#define RDMA_OUT_SEL2				GENMASK(1, 0)
#define MMSYS_RDMA_OUT_SEL3				0x00000108
	#define RDMA_OUT_SEL3				GENMASK(1, 0)
#define MMSYS_RDMA_MOUT_EN0				0x0000010c
	#define RDMA_MOUT0_EN				GENMASK(1, 0)
#define MMSYS_RDMA_MOUT_EN1				0x00000110
	#define RDMA_MOUT1_EN				GENMASK(1, 0)
#define MMSYS_RDMA_MOUT_EN2				0x00000114
	#define RDMA_MOUT2_EN				GENMASK(1, 0)
#define MMSYS_RDMA_MOUT_EN3				0x00000118
	#define RDMA_MOUT3_EN				GENMASK(1, 0)
#define MMSYS_RDMA_MOUT_RST				0x0000011c
	#define RDMA_MOUT0_RST				BIT(0)
	#define RDMA_MOUT1_RST				BIT(1)
	#define RDMA_MOUT2_RST				BIT(2)
	#define RDMA_MOUT3_RST				BIT(3)
#define MMSYS_RDMA_MOUT_MASK				0x00000120
	#define RDMA_MOUT0_MASK				GENMASK(1, 0)
	#define RDMA_MOUT1_MASK				GENMASK(5, 4)
	#define RDMA_MOUT2_MASK				GENMASK(9, 8)
	#define RDMA_MOUT3_MASK				GENMASK(13, 12)
#define MMSYS_LHC_SEL0					0x00000124
	#define LHC_SEL0				BIT(0)
#define MMSYS_LHC_SEL1					0x00000128
	#define LHC_SEL1				BIT(0)
#define MMSYS_LHC_SEL2					0x0000012c
	#define LHC_SEL2				BIT(0)
#define MMSYS_LHC_SEL3					0x00000130
	#define LHC_SEL3				BIT(0)
#define MMSYS_LHC_SWAP_SEL0				0x00000134
	#define LHC0_SWAP_SEL				GENMASK(2, 0)
#define MMSYS_LHC_SWAP_SEL1				0x00000138
	#define LHC1_SWAP_SEL				GENMASK(2, 0)
#define MMSYS_LHC_SWAP_SEL2				0x0000013c
	#define LHC2_SWAP_SEL				GENMASK(2, 0)
#define MMSYS_LHC_SWAP_SEL3				0x00000140
	#define LHC3_SWAP_SEL				GENMASK(2, 0)
#define MMSYS_LHC_SWAP_RST				0x00000144
	#define LHC_SWAP_SW_RST				BIT(0)
#define MMSYS_LHC_SWAP_MASK				0x00000148
	#define LHC0_SWAP_MOUT_MASK			GENMASK(3, 0)
	#define LHC1_SWAP_MOUT_MASK			GENMASK(7, 4)
	#define LHC2_SWAP_MOUT_MASK			GENMASK(11, 8)
	#define LHC3_SWAP_MOUT_MASK			GENMASK(15, 12)
#define MMSYS_RSZ_MOUT_EN				0x0000014c
	#define RSZ_MOUT1_EN				GENMASK(1, 0)
#define MMSYS_RSZ_MOUT_RST				0x00000150
	#define RSZ_MOUT1_RST				BIT(0)
#define MMSYS_RSZ_MOUT_MASK				0x00000154
	#define RSZ_MOUT1_MASK				GENMASK(1, 0)
#define MMSYS_WDMA_SEL0					0x00000158
	#define WDMA_SEL0				BIT(0)
#define MMSYS_WDMA_SEL1					0x0000015c
	#define WDMA_SEL1				BIT(0)
#define MMSYS_WDMA_SEL2					0x00000160
	#define WDMA_SEL2				BIT(0)
#define MMSYS_WDMA_SEL3					0x00000164
	#define WDMA_SEL3				BIT(0)
#define MMSYS_DSC_MOUT_EN0				0x00000168
	#define DSC_MOUT0_EN				GENMASK(1, 0)
#define MMSYS_DSC_MOUT_EN1				0x0000016c
	#define DSC_MOUT1_EN				GENMASK(1, 0)
#define MMSYS_DSC_MOUT_EN2				0x00000170
	#define DSC_MOUT2_EN				GENMASK(1, 0)
#define MMSYS_DSC_MOUT_EN3				0x00000174
	#define DSC_MOUT3_EN				GENMASK(1, 0)
#define MMSYS_DSC_MOUT_RST				0x00000178
	#define DSC_MOUT0_RST				BIT(0)
	#define DSC_MOUT1_RST				BIT(1)
	#define DSC_MOUT2_RST				BIT(2)
	#define DSC_MOUT3_RST				BIT(3)
#define MMSYS_DSC_MOUT_MASK				0x0000017c
	#define DSC_MOUT0_MASK				GENMASK(1, 0)
	#define DSC_MOUT1_MASK				GENMASK(5, 4)
	#define DSC_MOUT2_MASK				GENMASK(9, 8)
	#define DSC_MOUT3_MASK				GENMASK(13, 12)
#define MMSYS_DSI_LANE_SWAP_SEL0			0x00000180
	#define DSI0_LANE_SWAP_SEL			GENMASK(2, 0)
#define MMSYS_DSI_LANE_SWAP_SEL1			0x00000184
	#define DSI1_LANE_SWAP_SEL			GENMASK(2, 0)
#define MMSYS_DSI_LANE_SWAP_SEL2			0x00000188
	#define DSI2_LANE_SWAP_SEL			GENMASK(2, 0)
#define MMSYS_DSI_LANE_SWAP_SEL3			0x0000018c
	#define DSI3_LANE_SWAP_SEL			GENMASK(2, 0)
#define MMSYS_DSI_LANE_SWAP_RST				0x00000190
	#define DSI_LANE_SWAP_SW_RST			BIT(0)
#define MMSYS_DSI_LANE_SWAP_MASK			0x00000194
	#define DSI0_LANE_SWAP_MOUT_MASK		GENMASK(3, 0)
	#define DSI1_LANE_SWAP_MOUT_MASK		GENMASK(7, 4)
	#define DSI2_LANE_SWAP_MOUT_MASK		GENMASK(11, 8)
	#define DSI3_LANE_SWAP_MOUT_MASK		GENMASK(15, 12)
#define MMSYS_FAKE_ENG0_CTRL0				0x00000198
	#define FAKE_ENG0_CON_0				GENMASK(27, 0)
	#define FAKE_ENG0_RESET				BIT(30)
	#define FAKE_ENG0_START				BIT(31)
#define MMSYS_FAKE_ENG0_CTRL1				0x0000019c
	#define FAKE_ENG0_CON_1				GENMASK(23, 0)
#define MMSYS_FAKE_ENG0_RD_ADDR				0x000001a0
	#define FAKE_ENG0_RD_ADDR			GENMASK(31, 0)
#define MMSYS_FAKE_ENG0_WR_ADDR				0x000001a4
	#define FAKE_ENG0_WR_ADDR			GENMASK(31, 0)
#define MMSYS_FAKE_ENG0_STATE				0x000001a8
	#define FAKE_ENG0_STATE				GENMASK(31, 0)
#define MMSYS_FAKE_ENG1_CTRL0				0x000001ac
	#define FAKE_ENG1_CON_0				GENMASK(27, 0)
	#define FAKE_ENG1_RESET				BIT(30)
	#define FAKE_ENG1_START				BIT(31)
#define MMSYS_FAKE_ENG1_CTRL1				0x000001b0
	#define FAKE_ENG1_CON_1				GENMASK(23, 0)
#define MMSYS_FAKE_ENG1_RD_ADDR				0x000001b4
	#define FAKE_ENG1_RD_ADDR			GENMASK(31, 0)
#define MMSYS_FAKE_ENG1_WR_ADDR				0x000001b8
	#define FAKE_ENG1_WR_ADDR			GENMASK(31, 0)
#define MMSYS_FAKE_ENG1_STATE				0x000001bc
	#define FAKE_ENG1_STATE				GENMASK(31, 0)
#define VSGEN_MUTEX_SEL					0x000001c0
	#define VSGEN_TO_MUTEX_SEL			GENMASK(2, 0)
	#define VSGEN_TO_TS_POL_SEL			BIT(16)
#define VSGEN_DSI_CTRL					0x000001c4
	#define VSGEN_DSI_SRC_SEL			GENMASK(1, 0)
	#define VSGEN_DSI_VSYNC_POL			BIT(16)
#define VSGEN_DSI_PERIOD_CNT_MON			0x000001c8
	#define VSGEN_DSI_PERIOD_CNT			GENMASK(31, 0)
#define VSGEN_DSI_DLY0_CTRL0				0x000001cc
	#define VSGEN_DLY0_ON_DELAY			GENMASK(31, 0)
#define VSGEN_DSI_DLY0_CTRL1				0x000001d0
	#define VSGEN_DLY0_ON_TIME			GENMASK(15, 0)
	#define VSGEN_DLY0_FRM_CONV_M			GENMASK(20, 16)
	#define VSGEN_DLY0_FRM_CONV_N			GENMASK(28, 24)
	#define VSGEN_DLY0_OUT_POL			BIT(30)
	#define VSGEN_DLY0_OUT_EN			BIT(31)
#define VSGEN_DSI_DLY0_CTRL2				0x000001d4
	#define VSGEN_DLY0_FRM_COV_PERIOD		GENMASK(31, 0)
#define VSGEN_DSI_DLY1_CTRL0				0x000001d8
#define VSGEN_DSI_DLY1_CTRL1				0x000001dc
#define VSGEN_DSI_DLY1_CTRL2				0x000001e0
#define VSGEN_DSI_DLY2_CTRL0				0x000001e4
#define VSGEN_DSI_DLY2_CTRL1				0x000001e8
#define VSGEN_DSI_DLY2_CTRL2				0x000001ec
#define VSGEN_DSI_DLY3_CTRL0				0x000001f0
#define VSGEN_DSI_DLY3_CTRL1				0x000001f4
#define VSGEN_DSI_DLY3_CTRL2				0x000001f8
#define VSGEN_DSI_DLY4_CTRL0				0x000001fc
#define VSGEN_DSI_DLY4_CTRL1				0x00000200
#define VSGEN_DSI_DLY4_CTRL2				0x00000204
#define MMSYS_DSI_TE_SEL				0x00000208
	#define DSI1_TE_SEL				BIT(1)
	#define DSI2_TE_SEL				BIT(2)
	#define DSI3_TE_SEL				BIT(3)
#define MMSYS_LCM_RST_B					0x0000020c
	#define LCM_RST_B				BIT(0)
	#define LCM1_RST_B				BIT(1)
	#define LCM2_RST_B				BIT(2)
	#define LCM3_RST_B				BIT(3)
#define MMSYS_SLCR_TO_DDDS_SELECT			0x00000210
	#define MMSYS_SLCR_TO_DDDS_SEL			BIT(0)
#define MMSYS_CRC_CTRL_EN				0x00000214
	#define MMSYS_CRC_EN				GENMASK(31, 0)
#define MMSYS_CRC_CTRL_CLR				0x00000218
	#define MMSYS_CRC_CLR				GENMASK(31, 0)
#define VSGEN_IRQ_CTRL					0x0000021c
	#define VSGEN_IRQ_EN				GENMASK(9, 0)
	#define VSGEN_IRQ_CLR				GENMASK(25, 16)
#define VSGEN_EVENT_CTRL				0x00000220
	#define VSGEN_EVENT_EN				GENMASK(9, 0)
#define VSGEN_IRQ_STATUS				0x00000224
	#define VSGEN_IRQ_STATUS_MON			GENMASK(9, 0)
#define MMSYS_DEBUG_CTRL				0x00000228
	#define MMSYS_DEBUG_OUT_BYTE_SEL0		GENMASK(1, 0)
	#define MMSYS_DEBUG_OUT_SEL0			GENMASK(7, 2)
	#define MMSYS_DEBUG_OUT_BYTE_SEL1		GENMASK(9, 8)
	#define MMSYS_DEBUG_OUT_SEL1			GENMASK(15, 10)
	#define MMSYS_DEBUG_OUT_BYTE_SEL2		GENMASK(17, 16)
	#define MMSYS_DEBUG_OUT_SEL2			GENMASK(23, 18)
	#define MMSYS_DEBUG_OUT_BYTE_SEL3		GENMASK(25, 24)
	#define MMSYS_DEBUG_OUT_SEL3			GENMASK(31, 26)
#define RDMA_CSC_CTRL					0x0000022c
	#define RDMA_CSC_BIT_LOCATION_SEL		BIT(0)
#define RDMA0_CSC_TRANSFORM_0				0x00000230
	#define RDMA0_CONV_ENG_ACTIVE			BIT(0)
	#define RDMA0_CONV_CLR				BIT(1)
	#define RDMA0_CONV_TRANS_EN			BIT(16)
	#define RDMA0_CONV_EXT_MATRIX_EN		BIT(20)
	#define RDMA0_CONV_INT_MATRIX_SEL		GENMASK(27, 24)
#define RDMA0_CSC_TRANSFORM_1				0x00000234
	#define RDMA0_CONV_EXT_C_00			GENMASK(14, 0)
	#define RDMA0_CONV_EXT_C_01			GENMASK(30, 16)
#define RDMA0_CSC_TRANSFORM_2				0x00000238
	#define RDMA0_CONV_EXT_C_02			GENMASK(14, 0)
	#define RDMA0_CONV_EXT_C_10			GENMASK(30, 16)
#define RDMA0_CSC_TRANSFORM_3				0x0000023c
	#define RDMA0_CONV_EXT_C_11			GENMASK(14, 0)
	#define RDMA0_CONV_EXT_C_12			GENMASK(30, 16)
#define RDMA0_CSC_TRANSFORM_4				0x00000240
	#define RDMA0_CONV_EXT_C_20			GENMASK(14, 0)
	#define RDMA0_CONV_EXT_C_21			GENMASK(30, 16)
#define RDMA0_CSC_TRANSFORM_5				0x00000244
	#define RDMA0_CONV_EXT_C_22			GENMASK(14, 0)
#define RDMA0_CSC_TRANSFORM_6				0x00000248
	#define RDMA0_CONV_EXT_IN_OFFSET_0		GENMASK(10, 0)
	#define RDMA0_CONV_EXT_IN_OFFSET_1		GENMASK(26, 16)
#define RDMA0_CSC_TRANSFORM_7				0x0000024c
	#define RDMA0_CONV_EXT_OUT_OFFSET_0		GENMASK(10, 0)
	#define RDMA0_CONV_EXT_OUT_OFFSET_1		GENMASK(26, 16)
#define RDMA0_CSC_TRANSFORM_8				0x00000250
	#define RDMA0_CONV_EXT_IN_OFFSET_2		GENMASK(10, 0)
	#define RDMA0_CONV_EXT_OUT_OFFSET_2		GENMASK(26, 16)
#define RDMA0_CSC_DITHER_CON				0x00000254
	#define RDMA0_CONV_DITHER_CEN			GENMASK(2, 0)
	#define RDMA0_CONV_DITHER_INIT_V_POS		GENMASK(5, 4)
	#define RDMA0_CONV_DITHER_INIT_H_POS		GENMASK(9, 8)
	#define RDMA0_CONV_DITHER_HSIZE			GENMASK(29, 16)
#define RDMA1_CSC_TRANSFORM_0				0x00000258
#define RDMA1_CSC_TRANSFORM_1				0x0000025c
#define RDMA1_CSC_TRANSFORM_2				0x00000260
#define RDMA1_CSC_TRANSFORM_3				0x00000264
#define RDMA1_CSC_TRANSFORM_4				0x00000268
#define RDMA1_CSC_TRANSFORM_5				0x0000026c
#define RDMA1_CSC_TRANSFORM_6				0x00000270
#define RDMA1_CSC_TRANSFORM_7				0x00000274
#define RDMA1_CSC_TRANSFORM_8				0x00000278
#define RDMA1_CSC_DITHER_CON				0x0000027c
#define RDMA2_CSC_TRANSFORM_0				0x00000280
#define RDMA2_CSC_TRANSFORM_1				0x00000284
#define RDMA2_CSC_TRANSFORM_2				0x00000288
#define RDMA2_CSC_TRANSFORM_3				0x0000028c
#define RDMA2_CSC_TRANSFORM_4				0x00000290
#define RDMA2_CSC_TRANSFORM_5				0x00000294
#define RDMA2_CSC_TRANSFORM_6				0x00000298
#define RDMA2_CSC_TRANSFORM_7				0x0000029c
#define RDMA2_CSC_TRANSFORM_8				0x000002a0
#define RDMA2_CSC_DITHER_CON				0x000002a4
#define RDMA3_CSC_TRANSFORM_0				0x000002a8
#define RDMA3_CSC_TRANSFORM_1				0x000002ac
#define RDMA3_CSC_TRANSFORM_2				0x000002b0
#define RDMA3_CSC_TRANSFORM_3				0x000002b4
#define RDMA3_CSC_TRANSFORM_4				0x000002b8
#define RDMA3_CSC_TRANSFORM_5				0x000002bc
#define RDMA3_CSC_TRANSFORM_6				0x000002c0
#define RDMA3_CSC_TRANSFORM_7				0x000002c4
#define RDMA3_CSC_TRANSFORM_8				0x000002c8
#define RDMA3_CSC_DITHER_CON				0x000002cc
#define MMSYS_CRC_OUT_0					0x000002d0
	#define MMSYS_CRC_OUT0				GENMASK(31, 0)
#define MMSYS_CRC_OUT_1					0x000002d4
	#define MMSYS_CRC_OUT1				GENMASK(31, 0)
#define MMSYS_CRC_OUT_2					0x000002d8
	#define MMSYS_CRC_OUT2				GENMASK(31, 0)
#define MMSYS_CRC_OUT_3					0x000002dc
	#define MMSYS_CRC_OUT3				GENMASK(31, 0)
#define MMSYS_CRC_OUT_4					0x000002e0
	#define MMSYS_CRC_OUT4				GENMASK(31, 0)
#define MMSYS_CRC_OUT_5					0x000002e4
	#define MMSYS_CRC_OUT5				GENMASK(31, 0)
#define MMSYS_CRC_OUT_6					0x000002e8
	#define MMSYS_CRC_OUT6				GENMASK(31, 0)
#define MMSYS_CRC_OUT_7					0x000002ec
	#define MMSYS_CRC_OUT7				GENMASK(31, 0)
#define MMSYS_CRC_OUT_8					0x000002f0
	#define MMSYS_CRC_OUT8				GENMASK(31, 0)
#define MMSYS_CRC_OUT_9					0x000002f4
	#define MMSYS_CRC_OUT9				GENMASK(31, 0)
#define MMSYS_CRC_OUT_10				0x000002f8
	#define MMSYS_CRC_OUT10				GENMASK(31, 0)
#define MMSYS_CRC_OUT_11				0x000002fc
	#define MMSYS_CRC_OUT11				GENMASK(31, 0)
#define MMSYS_CRC_OUT_12				0x00000300
	#define MMSYS_CRC_OUT12				GENMASK(31, 0)
#define MMSYS_CRC_OUT_13				0x00000304
	#define MMSYS_CRC_OUT13				GENMASK(31, 0)
#define MMSYS_CRC_OUT_14				0x00000308
	#define MMSYS_CRC_OUT14				GENMASK(31, 0)
#define MMSYS_CRC_OUT_15				0x0000030c
	#define MMSYS_CRC_OUT15				GENMASK(31, 0)
#define MMSYS_CRC_OUT_16				0x00000310
	#define MMSYS_CRC_OUT16				GENMASK(31, 0)
#define MMSYS_CRC_OUT_17				0x00000314
	#define MMSYS_CRC_OUT17				GENMASK(31, 0)
#define MMSYS_CRC_OUT_18				0x00000318
	#define MMSYS_CRC_OUT18				GENMASK(31, 0)
#define MMSYS_CRC_OUT_19				0x0000031c
	#define MMSYS_CRC_OUT19				GENMASK(31, 0)
#define MMSYS_CRC_OUT_20				0x00000320
	#define MMSYS_CRC_OUT20				GENMASK(31, 0)
#define MMSYS_CRC_OUT_21				0x00000324
	#define MMSYS_CRC_OUT21				GENMASK(31, 0)
#define MMSYS_CRC_OUT_22				0x00000328
	#define MMSYS_CRC_OUT22				GENMASK(31, 0)
#define MMSYS_CRC_OUT_23				0x0000032c
	#define MMSYS_CRC_OUT23				GENMASK(31, 0)
#define MMSYS_CRC_OUT_24				0x00000330
	#define MMSYS_CRC_OUT24				GENMASK(31, 0)
#define MMSYS_CRC_OUT_25				0x00000334
	#define MMSYS_CRC_OUT25				GENMASK(31, 0)
#define MMSYS_CRC_OUT_26				0x00000338
	#define MMSYS_CRC_OUT26				GENMASK(31, 0)
#define MMSYS_CRC_OUT_27				0x0000033c
	#define MMSYS_CRC_OUT27				GENMASK(31, 0)
#define MMSYS_CRC_OUT_28				0x00000340
	#define MMSYS_CRC_OUT28				GENMASK(31, 0)
#define MMSYS_CRC_OUT_29				0x00000344
	#define MMSYS_CRC_OUT29				GENMASK(31, 0)
#define MMSYS_CRC_OUT_30				0x00000348
	#define MMSYS_CRC_OUT30				GENMASK(31, 0)
#define MMSYS_CRC_OUT_31				0x0000034c
	#define MMSYS_CRC_OUT31				GENMASK(31, 0)
#define MMSYS_CRC_NUM_0					0x00000350
	#define MMSYS_NUM_OUT0				GENMASK(31, 0)
#define MMSYS_CRC_NUM_1					0x00000354
	#define MMSYS_NUM_OUT1				GENMASK(31, 0)
#define MMSYS_CRC_NUM_2					0x00000358
	#define MMSYS_NUM_OUT2				GENMASK(31, 0)
#define MMSYS_CRC_NUM_3					0x0000035c
	#define MMSYS_NUM_OUT3				GENMASK(31, 0)
#define MMSYS_CRC_NUM_4					0x00000360
	#define MMSYS_NUM_OUT4				GENMASK(31, 0)
#define MMSYS_CRC_NUM_5					0x00000364
	#define MMSYS_NUM_OUT5				GENMASK(31, 0)
#define MMSYS_CRC_NUM_6					0x00000368
	#define MMSYS_NUM_OUT6				GENMASK(31, 0)
#define MMSYS_CRC_NUM_7					0x0000036c
	#define MMSYS_NUM_OUT7				GENMASK(31, 0)
#define MMSYS_CRC_NUM_8					0x00000370
	#define MMSYS_NUM_OUT8				GENMASK(31, 0)
#define MMSYS_CRC_NUM_9					0x00000374
	#define MMSYS_NUM_OUT9				GENMASK(31, 0)
#define MMSYS_CRC_NUM_10				0x00000378
	#define MMSYS_NUM_OUT10				GENMASK(31, 0)
#define MMSYS_CRC_NUM_11				0x0000037c
	#define MMSYS_NUM_OUT11				GENMASK(31, 0)
#define MMSYS_CRC_NUM_12				0x00000380
	#define MMSYS_NUM_OUT12				GENMASK(31, 0)
#define MMSYS_CRC_NUM_13				0x00000384
	#define MMSYS_NUM_OUT13				GENMASK(31, 0)
#define MMSYS_CRC_NUM_14				0x00000388
	#define MMSYS_NUM_OUT14				GENMASK(31, 0)
#define MMSYS_CRC_NUM_15				0x0000038c
	#define MMSYS_NUM_OUT15				GENMASK(31, 0)
#define MMSYS_CRC_NUM_16				0x00000390
	#define MMSYS_NUM_OUT16				GENMASK(31, 0)
#define MMSYS_CRC_NUM_17				0x00000394
	#define MMSYS_NUM_OUT17				GENMASK(31, 0)
#define MMSYS_CRC_NUM_18				0x00000398
	#define MMSYS_NUM_OUT18				GENMASK(31, 0)
#define MMSYS_CRC_NUM_19				0x0000039c
	#define MMSYS_NUM_OUT19				GENMASK(31, 0)
#define MMSYS_CRC_NUM_20				0x000003a0
	#define MMSYS_NUM_OUT20				GENMASK(31, 0)
#define MMSYS_CRC_NUM_21				0x000003a4
	#define MMSYS_NUM_OUT21				GENMASK(31, 0)
#define MMSYS_CRC_NUM_22				0x000003a8
	#define MMSYS_NUM_OUT22				GENMASK(31, 0)
#define MMSYS_CRC_NUM_23				0x000003ac
	#define MMSYS_NUM_OUT23				GENMASK(31, 0)
#define MMSYS_CRC_NUM_24				0x000003b0
	#define MMSYS_NUM_OUT24				GENMASK(31, 0)
#define MMSYS_CRC_NUM_25				0x000003b4
	#define MMSYS_NUM_OUT25				GENMASK(31, 0)
#define MMSYS_CRC_NUM_26				0x000003b8
	#define MMSYS_NUM_OUT26				GENMASK(31, 0)
#define MMSYS_CRC_NUM_27				0x000003bc
	#define MMSYS_NUM_OUT27				GENMASK(31, 0)
#define MMSYS_CRC_NUM_28				0x000003c0
	#define MMSYS_NUM_OUT28				GENMASK(31, 0)
#define MMSYS_CRC_NUM_29				0x000003c4
	#define MMSYS_NUM_OUT29				GENMASK(31, 0)
#define MMSYS_CRC_NUM_30				0x000003c8
	#define MMSYS_NUM_OUT30				GENMASK(31, 0)
#define MMSYS_CRC_NUM_31				0x000003cc
	#define MMSYS_NUM_OUT31				GENMASK(31, 0)
#define MMSYS_MBIST_CTRL				0x00000500
	#define MBIST_LOAD_FUSE				BIT(0)
	#define MBIST_FUSE_SEL				BIT(1)
	#define MBIST_RPRST_B_REG			BIT(2)
	#define MBIST_RSTB_REG				BIT(3)
	#define MBIST_BACKGROUND			GENMASK(6, 4)
	#define MBIST_HDEN				BIT(8)
	#define MBIST_FAILOUT_SEL			GENMASK(31, 28)
#define MMSYS_MBIST_HOLDB0				0x00000504
	#define MBIST_HOLDB_0				GENMASK(31, 0)
#define MMSYS_MBIST_DEBUG				0x00000508
	#define MBIST_DEBUG				GENMASK(12, 0)
#define MMSYS_MBIST_MODE0				0x0000050c
	#define MBIST_MODE_0				GENMASK(31, 0)
#define MMSYS_MBIST_MODE1				0x00000510
	#define MBIST_MODE_1				GENMASK(31, 0)
#define MMSYS_MBIST_DONE0				0x00000514
	#define MBIST_DONE_0				GENMASK(31, 0)
#define MMSYS_MBIST_DONE1				0x00000518
	#define MBIST_DONE_1				GENMASK(31, 0)
#define MMSYS_MBIST_STATE				0x0000051c
	#define MBIST_DONE_AND_ALL			BIT(0)
	#define MBIST_FAIL_OR_ALL			BIT(1)
	#define MBIST_DIAG_SCANOUT_OR_ALL		BIT(2)
	#define MBIST_DIAG_SCANOUT			GENMASK(28, 4)
#define MMSYS_MBIST_FAIL0				0x00000520
	#define MBIST_FAIL_0				GENMASK(31, 0)
#define MMSYS_MBIST_FAIL1				0x00000524
	#define MBIST_FAIL_1				GENMASK(31, 0)
#define MMSYS_MBIST_FAIL2				0x00000528
	#define MBIST_FAIL_2				GENMASK(31, 0)
#define MMSYS_MBIST_FAIL3				0x0000052c
	#define MBIST_FAIL_3				GENMASK(31, 0)
#define MMSYS_MBIST_FAIL4				0x00000530
	#define MBIST_FAIL_4				GENMASK(31, 0)
#define MMSYS_MBIST_FAIL5				0x00000534
	#define MBIST_FAIL_5				GENMASK(31, 0)
#define MMSYS_MBIST_PRE_FUSE0				0x00000538
	#define MBIST_PRE_FUSE_REG_0_MON		GENMASK(31, 0)
#define MMSYS_MBIST_PRE_FUSE1				0x0000053c
	#define MBIST_PRE_FUSE_REG_1_MON		GENMASK(31, 0)
#define MMSYS_MBIST_BSEL0				0x00000540
	#define LHC0_MBIST_BSEL				GENMASK(7, 0)
	#define LHC1_MBIST_BSEL				GENMASK(15, 8)
	#define LHC2_MBIST_BSEL				GENMASK(23, 16)
	#define LHC3_MBIST_BSEL				GENMASK(31, 24)
#define MMSYS_MBIST_BSEL1				0x00000544
	#define RSZ0_BSEL				GENMASK(14, 0)
	#define RSZ1_BSEL				GENMASK(30, 16)
#define MMSYS_MBIST_BSEL2				0x00000548
	#define DISP_WDMA0_STANDALONE_MBIST_BSEL	GENMASK(15, 0)
	#define DISP_WDMA1_STANDALONE_MBIST_BSEL	GENMASK(31, 16)
#define MMSYS_MBIST_BSEL3				0x0000054c
	#define DISP_WDMA2_STANDALONE_MBIST_BSEL	GENMASK(15, 0)
	#define DISP_WDMA3_STANDALONE_MBIST_BSEL	GENMASK(31, 16)
#define MMSYS_MBIST_BSEL4				0x00000550
	#define MDP_RDMA0_MBIST_BSEL			GENMASK(4, 0)
	#define MDP_RDMA1_MBIST_BSEL			GENMASK(12, 8)
	#define MDP_RDMA2_MBIST_BSEL			GENMASK(20, 16)
	#define MDP_RDMA3_MBIST_BSEL			GENMASK(28, 24)
#define MMSYS_MBIST_DELSEL0				0x00000554
	#define SLCR_VUPS_MBIST_DELSEL			GENMASK(5, 0)
	#define SLCR_VID_BUFFER_MBIST_DELSEL		GENMASK(13, 8)
	#define SLCR_DSC_BUFFER_MBIST_DELSEL		GENMASK(21, 16)
#define MMSYS_MBIST_DELSEL1				0x00000558
	#define LHC0_MBIST_DELSEL			GENMASK(5, 0)
	#define LHC1_MBIST_DELSEL			GENMASK(13, 8)
	#define LHC2_MBIST_DELSEL			GENMASK(21, 16)
	#define LHC3_MBIST_DELSEL			GENMASK(29, 24)
#define MMSYS_MBIST_DELSEL2				0x0000055c
	#define RSZ0_DELSEL				GENMASK(5, 0)
	#define RSZ1_DELSEL				GENMASK(13, 8)
	#define P2S0_MBIST_DELSEL			GENMASK(21, 16)
#define MMSYS_MBIST_DELSEL3				0x00000560
	#define DSC0_DELSEL_0				GENMASK(5, 0)
	#define DSC0_DELSEL_1				GENMASK(13, 8)
	#define DSC0_DELSEL_2				GENMASK(21, 16)
	#define DSC0_DELSEL_3				GENMASK(29, 24)
#define MMSYS_MBIST_DELSEL4				0x00000564
	#define DSC1_DELSEL_0				GENMASK(5, 0)
	#define DSC1_DELSEL_1				GENMASK(13, 8)
	#define DSC1_DELSEL_2				GENMASK(21, 16)
	#define DSC1_DELSEL_3				GENMASK(29, 24)
#define MMSYS_MBIST_DELSEL5				0x00000568
	#define DSI0_DELSEL				GENMASK(9, 0)
	#define DSI1_DELSEL				GENMASK(25, 16)
#define MMSYS_MBIST_DELSEL6				0x0000056c
	#define DSI2_DELSEL				GENMASK(9, 0)
	#define DSI3_DELSEL				GENMASK(25, 16)
#define MMSYS_MBIST_DELSEL7				0x00000570
	#define DSI0_FIFO_DELSEL			GENMASK(5, 0)
	#define DSI1_FIFO_DELSEL			GENMASK(13, 8)
	#define DSI2_FIFO_DELSEL			GENMASK(21, 16)
	#define DSI3_FIFO_DELSEL			GENMASK(29, 24)
#define MMSYS_MBIST_DELSEL8				0x00000574
	#define DISP_WDMA0_MEM_DELSEL			GENMASK(23, 0)
#define MMSYS_MBIST_DELSEL9				0x00000578
	#define DISP_WDMA1_MEM_DELSEL			GENMASK(23, 0)
#define MMSYS_MBIST_DELSEL10				0x0000057c
	#define DISP_WDMA2_MEM_DELSEL			GENMASK(23, 0)
#define MMSYS_MBIST_DELSEL11				0x00000580
	#define DISP_WDMA3_MEM_DELSEL			GENMASK(23, 0)
#define MMSYS_MBIST_DELSEL12				0x00000584
	#define MDP_RDMA0_MEM_DELSEL			GENMASK(11, 0)
	#define MDP_RDMA1_MEM_DELSEL			GENMASK(27, 16)
#define MMSYS_MBIST_DELSEL13				0x00000588
	#define MDP_RDMA2_MEM_DELSEL			GENMASK(11, 0)
	#define MDP_RDMA3_MEM_DELSEL			GENMASK(27, 16)
#define MMSYS_MBIST_DELSEL14				0x0000058c
	#define MDP_RDMA_PVRIC0_0_LSB_DELSEL		GENMASK(29, 0)
#define MMSYS_MBIST_DELSEL15				0x00000590
	#define MDP_RDMA_PVRIC1_0_LSB_DELSEL		GENMASK(29, 0)
#define MMSYS_MBIST_DELSEL16				0x00000594
	#define MDP_RDMA_PVRIC2_0_LSB_DELSEL		GENMASK(29, 0)
#define MMSYS_MBIST_DELSEL17				0x00000598
	#define MDP_RDMA_PVRIC3_0_LSB_DELSEL		GENMASK(29, 0)
#define MMSYS_MBIST_DELSEL18				0x0000059c
	#define MDP_RDMA_PVRIC0_0_MSB_DELSEL		GENMASK(5, 0)
#define MMSYS_MBIST_DELSEL19				0x000005a0
	#define MDP_RDMA_PVRIC1_0_MSB_DELSEL		GENMASK(5, 0)
#define MMSYS_MBIST_DELSEL20				0x000005a4
	#define MDP_RDMA_PVRIC2_0_MSB_DELSEL		GENMASK(5, 0)
#define MMSYS_MBIST_DELSEL21				0x000005a8
	#define MDP_RDMA_PVRIC3_0_MSB_DELSEL		GENMASK(5, 0)
#define MMSYS_MBIST_DELSEL22				0x000005ac
	#define MDP_RDMA_PVRIC0_1_DELSEL		GENMASK(17, 0)
#define MMSYS_MBIST_DELSEL23				0x000005b0
	#define MDP_RDMA_PVRIC1_1_DELSEL		GENMASK(17, 0)
#define MMSYS_MBIST_DELSEL24				0x000005b4
	#define MDP_RDMA_PVRIC2_1_DELSEL		GENMASK(17, 0)
#define MMSYS_MBIST_DELSEL25				0x000005b8
	#define MDP_RDMA_PVRIC3_1_DELSEL		GENMASK(17, 0)
#define MMSYS_MBIST_DELSEL26				0x000005bc
	#define MDP_RDMA_PVRIC0_LINEBUFFER_DELSEL	GENMASK(11, 0)
#define MMSYS_MBIST_DELSEL27				0x000005c0
	#define MDP_RDMA_PVRIC1_LINEBUFFER_DELSEL	GENMASK(27, 16)
#define MMSYS_MBIST_DELSEL28				0x000005c4
	#define MDP_RDMA_PVRIC2_LINEBUFFER_DELSEL	GENMASK(11, 0)
#define MMSYS_MBIST_DELSEL29				0x000005c8
	#define MDP_RDMA_PVRIC3_LINEBUFFER_DELSEL	GENMASK(27, 16)
#define MMSYS_MBIST_RP_OK_0				0x000005cc
	#define MMSYS_MBIST_RP_OK_0_MON			GENMASK(31, 0)
#define MMSYS_MBIST_RP_OK_1				0x000005d0
	#define MMSYS_MBIST_RP_OK_1_MON			GENMASK(31, 0)
#define MMSYS_MBIST_RP_OK_2				0x000005d4
	#define MMSYS_MBIST_RP_OK_2_MON			GENMASK(18, 0)
#define MMSYS_MBIST_RP_FAIL_0				0x000005d8
	#define MMSYS_MBIST_RP_FAIL_0_MON		GENMASK(31, 0)
#define MMSYS_MBIST_RP_FAIL_1				0x000005dc
	#define MMSYS_MBIST_RP_FAIL_1_MON		GENMASK(31, 0)
#define MMSYS_MBIST_RP_FAIL_2				0x000005e0
	#define MMSYS_MBIST_RP_FAIL_2_MON		GENMASK(18, 0)
#define MMSYS_EVENT_MON					0x00000600
	#define MMSYS_CORE_EVENT_ID_MON			GENMASK(8, 0)
	#define MMSYS_CORE_EVENT_READY_MON		BIT(16)
	#define MMSYS_CORE_EVENT_VALID_MON		BIT(24)
#define MMSYS_CAM_VSYNC_EVENT_MON			0x00000604
	#define MMSYS_CORE_CAM_VSYNC_EVENT_ID_MON	GENMASK(3, 0)
	#define MMSYS_CORE_CAM_VSYNC_EVENT_READY_MON	BIT(16)
	#define MMSYS_CORE_CAM_VSYNC_EVENT_VALID_MON	BIT(24)
#define MMSYS_DATA_PATH_MON0				0x00000608
	#define DP_VID_VS				BIT(0)
	#define DP_VID_HS				BIT(1)
	#define DP_VID_DE				BIT(2)
	#define DP_VID_ST				BIT(3)
	#define DP_VID_MUTE				BIT(4)
	#define DP_VID_VS_DDDS				BIT(5)
	#define DP_VID_HS_DDDS				BIT(6)
	#define DP_DSC_VS				BIT(8)
	#define DP_DSC_HS				BIT(9)
	#define DP_DSC_DE				BIT(10)
	#define DP_DSC_ST				BIT(11)
	#define DP_DSC_MUTE				BIT(12)
	#define DP_DSC_VS_DDDS				BIT(13)
	#define DP_DSC_HS_DDDS				BIT(14)
	#define SLCR_VID_VS_X				BIT(16)
	#define SLCR_VID_HS_X				BIT(17)
	#define SLCR_VID_ST_X				BIT(18)
	#define SLCR_VID_MUTE_X				BIT(19)
	#define SLCR_DSC_VS_X				BIT(24)
	#define SLCR_DSC_HS_X				BIT(25)
	#define SLCR_DSC_ST_X				BIT(26)
	#define SLCR_DSC_MUTE_X				BIT(27)
#define MMSYS_DATA_PATH_MON1				0x0000060c
	#define SLCR_DSC_0_VLD				BIT(0)
	#define SLCR_DSC_0_RDY				BIT(1)
	#define SLCR_DSC_1_VLD				BIT(2)
	#define SLCR_DSC_1_RDY				BIT(3)
	#define SLCR_DSC_2_VLD				BIT(4)
	#define SLCR_DSC_2_RDY				BIT(5)
	#define SLCR_DSC_3_VLD				BIT(6)
	#define SLCR_DSC_3_RDY				BIT(7)
	#define SLCR_VID_0_VLD				BIT(8)
	#define SLCR_VID_0_RDY				BIT(9)
	#define SLCR_VID_1_VLD				BIT(10)
	#define SLCR_VID_1_RDY				BIT(11)
	#define SLCR_VID_2_VLD				BIT(12)
	#define SLCR_VID_2_RDY				BIT(13)
	#define SLCR_VID_3_VLD				BIT(14)
	#define SLCR_VID_3_RDY				BIT(15)
#define MMSYS_DATA_PATH_MON2				0x00000610
	#define SLCR_VID_0_TO_RDMA_VALID		BIT(0)
	#define SLCR_VID_0_TO_RDMA_READY		BIT(1)
	#define SLCR_VID_1_TO_RDMA_VALID		BIT(2)
	#define SLCR_VID_1_TO_RDMA_READY		BIT(3)
	#define SLCR_VID_2_TO_RDMA_VALID		BIT(4)
	#define SLCR_VID_2_TO_RDMA_READY		BIT(5)
	#define SLCR_VID_3_TO_RDMA_VALID		BIT(6)
	#define SLCR_VID_3_TO_RDMA_READY		BIT(7)
	#define SLCR_VID_0_TO_LHC_VALID			BIT(8)
	#define SLCR_VID_0_TO_LHC_READY			BIT(9)
	#define SLCR_VID_1_TO_LHC_VALID			BIT(10)
	#define SLCR_VID_1_TO_LHC_READY			BIT(11)
	#define SLCR_VID_2_TO_LHC_VALID			BIT(12)
	#define SLCR_VID_2_TO_LHC_READY			BIT(13)
	#define SLCR_VID_3_TO_LHC_VALID			BIT(14)
	#define SLCR_VID_3_TO_LHC_READY			BIT(15)
	#define SLCR_VID_0_TO_CROP_VALID		BIT(16)
	#define SLCR_VID_0_TO_CROP_READY		BIT(17)
	#define SLCR_VID_1_TO_CROP_VALID		BIT(18)
	#define SLCR_VID_1_TO_CROP_READY		BIT(19)
	#define SLCR_VID_2_TO_CROP_VALID		BIT(20)
	#define SLCR_VID_2_TO_CROP_READY		BIT(21)
	#define SLCR_VID_3_TO_CROP_VALID		BIT(22)
	#define SLCR_VID_3_TO_CROP_READY		BIT(23)
#define MMSYS_DATA_PATH_MON3				0x00000614
	#define RDMA_IN_0_VALID				BIT(0)
	#define RDMA_IN_0_READY				BIT(1)
	#define RDMA_IN_1_VALID				BIT(2)
	#define RDMA_IN_1_READY				BIT(3)
	#define RDMA_IN_2_VALID				BIT(4)
	#define RDMA_IN_2_READY				BIT(5)
	#define RDMA_IN_3_VALID				BIT(6)
	#define RDMA_IN_3_READY				BIT(7)
	#define MDP_RDMA_OUT_0_VALID			BIT(8)
	#define MDP_RDMA_OUT_0_READY			BIT(9)
	#define MDP_RDMA_OUT_1_VALID			BIT(10)
	#define MDP_RDMA_OUT_1_READY			BIT(11)
	#define MDP_RDMA_OUT_2_VALID			BIT(12)
	#define MDP_RDMA_OUT_2_READY			BIT(13)
	#define MDP_RDMA_OUT_3_VALID			BIT(14)
	#define MDP_RDMA_OUT_3_READY			BIT(15)
	#define MDP_RDMA_PVRIC_OUT_0_VALID		BIT(16)
	#define MDP_RDMA_PVRIC_OUT_0_READY		BIT(17)
	#define MDP_RDMA_PVRIC_OUT_1_VALID		BIT(18)
	#define MDP_RDMA_PVRIC_OUT_1_READY		BIT(19)
	#define MDP_RDMA_PVRIC_OUT_2_VALID		BIT(20)
	#define MDP_RDMA_PVRIC_OUT_2_READY		BIT(21)
	#define MDP_RDMA_PVRIC_OUT_3_VALID		BIT(22)
	#define MDP_RDMA_PVRIC_OUT_3_READY		BIT(23)
	#define DISP_RDMA_OUT_0_VALID			BIT(24)
	#define DISP_RDMA_OUT_0_READY			BIT(25)
	#define DISP_RDMA_OUT_1_VALID			BIT(26)
	#define DISP_RDMA_OUT_1_READY			BIT(27)
	#define DISP_RDMA_OUT_2_VALID			BIT(28)
	#define DISP_RDMA_OUT_2_READY			BIT(29)
	#define DISP_RDMA_OUT_3_VALID			BIT(30)
	#define DISP_RDMA_OUT_3_READY			BIT(31)
#define MMSYS_DATA_PATH_MON4				0x00000618
	#define RDMA_OUT_0_VALID			BIT(0)
	#define RDMA_OUT_0_READY			BIT(1)
	#define RDMA_OUT_1_VALID			BIT(2)
	#define RDMA_OUT_1_READY			BIT(3)
	#define RDMA_OUT_2_VALID			BIT(4)
	#define RDMA_OUT_2_READY			BIT(5)
	#define RDMA_OUT_3_VALID			BIT(6)
	#define RDMA_OUT_3_READY			BIT(7)
	#define RDMA_CSC_0_VALID			BIT(8)
	#define RDMA_CSC_0_READY			BIT(9)
	#define RDMA_CSC_1_VALID			BIT(10)
	#define RDMA_CSC_1_READY			BIT(11)
	#define RDMA_CSC_2_VALID			BIT(12)
	#define RDMA_CSC_2_READY			BIT(13)
	#define RDMA_CSC_3_VALID			BIT(14)
	#define RDMA_CSC_3_READY			BIT(15)
	#define RDMA_0_TO_PAT_VALID			BIT(16)
	#define RDMA_0_TO_PAT_READY			BIT(17)
	#define RDMA_1_TO_PAT_VALID			BIT(18)
	#define RDMA_1_TO_PAT_READY			BIT(19)
	#define RDMA_2_TO_PAT_VALID			BIT(20)
	#define RDMA_2_TO_PAT_READY			BIT(21)
	#define RDMA_3_TO_PAT_VALID			BIT(22)
	#define RDMA_3_TO_PAT_READY			BIT(23)
	#define RDMA_0_TO_LHC_VALID			BIT(24)
	#define RDMA_0_TO_LHC_READY			BIT(25)
	#define RDMA_1_TO_LHC_VALID			BIT(26)
	#define RDMA_1_TO_LHC_READY			BIT(27)
	#define RDMA_2_TO_LHC_VALID			BIT(28)
	#define RDMA_2_TO_LHC_READY			BIT(29)
	#define RDMA_3_TO_LHC_VALID			BIT(30)
	#define RDMA_3_TO_LHC_READY			BIT(31)
#define MMSYS_DATA_PATH_MON5				0x0000061c
	#define PAT_0_TO_DSC_VALID			BIT(0)
	#define PAT_0_TO_DSC_READY			BIT(1)
	#define PAT_1_TO_DSC_VALID			BIT(2)
	#define PAT_1_TO_DSC_READY			BIT(3)
	#define PAT_2_TO_DSC_VALID			BIT(4)
	#define PAT_2_TO_DSC_READY			BIT(5)
	#define PAT_3_TO_DSC_VALID			BIT(6)
	#define PAT_3_TO_DSC_READY			BIT(7)
	#define LHC_IN_0_VALID				BIT(8)
	#define LHC_IN_0_READY				BIT(9)
	#define LHC_IN_1_VALID				BIT(10)
	#define LHC_IN_1_READY				BIT(11)
	#define LHC_IN_2_VALID				BIT(12)
	#define LHC_IN_2_READY				BIT(13)
	#define LHC_IN_3_VALID				BIT(14)
	#define LHC_IN_3_READY				BIT(15)
	#define LHC_SEL_OUT_0_VALID			BIT(16)
	#define LHC_SEL_OUT_0_READY			BIT(17)
	#define LHC_SEL_OUT_1_VALID			BIT(18)
	#define LHC_SEL_OUT_1_READY			BIT(19)
	#define LHC_SEL_OUT_2_VALID			BIT(20)
	#define LHC_SEL_OUT_2_READY			BIT(21)
	#define LHC_SEL_OUT_3_VALID			BIT(22)
	#define LHC_SEL_OUT_3_READY			BIT(23)
#define MMSYS_DATA_PATH_MON6				0x00000620
	#define CROP_0_TO_RSZ_VALID			BIT(0)
	#define CROP_0_TO_RSZ_READY			BIT(1)
	#define CROP_1_TO_RSZ_VALID			BIT(2)
	#define CROP_1_TO_RSZ_READY			BIT(3)
	#define RSZ_0_TO_P2S_0_VALID			BIT(4)
	#define RSZ_0_TO_P2S_0_READY			BIT(5)
	#define RSZ_OUT_1_VALID				BIT(6)
	#define RSZ_OUT_1_READY				BIT(7)
	#define RSZ_1_TO_P2S_0_VALID			BIT(8)
	#define RSZ_1_TO_P2S_0_READY			BIT(9)
	#define P2S_0_TO_WDMA_VALID			BIT(16)
	#define P2S_0_TO_WDMA_READY			BIT(17)
	#define RSZ_1_TO_WDMA_VALID			BIT(18)
	#define RSZ_1_TO_WDMA_READY			BIT(19)
	#define CROP_2_TO_WDMA_VALID			BIT(20)
	#define CROP_2_TO_WDMA_READY			BIT(21)
	#define CROP_3_TO_WDMA_VALID			BIT(22)
	#define CROP_3_TO_WDMA_READY			BIT(23)
#define MMSYS_DATA_PATH_MON8				0x00000628
	#define WDMA_IN_0_VALID				BIT(0)
	#define WDMA_IN_0_READY				BIT(1)
	#define WDMA_IN_1_VALID				BIT(2)
	#define WDMA_IN_1_READY				BIT(3)
	#define WDMA_IN_2_VALID				BIT(4)
	#define WDMA_IN_2_READY				BIT(5)
	#define WDMA_IN_3_VALID				BIT(6)
	#define WDMA_IN_3_READY				BIT(7)
	#define DSC_OUT_0_VALID				BIT(8)
	#define DSC_OUT_0_READY				BIT(9)
	#define DSC_OUT_1_VALID				BIT(10)
	#define DSC_OUT_1_READY				BIT(11)
	#define DSC_OUT_2_VALID				BIT(12)
	#define DSC_OUT_2_READY				BIT(13)
	#define DSC_OUT_3_VALID				BIT(14)
	#define DSC_OUT_3_READY				BIT(15)
	#define DSC_0_TO_WDMA_VALID			BIT(16)
	#define DSC_0_TO_WDMA_READY			BIT(17)
	#define DSC_1_TO_WDMA_VALID			BIT(18)
	#define DSC_1_TO_WDMA_READY			BIT(19)
	#define DSC_2_TO_WDMA_VALID			BIT(20)
	#define DSC_2_TO_WDMA_READY			BIT(21)
	#define DSC_3_TO_WDMA_VALID			BIT(22)
	#define DSC_3_TO_WDMA_READY			BIT(23)
	#define DSC_0_TO_DSI_SWAP_VALID			BIT(24)
	#define DSC_0_TO_DSI_SWAP_READY			BIT(25)
	#define DSC_1_TO_DSI_SWAP_VALID			BIT(26)
	#define DSC_1_TO_DSI_SWAP_READY			BIT(27)
	#define DSC_2_TO_DSI_SWAP_VALID			BIT(28)
	#define DSC_2_TO_DSI_SWAP_READY			BIT(29)
	#define DSC_3_TO_DSI_SWAP_VALID			BIT(30)
	#define DSC_3_TO_DSI_SWAP_READY			BIT(31)
#define MMSYS_DATA_PATH_MON9				0x0000062c
	#define DSI_SWAP_0_TO_DIGITAL_VALID		BIT(0)
	#define DSI_SWAP_0_TO_DIGITAL_READY		BIT(1)
	#define DSI_SWAP_1_TO_DIGITAL_VALID		BIT(2)
	#define DSI_SWAP_1_TO_DIGITAL_READY		BIT(3)
	#define DSI_SWAP_2_TO_DIGITAL_VALID		BIT(4)
	#define DSI_SWAP_2_TO_DIGITAL_READY		BIT(5)
	#define DSI_SWAP_3_TO_DIGITAL_VALID		BIT(6)
	#define DSI_SWAP_3_TO_DIGITAL_READY		BIT(7)
#define MMSYS_RESERVE_MON				0x00000fdc
	#define RESERVE_DUMMY_OUT			GENMASK(31, 0)
#define MMSYS_RESERVE_0					0x00000fe0
	#define RESERVE_REG_A				GENMASK(31, 0)
#define MMSYS_RESERVE_1					0x00000fe4
	#define RESERVE_REG_B				GENMASK(31, 0)
#define MMSYS_RESERVE_2					0x00000fe8
	#define RESERVE_REG_C				GENMASK(31, 0)
#define MMSYS_RESERVE_3					0x00000fec
	#define RESERVE_REG_D				GENMASK(31, 0)
#define MMSYS_CTRL_ATPG					0x00000ff0
	#define MMSYS_CORE_TOP_ATPG_CT			BIT(0)
	#define MMSYS_CORE_TOP_ATPG_OB			BIT(1)

#endif /*__MTK_MMSYS_CFG_REG_H__*/
