#################################################################
# Makefile generated by Xilinx Platform Studio 
# Project:E:\Dev\FreeRTOS\Demo\MicroBlaze\system.xmp
#################################################################

XILINX_EDK_DIR = C:/devtools/xilinx/EDK

SYSTEM = system

MHSFILE = system.mhs

MSSFILE = system.mss

FPGA_ARCH = virtex4

DEVICE = xc4vfx12ff668-10

LANGUAGE = vhdl

SEARCHPATHOPT = 

SUBMODULE_OPT = 

PLATGEN_OPTIONS = -p $(DEVICE) -lang $(LANGUAGE) $(SEARCHPATHOPT) $(SUBMODULE_OPT)

LIBGEN_OPTIONS = -mhs $(MHSFILE) -p $(DEVICE) $(SEARCHPATHOPT) \
                   $(MICROBLAZE_0_LIBG_OPT)

VPGEN_OPTIONS = -p $(DEVICE) $(SEARCHPATHOPT)

RTOSDEMO_OUTPUT_DIR = RTOSDemo
RTOSDEMO_OUTPUT = $(RTOSDEMO_OUTPUT_DIR)/executable.elf

MICROBLAZE_BOOTLOOP = $(XILINX_EDK_DIR)/sw/lib/microblaze/mb_bootloop.elf
PPC405_BOOTLOOP = $(XILINX_EDK_DIR)/sw/lib/ppc405/ppc_bootloop.elf
BOOTLOOP_DIR = bootloops

MICROBLAZE_0_BOOTLOOP = $(BOOTLOOP_DIR)/microblaze_0.elf
MICROBLAZE_0_XMDSTUB = microblaze_0/code/xmdstub.elf

BRAMINIT_ELF_FILES =  $(RTOSDEMO_OUTPUT) 
BRAMINIT_ELF_FILE_ARGS =   -pe microblaze_0 $(RTOSDEMO_OUTPUT) 

ALL_USER_ELF_FILES = $(RTOSDEMO_OUTPUT) 

SIM_CMD = vsim

BEHAVIORAL_SIM_SCRIPT = simulation/behavioral/$(SYSTEM).do

STRUCTURAL_SIM_SCRIPT = simulation/structural/$(SYSTEM).do

TIMING_SIM_SCRIPT = simulation/timing/$(SYSTEM).do

DEFAULT_SIM_SCRIPT = $(BEHAVIORAL_SIM_SCRIPT)

MIX_LANG_SIM_OPT = -mixed yes

SIMGEN_OPTIONS = -p $(DEVICE) -lang $(LANGUAGE) $(SEARCHPATHOPT) $(SUBMODULE_OPT) $(BRAMINIT_ELF_FILE_ARGS) $(MIX_LANG_SIM_OPT)  -s mti

MICROBLAZE_0_XMDSTUB = microblaze_0/code/xmdstub.elf

LIBRARIES =  \
       microblaze_0/lib/libxil.a 
VPEXEC = virtualplatform/vpexec.exe

LIBSCLEAN_TARGETS = microblaze_0_libsclean 

PROGRAMCLEAN_TARGETS = RTOSDemo_programclean 

CORE_STATE_DEVELOPMENT_FILES = 

WRAPPER_NGC_FILES = implementation/microblaze_0_wrapper.ngc \
implementation/mb_opb_wrapper.ngc \
implementation/debug_module_wrapper.ngc \
implementation/ilmb_wrapper.ngc \
implementation/dlmb_wrapper.ngc \
implementation/dlmb_cntlr_wrapper.ngc \
implementation/ilmb_cntlr_wrapper.ngc \
implementation/lmb_bram_wrapper.ngc \
implementation/rs232_uart_wrapper.ngc \
implementation/leds_4bit_wrapper.ngc \
implementation/leds_positions_wrapper.ngc \
implementation/opb_timer_1_wrapper.ngc \
implementation/opb_intc_0_wrapper.ngc \
implementation/dcm_0_wrapper.ngc

POSTSYN_NETLIST = implementation/$(SYSTEM).ngc

SYSTEM_BIT = implementation/$(SYSTEM).bit

DOWNLOAD_BIT = implementation/download.bit

SYSTEM_ACE = implementation/$(SYSTEM).ace

UCF_FILE = data/system.ucf

BMM_FILE = implementation/$(SYSTEM).bmm

FASTRUNTIME_OPT_FILE = etc/fast_runtime.opt
BITGEN_UT_FILE = etc/bitgen.ut

#################################################################
# SOFTWARE APPLICATION RTOSDEMO
#################################################################

RTOSDEMO_SOURCES = main.c ParTest/ParTest.c ../../Source/tasks.c ../../Source/queue.c ../../Source/list.c ../../Source/portable/MemMang/heap_1.c ../../Source/portable/GCC/MicroBlaze/port.c ../../Source/portable/GCC/MicroBlaze/portasm.s ../Common/Minimal/flash.c serial/serial.c ../Common/Minimal/comtest.c ../Common/Minimal/integer.c ../Common/Minimal/semtest.c ../Common/Minimal/dynamic.c ../Common/Minimal/PollQ.c ../Common/Minimal/BlockQ.c 

RTOSDEMO_HEADERS = FreeRTOSConfig.h 

RTOSDEMO_CC = mb-gcc
RTOSDEMO_CC_SIZE = mb-size
RTOSDEMO_CC_OPT = -Os
RTOSDEMO_CFLAGS = -D MICROBLAZE_GCC -Wall
RTOSDEMO_CC_SEARCH = # -B
RTOSDEMO_LIBPATH = -L./microblaze_0/lib/ # -L
RTOSDEMO_INCLUDES = -I./microblaze_0/include/  -IDev/FreeRTOS/Demo/MicroBlaze/   -I. -I../Common/include -I../../Source/include -I../../Source/portable/GCC/MicroBlaze 
RTOSDEMO_LFLAGS = # -l
RTOSDEMO_CC_PREPROC_FLAG = # -Wp,
RTOSDEMO_CC_ASM_FLAG = # -Wa,
RTOSDEMO_CC_LINKER_FLAG =   -Wl,-Map=rtosdemo.map 
RTOSDEMO_LINKER_SCRIPT = 
RTOSDEMO_LINKER_SCRIPT_FLAG = #-Wl,-T -Wl,$(RTOSDEMO_LINKER_SCRIPT) 
RTOSDEMO_CC_DEBUG_FLAG =  -g 
RTOSDEMO_CC_GLOBPTR_FLAG= # -mxl-gp-opt
RTOSDEMO_MODE = executable
RTOSDEMO_LIBG_OPT = -$(RTOSDEMO_MODE) microblaze_0
RTOSDEMO_CC_SOFTMUL_FLAG= -mno-xl-soft-mul 
RTOSDEMO_CC_START_ADDR_FLAG=  # -Wl,-defsym -Wl,_TEXT_START_ADDR=
RTOSDEMO_CC_STACK_SIZE_FLAG=  # -Wl,-defsym -Wl,_STACK_SIZE=
RTOSDEMO_OTHER_CC_FLAGS= $(RTOSDEMO_CC_GLOBPTR_FLAG)  \
                  $(RTOSDEMO_CC_START_ADDR_FLAG) $(RTOSDEMO_CC_STACK_SIZE_FLAG)  \
                  $(RTOSDEMO_CC_SOFTMUL_FLAG)  \
                  $(RTOSDEMO_CC_PREPROC_FLAG) $(RTOSDEMO_CC_ASM_FLAG) $(RTOSDEMO_CC_LINKER_FLAG)  \
                  $(RTOSDEMO_LINKER_SCRIPT_FLAG) $(RTOSDEMO_CC_DEBUG_FLAG) 
