#################################################################
# Makefile generated by Xilinx Platform Studio 
# Project:E:\Dev\FreeRTOS\Demo\MicroBlaze\system.xmp
#################################################################

# Name of the Microprocessor system
# The hardware specification of the system is in file :
# E:\Dev\FreeRTOS\Demo\MicroBlaze\system.mhs
# The software specification of the system is in file :
# E:\Dev\FreeRTOS\Demo\MicroBlaze\system.mss

include system_incl.make


#################################################################
# EXTERNAL TARGETS
#################################################################
all:
	@echo "Makefile to build a Microprocessor system :"
	@echo "Run make with any of the following targets"
	@echo " "
	@echo "  netlist  : Generates the netlist for the given MHS "
	@echo "  bits     : Runs Implementation tools to generate the bitstream"
	@echo "  exporttopn:Export to ProjNav"
	@echo " "
	@echo "  libs     : Configures the sw libraries for this system"
	@echo "  program  : Compiles the program sources for all the processor instances"
	@echo " "
	@echo "  init_bram: Initializes bitstream with BRAM data"
	@echo "  ace      : Generate ace file from bitstream and elf"
	@echo "  download : Downloads the bitstream onto the board"
	@echo " "
	@echo "  sim      : Generates HDL simulation models and runs simulator for chosen simulation mode"
	@echo "  simmodel : Generates HDL simulation models for chosen simulation mode"
	@echo "  behavioral_model:Generates behavioral HDL models with BRAM initialization"
	@echo "  structural_model:Generates structural simulation HDL models with BRAM initialization"
	@echo "  timing_model    : Generates timing simulation HDL models with BRAM initialization"
	@echo "  vp       : Generates virtual platform model"
	@echo " "
	@echo "  netlistclean: Deletes netlist"
	@echo "  bitsclean: Deletes bit, ncd, bmm files"
	@echo "  hwclean  : Deletes implementation dir"
	@echo "  libsclean: Deletes sw libraries"
	@echo "  programclean: Deletes compiled ELF files"
	@echo "  swclean  : Deletes sw libraries and ELF files"
	@echo "  simclean : Deletes simulation dir"
	@echo "  vpclean  : Deletes virtualplatform dir"
	@echo "  clean    : Deletes all generated files/directories"
	@echo " "
	@echo "  make <target> : (Default)"
	@echo "      Creates a Microprocessor system using default initializations"
	@echo "      specified for each processor in MSS file"


bits: $(SYSTEM_BIT)

ace: $(SYSTEM_ACE)

netlist: $(POSTSYN_NETLIST)

libs: $(LIBRARIES)

program: $(ALL_USER_ELF_FILES)

download: $(DOWNLOAD_BIT) dummy
	@echo "*********************************************"
	@echo "Downloading Bitstream onto the target board"
	@echo "*********************************************"
	impact -batch etc/download.cmd

init_bram: $(DOWNLOAD_BIT)

sim: $(DEFAULT_SIM_SCRIPT)
	cd simulation/behavioral; \
	$(SIM_CMD)  &

simmodel: $(DEFAULT_SIM_SCRIPT)

behavioral_model: $(BEHAVIORAL_SIM_SCRIPT)

structural_model: $(STRUCTURAL_SIM_SCRIPT)

timing_model: $(TIMING_SIM_SCRIPT)

vp: $(VPEXEC)

clean: hwclean libsclean programclean simclean vpclean
	rm -f _impact.cmd

hwclean: netlistclean bitsclean
	rm -rf implementation synthesis xst hdl
	rm -rf xst.srp $(SYSTEM).srp

netlistclean:
	rm -f $(POSTSYN_NETLIST)
	rm -f $(BMM_FILE)

bitsclean:
	rm -f $(SYSTEM_BIT)
	rm -f implementation/$(SYSTEM).ncd
	rm -f implementation/$(SYSTEM)_bd.bmm 

bitsclean:

simclean: 
	rm -rf simulation/behavioral

swclean: libsclean programclean
	@echo ""

libsclean: $(LIBSCLEAN_TARGETS)

programclean: $(PROGRAMCLEAN_TARGETS)

vpclean:
	rm -rf virtualplatform

#################################################################
# SOFTWARE PLATFORM FLOW
#################################################################


$(LIBRARIES): $(MHSFILE) $(MSSFILE) __xps/libgen.opt
	@echo "*********************************************"
	@echo "Creating software libraries..."
	@echo "*********************************************"
	libgen $(LIBGEN_OPTIONS) $(MSSFILE)


microblaze_0_libsclean:
	rm -rf microblaze_0/lib/

$(MICROBLAZE_0_XMDSTUB): $(LIBRARIES)

#################################################################
# SOFTWARE APPLICATION RTOSDEMO
#################################################################

RTOSDemo_program: $(RTOSDEMO_OUTPUT) 

$(RTOSDEMO_OUTPUT) : $(RTOSDEMO_SOURCES) $(RTOSDEMO_HEADERS) $(RTOSDEMO_LINKER_SCRIPT) \
                    $(LIBRARIES) __xps/rtosdemo_compiler.opt
	@mkdir -p $(RTOSDEMO_OUTPUT_DIR) 
	$(RTOSDEMO_CC) $(RTOSDEMO_CC_OPT) $(RTOSDEMO_SOURCES) -o $(RTOSDEMO_OUTPUT) \
	$(RTOSDEMO_OTHER_CC_FLAGS) $(RTOSDEMO_INCLUDES) $(RTOSDEMO_LIBPATH) \
	-xl-mode-$(RTOSDEMO_MODE)  \
	$(RTOSDEMO_CFLAGS) $(RTOSDEMO_LFLAGS) 
	$(RTOSDEMO_CC_SIZE) $(RTOSDEMO_OUTPUT) 

RTOSDemo_programclean:
	rm -f $(RTOSDEMO_OUTPUT) 

#################################################################
# BOOTLOOP ELF FILES
#################################################################



$(MICROBLAZE_0_BOOTLOOP): $(MICROBLAZE_BOOTLOOP)
	@mkdir -p $(BOOTLOOP_DIR)
	cp -f $(MICROBLAZE_BOOTLOOP) $(MICROBLAZE_0_BOOTLOOP)

#################################################################
# HARDWARE IMPLEMENTATION FLOW
#################################################################


$(BMM_FILE) \
$(WRAPPER_NGC_FILES): $(MHSFILE) __xps/platgen.opt \
                      $(CORE_STATE_DEVELOPMENT_FILES)
	@echo "****************************************************"
	@echo "Creating system netlist for hardware specification.."
	@echo "****************************************************"
	platgen $(PLATGEN_OPTIONS) -st xst $(MHSFILE)

$(POSTSYN_NETLIST): $(WRAPPER_NGC_FILES)
	@echo "Running synthesis..."
	bash -c "cd synthesis; ./synthesis.sh; cd .."

$(SYSTEM_BIT): $(BMM_FILE) $(POSTSYN_NETLIST) __xps/xpsxflow.opt \
               $(UCF_FILE) $(BITGEN_UT_FILE) $(FASTRUNTIME_OPT_FILE)
	@echo "Copying Xilinx Implementation tool scripts.."
	@cp -f $(BITGEN_UT_FILE) implementation/bitgen.ut
	@cp -f $(FASTRUNTIME_OPT_FILE) implementation/fast_runtime.opt
	@cp -f $(UCF_FILE) implementation/$(SYSTEM).ucf
	@echo "*********************************************"
	@echo "Running Xilinx Implementation tools.."
	@echo "*********************************************"
	xflow -wd implementation -p $(DEVICE) -implement fast_runtime.opt $(SYSTEM).ngc
	cd implementation; bitgen -w -f bitgen.ut $(SYSTEM)

exporttopn: 
	@echo "You have chosen XPS for implementation tool flow."
	@echo "Please select ProjNav as your implementation flow in Project Options."
	@echo "In batch mode, use commad xset pnproj <isefile>."

$(DOWNLOAD_BIT): $(SYSTEM_BIT) $(BRAMINIT_ELF_FILES) __xps/bitinit.opt
	@cp -f implementation/$(SYSTEM)_bd.bmm .
	@echo "*********************************************"
	@echo "Initializing BRAM contents of the bitstream"
	@echo "*********************************************"
	bitinit $(MHSFILE) $(SEARCHPATHOPT) $(BRAMINIT_ELF_FILE_ARGS) \
	-bt $(SYSTEM_BIT) -o $(DOWNLOAD_BIT)
	@rm -f $(SYSTEM)_bd.bmm

$(SYSTEM_ACE): $(DOWNLOAD_BIT) $(RTOSDEMO_OUTPUT) 
	@echo "*********************************************"
	@echo "Creating system ace file"
	@echo "*********************************************"
	xmd -tcl genace.tcl -jprog -hw $(DOWNLOAD_BIT) -elf $(RTOSDEMO_OUTPUT)  -ace $(SYSTEM_ACE)

#################################################################
# SIMULATION FLOW
#################################################################


################## BEHAVIORAL SIMULATION ##################

$(BEHAVIORAL_SIM_SCRIPT): $(MHSFILE) __xps/simgen.opt \
                          $(BRAMINIT_ELF_FILES)
	@echo "*********************************************"
	@echo "Creating behavioral simulation models..."
	@echo "*********************************************"
	simgen $(SIMGEN_OPTIONS) -m behavioral $(MHSFILE)

################## STRUCTURAL SIMULATION ##################

$(STRUCTURAL_SIM_SCRIPT): $(WRAPPER_NGC_FILES) __xps/simgen.opt \
                          $(BRAMINIT_ELF_FILES)
	@echo "*********************************************"
	@echo "Creating structural simulation models..."
	@echo "*********************************************"
	simgen $(SIMGEN_OPTIONS) -sd implementation -m structural $(MHSFILE)


################## TIMING SIMULATION ##################

$(TIMING_SIM_SCRIPT): $(SYSTEM_BIT) __xps/simgen.opt \
                      $(BRAMINIT_ELF_FILES)
	@echo "*********************************************"
	@echo "Creating timing simulation models..."
	@echo "*********************************************"
	simgen $(SIMGEN_OPTIONS) -sd implementation -m timing $(MHSFILE)

#################################################################
# VIRTUAL PLATFORM FLOW
#################################################################


$(VPEXEC): $(MHSFILE) __xps/vpgen.opt
	@echo "****************************************************"
	@echo "Creating virtual platform for hardware specification.."
	@echo "****************************************************"
	vpgen $(VPGEN_OPTIONS) $(MHSFILE)

dummy:
	@echo ""

