/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : TickTimer.H
**     Project   : RTOSDemo
**     Processor : MC9S12C32CFU
**     Beantype  : TimerInt
**     Version   : Bean 02.063, Driver 01.05, CPU db: 2.87.276
**     Compiler  : Metrowerks HC12 C Compiler
**     Date/Time : 18/06/2005, 17:53
**     Abstract  :
**         This bean "TimerInt" implements a periodic interrupt.
**         When the bean and its events are enabled, the "OnInterrupt"
**         event is called periodically with the period that you specify.
**         TimerInt supports also changing the period in runtime.
**         The source of periodic interrupt can be timer compare or reload 
**         register or timer-overflow interrupt (of free running counter).
**     Settings  :
**         Timer name                  : TIM (16-bit)
**         Compare name                : TC0
**         Counter shared              : No
**
**         High-speed CPU mode
**             Prescaler               : divide-by-4
**             Clock                   : 5999000 Hz
**           Initial period/frequency
**             Xtal ticks              : 16000
**             microseconds            : 1000
**             milliseconds            : 1
**             seconds (real)          : 0.0010000
**             Hz                      : 1000
**             kHz                     : 1
**
**         Runtime setting             : period/frequency interval (continual setting)
**             ticks                   : 16000 to 160000 ticks
**             microseconds            : 1000 to 10000 microseconds
**             milliseconds            : 1 to 10 milliseconds
**             seconds (real)          : 0.0010000 to 0.0100000 seconds
**             Hz                      : 100 to 1000 Hz
**
**         Initialization:
**              Timer                  : Disabled
**              Events                 : Enabled
**
**         Timer registers
**              Counter                : TCNT      [68]
**              Mode                   : TIOS      [64]
**              Run                    : TSCR1     [70]
**              Prescaler              : TSCR2     [77]
**
**         Compare registers
**              Compare                : TC0       [80]
**
**         Flip-flop registers
**              Mode                   : TCTL2     [73]
**     Contents  :
**         Enable    - byte TickTimer_Enable(void);
**         SetFreqHz - byte TickTimer_SetFreqHz(word Freq);
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2002
**     UNIS, spol. s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

#ifndef __TickTimer
#define __TickTimer

/* MODULE TickTimer. */

#include "Cpu.h"

#pragma CODE_SEG TickTimer_CODE        /* Code section for this module. */

#define TickTimer_SFHzMin  100         /* Lower bound of interval for method SetFreqHz */
#define TickTimer_SFHzMax  1000        /* Upper bound of interval for method SetFreqHz */


byte TickTimer_Enable(void);
/*
** ===================================================================
**     Method      :  TickTimer_Enable (bean TimerInt)
**
**     Description :
**         Enable the bean - it starts the timer. Events may be
**         generated ("DisableEvent"/"EnableEvent").
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

byte TickTimer_SetFreqHz(word Freq);
/*
** ===================================================================
**     Method      :  TickTimer_SetFreqHz (bean TimerInt)
**
**     Description :
**         This method sets the new frequency of the generated
**         events. The frequency is expressed in Hz as a 16-bit
**         unsigned integer number.
**         This method is available only if runtime setting type
**         'from interval' is selected in the Timing dialog box in
**         Runtime setting area.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Freq            - Frequency to set [in Hz]
**                      (100 to 1000 Hz)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_MATH - Overflow during evaluation
**                           ERR_RANGE - Parameter out of range
** ===================================================================
*/

#pragma CODE_SEG __NEAR_SEG NON_BANKED /* Interrupt section for this module. Placement will be in NON_BANKED area. */
__interrupt void  TickTimer_Interrupt(void);
#pragma CODE_SEG TickTimer_CODE        /* Code section for this module. */
/*
** ===================================================================
**     Method      :  TickTimer_Interrupt (bean TimerInt)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/

void TickTimer_Init(void);
/*
** ===================================================================
**     Method      :  TickTimer_Init (bean TimerInt)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/

#pragma CODE_SEG DEFAULT               /* Change code section to DEFAULT. */

/* END TickTimer. */

#endif /* ifndef __TickTimer */
/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 03.33 for 
**     the Motorola HCS12 series of microcontrollers.
**
** ###################################################################
*/
