/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : COM0.H
**     Project   : RTOSDemo
**     Processor : MC9S12DP256BCPV
**     Beantype  : AsynchroSerial
**     Version   : Bean 02.231, Driver 01.08, CPU db: 2.87.283
**     Compiler  : Metrowerks HC12 C Compiler
**     Date/Time : 19/06/2005, 15:07
**     Abstract  :
**         This bean "AsynchroSerial" implements an asynchronous serial
**         communication. The bean supports different settings of 
**         parity, word width, stop-bit and communication speed,
**         user can select interrupt or polling handler.
**         Communication speed can be changed also in runtime.
**         The bean requires one on-chip asynchronous serial channel.
**     Settings  :
**         Serial channel              : SCI0
**
**         Protocol
**             Init baud rate          : 38400baud
**             Width                   : 8 bits
**             Stop bits               : 1
**             Parity                  : none
**             Breaks                  : Disabled
**
**         Registers
**             Input buffer            : SCI0DRL   [207]
**             Output buffer           : SCI0DRL   [207]
**             Control register        : SCI0CR1   [202]
**             Mode register           : SCI0CR2   [203]
**             Baud setting reg.       : SCI0BD    [200]
**             Special register        : SCI0SR1   [204]
**
**         Input interrupt
**             Vector name             : INT_SCI0
**             Priority                : 1
**
**         Output interrupt
**             Vector name             : INT_SCI0
**             Priority                : 1
**
**         Used pins                   : 
**             ----------------------------------------------------
**               Function | On package |    Name
**             ----------------------------------------------------
**                Input   |     89     |  PS0_RxD0
**                Output  |     90     |  PS1_TxD0
**             ----------------------------------------------------
**
**
**         Used baud modes             :
**             ----------------------------------------------------
**               No. |    Mode ID      |  Baud rate
**             ----------------------------------------------------
**                0  |  Bm_38400baud   |  38400baud
**                1  |  Bm_19200baud   |  19200baud
**                2  |  Bm_9600baud    |  9600baud
**                3  |  Bm_4800baud    |  4800baud
**             ----------------------------------------------------
**     Contents  :
**         SetBaudRateMode - byte COM0_SetBaudRateMode(byte Mod);
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2002
**     UNIS, spol. s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

#ifndef __COM0
#define __COM0

/* MODULE COM0. */

#include "Cpu.h"

#define COM0_Bm_38400baud         0    /* Constant for switch to mode 0 */
#define COM0_Bm_19200baud         1    /* Constant for switch to mode 1 */
#define COM0_Bm_9600baud          2    /* Constant for switch to mode 2 */
#define COM0_Bm_4800baud          3    /* Constant for switch to mode 3 */



#ifndef __BWUserType_tItem
#define __BWUserType_tItem
  typedef struct {                     /* Item of the index table for possible baudrates */
    word div;                          /* divisior */
    byte val;                          /* values of the prescalers */
  } tItem;
#endif
#ifndef __BWUserType_COM0_TError
#define __BWUserType_COM0_TError
typedef union {
  byte err;
  struct {
    bool OverRun  : 1;                 /* OverRun error flag */
    bool Framing  : 1;                 /* Framing error flag */
    bool Parity   : 1;                 /* Parity error flag */
    bool RxBufOvf : 1;                 /* Rx buffer full error flag */
    bool Noise    : 1;                 /* Noise error */
    bool Break    : 1;                 /* Break detect */
    bool Idle     : 1;                 /* Idle characted */
  }errName;
} COM0_TError;
#endif
#ifndef __BWUserType_TDirection
#define __BWUserType_TDirection
  typedef enum {                       /*  */
    TXD_INPUT,
    TXD_OUTPUT
  } TDirection;
#endif

#ifndef __BWUserType_COM0_TComData
#define __BWUserType_COM0_TComData
  typedef byte COM0_TComData ;         /* User type for communication. Size of this type depends on the communication data witdh. */
#endif

#pragma CODE_SEG COM0_CODE             /* Code section for this module. */

byte COM0_SetBaudRateMode(byte Mod);
/*
** ===================================================================
**     Method      :  COM0_SetBaudRateMode (bean AsynchroSerial)
**
**     Description :
**         This method changes the channel communication speed (baud
**         rate). This method can be used only if you specify a list
**         of possible period settings at design time (see <Timing
**         dialog box> - Runtime setting - from a list of values).
**         Each of these settings constitutes a mode and Processor
**         Expert^[TM] assigns them a mode identifier. The prescaler
**         and compare values corresponding to each mode are
**         calculated at design time. You may switch modes at
**         runtime by referring only to a mode identifier. No
**         run-time calculations are performed, all the calculations
**         are performed at design time.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Mod             - Timing mode to set
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

#pragma CODE_SEG __NEAR_SEG NON_BANKED /* Interrupt section for this module. Placement will be in NON_BANKED area. */
__interrupt void COM0_Interrupt(void);
#pragma CODE_SEG COM0_CODE             /* Code section for this module. */
/*
** ===================================================================
**     Method      :  COM0_Interrupt (bean AsynchroSerial)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/


void COM0_Init(void);
/*
** ===================================================================
**     Method      :  COM0_Init (bean AsynchroSerial)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/


#pragma CODE_SEG DEFAULT               /* Change code section to DEFAULT. */

/* END COM0. */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 03.33 for 
**     the Motorola HCS12 series of microcontrollers.
**
** ###################################################################
*/

#endif /* ifndef __COM0 */
