/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : COM0.C
**     Project   : RTOSDemo
**     Processor : MC9S12DP256BCPV
**     Beantype  : AsynchroSerial
**     Version   : Bean 02.231, Driver 01.08, CPU db: 2.87.283
**     Compiler  : Metrowerks HC12 C Compiler
**     Date/Time : 19/06/2005, 15:07
**     Abstract  :
**         This bean "AsynchroSerial" implements an asynchronous serial
**         communication. The bean supports different settings of 
**         parity, word width, stop-bit and communication speed,
**         user can select interrupt or polling handler.
**         Communication speed can be changed also in runtime.
**         The bean requires one on-chip asynchronous serial channel.
**     Settings  :
**         Serial channel              : SCI0
**
**         Protocol
**             Init baud rate          : 38400baud
**             Width                   : 8 bits
**             Stop bits               : 1
**             Parity                  : none
**             Breaks                  : Disabled
**
**         Registers
**             Input buffer            : SCI0DRL   [207]
**             Output buffer           : SCI0DRL   [207]
**             Control register        : SCI0CR1   [202]
**             Mode register           : SCI0CR2   [203]
**             Baud setting reg.       : SCI0BD    [200]
**             Special register        : SCI0SR1   [204]
**
**         Input interrupt
**             Vector name             : INT_SCI0
**             Priority                : 1
**
**         Output interrupt
**             Vector name             : INT_SCI0
**             Priority                : 1
**
**         Used pins                   : 
**             ----------------------------------------------------
**               Function | On package |    Name
**             ----------------------------------------------------
**                Input   |     89     |  PS0_RxD0
**                Output  |     90     |  PS1_TxD0
**             ----------------------------------------------------
**
**
**         Used baud modes             :
**             ----------------------------------------------------
**               No. |    Mode ID      |  Baud rate
**             ----------------------------------------------------
**                0  |  Bm_38400baud   |  38400baud
**                1  |  Bm_19200baud   |  19200baud
**                2  |  Bm_9600baud    |  9600baud
**                3  |  Bm_4800baud    |  4800baud
**             ----------------------------------------------------
**     Contents  :
**         SetBaudRateMode - byte COM0_SetBaudRateMode(byte Mod);
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2002
**     UNIS, spol. s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

/* MODULE COM0. */

#pragma MESSAGE DISABLE C4002 /* WARNING C4002: Result not used is ignored */
#pragma MESSAGE DISABLE C4301 /* INFORMATION C4301: Inline expansion done for function call */

#include "COM0.h"
#include "TickTimer.h"
#include "Byte1.h"

/* Definition of DATA and CODE segments for this bean. User can specify where
   these segments will be located on "Build options" tab of the selected CPU bean. */
#pragma DATA_SEG COM0_DATA             /* Data section for this module. */
#pragma CODE_SEG COM0_CODE             /* Code section for this module. */


#define OVERRUN_ERR      1             /* Overrun error flag bit   */
#define FRAMING_ERR      2             /* Framing error flag bit   */
#define PARITY_ERR       4             /* Parity error flag bit    */
#define CHAR_IN_RX       8             /* Char is in RX buffer     */
#define FULL_TX          16            /* Full transmit buffer     */
#define RUNINT_FROM_TX   32            /* Interrupt is in progress */
#define FULL_RX          64            /* Full receive buffer      */
#define NOISE_ERR        128           /* Noise erorr flag bit     */
#define IDLE_ERR         256           /* Idle character flag bit  */
#define BREAK_ERR        512           /* Break detect             */

static word SerFlag;                   /* Flags for serial communication */
                                       /* Bits: 0 - OverRun error */
                                       /*       1 - Framing error */
                                       /*       2 - Parity error */
                                       /*       3 - Char in RX buffer */
                                       /*       4 - Full TX buffer */
                                       /*       5 - Running int from TX */
                                       /*       6 - Full RX buffer */
                                       /*       7 - Noise error */
                                       /*       8 - Idle character  */
                                       /*       9 - Break detected  */
                                       /*      10 - Unused */
static word PrescHigh;
static byte NumMode;                   /* Number of selected baud mode */


/*
** ===================================================================
**     Method      :  HWEnDi (bean AsynchroSerial)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
static void HWEnDi(void)
{
    SCI0CR2_TE = 1;                    /* Enable transmitter */
    SCI0CR2_RE = 1;                    /* Enable receiver */
    SCI0CR2_RIE = 1;                   /* Enable recieve interrupt */
}

/*
** ===================================================================
**     Method      :  COM0_SetBaudRateMode (bean AsynchroSerial)
**
**     Description :
**         This method changes the channel communication speed (baud
**         rate). This method can be used only if you specify a list
**         of possible period settings at design time (see <Timing
**         dialog box> - Runtime setting - from a list of values).
**         Each of these settings constitutes a mode and Processor
**         Expert^[TM] assigns them a mode identifier. The prescaler
**         and compare values corresponding to each mode are
**         calculated at design time. You may switch modes at
**         runtime by referring only to a mode identifier. No
**         run-time calculations are performed, all the calculations
**         are performed at design time.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Mod             - Timing mode to set
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte COM0_SetBaudRateMode(byte Mod)
{
  static const word COM0_PrescHigh[4] = {41,81,163,326};

  if(Mod >= 4)                         /* Is mode in baud mode list */
    return ERR_VALUE;                  /* If no then error */
  NumMode = Mod;                       /* New baud mode */
  PrescHigh = COM0_PrescHigh[Mod];     /* Prescaler in high speed mode */
  SCI0BD = PrescHigh;                  /* Set prescaler bits */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  COM0_Init (bean AsynchroSerial)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
void COM0_Init(void)
{
  PrescHigh = 41;                      /* Precaler in high speed mode */
  SerFlag = 0;                         /* Reset flags */
  NumMode = 0;                         /* Number of selected baud mode */
  /* SCI0CR1: LOOPS=0,SCISWAI=1,RSRC=0,M=0,WAKE=0,ILT=0,PE=0,PT=0 */
  SCI0CR1 = 64;                        /* Set the SCI configuration */
  /* SCI0SR2: ??=0,??=0,??=0,??=0,??=0,BRK13=0,TXDIR=0,RAF=0 */
  SCI0SR2 = 0;                         /* Set the Break Character Length and Transmitter pin data direction in Single-wire mode */
  SCI0SR1;                             /* Reset interrupt request flags */
  /* SCI0CR2: SCTIE=0,TCIE=0,RIE=0,ILIE=0,TE=0,RE=0,RWU=0,SBK=0 */
  SCI0CR2 = 0;                         /* Disable error interrupts */
  SCI0BD = PrescHigh;                  /* Set prescaler bits */
  HWEnDi();                            /* Enable/disable device according to status flags */
}


/* END COM0. */


/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 03.33 for 
**     the Motorola HCS12 series of microcontrollers.
**
** ###################################################################
*/
