/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : TickTimer.C
**     Project   : RTOSDemo
**     Processor : MC9S12DP256BCPV
**     Beantype  : TimerInt
**     Version   : Bean 02.063, Driver 01.05, CPU db: 2.87.283
**     Compiler  : Metrowerks HC12 C Compiler
**     Date/Time : 18/06/2005, 16:21
**     Abstract  :
**         This bean "TimerInt" implements a periodic interrupt.
**         When the bean and its events are enabled, the "OnInterrupt"
**         event is called periodically with the period that you specify.
**         TimerInt supports also changing the period in runtime.
**         The source of periodic interrupt can be timer compare or reload 
**         register or timer-overflow interrupt (of free running counter).
**     Settings  :
**         Timer name                  : ECT (16-bit)
**         Compare name                : TC0
**         Counter shared              : No
**
**         High-speed CPU mode
**             Prescaler               : divide-by-8
**             Clock                   : 3124000 Hz
**           Initial period/frequency
**             Xtal ticks              : 16000
**             microseconds            : 1000
**             milliseconds            : 1
**             seconds (real)          : 0.0010000
**             Hz                      : 1000
**             kHz                     : 1
**
**         Runtime setting             : period/frequency interval (continual setting)
**             ticks                   : 16000 to 320000 ticks
**             microseconds            : 1000 to 20000 microseconds
**             milliseconds            : 1 to 20 milliseconds
**             seconds (real)          : 0.0010000 to 0.0200000 seconds
**             Hz                      : 50 to 1000 Hz
**
**         Initialization:
**              Timer                  : Enabled
**              Events                 : Enabled
**
**         Timer registers
**              Counter                : TCNT      [68]
**              Mode                   : TIOS      [64]
**              Run                    : TSCR1     [70]
**              Prescaler              : TSCR2     [77]
**
**         Compare registers
**              Compare                : TC0       [80]
**
**         Flip-flop registers
**              Mode                   : TCTL2     [73]
**     Contents  :
**         Enable           - byte TickTimer_Enable(void);
**         SetPeriodTicks16 - byte TickTimer_SetPeriodTicks16(word Ticks);
**         SetPeriodTicks32 - byte TickTimer_SetPeriodTicks32(dword Ticks);
**         SetPeriodUS      - byte TickTimer_SetPeriodUS(word Time);
**         SetPeriodMS      - byte TickTimer_SetPeriodMS(word Time);
**         SetFreqHz        - byte TickTimer_SetFreqHz(word Freq);
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2002
**     UNIS, spol. s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/


/* MODULE TickTimer. */

#include "Events.h"
#include "TickTimer.h"

/* Definition of DATA and CODE segments for this bean. User can specify where
   these segments will be located on "Build options" tab of the selected CPU bean. */
#pragma DATA_SEG TickTimer_DATA        /* Data section for this module. */
#pragma CODE_SEG TickTimer_CODE        /* Code section for this module. */

static word CmpHighVal;                /* Compare register value for high speed CPU mode */


/*
** ===================================================================
**     Method      :  SetCV (bean TimerInt)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
static void SetCV(word Val)
{
  if (Val == 0)                        /* If the given value is zero */
    Val = 65535;                       /* then change it to the maximal one */
  TC0 = Val;                           /* Store given value to the compare register */
  TC7 = Val;                           /* Store given value to the modulo register */
}

/*
** ===================================================================
**     Method      :  SetPV (bean TimerInt)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
static void SetPV(byte Val)
{
  TSCR2_PR = Val;                      /* Store given value to the prescaler */
}

/*
** ===================================================================
**     Method      :  HWEnDi (bean TimerInt)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
static void HWEnDi(void)
{
    TFLG1 = 1;                         /* Reset interrupt request flag */
    TIE_C0I = 1;                       /* Enable interrupt */
}

/*
** ===================================================================
**     Method      :  TickTimer_Enable (bean TimerInt)
**
**     Description :
**         Enable the bean - it starts the timer. Events may be
**         generated ("DisableEvent"/"EnableEvent").
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte TickTimer_Enable(void)
{
  HWEnDi();                            /* Enable the device */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  TickTimer_SetPeriodTicks16 (bean TimerInt)
**
**     Description :
**         This method sets the new period of the generated events.
**         The period is expressed in Xtal ticks as a 16-bit unsigned
**         integer number.
**         This method is available only if runtime setting type
**         'from interval' is selected in the Timing dialog box in
**         Runtime setting area.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Ticks           - Period to set [in Xtal ticks]
**                      (16000 to 65535 ticks)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_MATH - Overflow during evaluation
**                           ERR_RANGE - Parameter out of range
** ===================================================================
*/
byte TickTimer_SetPeriodTicks16(word Ticks)
{
  dlong rtval;                         /* Result of two 32-bit numbers multiplication */
  word rtword;                         /* Result of 64-bit number division */

  if (Ticks < 16000)                   /* Is the given value out of range? */
    return ERR_RANGE;                  /* If yes then error */
  PE_Timer_LngMul((dword)Ticks,838592365,&rtval); /* Multiply given value and high speed CPU mode coefficient */
  if (PE_Timer_LngHi4(rtval[0],rtval[1],&rtword)) /* Is the result greater or equal than 65536 ? */
    rtword = 65535;                    /* If yes then use maximal possible value */
  CmpHighVal = rtword;                 /* Store result (compare register value for high speed CPU mode) to the variable CmpHighVal */
  SetCV(CmpHighVal);                   /* Store appropriate value to the compare register according to the selected high speed CPU mode */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  TickTimer_SetPeriodTicks32 (bean TimerInt)
**
**     Description :
**         This method sets the new period of the generated events.
**         The period is expressed in Xtal ticks as a 32-bit unsigned
**         integer number.
**         This method is available only if runtime setting type
**         'from interval' is selected in the Timing dialog box in
**         Runtime setting area.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Ticks           - Period to set [in Xtal ticks]
**                      (16000 to 320000 ticks)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_MATH - Overflow during evaluation
**                           ERR_RANGE - Parameter out of range
** ===================================================================
*/
byte TickTimer_SetPeriodTicks32(dword Ticks)
{
  dlong rtval;                         /* Result of two 32-bit numbers multiplication */
  word rtword;                         /* Result of 64-bit number division */

  if ((Ticks > 320000) || (Ticks < 16000)) /* Is the given value out of range? */
    return ERR_RANGE;                  /* Range error */
  PE_Timer_LngMul(Ticks,838592365,&rtval); /* Multiply given value and high speed CPU mode coefficient */
  if (PE_Timer_LngHi4(rtval[0],rtval[1],&rtword)) /* Is the result greater or equal than 65536 ? */
    rtword = 65535;                    /* If yes then use maximal possible value */
  CmpHighVal = rtword;                 /* Store result (compare register value for high speed CPU mode) to the variable CmpHighVal */
  SetCV(CmpHighVal);                   /* Store appropriate value to the compare register according to the selected high speed CPU mode */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  TickTimer_SetPeriodUS (bean TimerInt)
**
**     Description :
**         This method sets the new period of the generated events.
**         The period is expressed in microseconds as a 16-bit
**         unsigned integer number.
**         This method is available only if runtime setting type
**         'from interval' is selected in the Timing dialog box in
**         Runtime setting area.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Time            - Period to set [in microseconds]
**                      (1000 to 20000 microseconds)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_MATH - Overflow during evaluation
**                           ERR_RANGE - Parameter out of range
** ===================================================================
*/
byte TickTimer_SetPeriodUS(word Time)
{
  dlong rtval;                         /* Result of two 32-bit numbers multiplication */
  word rtword;                         /* Result of 64-bit number division */

  if ((Time > 20000) || (Time < 1000)) /* Is the given value out of range? */
    return ERR_RANGE;                  /* If yes then error */
  PE_Timer_LngMul((dword)Time,52412023,&rtval); /* Multiply given value and high speed CPU mode coefficient */
  if (PE_Timer_LngHi3(rtval[0],rtval[1],&rtword)) /* Is the result greater or equal than 65536 ? */
    rtword = 65535;                    /* If yes then use maximal possible value */
  CmpHighVal = rtword;                 /* Store result (compare register value for high speed CPU mode) to the variable CmpHighVal */
  SetCV(CmpHighVal);                   /* Store appropriate value to the compare register according to the selected high speed CPU mode */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  TickTimer_SetPeriodMS (bean TimerInt)
**
**     Description :
**         This method sets the new period of the generated events.
**         The period is expressed in miliseconds as a 16-bit
**         unsigned integer number.
**         This method is available only if runtime setting type
**         'from interval' is selected in the Timing dialog box in
**         Runtime setting area.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Time            - Period to set [in miliseconds]
**                      (1 to 20 milliseconds)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_MATH - Overflow during evaluation
**                           ERR_RANGE - Parameter out of range
** ===================================================================
*/
byte TickTimer_SetPeriodMS(word Time)
{
  dlong rtval;                         /* Result of two 32-bit numbers multiplication */
  word rtword;                         /* Result of 64-bit number division */

  if ((Time > 20) || (Time < 1))       /* Is the given value out of range? */
    return ERR_RANGE;                  /* If yes then error */
  PE_Timer_LngMul((dword)Time,204734464,&rtval); /* Multiply given value and high speed CPU mode coefficient */
  if (PE_Timer_LngHi2(rtval[0],rtval[1],&rtword)) /* Is the result greater or equal than 65536 ? */
    rtword = 65535;                    /* If yes then use maximal possible value */
  CmpHighVal = rtword;                 /* Store result (compare register value for high speed CPU mode) to the variable CmpHighVal */
  SetCV(CmpHighVal);                   /* Store appropriate value to the compare register according to the selected high speed CPU mode */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  TickTimer_SetFreqHz (bean TimerInt)
**
**     Description :
**         This method sets the new frequency of the generated
**         events. The frequency is expressed in Hz as a 16-bit
**         unsigned integer number.
**         This method is available only if runtime setting type
**         'from interval' is selected in the Timing dialog box in
**         Runtime setting area.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Freq            - Frequency to set [in Hz]
**                      (50 to 1000 Hz)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_MATH - Overflow during evaluation
**                           ERR_RANGE - Parameter out of range
** ===================================================================
*/
byte TickTimer_SetFreqHz(word Freq)
{
  dlong rtval;                         /* Result of two 32-bit numbers division */
  word rtword;                         /* Result of 64-bit number division */

  if ((Freq > 1000) || (Freq < 50))    /* Is the given value out of range? */
    return ERR_RANGE;                  /* If yes then error */
  rtval[1] = 799744000 / (dword)Freq;  /* Divide high speed CPU mode coefficient by the given value */
  rtval[0] = 0;                        /* Convert result to the type dlong */
  if (PE_Timer_LngHi1(rtval[0],rtval[1],&rtword)) /* Is the result greater or equal than 65536 ? */
    rtword = 65535;                    /* If yes then use maximal possible value */
  CmpHighVal = rtword;                 /* Store result (compare register value for high speed CPU mode) to the variable CmpHighVal */
  SetCV(CmpHighVal);                   /* Store appropriate value to the compare register according to the selected high speed CPU mode */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  TickTimer_Init (bean TimerInt)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
void TickTimer_Init(void)
{
  CmpHighVal = 3124;                   /* Compare register value for high speed CPU mode */
  SetCV(CmpHighVal);                   /* Store appropriate value to the compare register according to the selected high speed CPU mode */
  SetPV(3);                            /* Set prescaler register according to the selected high speed CPU mode */
  HWEnDi();                            /* Enable/disable device according to status flags */
}

/*
** ===================================================================
**     Method      :  TickTimer_Interrupt (bean TimerInt)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
#pragma CODE_SEG __NEAR_SEG NON_BANKED /* Interrupt section for this module. Placement will be in NON_BANKED area. */
__interrupt void TickTimer_Interrupt(void)
{
  TFLG1 = 1;                           /* Reset interrupt request flag */
  TickTimer_OnInterrupt();             /* Invoke user event */
}

#pragma CODE_SEG TickTimer_CODE        /* Code section for this module. */

/* END TickTimer. */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 03.33 for 
**     the Motorola HCS12 series of microcontrollers.
**
** ###################################################################
*/
