description(
'This tests enumerating the elements of DOM lists.'
);

if (window.testRunner)
    testRunner.dumpAsText();

// Create a testing environment that can be cleanup up easily.
var testingGround = document.createElement('div');
document.body.appendChild(testingGround);

function createFromMarkup(markup)
{
    var range = document.createRange();
    var fragmentContainer = document.createElement("div");
    range.selectNodeContents(fragmentContainer);
    testingGround.appendChild(fragmentContainer);
    var fragment = range.createContextualFragment(markup);
    fragmentContainer.appendChild(fragment);
    return fragmentContainer.firstChild;
}

function setup()
{
    var head = document.getElementsByTagName('head')[0];

    // 2 additional <style>s needed for StyleSheetList test (one is included in the template).
    // 3 rules needed in the first addtional <style> for the CSSRuleList test.
    // 3 declarations needed in the first rule needed for the CSSStyleDeclaration test.
    // @media rule in the second addtional <style> for the MediaList test.
    head.appendChild(createFromMarkup("<style> ol { width: 100px; height: 100px; color: green; } ol { } ol { } </style>"));
    head.appendChild(createFromMarkup("<style> @media screen, projector, printer { ol { } } </style>"));

    // 3 <ol>s for NodeList test.
    // 3 attributes in the first <ol> for the NamedNodeMap test.
    testingGround.appendChild(createFromMarkup("<ol class='foo' id='bar' name='baz'></ol>"));
    testingGround.appendChild(document.createElement('ol'));
    testingGround.appendChild(document.createElement('ol'));

    // 3 <form>s for forms for HTMLCollection test.
    var form = document.createElement('form');
    testingGround.appendChild(form);
    testingGround.appendChild(document.createElement('form'));
    testingGround.appendChild(document.createElement('form'));

    // 3 <select>s for HTMLFormElement test.
    var select = document.createElement('select');
    form.appendChild(select);
    form.appendChild(document.createElement('select'));
    form.appendChild(document.createElement('select'));

    // 3 <option>s for HTMLSelectElement test.
    select.appendChild(document.createElement('option'));
    select.appendChild(document.createElement('option'));
    select.appendChild(document.createElement('option'));

    document.body.appendChild(testingGround);
}

function iterateList(list)
{
    debug("");
    debug(Object.prototype.toString.call(list));
    var temp = new Array();
    for (var i in list) {
        temp.push(i);
    }
    temp.sort();

    var a = new Array();
    for (var i = 0; i < temp.length; ++i) {
        a.push({"i" : temp[i], "item" : list[temp[i]]});
    }
    return a;
}

// ** Firefox DOES include the indexGetter results in enumeration **
// NodeList
// HTMLCollection
// CSSRuleList
// CSSStyleDeclaration
// CSSValueList
// StyleSheetList
// MediaList
// NamedNodeMap
// HTMLFormElement
// HTMLSelectElement

// ** Firefox DOESN'T include the indexGetter results in enumeration **
// Window

setup();

var resultArray = new Array();

// NodeList
var nodeList = document.getElementsByTagName('ol');
resultArray = iterateList(nodeList);

shouldBe("resultArray.length", "5");
shouldBe("resultArray[0].i", "'0'");
shouldBe("resultArray[0].item", "nodeList.item(0)");
shouldBe("resultArray[1].i", "'1'");
shouldBe("resultArray[1].item", "nodeList.item(1)");
shouldBe("resultArray[2].i", "'2'");
shouldBe("resultArray[2].item", "nodeList.item(2)");

// HTMLCollection
var htmlCollection = document.forms;
resultArray = iterateList(htmlCollection);
shouldBe("resultArray.length", "6");
shouldBe("resultArray[0].i", "'0'");
shouldBe("resultArray[0].item", "htmlCollection.item(0)");
shouldBe("resultArray[1].i", "'1'");
shouldBe("resultArray[1].item", "htmlCollection.item(1)");
shouldBe("resultArray[2].i", "'2'");
shouldBe("resultArray[2].item", "htmlCollection.item(2)");

// NamedNodeMap
var namedNodeMap = document.getElementsByTagName('ol')[0].attributes;
resultArray = iterateList(namedNodeMap);
shouldBe("resultArray.length", "11");
shouldBe("resultArray[0].i", "'0'");
shouldBe("resultArray[0].item", "namedNodeMap.item(0)");
shouldBe("resultArray[1].i", "'1'");
shouldBe("resultArray[1].item", "namedNodeMap.item(1)");
shouldBe("resultArray[2].i", "'2'");
shouldBe("resultArray[2].item", "namedNodeMap.item(2)");

// HTMLFormElement
var htmlFormElement = document.getElementsByTagName('form')[0];
resultArray = iterateList(htmlFormElement);
shouldBe("resultArray[0].i", "'0'");
shouldBe("resultArray[0].item", "document.getElementsByTagName('select')[0]");
shouldBe("resultArray[1].i", "'1'");
shouldBe("resultArray[1].item", "document.getElementsByTagName('select')[1]");
shouldBe("resultArray[2].i", "'2'");
shouldBe("resultArray[2].item", "document.getElementsByTagName('select')[2]");

// HTMLSelectElement
var htmlSelectElement = document.getElementsByTagName('select')[0];
resultArray = iterateList(htmlSelectElement);
shouldBe("resultArray[0].i", "'0'");
shouldBe("resultArray[0].item", "document.getElementsByTagName('option')[0]");
shouldBe("resultArray[1].i", "'1'");
shouldBe("resultArray[1].item", "document.getElementsByTagName('option')[1]");
shouldBe("resultArray[2].i", "'2'");
shouldBe("resultArray[2].item", "document.getElementsByTagName('option')[2]");

// StyleSheetList
var styleSheetList = document.styleSheets;
resultArray = iterateList(styleSheetList);
shouldBe("resultArray.length", "6");
shouldBe("resultArray[0].i", "'0'");
shouldBe("resultArray[0].item", "styleSheetList.item(0)");
shouldBe("resultArray[1].i", "'1'");
shouldBe("resultArray[1].item", "styleSheetList.item(1)");
shouldBe("resultArray[2].i", "'2'");
shouldBe("resultArray[2].item", "styleSheetList.item(2)");

// CSSRuleList
var cssRuleList = document.styleSheets[1].cssRules;
resultArray = iterateList(cssRuleList);
shouldBe("resultArray.length", "5");
shouldBe("resultArray[0].i", "'0'");
shouldBe("resultArray[0].item", "cssRuleList.item(0)");
shouldBe("resultArray[1].i", "'1'");
shouldBe("resultArray[1].item", "cssRuleList.item(1)");
shouldBe("resultArray[2].i", "'2'");
shouldBe("resultArray[2].item", "cssRuleList.item(2)");

// CSSStyleDeclaration
//debug(escapeHTML(document.getElementsByTagName('style')));
var cssStyleDeclaration = document.styleSheets[2].cssRules[0].style;
resultArray = iterateList(cssStyleDeclaration);
shouldBe("resultArray[0].i", "'0'");
shouldBe("resultArray[0].item", "cssStyleDeclaration.item(0)");
shouldBe("resultArray[1].i", "'1'");
shouldBe("resultArray[1].item", "cssStyleDeclaration.item(1)");
shouldBe("resultArray[2].i", "'2'");
shouldBe("resultArray[2].item", "cssStyleDeclaration.item(2)");

// CSSValueList
var cssValueList = window.getComputedStyle(document.getElementsByTagName('ol')[0]).getPropertyCSSValue('border-spacing');
resultArray = iterateList(cssValueList);
shouldBe("resultArray.length", "10");
shouldBe("resultArray[0].i", "'0'");
shouldBe("resultArray[0].item", "cssValueList.item(0)");
shouldBe("resultArray[1].i", "'1'");
shouldBe("resultArray[1].item", "cssValueList.item(1)");

// MediaList
var mediaList = document.styleSheets[3].cssRules[0].media;
resultArray = iterateList(mediaList);
shouldBe("resultArray.length", "8");
shouldBe("resultArray[0].i", "'0'");
shouldBe("resultArray[0].item", "mediaList.item(0)");
shouldBe("resultArray[1].i", "'1'");
shouldBe("resultArray[1].item", "mediaList.item(1)");
shouldBe("resultArray[2].i", "'2'");
shouldBe("resultArray[2].item", "mediaList.item(2)");

debug("");

document.body.removeChild(testingGround);
