description("Test reflecting boolean attributes.");

var attributes = [
    [ "area", "noHref" ],
    [ "dir", "compact" ],
    [ "dl", "compact" ],
    [ "form", "noValidate" ],
    [ "frame", "noResize" ],
    [ "hr", "noShade" ],
    [ "img", "isMap" ],
    [ "input", "autofocus" ],
    [ "input", "defaultChecked", "checked" ],
    [ "input", "disabled" ],
    [ "input", "formNoValidate" ],
    [ "input", "multiple" ],
    [ "input", "readOnly" ],
    [ "input", "required" ],
    [ "link", "disabled" ],
    [ "menu", "compact" ],
    [ "object", "declare" ],
    [ "ol", "compact" ],
    [ "option", "defaultSelected", "selected" ],
    [ "pre", "wrap" ],
    [ "script", "defer" ],
    [ "select", "multiple" ],
    [ "td", "noWrap" ],
    [ "ul", "compact" ],
    [ "video", "autoplay" ],
    [ "video", "controls" ],
    [ "video", "loop" ],
];

function make(tag)
{
    return document.createElement(tag);
}

for (var i = 0; i < attributes.length; ++i) {
    var tag = attributes[i][0];
    var reflectingAttribute = attributes[i][1];
    var contentAttribute = attributes[i][2] || reflectingAttribute.toLowerCase();
    shouldBe("e = make('" + tag + "'); "
        + "e.removeAttribute('" + contentAttribute + "'); "
        + "e." + reflectingAttribute,
        "false");
    shouldBe("e = make('" + tag + "'); "
        + "e.setAttribute('" + contentAttribute + "', ''); "
        + "e." + reflectingAttribute,
        "true");
    shouldBe("e = make('" + tag + "'); "
        + "e.setAttribute('" + contentAttribute + "', 'x'); "
        + "e." + reflectingAttribute + " = false; "
        + "e.getAttribute('" + contentAttribute + "')",
        "null");
    shouldBe("e = make('" + tag + "'); "
        + "e.setAttribute('" + contentAttribute + "', 'x'); "
        + "e." + reflectingAttribute + " = true; "
        + "e.getAttribute('" + contentAttribute + "')",
        "''");
}
