#!/bin/sh

# current dir
pwd
path=`dirname $0`
if test ${path} = "."; then
    path=`pwd`
else
    cd ${path}
fi
#echo ${path}
pwd

# debug mode exit
echo "start wrap-run-webkit-tests.sh"

cd ../../../LayoutTests
pwd

# log dir make for log
if [ -d log ]; then
  echo "log directory found."
else
  echo "log directory not found."
  mkdir log
fi

  
# result dir make for html report
cd ../../
pwd

if [ -d result ]; then
  echo "result directory found."
else
  echo "result directory not found."
  mkdir result
fi


cd ${path}
pwd

# check connected vita
psp2ctrl reboot
vita_connect=$?

if test ${vita_connect} -ne 0; then
    echo "vita unconnected!!"
    exit 1
fi

sleep 10s

# run DRT ---> create report
if test $1 = "-d"
then
    echo "debug"
    perl ../run-webkit-tests --psvita --debug --no-http
else
    echo "release"
    perl ../run-webkit-tests --psvita --release --no-http
fi

sleep 5s

# PSVita shutdown
#psp2ctrl off

#sleep 15s

# PC Shutdown
#C:¥windows¥system32¥shutdown.exe /s /t 1
#/cygdrive/c/Windows/System32/shutdown.exe -s -t 1

echo "end wrap-run-webkit-tests.sh"
