#
# Copyright (C) 2011 Sony Network Entertainment, Inc. All Rights Reserved
# Copyright (C) 2012 Sony Computer Entertainment Inc.
#

use webkitdirs;

my $isBuildingPS3;
my $isBuildingPSOrbis;
my $isBuildingPSVita;
my $isBuildingDebug;

my $pathRootDRT;
my $cntTestLimit = 25455; ## filelist.txt ̍sݒ
my $loopLimit = 10000;    ## DRT̍őN
my $stopLimit = 2;        ## eXgł̍őN(+1s)

my $oldStartLine = 0;     ## ÕeXgs
my $cntStopLimit = 0;     ## eXgŋN
my $logFileName = "";     ## logfile name
my $oldEndLine = 0;       ## eXgŏIs

my $testDirectory = "";   ## test current dir
my $logDir = "";          ## log output dir

sub isPS3()
{
    if (!defined($isBuildingPS3)) {
        if (checkForArgumentAndRemoveFromARGV("--ps3")) {
            $isBuildingPS3 = 1;
        } else {
            $isBuildingPS3 = 0;
        }
    }

    return $isBuildingPS3;
}

sub isPSOrbis()
{
    if (!defined($isBuildingPSOrbis)) {
        if (checkForArgumentAndRemoveFromARGV("--psorbis")) {
            setConfigurationProductDir(Cwd::abs_path(sourceDir() . "/Tools/Scripts/sony"));
            $isBuildingPSOrbis = 1;
        } else {
            $isBuildingPSOrbis = 0;
        }
    }

    return $isBuildingPSOrbis;
}

sub buildPS3Project($@)
{
    my ($project, @buildargs) = @_;

    # configure using gyp
    system(sourceDir() . "/Source/gyp/configure", "--port=ps3");

    # prepare parameters to be passed to 'make'
    my @makeargs = "";
    push @makeargs, "AR=ppu-lv2-ar ";
    push @makeargs, "CC=ppu-lv2-gcc ";
    push @makeargs, "CPP=ppu-lv2-cpp ";
    push @makeargs, "CXX=ppu-lv2-g++ ";
    push @makeargs, "LD=ppu-lv2-ld ";
    push @makeargs, "OBJDUMP=ppu-lv2-objdump ";
    push @makeargs, "RANLIB=ppu-lv2-ranlib ";
    push @makeargs, "STRIP=ppu-lv2-strip ";
    push @makeargs, "ARFLAGS.target=rucs ";
    push @makeargs, "-C" . sourceDir(). "/Source ";
    push @makeargs, "-fMakefile.ps3 ";

    # append 'make' args passed by the user
    foreach (@buildargs) {
        if (/^--makeargs=(.*)/) {
            push @makeargs, $1;
        }
    }

    # build the project
    system("make @makeargs $project");
}

sub isPSVita()
{
    if (!defined($isBuildingPSVita)) {
        if (checkForArgumentAndRemoveFromARGV("--psvita")) {
            setConfigurationProductDir(Cwd::abs_path(sourceDir() . "/Tools/Scripts/sony"));
            $isBuildingPSVita = 1;
        } else {
            $isBuildingPSVita = 0;
        }
        isPSVitaDebug();
    }

    return $isBuildingPSVita;
}

## is debug mode (default release)
sub isPSVitaDebug()
{
    if (!defined($isBuildingDebug)) {
       if (checkForArgumentAndRemoveFromARGV("--debug")) {
            $isBuildingDebug = 1;
        } else {
            $isBuildingDebug = 0;
        }
    }
    return $isBuildingDebug;
}

## read test dir "endline.txt"
sub readEndLine
{
    my $endLineFile = $logDir . "/endline.txt";
    my $line = 0;
    
    if (!open(END_LINE, $endLineFile)) {
        writeLog("Open Error EndLine.txt");
        return $line;
    }
    if (!($line = readline END_LINE)) {
        writeLog("readline Error empty EndLine.txt");
        close(END_LINE);
        return 0;
    }
    chomp $line;
    close(END_LINE);
    return $line;
}

## write test dir "log_mmdd_hhmmss.txt"
sub writeLog
{
    my $startLine = $_[0];
    my ($sec, $min, $hour, $day, $mon, $year) = localtime;
    
    $logFileName = sprintf("%04d_%02d%02d_%02d%02d%02d", $year + 1900, $mon + 1, $day ,$hour, $min, $sec) if (!length($logFileName));
    $updateTime = sprintf("%02d/%02d %02d:%02d:%02d ", $mon + 1, $day ,$hour, $min, $sec);
    
    my $logFile = $logDir . "/log_" . $logFileName . ".txt";
    open(LOG_WRITE, ">> $logFile");
    print LOG_WRITE $updateTime . $startLine . "\n";
    close(LOG_WRITE);
}

## write test dir "startline.txt"
sub writeStartLine
{
    my $startLine = $_[0];
    my $startLineFile = $logDir . "/startline.txt";
    open(START_LINE, "> $startLineFile");
    print START_LINE $startLine;
    close(START_LINE);
    
    writeLog($_[0]);
}

## write test dir "endline.txt"
sub writeEndLine
{
    my $endLine = $_[0];
    my $endLineFile = $logDir . "/endline.txt";
    open(END_LINE, "> $endLineFile");
    print END_LINE $endLine;
    close(END_LINE);
}

## delete test dir "startline.txt" "endline.txt"
sub deleteLineFile
{
    my $startLineFile = $logDir . "/startline.txt";
    my $endLineFile = $logDir . "/endline.txt";
    unlink $startLineFile;
    unlink endLineFile;
    
}

## write pid file
sub writePidFile
{
    my $pidFile = $logDir . "/main_pid.txt";
    open(PID_FILE, "> $pidFile");
    print PID_FILE $$;
    close(PID_FILE);
}

## kill monitor process
sub killMonitor
{
    my $pidFile = $logDir . "/child_pid.txt";
    my $pid = "";
    if (!open(PID_FILE, $pidFile)) {
        writeLog("Open Error child_pid.txt");
        return;
    }
    if (!($pid = readline PID_FILE)) {
        writeLog("readline Error empty child_pid.txt");
        close(PID_FILE);
        return;
    }
    chomp $pid;
    close(PID_FILE);
    print "read pid : " . $pid . "\n";

    system "kill " . $pid;
}

sub checkDir
{
    mkdir($logDir);
    mkdir($logDir . "/" . $logFileName);
}

## check log psp2run output STDOUT STDERR
sub checkPSP2RunLog
{
    my $psp2runLogFile = $logDir . "/" . $logFileName . $_[0];
    
    if (!open(PSPRUN_LOG, $psp2runLogFile)) {
        writeLog("Open Error psp2runLogFile : " . $psp2runLogFile);
        return;
    }
    
    while( my $line = readline PSPRUN_LOG ){ 
        chomp $line;
        # "Target failed to reply - LOADP protocol." ܂܂ĂċN
        $find = index ($line, "Target failed to reply - LOADP protocol.");
        if ($find < 0) {
            # "Target not ready (no protocol)." ܂܂ĂċN
            $find = index ($line, "Target not ready (no protocol).");
        }
        if ($find >= 0) {
            system("psp2ctrl reboot");
            writeLog("PSP2 Run Error LOADP protocol. to Reboot!!");
            sleep 10;
            return;
        }
    }
    close(PSPRUN_LOG);
}

## kick DRT for PSVita
sub runDumpRenderTree4PSVita
{
    return if !isPSVita();
    
    #system('cd /var; pwd');
    my $pathRoot;
    open(FILE_PWD, "pwd |");
    while(<FILE_PWD>){ 
        #print $_;    /cygdrive/d/svn/psp2/webcore/trunk/webkit_536_26
        $pathRoot = $_;
    }
    close FILE_PWD;
    chomp $pathRoot;
    my $pathFsroot = $pathRoot;

    # fsroot ̐ݒ
    if (index($pathRoot, "/cygdrive/") == 0)
    {
        # "/cygdrive/" ̐؂蔲
        $pathFsroot = substr($pathRoot, 10);
        my $drive = uc(substr($pathFsroot, 0, 1)) . ':';
        $pathFsroot = $drive . substr($pathFsroot, 1);
        $pathFsroot = $pathFsroot . '/LayoutTests';
    }
    # psp2ctrl fsroot D:/svn/psp2/webcore/trunk/webkit_536_26/LayoutTests
    print "start PSVita set psp2ctrl fsroot -> " . $pathFsroot . "\n";
    system('psp2ctrl fsroot ' . $pathFsroot);
    print "ok settingl fsroot\n";
    
    # PSVitaŁADumpRenderTreeN
    my $pathRootDRT;
    if (isPSVitaDebug()) {
        # D:\svn\psp2\webcore\trunk\webkit_536_26\Tools\DumpRenderTree\manx\PSP2 Debug
        $pathRootDRT = $pathRoot . "/Tools/DumpRenderTree/manx/PSP2\\ Debug";
    } else {
        # D:\svn\psp2\webcore\trunk\webkit_536_26\Tools\DumpRenderTree\manx\PSP2 Release
        $pathRootDRT = $pathRoot . "/Tools/DumpRenderTree/manx/PSP2\\ Release";
    }

    # Init eXgfBNgݒ
    # testDirectory : /cygdrive/d/svn/psp2/webcore/trunk/webkit_536_26/LayoutTests
    $testDirectory = $_[0]; 
    $logDir = $testDirectory . "/log";

    print "start DumpRenderTree.self cmd path -> " . $pathRootDRT . "\n";

    # "endline.txt"ĎvOʃvZXŋN
    my $monitorToolPath = $pathRoot . "/Tools/Scripts/sony/fileMonitor.pm ";
    my $cmdMonitor = "nohup perl " . $monitorToolPath . $testDirectory . " &";
    print "start fileMonitor cmd -> " . $cmdMonitor . "\n";
    system $cmdMonitor;

    # pid save
    writePidFile();
    
    writeLog("start");

    # fBNgݒ
    checkDir();

    # t@C폜
    deleteLineFile();

    for ($i = 1; $i <= $loopLimit; $i++) {
        ## psp2run cmmand
        my $psp2runLogName = sprintf("/log_psp2run_%06d.txt", $i);
        my $cmd = "cd " . $pathRootDRT . "; psp2run /c /elf DumpRenderTree.self 2>&1 | tee ../../../../LayoutTests/log/" . $logFileName. $psp2runLogName;
        system($cmd);
        # endline.txt ̓Ǎ
        my $endline = readEndLine();
        if ($endline eq "end") {
            print "file write end\n";
            last;
        }
        
        if ($endline >= $cntTestLimit) {
            last;
        }
        # endline.txt ݎsΉ
        if ($oldEndLine > $endline) {
            writeLog("endline < oldEndLine endline : " . $endline . "oldEndLine : " . $oldEndLine);
            $endline = $oldEndLine;
        }
        # startline.txt ̏
        writeStartLine($endline + 1);
        if ($oldEndLine == $endline) {
            $cntStopLimit++;
            if ($cntStopLimit > $stopLimit) {
                $cntStopLimit = 0;
                $endline++;
                writeEndLine($endline);
            }
        } else {
            $cntStopLimit = 0;
        }
        $oldEndLine = $endline;
        
        # psp2run WG[o͂`FbN
        checkPSP2RunLog($psp2runLogName);
    }
    print "ok run l DumpRenderTree.self\n";
    writeLog("end");
    # system 𔲂rootɖ߂ĂB

    # ʃvZXŋNvOkill
    sleep 10;
    killMonitor();
}

sub buildPSVitaProject($@)
{
    my ($project, @buildargs) = @_;

    # prepare parameters to be passed to 'make'
    my @makeargs = "";
    push @makeargs, "/sn-dbs";

    # append 'make' args passed by the user
    foreach (@buildargs) {
        if (/^--makeargs=(.*)/) {
            push @makeargs, $1;
        }
    }

    $top = sourceDir(). "/..";
    $configuration = "PSP2 Debug";
    system("vsibuild.exe $top/browsercore.sln \"$configuration\" /project \"$project\" /build @makeargs");
}

1;
