#!/bin/bash
# Copyright (C) 2013 Sony Computer Entertainment
# All Rights Reserved
orbis-ctrl reboot
orbis_connect=$?
if test ${orbis_connect} -ne 0; then
    echo "orbis not connected!!"
    exit 1
fi
orbis-ctrl connect
echo $WORKSPACE
#change to current build directory
#[Enable when running from Jenkins]
cd $WORKSPACE
#[Enable when running from local and not from Jenkins]
#cd C:\Jenkins-Workspace 
#clean the result directory before test execution
if cd $1; then
   rm -rf *
   #return to build root
   cd ../../
else
   echo "Cannot change directory!" 1>&2
fi
#To ensure Orbis is booted completed
sleep 10

orbis-ctrl fsroot orbis/WebKitTestRunnerOrbis/fsroot/

./webkit_537_73/Tools/Scripts/new-run-webkit-tests --verbose --release --orbis -2  \
--results-directory=$1 \
LayoutTests/$2 \
--no-pixel-tests --no-ref-tests --child-processes=1 --retry-failures \
--exit-after-n-crashes-or-timeouts=8000 --exit-after-n-failures=8000
exit $?
