#!/usr/bin/perl

my $filename = "/endline.txt"; ## monitor filename
my $cnt = 0;                  ## loop cnt
my $logFileName = "";         ## logfile name
my $pid = $$;                 ## PID → 親プロセスからkillしてもらうため
my $testDirectory = $ARGV[0] . "/log" ; ## テストDir
my $monitorPath = $testDirectory . $filename;

my @longTestLine = (4745, 10457, 17163, 17171);

## write pid file
sub writePidFile
{
    my $pidFile = $testDirectory . "/child_pid.txt";
    open(PID_FILE, "> $pidFile");
    print PID_FILE $pid;
    close(PID_FILE);
}

## write time reboot logfile
sub writeLogReboot
{
    my ($sec, $min, $hour, $day, $mon, $year) = localtime;
    $logFileName = sprintf("%04d_%02d%02d_%02d%02d%02d", $year + 1900, $mon + 1, $day ,$hour, $min, $sec) if (!length($logFileName));
    $updateTime = sprintf("%02d/%02d %02d:%02d:%02d ", $mon + 1, $day ,$hour, $min, $sec);
    my $logFile = $testDirectory . "/reboot_" . $logFileName . ".txt";
    open(LOG_WRITE, ">> $logFile");
    print LOG_WRITE $updateTime . " reboot !! \n";
    close(LOG_WRITE);
}

## write logfile time and message 
sub writeLog
{
    return;   # comment out in Debug.
    my $printLog = $_[0];
    my ($sec, $min, $hour, $day, $mon, $year) = localtime;
    $logFileName = sprintf("%04d_%02d%02d_%02d%02d%02d", $year + 1900, $mon + 1, $day ,$hour, $min, $sec) if (!length($logFileName));
    $updateTime = sprintf("%02d/%02d %02d:%02d:%02d %s", $mon + 1, $day ,$hour, $min, $sec, $printLog);
    my $logFile = $testDirectory . "/child_log_" . $logFileName . ".txt";
    open(LOG_WRITE, ">> $logFile");
    print LOG_WRITE $updateTime . "\n";
    close(LOG_WRITE);
}

## LongTimeTest Check
sub isLongTest
{
    # endline を読込実行行数を取得
    open(END_LINE, $monitorPath);
    my $endLine = readline END_LINE;
    chomp $endLine;
    close(END_LINE);

    $endLine++;

    foreach my $line (@longTestLine) {
        if ($line == $endLine) {
            writeLog("childMonitor isLongTest : " . $endLine);
            return ($cnt > 15) ? 0 : 1;
        }
    }
    return 0;
}

## main start!!
writePidFile();
writeLog("childMonitor hellow");
writeLog("monitorPath : " . $monitorPath);

## loop monitor "endline.txt"
while(1) {
    my $lastmodified = (stat $monitorPath)[9];
    if ($cnt == 0) {
        $old = $lastmodified;
    }
#    my ($sec, $min, $hour, $day, $mon, $year) = localtime;
#    $updateTime = sprintf("%02d/%02d %02d:%02d:%02d ", $mon + 1, $day ,$hour, $min, $sec);
#    print $updateTime . " " . $lastmodified . " loop : " . $cnt . "\n";

    $cnt++;

    if ($old == $lastmodified) {
        if ($cnt > 2) {
            if (!isLongTest()) {
                writeLog("to reboot !!");
                system("psp2ctrl reboot &");
                writeLogReboot();
                $cnt = 0;
            }
        }
    } else {
        writeLog("modified cnt reset");
        $cnt = 0;
    }
    sleep 60; #60 で1分ポーリング
}
writeLog("childMonitor good by");


