/* SIE CONFIDENTIAL
 * $PSLibId$
 * Copyright (C) 2011 Sony Interactive Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef _RENDER_H
#define _RENDER_H

#include <gxm.h>
#include <tilebackend/tilebackend.h>

// WebView window parameters
#define WEBVIEW_WIDTH 960
#define WEBVIEW_HEIGHT 544
#define WEBVIEW_FORMAT SCE_GXM_TEXTURE_FORMAT_A8R8G8B8

// Shared Texture Buffer
extern uint8_t *g_testTextureData;

extern tilebackend::Target g_target;

// Create data for clear draw call
void createClearData(void);

// Destroy data for clear draw call
void destroyClearData(void);

// Create data for cube draw call
void createCubeData(void);

// Destroy data for cube draw call
void destroyCubeData(void);

// Create test texture data
void createTestTextureData(uint32_t width, uint32_t height, SceGxmTextureFormat format);

// Destroy test texture data
void destroyTestTextureData(void);

// Create the offscreen buffer
void createOffscreenBuffer(void);

// Destroy the offscreen buffer
void destroyOffscreenBuffer(void);

// Do update step
void updateRender(void);

// Render offscreen buffer
void renderOffscreen(void);

// Render main buffer
void renderMain(void);

// Get View Offset
void getOffset(uint32_t *x, uint32_t *y);

// convert the coord-system for a point. (coord-system: the device-coord to the local-coord on a plane) and returns if the point is on the plane.
// x/y: the point
bool convertScreenToLocalCSS(short& x, short& y);

// popup a window of mag
void popup_mag(float x, float y, float z, float w, float h, float tx, float ty, float tw, float th);

// update a content of mag
void update_mag(float x, float y, float rx, float ry);

// close a window of mag
void dismiss_mag();

#endif /* _RENDER_H */

