/*
 * Copyright (C) 2008 Apple Computer, Inc.  All rights reserved.
 * Copyright 2010 Sony Network Entertainment
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _WEBVIEW_H_
#define _WEBVIEW_H_

#include <stdlib.h>

union VarData {
    int type_int;
    float type_float;
    bool type_bool;
    char type_char;
    char *type_char_ptr;
    const char *type_const_char_ptr;
    unsigned char type_uchar;
    unsigned char *type_uchar_ptr;
    const unsigned char *type_const_uchar_ptr;
    void *type_void_ptr;
};

typedef VarData CallbackData;

enum CallbackType {
    CallbackTypeUndefined = -1,

    CALLBACK_ERROR,
    CALLBACK_SET_TEXTURE,
    CALLBACK_SET_TITLE,
    CALLBACK_SET_URL,
    CALLBACK_HOVER_LINK_URL,
    CALLBACK_HOVER_INPUT_ELEMENT,
    CALLBACK_FOCUS_INPUT_ELEMENT,
    CALLBACK_FOCUS_CHANGED,
    CALLBACK_SCROLL_CHANGED,
    CALLBACK_SHOW_POPUP_MENU,
    CALLBACK_HIDE_POPUP_MENU,
    CALLBACK_LOAD_STARTED,
    CALLBACK_LOAD_FINISHED,
    CALLBACK_LOAD_FAILED,
    CALLBACK_LOAD_PROGRESS_CHANGED,
    CALLBACK_JAVASCRIPT_ALERT,
    CALLBACK_JAVASCRIPT_CONFIRM,
    CALLBACK_JAVASCRIPT_PROMPT,

    CallbackTypeCount
};

enum LoadErrorType {
    LoadErrorTypeUndefined = -1,

    LOAD_ERROR_CANCELLED,
    LOAD_ERROR_BLOCKED,
    LOAD_ERROR_CANNOT_SHOW_URL,
    LOAD_ERROR_INTERRUPTED_FOR_POLICY_CHANGE,
    LOAD_ERROR_CANNOT_SHOW_MIME_TYPE,
    LOAD_ERROR_FILE_DOES_NOT_EXIST,
    LOAD_ERROR_PLUGIN_WILL_HANDLE_LOAD,

    LoadErrorTypeCount
};

enum ScrollEventType {
    ScrollEventTypeUndefined = -1,

    SCROLL_EVENT_UP,
    SCROLL_EVENT_DOWN,
    SCROLL_EVENT_LEFT,
    SCROLL_EVENT_RIGHT,
    SCROLL_EVENT_TOP,
    SCROLL_EVENT_BOTTOM,
    SCROLL_EVENT_PAGE_UP,
    SCROLL_EVENT_PAGE_DOWN,
    SCROLL_EVENT_SET_POSITION,

    ScrollEventTypeCount
};

enum MouseEventType {
    MouseEventTypeUndefined = -1,

    MOUSE_EVENT_MOVED,
    MOUSE_EVENT_PRESSED,
    MOUSE_EVENT_RELEASED,

    MouseEventTypeCount
};

enum MouseButtonType {
    MouseButtonTypeUndefined = -1,

    MOUSE_BUTTON_NONE,
    MOUSE_BUTTON_LEFT,
    MOUSE_BUTTON_MIDDLE,
    MOUSE_BUTTON_RIGHT,
    MOUSE_WHEEL_UP,
    MOUSE_WHEEL_DOWN,

    MouseButtonTypeCount
};

enum KeyEventType {
    KeyEventTypeUndefined = -1,

    KEY_EVENT_PRESSED,
    KEY_EVENT_RELEASED,

    KeyEventTypeCount
};

enum KeyType {
    KeyTypeUndefined = -1,

    KEY_A,
    KEY_B,
    KEY_C,
    KEY_D,
    KEY_E,
    KEY_F,
    KEY_G,
    KEY_H,
    KEY_I,
    KEY_J,
    KEY_K,
    KEY_L,
    KEY_M,
    KEY_N,
    KEY_O,
    KEY_P,
    KEY_Q,
    KEY_R,
    KEY_S,
    KEY_T,
    KEY_U,
    KEY_V,
    KEY_W,
    KEY_X,
    KEY_Y,
    KEY_Z,
    KEY_1,
    KEY_2,
    KEY_3,
    KEY_4,
    KEY_5,
    KEY_6,
    KEY_7,
    KEY_8,
    KEY_9,
    KEY_0,

    KEY_F1,
    KEY_F2,
    KEY_F3,
    KEY_F4,
    KEY_F5,
    KEY_F6,
    KEY_F7,
    KEY_F8,
    KEY_F9,
    KEY_F10,
    KEY_F11,
    KEY_F12,

    KEY_ACCENT,
    KEY_BACKSLASH,
    KEY_BACKSPACE,
    KEY_CAPS_LOCK,
    KEY_COMMA,
    KEY_DELETE,
    KEY_DOWN_ARROW,
    KEY_END,
    KEY_ENTER,
    KEY_EQUAL,
    KEY_ESC,
    KEY_HENKAN,
    KEY_HOME,
    KEY_INSERT,
    KEY_KANA,
    KEY_KANJI,
    KEY_LEFT_ARROW,
    KEY_LEFT_BRACKET,
    KEY_MINUS,
    KEY_MUHENKAN,
    KEY_PAGE_DOWN,
    KEY_PAGE_UP,
    KEY_PAUSE,
    KEY_PERIOD,
    KEY_PRINTSCREEN,
    KEY_QUOTATION,
    KEY_RIGHT_ARROW,
    KEY_RIGHT_BRACKET,
    KEY_SCROLL_LOCK,
    KEY_SEMICOLON,
    KEY_SLASH,
    KEY_SPACE,
    KEY_TAB,
    KEY_UP_ARROW,

    KEY_NUMPAD_1,
    KEY_NUMPAD_2,
    KEY_NUMPAD_3,
    KEY_NUMPAD_4,
    KEY_NUMPAD_5,
    KEY_NUMPAD_6,
    KEY_NUMPAD_7,
    KEY_NUMPAD_8,
    KEY_NUMPAD_9,
    KEY_NUMPAD_0,
    KEY_NUMPAD_ASTERISK,
    KEY_NUMPAD_ENTER,
    KEY_NUMPAD_MINUS,
    KEY_NUMPAD_NUMLOCK,
    KEY_NUMPAD_PERIOD,
    KEY_NUMPAD_PLUS,
    KEY_NUMPAD_SLASH,

    KeyTypeCount
};

typedef VarData HtmlEventData;

enum HtmlEventType {
    HtmlEventTypeUndefined = -1,

    HTML_NODE_FOCUS_NONE,
    HTML_NODE_FOCUS_FORWARD,
    HTML_NODE_FOCUS_BACKWARD,
    HTML_NODE_FOCUS_UP,
    HTML_NODE_FOCUS_DOWN,
    HTML_NODE_FOCUS_LEFT,
    HTML_NODE_FOCUS_RIGHT,
    HTML_INPUT_ELEMENT_SET_VALUE,

    HtmlEventTypeCount
};

class WebView
{
public:
    WebView() {}
    ~WebView() {}

    void create(int width, int height, bool async) {}
    void update() {}

    void setCallbackHandler(
        bool (*callbackHandler)(WebView *webview, void *userData, CallbackType type, const CallbackData *in, CallbackData *out),
        void *userData = NULL) {}

    void getContentSize(int &width, int &height) {}
    void getScrollPosition(int &x, int &y) {}

    void sendScrollEvent(ScrollEventType event, int x=0, int y=0) {}
    void sendMouseEvent(MouseEventType event, MouseButtonType button, int x, int y) {}
    void sendKeyEvent(KeyEventType event, KeyType key, char ascii = 0, bool shift = false, bool ctrl = false, bool alt = false, bool win = false) {}
    void sendHtmlEvent(HtmlEventType event, const HtmlEventData *data = NULL) {}

    void loadUrl(const char *url) {}
    void loadHtml(const char *html) {}

    void reload() {}
    void stop() {}

    bool canGoBack() { return false; }
    void goBack() {}

    bool canGoForward() { return false; }
		void goForward() {}

    bool canIncreaseTextSize() const;
    void increaseTextSize() {}

    bool canDecreaseTextSize() const;
    void decreaseTextSize() {}

    void resetTextSize() {}

    const char *executeJavaScript(const char *javascript) { return NULL; }
};

#endif//_WEBVIEW_H_
