/*
 * Copyright (C) 2006, 2007, 2008, 2009, 2010 Apple Inc. All rights reserved.
 * Copyright (C) 2012 Sony Interactive Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 * 3.  Neither the name of Apple Computer, Inc. ("Apple") nor the names of
 *     its contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "LayoutTestController.h"

#include "DumpRenderTree.h"
#include "NotImplemented.h"
#include "WebCoreSupport/DumpRenderTreeSupportManx.h"
#include "WorkQueue.h"
#include "WorkQueueItem.h"
#include <JavaScriptCore/JSRetainPtr.h>
#include <JavaScriptCore/JavaScriptCore.h>
#include <string>
#include <wtf/Assertions.h>
#include <wtf/Platform.h>
#include <wtf/RetainPtr.h>
#include <wtf/Vector.h>


using namespace std;

LayoutTestController::~LayoutTestController()
{
}

void LayoutTestController::addDisallowedURL(JSStringRef url)
{
    notImplemented();
}

void LayoutTestController::clearBackForwardList()
{
}

bool LayoutTestController::callShouldCloseOnWebView()
{
    return false;
}

JSStringRef LayoutTestController::copyDecodedHostName(JSStringRef name)
{
    return 0;
}

JSStringRef LayoutTestController::copyEncodedHostName(JSStringRef name)
{
    return 0;
}

void LayoutTestController::disableImageLoading()
{
}

void LayoutTestController::dispatchPendingLoadRequests()
{
}

void LayoutTestController::display()
{
}

void LayoutTestController::keepWebHistory()
{
}

JSValueRef LayoutTestController::computedStyleIncludingVisitedInfo(JSContextRef context, JSValueRef value)
{
    return JSValueMakeUndefined(context);
}

JSRetainPtr<JSStringRef> LayoutTestController::layerTreeAsText() const
{

    return 0;
}

JSRetainPtr<JSStringRef> LayoutTestController::markerTextForListItem(JSContextRef context, JSValueRef nodeObject) const
{
    return 0;
}

void LayoutTestController::waitForPolicyDelegate()
{
    waitForPolicy = true;
    setWaitToDump(true);
}

size_t LayoutTestController::webHistoryItemCount()
{
    return 0;
}

unsigned LayoutTestController::workerThreadCount() const
{
    return 0;
}

void LayoutTestController::notifyDone()
{
    if (m_waitToDump)
        dump();

    m_waitToDump = false;
    waitForPolicy = false;
}

JSStringRef LayoutTestController::pathToLocalResource(JSContextRef context, JSStringRef url)
{
    return JSStringCreateWithCharacters(JSChar(), 0);
}

void LayoutTestController::queueLoad(JSStringRef url, JSStringRef target)
{
}

void LayoutTestController::setAcceptsEditing(bool acceptsEditing)
{
}

void LayoutTestController::setAlwaysAcceptCookies(bool alwaysAcceptCookies)
{
}

void LayoutTestController::setAuthorAndUserStylesEnabled(bool flag)
{
}

void LayoutTestController::setAutofilled(JSContextRef context, JSValueRef nodeObject, bool autofilled)
{
}

void LayoutTestController::setCustomPolicyDelegate(bool setDelegate, bool permissive)
{
}

void LayoutTestController::setMockDeviceOrientation(bool canProvideAlpha, double alpha, bool canProvideBeta, double beta, bool canProvideGamma, double gamma)
{
}

void LayoutTestController::setMockGeolocationPosition(double latitude, double longitude, double accuracy)
{
}

void LayoutTestController::setMockGeolocationError(int code, JSStringRef message)
{
}

void LayoutTestController::setGeolocationPermission(bool allow)
{
}

int LayoutTestController::numberOfPendingGeolocationPermissionRequests()
{
    return -1;
}

void LayoutTestController::addMockSpeechInputResult(JSStringRef result, double confidence, JSStringRef language)
{
}

void LayoutTestController::setMockSpeechInputDumpRect(bool flag)
{
}

void LayoutTestController::startSpeechInput(JSContextRef inputElement)
{
}

void LayoutTestController::setIconDatabaseEnabled(bool iconDatabaseEnabled)
{
}

void LayoutTestController::setMainFrameIsFirstResponder(bool flag)
{
}

void LayoutTestController::setPrivateBrowsingEnabled(bool privateBrowsingEnabled)
{
}

void LayoutTestController::setXSSAuditorEnabled(bool enabled)
{
}

void LayoutTestController::setFrameFlatteningEnabled(bool enabled)
{
}

void LayoutTestController::setSpatialNavigationEnabled(bool enabled)
{
}

void LayoutTestController::setAllowUniversalAccessFromFileURLs(bool enabled)
{
}

void LayoutTestController::setAllowFileAccessFromFileURLs(bool enabled)
{
}

void LayoutTestController::setPopupBlockingEnabled(bool enabled)
{
}

void LayoutTestController::setPluginsEnabled(bool flag)
{
}

void LayoutTestController::setJavaScriptCanAccessClipboard(bool enabled)
{
}

void LayoutTestController::setTabKeyCyclesThroughElements(bool shouldCycle)
{
}

void LayoutTestController::setUseDashboardCompatibilityMode(bool flag)
{
}

void LayoutTestController::setUserStyleSheetEnabled(bool flag)
{
}

void LayoutTestController::setUserStyleSheetLocation(JSStringRef jsURL)
{
}

void LayoutTestController::setValueForUser(JSContextRef context, JSValueRef element, JSStringRef value)
{
}

void LayoutTestController::setViewModeMediaFeature(JSStringRef mode)
{
}

void LayoutTestController::setPersistentUserStyleSheetLocation(JSStringRef jsURL)
{
}

void LayoutTestController::clearPersistentUserStyleSheet()
{
}

void LayoutTestController::setWindowIsKey(bool flag)
{
}

void LayoutTestController::setSmartInsertDeleteEnabled(bool flag)
{
}

void LayoutTestController::setJavaScriptProfilingEnabled(bool flag)
{
}

void LayoutTestController::setSelectTrailingWhitespaceEnabled(bool flag)
{
}
static bool waitToDumpWatchdogFired()
{
    setWaitToDumpWatchdog(0);
    gLayoutTestController->waitToDumpWatchdogTimerFired();
    return FALSE;
}
void LayoutTestController::setWaitToDump(bool waitUntilDone)
{
    static const int timeoutSeconds = 3;

    m_waitToDump = waitUntilDone;
    if (m_waitToDump && shouldSetWaitToDumpWatchdog()) {
        sceKernelDelayThread(timeoutSeconds * 1000 *1000);
        waitToDumpWatchdogFired();
        setWaitToDumpWatchdog(1);
    }
}

int LayoutTestController::windowCount()
{
    return 1;
}

bool LayoutTestController::elementDoesAutoCompleteForElementWithId(JSStringRef id)
{
    return false;
}

void LayoutTestController::execCommand(JSStringRef name, JSStringRef value)
{
}

bool LayoutTestController::findString(JSContextRef /* context */, JSStringRef /* target */, JSObjectRef /* optionsArray */)
{
    return false;
}

void LayoutTestController::setCacheModel(int)
{
}

bool LayoutTestController::isCommandEnabled(JSStringRef /*name*/)
{
    return false;
}

void LayoutTestController::clearAllApplicationCaches()
{
}

void LayoutTestController::clearApplicationCacheForOrigin(JSStringRef origin)
{
}

void LayoutTestController::setApplicationCacheOriginQuota(unsigned long long quota)
{
}

JSValueRef LayoutTestController::originsWithApplicationCache(JSContextRef context)
{
    return JSValueMakeUndefined(context);
}

long long LayoutTestController::applicationCacheDiskUsageForOrigin(JSStringRef name)
{
    // FIXME: Implement to get disk usage by all application caches for an origin.
    return 0;
}

void LayoutTestController::clearAllDatabases()
{
}

void LayoutTestController::overridePreference(JSStringRef key, JSStringRef value)
{
}

void LayoutTestController::setDatabaseQuota(unsigned long long quota)
{
}

void LayoutTestController::goBack()
{
}

void LayoutTestController::setDefersLoading(bool)
{
}

void LayoutTestController::setDomainRelaxationForbiddenForURLScheme(bool forbidden, JSStringRef scheme)
{
}

void LayoutTestController::setAppCacheMaximumSize(unsigned long long size)
{
}

bool LayoutTestController::pauseAnimationAtTimeOnElementWithId(JSStringRef animationName, double time, JSStringRef elementId)
{
    return false;
}

bool LayoutTestController::pauseTransitionAtTimeOnElementWithId(JSStringRef propertyName, double time, JSStringRef elementId)
{
    return false;
}

unsigned LayoutTestController::numberOfActiveAnimations() const
{
    return 0;
}

void LayoutTestController::suspendAnimations() const
{
}

void LayoutTestController::resumeAnimations() const
{
}

void LayoutTestController::addOriginAccessWhitelistEntry(JSStringRef sourceOrigin, JSStringRef destinationProtocol, JSStringRef destinationHost, bool allowDestinationSubdomains)
{
}

void LayoutTestController::removeOriginAccessWhitelistEntry(JSStringRef sourceOrigin, JSStringRef destinationProtocol, JSStringRef destinationHost, bool allowDestinationSubdomains)
{
}

void LayoutTestController::setScrollbarPolicy(JSStringRef orientation, JSStringRef policy)
{
}

void LayoutTestController::addUserScript(JSStringRef source, bool runAtStart, bool allFrames)
{
}


void LayoutTestController::addUserStyleSheet(JSStringRef source, bool allFrames)
{
}

void LayoutTestController::setDeveloperExtrasEnabled(bool enabled)
{
}

void LayoutTestController::setAsynchronousSpellCheckingEnabled(bool)
{
}

void LayoutTestController::showWebInspector()
{
}

void LayoutTestController::closeWebInspector()
{
}

void LayoutTestController::evaluateInWebInspector(long callId, JSStringRef script)
{
}

void LayoutTestController::evaluateScriptInIsolatedWorld(unsigned worldID, JSObjectRef globalObject, JSStringRef script)
{
}

void LayoutTestController::removeAllVisitedLinks()
{
}

JSRetainPtr<JSStringRef> LayoutTestController::counterValueForElementById(JSStringRef id)
{
    return JSRetainPtr<JSStringRef>();
}

int LayoutTestController::pageNumberForElementById(JSStringRef id, float pageWidthInPixels, float pageHeightInPixels)
{
    return 0;
}

int LayoutTestController::numberOfPages(float pageWidthInPixels, float pageHeightInPixels)
{
    return 0;
}

JSRetainPtr<JSStringRef> LayoutTestController::pageProperty(const char* propertyName, int pageNumber) const
{
    return JSRetainPtr<JSStringRef>();
}

void LayoutTestController::apiTestNewWindowDataLoadBaseURL(JSStringRef utf8Data, JSStringRef baseURL)
{
}

bool LayoutTestController::isPageBoxVisible(int pageNumber) const
{
    return false;
}

JSRetainPtr<JSStringRef> LayoutTestController::pageSizeAndMarginsInPixels(int pageNumber, int width, int height, int marginTop, int marginRight, int marginBottom, int marginLeft) const
{
    return JSRetainPtr<JSStringRef>();
}

void LayoutTestController::apiTestGoToCurrentBackForwardItem()
{
}

void LayoutTestController::setWebViewEditable(bool)
{
}

void LayoutTestController::authenticateSession(JSStringRef, JSStringRef, JSStringRef)
{
}

void LayoutTestController::setEditingBehavior(const char* editingBehavior)
{
}

void LayoutTestController::abortModal()
{
}

void LayoutTestController::dumpConfigurationForViewport(int /*deviceDPI*/, int /*deviceWidth*/, int /*deviceHeight*/, int /*availableWidth*/, int /*availableHeight*/)
{
}

void LayoutTestController::setSerializeHTTPLoads(bool)
{
}

void LayoutTestController::syncLocalStorage()
{
}

void LayoutTestController::observeStorageTrackerNotifications(unsigned number)
{
}

void LayoutTestController::deleteAllLocalStorage()
{
}

JSValueRef LayoutTestController::originsWithLocalStorage(JSContextRef context)
{
    return JSValueMakeUndefined(context);
}

long long LayoutTestController::localStorageDiskUsageForOrigin(JSStringRef originIdentifier)
{
    return 0;
}

void LayoutTestController::deleteLocalStorageForOrigin(JSStringRef URL)
{
}

void LayoutTestController::setMinimumTimerInterval(double minimumTimerInterval)
{
}

void LayoutTestController::setTextDirection(JSStringRef direction)
{
}

void LayoutTestController::allowRoundingHacks()
{
}

void LayoutTestController::addChromeInputField()
{
}

void LayoutTestController::removeChromeInputField()
{
}

void LayoutTestController::focusWebView()
{
}

void LayoutTestController::setBackingScaleFactor(double)
{
}

void LayoutTestController::simulateDesktopNotificationClick(JSStringRef title)
{
}

void LayoutTestController::setPageVisibility(const char* visibilityBuffer)
{
}
void LayoutTestController::resetPageVisibility()
{
}
void LayoutTestController::evaluateScriptInIsolatedWorldAndReturnValue(unsigned worldID, JSObjectRef globalObject, JSStringRef script)
{
}
