#include "config.h"
#include "GCController.h"

#include "WebCoreSupport/DumpRenderTreeSupportManx.h"

void GCController::collect() const
{
    DumpRenderTreeSupportManx::gcCollectJavascriptObjects();
}

void GCController::collectOnAlternateThread(bool waitUntilDone) const
{
    DumpRenderTreeSupportManx::gcCollectJavascriptObjectsOnAlternateThread(waitUntilDone);
}

size_t GCController::getJSObjectCount() const
{
    return DumpRenderTreeSupportManx::gcCountJavascriptObjects();
}
