/*
 * Copyright (C) 2011 Samsung Electronics. All rights reserved.
 * Copyright (C) 2012 Sony Interactive Entertainment Inc.
 * Copyright (C) 2014 Sony Interactive Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY MOTOROLA INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL MOTOROLA INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WebProcess.h"

#include "WebProcessCreationParameters.h"
#include <WebCore/AXObjectCache.h>
#include <WebCore/NotImplemented.h>
#include <WebCore/RunLoop.h>
#if USE(NTF)
#include <ntf/Common.h>
#include <ntf/NetworkControl.h>
#include <ntf/Proxy.h>
#include <ntf/WebSecurity.h>
#endif
#include <wtf/text/CString.h>

namespace WebKit {

void WebProcess::platformSetCacheModel(CacheModel)
{
    notImplemented();
}

void WebProcess::platformClearResourceCaches(ResourceCachesToClear)
{
    notImplemented();
}

void WebProcess::platformInitializeWebProcess(const WebProcessCreationParameters& parameters, CoreIPC::MessageDecoder&)
{
    CString userIDString = String::number(parameters.userID).ascii();
    setenv("WEBKIT_USER_ID", userIDString.data(), 1);
    setenv("WEBKIT_NET_SKIP_CLEAR_SESSCOOKIE", "1", 1);

#if USE(NTF)
    // Initialization of the NTF
    NTF::CreationParameters ntfCreationParameters;

    const char* secureWebProcess = getenv("MANX_SECURE_WEB_PROCESS");
    if (secureWebProcess && !strcmp(secureWebProcess, "1"))
        ntfCreationParameters.isSecureWebProcess = true;

    const char* webProcessHTMLTile = getenv("MANX_WEB_PROCESS_HTML_TILE");
    if (webProcessHTMLTile && !strcmp(webProcessHTMLTile, "1"))
        ntfCreationParameters.isWebProcessHTMLTile = true;

    const char* systemProxyOnSecureEnv = getenv("MANX_PROXY_SETTING");
    if (systemProxyOnSecureEnv && !strcmp(systemProxyOnSecureEnv, "1"))
        ntfCreationParameters.useSystemProxyOnSecureEnv = true;

    size_t length = parameters.cookieStorageDirectory.utf8().length();
    size_t arraySize = sizeof(ntfCreationParameters.cookieStorageDirectory);

    if ((length > 0) && (length < arraySize)) {
        strncpy(ntfCreationParameters.cookieStorageDirectory, parameters.cookieStorageDirectory.utf8().data(), arraySize - 1);
        ntfCreationParameters.cookieStorageDirectory[arraySize - 1] = '\0';
    }

    ntfCreationParameters.cookieJarDBMode = parameters.cookieMode;

    length = parameters.diskCacheDirectory.utf8().length();
    arraySize = sizeof(ntfCreationParameters.diskCacheDirectory);

    if ((length > 0) && (length < arraySize)) {
        strncpy(ntfCreationParameters.diskCacheDirectory, parameters.diskCacheDirectory.utf8().data(), arraySize - 1);
        ntfCreationParameters.diskCacheDirectory[arraySize - 1] = '\0';
    }

    NTF::initialize(ntfCreationParameters);
#endif

#if HAVE(ACCESSIBILITY)
    if (parameters.enableAccessibility)
        WebCore::AXObjectCache::enableAccessibility();
#endif
}

void WebProcess::platformTerminate()
{
#if USE(NTF)
    NTF::finalize();
#endif
}

void WebProcess::setPrivilegedNetworkBandwidth(uint32_t bandwidthMode)
{
#if USE(NTF)
    NTF::NetworkControl::setPrivilegedNetworkBandwidth(bandwidthMode);
#endif
}

void WebProcess::setIFilterHTTPProxy(bool enable, String server, int port, String userId, String password)
{
#if USE(NTF)
    NTF::Proxy::setIFilterHTTPProxy(enable,
        server.latin1().data(), 
        server.length(),
        port,
        userId.latin1().data(), 
        userId.length(),
        password.latin1().data(), 
        password.length());
#endif
}

void WebProcess::setWebSecurityFilter(int filterMode)
{
#if USE(NTF)
    NTF::WebSecurity::setUrlFilterMode(filterMode);
#endif
}

void WebProcess::setHTTPProxy(bool enable, String server, int port, String userId, String password)
{
#if USE(NTF)
    NTF::Proxy::setHTTPProxy(enable,
        server.latin1().data(), 
        server.length(),
        port,
        userId.latin1().data(), 
        userId.length(),
        password.latin1().data(), 
        password.length());
#endif
}

} // namespace WebKit
