/*
 * Copyright (C) 2013 Sony Interactive Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY SONY INTERACTIVE ENTERTAINMENT INC. ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL SONY INTERACTIVE ENTERTAINMENT INC.
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WKBundleManx.h"

#include "InjectedBundle.h"
#include "WKBundleAPICast.h"
#include <MemoryCache.h>
#include <wtf/OSAllocator.h>

using namespace WebKit;

void WKBundleGetFastMallocStatistics(WKBundleRef bundleRef, size_t* usedBytes, size_t* reservedBytes)
{
    toImpl(bundleRef)->getFastMallocStatistics(usedBytes, reservedBytes);
}

void WKBundleGetJavaScriptHeapStatistics(WKBundleRef bundleRef, size_t* usedBytes, size_t* reservedBytes)
{
    toImpl(bundleRef)->javaScriptHeapStatistics(usedBytes, reservedBytes);
}

void WKBundleShutdownProcess(WKBundleRef bundleRef)
{
    toImpl(bundleRef)->shutdownProcess();
}

void WKBundleClearAllDiskcaches(WKBundleRef bundleRef)
{
    toImpl(bundleRef)->clearAllDiskcaches();
}

void WKBundleSetGarbageCollectClient(WKBundleRef bundleRef, WKBundleGarbageCollectClient* wkClient)
{
    toImpl(bundleRef)->initializeGCClient(wkClient);
}

static inline WKBundleMemoryCacheTypeStatistic convert(const WebCore::MemoryCache::TypeStatistic& from)
{
    WKBundleMemoryCacheTypeStatistic to;
    to.count = from.count;
    to.size = from.size;
    to.liveSize = from.liveSize;
    to.decodedSize = from.decodedSize;
    to.purgeableSize = from.purgeableSize;
    to.purgedSize = from.purgedSize;
    return to;
}

void WKBundleGetMemoryCacheStatistics(WKBundleRef, WKBundleMemoryCacheStatistics* out)
{
    if (!out)
        return;

    WebCore::MemoryCache::Statistics stat = WebCore::memoryCache()->getStatistics();
    out->images = convert(stat.images);
    out->cssStyleSheets = convert(stat.cssStyleSheets);
    out->scripts = convert(stat.scripts);
    out->xslStyleSheets = convert(stat.xslStyleSheets);
    out->fonts = convert(stat.fonts);
}
