/*
 * Copyright (C) 2015 Sony Interactive Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WKBundleFrameManx_h
#define WKBundleFrameManx_h

#include <WebKit2/WKBase.h>
#include <WebKit2/WKFrame.h>

#ifdef __cplusplus
extern "C" {
#endif

WK_EXPORT WKCertificateInfoRef WKBundleFrameCopyCertificateInfo(WKBundleFrameRef);

WK_EXPORT bool WKBundleFrameEnableHTMLTile(WKBundleFrameRef, WKBundleScriptWorldRef);
WK_EXPORT bool WKBundleFrameRegisterAsyncImageDecoder(WKStringRef propertyName, WKBundleFrameRef, WKBundleScriptWorldRef);

WK_EXPORT double WKBundleFrameConvertMonotonicTimeToDocumentTime(WKBundleFrameRef, double timestamp);

typedef void (*WKBundleInjectSceExtensionsCallback)(WKBundleFrameRef, WKBundleScriptWorldRef, const void* clientInfo);

struct WKBundleSceExtensionsClient {
    int                                     version;
    const void*                             clientInfo;
    WKBundleInjectSceExtensionsCallback      injectSceExtensions;
};
typedef struct WKBundleSceExtensionsClient WKBundleSceExtensionsClient;
enum { kWKBundleSceExtensionsClientCurrentVersion = 0 };

struct WKBundleGLMemoryInfo {
    size_t heap; /* Various runtime heap memory usage */
    size_t texture; /* Memory used for Texture surfaces */
    size_t surfaces; /* Memory used for Render and Display surfaces for Color, Depth and Stencil */
    size_t programs; /* Memory used for Shader and Programs */
    size_t buffers; /* Memory used for Buffers, vertex ringbuffers */
    size_t commandBuffers; /* Memory used for the underlying Command Buffers */
    size_t total; /* Total memory used by driver */
    size_t maxAllowed; /* Maximum memory allowed to be used, 0 if no restriction */
};
typedef struct WKBundleGLMemoryInfo WKBundleGLMemoryInfo;
WK_EXPORT void WKBundleFrameGetACMemoryInfo(WKBundleFrameRef, WKBundleGLMemoryInfo*);

WK_EXPORT void WKBundleFrameEnableThrottlingByTileCount(WKBundleFrameRef, int count);
WK_EXPORT void WKBundleFrameEnableThrottlingByTime(WKBundleFrameRef, double timeInMs);
WK_EXPORT void WKBundleFrameDisableThrottlingByTileCount(WKBundleFrameRef);
WK_EXPORT void WKBundleFrameDisableThrottlingByTime(WKBundleFrameRef);

#ifdef __cplusplus
}
#endif

#endif /* WKBundleFrameManx_h */

