/*
 * Copyright (C) 2013 Sony Interactive Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WebViewContextMenuClient.h"

#include "WebContextMenuItem.h"
#include "WebView.h"

using namespace WebCore;

namespace WebKit {

void WebViewContextMenuClient::showContextMenu(WebView* view, const WebCore::IntPoint& point, const Vector<WebContextMenuItemData>& items)
{
    if (!m_client.showContextMenu)
        return;

    WTF::Vector<RefPtr<APIObject> > ContextMenuItems;
    ContextMenuItems.reserveCapacity(items.size());
        
    for (int i = 0; i < items.size(); i++) 
        ContextMenuItems.append(WebContextMenuItem::create(items[i]));
        
    RefPtr<ImmutableArray> immutableArray = ImmutableArray::adopt(ContextMenuItems);
    WKArrayRef itemArray = toAPI(immutableArray.get());

    m_client.showContextMenu(toAPI(view), toAPI(point), itemArray, m_client.clientInfo);
}

void WebViewContextMenuClient::hideContextMenu(WebView* view)
{
    if (!m_client.hideContextMenu)
        return;
    m_client.hideContextMenu(toAPI(view), m_client.clientInfo);
}

} // namespace WebKit
