/*
 * Copyright (C) 2010 Apple Inc. All rights reserved.
 * Copyright (C) 2012 Sony Interactive Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WebInspectorProxy.h"

#if ENABLE(INSPECTOR)

#include "NotImplemented.h"
#include "WebInspectorServer.h"
#include "WebProcessProxy.h"
#include "WebView.h"

namespace {
    WebKit::WebView* inspectorView = 0;
}

namespace WebKit {

WebPageProxy* WebInspectorProxy::platformCreateInspectorPage()
{
    ASSERT(m_page);

    if (!inspectorView) {
        WKViewClient viewClient = {0};
        viewClient.version = kWKViewClientCurrentVersion;

        inspectorView = WebView::create(page()->process()->context(), inspectorPageGroup(), &viewClient).leakRef();
    }

    return inspectorView->page();
}

void WebInspectorProxy::platformOpen()
{
    if (inspectorView)
        inspectorView->setIsVisible(true);
}

void WebInspectorProxy::platformDidClose()
{
    delete inspectorView;
    inspectorView = 0;
}

void WebInspectorProxy::platformBringToFront()
{
}

bool WebInspectorProxy::platformIsFront()
{
    return true;
}

void WebInspectorProxy::platformInspectedURLChanged(const String&)
{
}

unsigned WebInspectorProxy::platformInspectedWindowWidth()
{
    return 1920;
}

unsigned WebInspectorProxy::platformInspectedWindowHeight()
{
    return 1080;
}

void WebInspectorProxy::platformAttach()
{
}

void WebInspectorProxy::platformDetach()
{
}

void WebInspectorProxy::platformSetAttachedWindowHeight(unsigned height)
{
}

void WebInspectorProxy::platformSetAttachedWindowWidth(unsigned)
{
}

void WebInspectorProxy::platformSetToolbarHeight(unsigned)
{
}

void WebInspectorProxy::platformSave(const String&, const String&, bool)
{
    notImplemented();
}

void WebInspectorProxy::platformAppend(const String&, const String&)
{
    notImplemented();
}

String WebInspectorProxy::inspectorPageURL() const
{
#if ENABLE(INSPECTOR_SERVER)
    static String localPageURL = inspectorBaseURL() +
        String("external/inspector/front-end/inspector.html?inspectortest=true&page=1&host=") +
        WebInspectorServer::shared().bindAddress() +
        String::format(":%d", WebInspectorServer::shared().port());
#else
    static String localPageURL = inspectorBaseURL() +
        String("external/inspector/front-end/inspector.html");
#endif
    static String remotePageURL = inspectorBaseURL() +
        String("inspector.html");
    return inspectorView ? localPageURL : remotePageURL;
}

String WebInspectorProxy::inspectorBaseURL() const
{
    static String baseURL = String("file://") + getenv("MANX_INSPECTOR_SERVER_PATH");
    if (!baseURL.endsWith('/'))
        baseURL.append('/');

    return baseURL;
}

void WebInspectorProxy::platformHide()
{
    if (inspectorView)
        inspectorView->setIsVisible(false);
}

void WebInspectorProxy::platformAttachAvailabilityChanged(bool)
{
}

} // namespace WebKit

#endif // ENABLE(INSPECTOR)
