/*
 * Copyright (C) 2008 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2012 Sony Interactive Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WebViewSettings.h"

#include "InspectorClientManx.h"
#include "InspectorController.h"
#include "Page.h"
#include "Settings.h"
#include "WebViewPrivate.h"

#if USE(NTF)
#include <ntf/Setting.h>
#endif

namespace WebKit {

SettingsImpl::SettingsImpl(WebViewPrivate& webView)
    : m_webView(webView)
{
}

WebCore::Settings& SettingsImpl::settings()
{
    return *m_webView.m_page->settings();
}

void SettingsImpl::setScriptEnabled(bool enable)
{
    settings().setScriptEnabled(enable);
}

void SettingsImpl::setCookieEnabled(bool enable)
{
    settings().setCookieEnabled(enable);

#if USE(NTF)
    NTF::Setting::Setting::setCookieEnabled(enable);
#endif
}

void SettingsImpl::setWebGLEnabled(bool enable)
{
    settings().setWebGLEnabled(enable);
}

void SettingsImpl::setWebSecurityEnabled(bool enable)
{
    // FIXME: Should we use m_webSecurityEnabled of WebCore::Settings?
    settings().setWebSecurityEnabled(enable);
}

void SettingsImpl::setDeveloperExtrasEnabled(bool enable)
{
    settings().setDeveloperExtrasEnabled(enable);
#if ENABLE(INSPECTOR_SERVER)
    static_cast<WebCore::InspectorClientManx*>(m_webView.m_page->inspectorController()->inspectorClient())->setRemoteInspectionEnabled(enable);
#endif
}

} // namespace WebKit
