/*
 Copyright (C) 2013 Nokia Corporation and/or its subsidiary(-ies)
 Copyright (C) 2014 Sony Interactive Entertainment Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 Boston, MA 02110-1301, USA.
 */

#ifndef AcagiTiledBackingStore_h
#define AcagiTiledBackingStore_h

#if USE(ACCELERATED_COMPOSITING) && USE(ACAGI)

#include "AcagiBackingStore.h"
#include "AcagiTile.h"
#include "FloatRect.h"
#include "Image.h"
#include <wtf/RefPtr.h>

namespace WebCore {

class AcagiCompositor;

class AcagiTiledBackingStore : public AcagiBackingStore {
public:
    static PassRefPtr<AcagiTiledBackingStore> create() { return adoptRef(new AcagiTiledBackingStore); }
    virtual ~AcagiTiledBackingStore() { }

    virtual PassRefPtr<AcagiBitmapTexture> texture() const OVERRIDE;
    virtual void compositeContents(AcagiCompositor*, const FloatRect&, const TransformationMatrix&, float) OVERRIDE;
    virtual void drawBorder(AcagiCompositor*, const Color&, float borderWidth, const FloatRect&, const TransformationMatrix&) OVERRIDE;
    virtual void drawRepaintCounter(AcagiCompositor*, int repaintCount, const Color&, const FloatRect&, const TransformationMatrix&) OVERRIDE;
    void updateContents(AcagiCompositor*, Image*, const FloatSize&, const IntRect&, AcagiBitmapTexture::UpdateContentsFlag);
    void updateContents(AcagiCompositor*, GraphicsLayer*, const FloatSize&, const FloatRect&, const IntRect&, AcagiBitmapTexture::UpdateContentsFlag);

    void setContentsToImage(Image* image) { m_image = image; }

private:
    AcagiTiledBackingStore();
    void createOrDestroyTilesIfNeeded(const FloatSize& backingStoreSize, const FloatRect& visibleContentRect, float contentsScale, const IntSize& tileSize, bool hasAlpha);
    void updateContentsFromImageIfNeeded(AcagiCompositor*);
    TransformationMatrix adjustedTransformForRect(const FloatRect&);
    inline FloatRect rect() const { return FloatRect(FloatPoint::zero(), m_size); }

    Vector<AcagiTile> m_tiles;
    FloatSize m_size;
    FloatRect m_coveredRect;
    float m_contentsScale;
    RefPtr<Image> m_image;
};

} // namespace WebCore
#endif

#endif
