/*
 * Copyright (C) 2014 Sony Interactive Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
#include "config.h"

#if ENABLE(MEDIA_SOURCE)

#include "SourceBufferPrivateManx.h"

// #define TRACE_FUNCTION printf("[WebCore::MediaPlayerPrivate] %s\n", __FUNCTION__)
#define TRACE_FUNCTION

namespace WebCore {

SourceBufferPrivateManx* SourceBufferPrivateManx::create()
{
    return new SourceBufferPrivateManx();
}

SourceBufferPrivateManx::SourceBufferPrivateManx()
    : m_platformSourceBuffer(0)
{
    TRACE_FUNCTION;
    m_platformSourceBuffer = Manx::SourceBuffer::create();
}

SourceBufferPrivateManx::~SourceBufferPrivateManx()
{
    TRACE_FUNCTION;
    delete m_platformSourceBuffer;
}

PassRefPtr<TimeRanges> SourceBufferPrivateManx::buffered()
{
    TRACE_FUNCTION;

    uint32_t length = 0;
    Manx::SourceBuffer::BufferedTimeRange bufferedTimeRange[Manx::SourceBuffer::BufferedTimeRangeArraySize];
    RefPtr<TimeRanges> timeRanges = TimeRanges::create();

    m_platformSourceBuffer->buffered(bufferedTimeRange, &length);

    for (uint32_t i = 0; i < length; i++)
        timeRanges->add(bufferedTimeRange[i].start, bufferedTimeRange[i].end);

    return timeRanges.release();
}

void SourceBufferPrivateManx::append(const unsigned char* data, unsigned length)
{
    TRACE_FUNCTION;
    m_platformSourceBuffer->append(data, length);
}

void SourceBufferPrivateManx::abort()
{
    TRACE_FUNCTION;
    m_platformSourceBuffer->abort();
}

bool SourceBufferPrivateManx::setTimestampOffset(double timestampOffset)
{
    TRACE_FUNCTION;
    return m_platformSourceBuffer->setTimestampOffset(timestampOffset);
}

void SourceBufferPrivateManx::removedFromMediaSource()
{
    TRACE_FUNCTION;
    m_platformSourceBuffer->removedFromMediaSource();
}

} // namespace WebCore

#endif // ENABLE(MEDIA_SOURCE)
