{
    'includes': [
        '../WebCore.gypi',
        ],

    'variables': {
        'webcore_include_dirs' : [
            '../accessibility/manx',
            '../Modules/asyncimagedecoder',
            '../Modules/htmltile',
            '../page/manx',
            '../platform/graphics/cairo',
            '../platform/graphics/gpu',
            '../platform/graphics/opengl',
            '../platform/graphics/manx',
            '../platform/network/ntf',
            '../platform/graphics/texmap',
            '../platform/graphics/surfaces/egl',
            '../platform/graphics/surfaces/manx',
            '../platform/manx',

            '../..',
        ], # webcore_include_dirs
        'webcore_files' : [
            '../accessibility/manx/AccessibilityObjectManx.cpp',
            '../accessibility/manx/AXObjectCacheManx.cpp',
            '../bindings/js/ScriptControllerManx.cpp',
            '../editing/manx/EditorManx.cpp',
            '../Modules/asyncimagedecoder/AsyncImageDecoder.h',
            '../Modules/asyncimagedecoder/AsyncImageDecoder.cpp',
            '../Modules/htmltile/HTMLTile.h',
            '../Modules/htmltile/HTMLTile.cpp',
            '../Modules/htmltile/HTMLTileClient.h',
            '../page/manx/CursorNavigation.cpp',
            '../page/manx/CursorNavigation.h',
            '../page/manx/DragControllerManx.cpp',
            '../page/manx/EventHandlerManx.cpp',
            '../page/manx/FocusControllerManx.cpp',
            '../platform/graphics/cairo/PlatformContextCairo.cpp',
            '../platform/graphics/cairo/PlatformContextCairo.h',
            '../platform/graphics/cairo/PlatformPathCairo.cpp',
            '../platform/graphics/cairo/PlatformPathCairo.h',
            '../platform/graphics/manx/FontCacheManx.cpp',
            '../platform/graphics/manx/FontCustomPlatformDataManx.cpp',
            '../platform/graphics/manx/FontStreamBufferManx.cpp',
            '../platform/graphics/manx/FontStreamBufferManx.h',
            '../platform/graphics/manx/FontPlatformData.h',
            '../platform/graphics/manx/FontPlatformDataManx.cpp',
            '../platform/graphics/manx/FontManx.cpp',
            '../platform/graphics/manx/FtStreamManx.cpp',
            '../platform/graphics/manx/FtStreamManx.h',
            '../platform/graphics/manx/GlyphPageTreeNodeManx.cpp',
            '../platform/graphics/manx/IconManx.cpp',
            '../platform/graphics/manx/ImageManx.cpp',
            '../platform/graphics/manx/MediaPlayerPrivateManx.cpp',
            '../platform/graphics/manx/MediaPlayerPrivateManx.h',
            '../platform/graphics/manx/MediaSourcePrivateManx.cpp',
            '../platform/graphics/manx/MediaSourcePrivateManx.h',
            '../platform/graphics/manx/SimpleFontDataManx.cpp',
            '../platform/graphics/manx/SourceBufferPrivateManx.cpp',
            '../platform/graphics/manx/SourceBufferPrivateManx.h',
            '../platform/graphics/manx/TileUpdateThrottle.cpp',
            '../platform/graphics/manx/TileUpdateThrottle.h',
            '../platform/graphics/manx/BuiltinShaderCompiler.cpp',
            '../platform/graphics/manx/BuiltinShaderCompiler.h',
            '../platform/graphics/manx/VideoLayerManx.cpp',
            '../platform/graphics/manx/VideoLayerManx.h',
            '../platform/network/ntf/AuthenticationChallenge.h',
            '../platform/network/ntf/CookieJarNtf.cpp',
            '../platform/network/ntf/CookieStorageNtf.cpp',
            '../platform/network/ntf/CredentialBackingStoreNtf.cpp',
            '../platform/network/ntf/CredentialBackingStoreNtf.h',
            '../platform/network/ntf/CredentialStorageNtf.cpp',
            '../platform/network/ntf/CredentialTransformDataNtf.cpp',
            '../platform/network/ntf/CredentialTransformDataNtf.h',
            '../platform/network/ntf/DNSNtf.cpp',
            '../platform/network/ntf/NetworkStateNotifierNtf.cpp',
            '../platform/network/ntf/ProxyServerNtf.cpp',
            '../platform/network/ntf/ResourceError.h',
            '../platform/network/ntf/ResourceHandleNtf.cpp',
            '../platform/network/ntf/ResourceRequest.h',
            '../platform/network/ntf/ResourceRequestNtf.cpp',
            '../platform/network/ntf/ResourceResponse.h',
            '../platform/network/ntf/SocketStreamError.h',
            '../platform/network/ntf/SocketStreamHandle.h',
            '../platform/network/ntf/SocketStreamHandleNtf.h',
            '../platform/network/ntf/SocketStreamHandleNtf.cpp',
            '../platform/network/ntf/URLRequestData.cpp',
            '../platform/network/ntf/URLRequestData.h',
            '../platform/network/ntf/URLRequestFile.cpp',
            '../platform/network/ntf/URLRequestFile.h',
            '../platform/network/ntf/URLRequestHttp.cpp',
            '../platform/network/ntf/URLRequestHttp.h',
            '../platform/network/ntf/URLRequestJobFactory.cpp',
            '../platform/network/ntf/URLRequestJobFactory.h',
            '../platform/network/ntf/URLRequestListenerNtf.cpp',
            '../platform/network/ntf/URLRequestListenerNtf.h',
            '../platform/network/ntf/URLRequestUndefined.cpp',
            '../platform/network/ntf/URLRequestUndefined.h',
            '../platform/manx/ClipboardManx.cpp',
            '../platform/manx/ContextMenuItemManx.cpp',
            '../platform/manx/ContextMenuManx.cpp',
            '../platform/manx/CursorManx.cpp',
            '../platform/manx/DragDataManx.cpp',
            '../platform/manx/DragImageManx.cpp',
            '../platform/manx/EventLoopManx.cpp',
            '../platform/manx/FileSystemManx.cpp',
            '../platform/manx/GamepadsManx.cpp',
            '../platform/manx/KURLManx.cpp',
            '../platform/manx/LanguageManx.cpp',
            '../platform/manx/LocalizedStringsManx.cpp',
            '../platform/manx/LoggingManx.cpp',
            '../platform/manx/MIMETypeRegistryManx.cpp',
            '../platform/manx/PasteboardManx.cpp',
            '../platform/manx/PlatformClockManx.cpp',
            '../platform/manx/PlatformClockManx.h',
            '../platform/manx/PlatformKeyboardEventManx.cpp',
            '../platform/manx/PlatformMouseEventManx.cpp',
            '../platform/manx/PlatformScreenManx.cpp',
            '../platform/manx/PlatformTouchEventManx.cpp',
            '../platform/manx/PlatformTouchPointManx.cpp',
            '../platform/manx/RenderThemeManx.cpp',
            '../platform/manx/RenderThemeManx.h',
            '../platform/manx/RunLoopManx.cpp',
            '../platform/manx/ScrollbarThemeManx.cpp',
            '../platform/manx/ScrollbarThemeManx.h',
            '../platform/manx/SharedBufferManx.cpp',
            '../platform/manx/SharedTimerManx.cpp',
            '../platform/manx/SoundManx.cpp',
            '../platform/manx/TemporaryLinkStubs.cpp',
            '../platform/manx/WidgetManx.cpp',
            '../platform/text/manx/TextBreakIteratorInternalICUManx.cpp',
            ],
        }, # variables

    'targets': [
        {
            'target_name': 'WebCoreGenerated',
            'type'       : 'none',
            'hard_dependency': 1,
            'actions': [
                {
                    'action_name'    : 'Generate WebCore Derived Sources',
                    'inputs'         : [ 'generate-derived-sources-manx.sh' ],
                    'outputs'        : [
                        '<@(webcore_derived_source_files)',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSEXTTextureFormatBGRA8888.h',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSEXTTextureFormatBGRA8888.cpp',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSFloat64Array.cpp',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSFloat64Array.h',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSAsyncImageDecoder.h',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSAsyncImageDecoder.cpp',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSHTMLTile.h',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSHTMLTile.cpp',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSLocationChangeEvent.h',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSLocationChangeEvent.cpp',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSHTMLTrackElement.cpp',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSHTMLTrackElement.h',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTrackEvent.cpp',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTrackEvent.h',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTextTrack.cpp',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTextTrack.h',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTextTrackCue.cpp',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTextTrackCue.h',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTextTrackCueList.cpp',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTextTrackCueList.h',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTextTrackList.cpp',
                        '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTextTrackList.h',
                        ],
                    'action'         : [ 'bash', 'generate-derived-sources-manx.sh', '<(PRODUCT_DIR)/DerivedSources' ],
                    'parallel_build' : 1,
                    },
                ],
            }, # DerivedSources target

        {
            'target_name': 'WebCore',
            'type' : 'static_library',
            'msvs_guid' : '4C50E8DB-04A2-4BFF-9170-037AC1EB4715',
            'dependencies'  : [
                'WTF',
                'JavaScriptCore',
                ],
            'direct_dependent_settings' : {
                'include_dirs' : [ '<@(webcore_include_dirs)' ]
                },
            'include_dirs' : [ '<@(webcore_include_dirs)' ],
            'defines' : [
                'BUILDING_WebCore',
                ],
            'sources': [
                '<@(webcore_files)',
                ],
            'sources/': [
                [ 'exclude', 'bindings/cpp/' ],

                [ 'exclude', 'bridge/[^/]+/' ],
                [ 'exclude', 'bridge/testbindings\\.cpp$' ],   # Remove from GYPI?
                [ 'exclude', 'bridge/testbindings\\.mm$' ],    # Remove from GYPI?
                [ 'exclude', 'bridge/testqtbindings\\.cpp$' ], # Remove from GYPI?
                [ 'include', 'bridge/jsc/' ],

                [ 'exclude', 'plugins/PluginDataNone.cpp' ],

                [ 'exclude', 'platform/geoclue/' ],

                [ 'exclude', 'platform/graphics/opengl/GraphicsContext3DOpenGL.cpp' ],
                [ 'exclude', 'platform/graphics/cairo/FontCairo.cpp' ],
                [ 'exclude', 'platform/graphics/FontPlatformData.cpp' ],
                [ 'exclude', 'platform/graphics/freetype/' ],
                [ 'exclude', 'platform/graphics/egl' ],

                [ 'exclude', 'platform/image-encoders/' ],
                [ 'exclude', 'platform/mock/GeolocationClientMock' ],
                [ 'exclude', 'platform/network/curl/' ],

                [ 'exclude', 'platform/text/LocaleICU.cpp' ],
                [ 'exclude', 'platform/text/LocaleToScriptMappingDefault.cpp' ],
                [ 'exclude', 'platform/text/LocalizedDateICU.cpp' ],
                [ 'exclude', 'platform/text/LocalizedNumberICU.cpp' ],
                [ 'exclude', 'platform/text/TextEncodingDetectorNone.cpp' ],

                [ 'exclude', 'AllInOne\\.cpp$' ],
                ],

            'conditions' : [
                [ 'enable_webgl==1', {
                        'sources': [
                            '../platform/graphics/cairo/DrawingBufferCairo.cpp',
                            '../platform/graphics/manx/GraphicsContext3DManx.cpp',
                            '../platform/graphics/manx/GraphicsContext3DPrivate.cpp',
                            '../platform/graphics/manx/GraphicsContext3DPrivate.h',
                            '../platform/graphics/surfaces/manx/GLTransportSurface.cpp',
                            '../platform/graphics/surfaces/manx/GLTransportSurface.h',
                            '../platform/graphics/surfaces/manx/GraphicsSurfaceOrbis.cpp',
                        ],
                        'sources/': [
                            # Not used for EGL
                            [ 'exclude', 'OpenGLShims.h'],
                            [ 'exclude', 'OpenGLShims.cpp'],
                        ],
                        }],
                [ 'enable_webgl==0', {
                        'sources/': [
                            [ 'exclude', 'egl/'],
                            [ 'exclude', 'gpu/'],
                            [ 'exclude', 'opengl/'],
                            [ 'exclude', 'GL\\.cpp$'],
                            [ 'exclude', 'OpenGLShims.cpp'],
                        ],
                        }],
                [ 'use_accelerated_compositing==1', {
                        'sources': [
                            # For canvas extension
                            '../platform/graphics/manx/OpenGLManx.cpp',
                            '../platform/graphics/manx/OpenGLManx.h',
                        ],
                        }],
                [ 'use_accelerated_compositing==0', {
                        'sources/': [
                            [ 'exclude', 'texmap/'],
                        ],
                        }],
                [ 'OS=="orbis"' , {
                        'sources': [
                            '../inspector/InspectorManxAgent.cpp',
                            '../inspector/InspectorManxAgent.h',
                            '../platform/graphics/DisplayRefreshMonitor.cpp',
                            '../platform/graphics/DisplayRefreshMonitor.h',
                            '../platform/graphics/manx/DisplayRefreshMonitorManx.cpp',
                            '../platform/graphics/harfbuzz/HarfBuzzFace.cpp',
                            '../platform/graphics/harfbuzz/HarfBuzzFace.h',
                            '../platform/graphics/harfbuzz/HarfBuzzFaceCairo.cpp',
                            '../platform/graphics/harfbuzz/HarfBuzzShaper.cpp',
                            '../platform/graphics/harfbuzz/HarfBuzzShaper.h',
                        ],
                        'sources/' : [
                            [ 'include', 'harfbuzz/' ],
                            [ 'exclude', 'HarfBuzzFaceCoreText.cpp' ],
                            ],
                        },
                  ],
                [ 'OS=="win"' , {
                        'sources/' : [
                            [ 'exclude', 'FileSystemManx.cpp' ],
                            [ 'include', 'FileSystemWin.cpp' ],
                            [ 'include', 'PathWalker.cpp' ],
                            ],
                        },
                ],
                [ 'OS=="psp2"' , {
                        'sources' : [
                            '../platform/graphics/cairo/IntRectCairo.cpp',
                            '../platform/graphics/cairo/TileCairo.cpp',
                            '../platform/graphics/cairo/TiledBackingStoreBackendCairo.cpp',
                            ],
                        'sources/' : [
                            [ 'exclude', 'harfbuzz/' ],
                            ],
                        },
                  ],
                [ 'OS=="psp2"' , {
                        'configurations': {
                            'Release' : {
                                'msbuild_settings' : {
                                    'ClCompile' : {
                                        'AdditionalOptions' : ['-Os'],
                                        },
                                    },
                                },
                            },
                        },
                  ],
                ],
            },
        {
            'target_name': 'WebCoreDerived',
            'type' : 'static_library',
            'msvs_guid' : 'FEF5A036-F2CE-4C81-B838-B7670AB3BA07',
            'dependencies'  : [
                'WTF',
                'JavaScriptCore',
                ],
            'direct_dependent_settings' : {
                'include_dirs' : [ '<@(webcore_include_dirs)' ]
                },
            'include_dirs' : [ '<@(webcore_include_dirs)' ],
            'defines' : [
                'BUILDING_WebCore',
                ],
            'sources': [
                '../config.h', # dummy
                '<@(webcore_derived_source_files)',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSEXTTextureFormatBGRA8888.h',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSEXTTextureFormatBGRA8888.cpp',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSFloat64Array.cpp',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSFloat64Array.h',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSAsyncImageDecoder.h',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSAsyncImageDecoder.cpp',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSHTMLTile.h',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSHTMLTile.cpp',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSLocationChangeEvent.h',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSLocationChangeEvent.cpp',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSHTMLTrackElement.cpp',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSHTMLTrackElement.h',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTrackEvent.cpp',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTrackEvent.h',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTextTrack.cpp',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTextTrack.h',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTextTrackCue.cpp',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTextTrackCue.h',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTextTrackCueList.cpp',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTextTrackCueList.h',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTextTrackList.cpp',
                '<(PRODUCT_DIR)/DerivedSources/WebCore/JSTextTrackList.h',
                ],
            'sources/': [
                [ 'exclude', '\\.h$' ],
                [ 'exclude', 'CharsetData\\.cpp' ],
                [ 'exclude', 'JSAbstractView\\.cpp' ],
                [ 'exclude', 'JSElementTimeControl\\.cpp' ],
                [ 'exclude', 'JSMediaKeyError.cpp' ],
                [ 'exclude', 'JSMediaKeyEvent.cpp' ],
                [ 'exclude', 'JSSVGExternalResourcesRequired.cpp' ],
                [ 'exclude', 'JSSVGFilterPrimitiveStandardAttributes.cpp' ],
                [ 'exclude', 'JSSVGFitToViewBox.cpp' ],
                [ 'exclude', 'JSSVGLangSpace.cpp' ],
                [ 'exclude', 'JSSVGLocatable.cpp' ],
                [ 'exclude', 'JSSVGStylable.cpp' ],
                [ 'exclude', 'JSSVGTests.cpp' ],
                [ 'exclude', 'JSSVGTransformable.cpp' ],
                [ 'exclude', 'JSSVGURIReference.cpp' ],
                [ 'exclude', 'JSSpellcheckRange.cpp' ],
                [ 'exclude', 'JSSpellcheckRangeList.cpp' ],
                [ 'exclude', 'tokenizer.cpp' ],
                [ 'exclude', 'DocTypeStrings.cpp' ],
                ],
            'conditions' : [
                [ 'OS=="psp2"' , {
                        'configurations': {
                            'Release' : {
                                'msbuild_settings' : {
                                    'ClCompile' : {
                                        'AdditionalOptions' : ['-Os'],
                                        },
                                    },
                                },
                            },
                        },
                  ],
                ],
            },
        {
            'target_name': 'WebCoreDom',
            'type' : 'static_library',
            'msvs_guid' : 'E7D745CC-F857-4D06-9947-01602F228413',
            'dependencies'  : [
                'WTF',
                'JavaScriptCore',
                ],
            'direct_dependent_settings' : {
                'include_dirs' : [ '<@(webcore_include_dirs)' ]
                },
            'include_dirs' : [ '<@(webcore_include_dirs)' ],
            'defines' : [
                'BUILDING_WebCore',
                ],
            'sources': [
                '<@(webcore_dom_files)',
                ],
            'sources/': [
                [ 'exclude', 'AllInOne\\.cpp$' ],
                ],
            'conditions' : [
                [ 'OS=="psp2"' , {
                        'configurations': {
                            'Release' : {
                                'msbuild_settings' : {
                                    'ClCompile' : {
                                        'AdditionalOptions' : ['-Os'],
                                        },
                                    },
                                },
                            },
                        },
                  ],
                ],
            },
        {
            'target_name': 'WebCoreHtml',
            'type' : 'static_library',
            'msvs_guid' : 'EC1EB5D7-B5B3-43B0-B36B-E4B79FC1A956',
            'dependencies'  : [
                'WTF',
                'JavaScriptCore',
                ],
            'direct_dependent_settings' : {
                'include_dirs' : [ '<@(webcore_include_dirs)' ]
                },
            'include_dirs' : [ '<@(webcore_include_dirs)' ],
            'defines' : [
                'BUILDING_WebCore',
                ],
            'sources': [
                '<@(webcore_html_files)',
                '../html/canvas/EXTTextureFormatBGRA8888.cpp',
                '../html/canvas/EXTTextureFormatBGRA8888.h',
                ],
            'sources/': [
                [ 'exclude', 'AllInOne\\.cpp$' ],
                ],
            'conditions' : [
                [ 'OS=="psp2"' , {
                        'configurations': {
                            'Release' : {
                                'msbuild_settings' : {
                                    'ClCompile' : {
                                        'AdditionalOptions' : ['-Os'],
                                        },
                                    },
                                },
                            },
                        },
                  ],
                ],
            },
        {
            'target_name': 'WebCoreSvg',
            'type' : 'static_library',
            'msvs_guid' : '3DDC1DF2-082F-4BB9-BE53-CFE69EBD9A63',
            'dependencies'  : [
                'WTF',
                'JavaScriptCore',
                ],
            'direct_dependent_settings' : {
                'include_dirs' : [ '<@(webcore_include_dirs)' ]
                },
            'include_dirs' : [ '<@(webcore_include_dirs)' ],
            'defines' : [
                'BUILDING_WebCore',
                ],
            'sources': [
                '<@(webcore_svg_files)',
                ],
            'sources/': [
                [ 'exclude', 'AllInOne\\.cpp$' ],
                ],
            'conditions' : [
                [ 'OS=="psp2"' , {
                        'configurations': {
                            'Release' : {
                                'msbuild_settings' : {
                                    'ClCompile' : {
                                        'AdditionalOptions' : ['-Os'],
                                        },
                                    },
                                },
                            },
                        },
                  ],
                ],
            },
        {
            'target_name': 'WebCoreTestSupport',
            'type' : 'static_library',
            'msvs_guid' : 'BD0C6AF9-EED6-405A-BFCE-35526905AE69',
            'dependencies'  : [
                'WTF',
                'JavaScriptCore',
                ],
            'direct_dependent_settings' : {
                'include_dirs' : [ '<@(webcore_include_dirs)' ]
                },
            'include_dirs' : [ '<@(webcore_include_dirs)' ],
            'defines' : [
                'BUILDING_WebCore',
                ],
            'sources': [
                '<@(webcore_test_support_files)',
                '<@(webcore_test_support_derived_source_files)',
                ],
            },
        {
            'target_name': 'WebCore_CoreIPC',
            'type' : 'static_library',
            'msvs_guid' : '7AE3C5AB-352F-4CA2-A385-917D49F3A35F',
            'dependencies'  : [
                'WTF',
                'JavaScriptCore',
                ],
            'direct_dependent_settings' : {
                'include_dirs' : [ '<@(webcore_include_dirs)' ]
                },
            'include_dirs' : [ '<@(webcore_include_dirs)' ],
            'defines' : [
                'BUILDING_WebCore',
                ],
            'sources': [
                '../platform/RunLoop.cpp',
                '../platform/manx/RunLoopManx.cpp',
                ],
            'msbuild_settings' : {
                'ClCompile' : {
                    'AdditionalOptions' : ['-fvisibility=default'],
                  },
              },
            },
        ], # targets
    }
