/*
 * Copyright (C) 2010 Apple Inc. All rights reserved.
 * Portions Copyright (c) 2010 Motorola Mobility, Inc.  All rights reserved.
 * Copyright (C) 2012 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WebCoreArgumentCoders.h"

#include <WebCore/ResourceError.h>
#include <WebCore/ResourceRequest.h>
#include <WebCore/ResourceResponse.h>
#include <wtf/text/CString.h>

using namespace WebCore;

namespace CoreIPC {

#if 0
void ArgumentCoder<ResourceRequest>::encode(ArgumentEncoder& encoder, const ResourceRequest& resourceRequest)
{
    encoder << resourceRequest.url().string();
    encoder << resourceRequest.httpMethod();

    const HTTPHeaderMap& headers = resourceRequest.httpHeaderFields();
    encoder << headers;

    FormData* httpBody = resourceRequest.httpBody();
    encoder << static_cast<bool>(httpBody);
    if (httpBody)
        encoder << httpBody->flattenToString();

    encoder << resourceRequest.firstPartyForCookies().string();
}

bool ArgumentCoder<ResourceRequest>::decode(ArgumentDecoder& decoder, ResourceRequest& resourceRequest)
{
    ResourceRequest request;

    String url;
    if (!decoder.decode(url))
        return false;
    request.setURL(KURL(KURL(), url));

    String httpMethod;
    if (!decoder.decode(httpMethod))
        return false;
    request.setHTTPMethod(httpMethod);

    HTTPHeaderMap headers;
    if (!decoder.decode(headers))
        return false;
    request.addHTTPHeaderFields(headers);

    bool hasHTTPBody;
    if (!decoder.decode(hasHTTPBody))
        return false;
    if (hasHTTPBody) {
        String httpBody;
        if (!decoder.decode(httpBody))
            return false;
        request.setHTTPBody(FormData::create(httpBody.utf8()));
    }

    String firstPartyForCookies;
    if (!decoder.decode(firstPartyForCookies))
        return false;
    request.setFirstPartyForCookies(KURL(KURL(), firstPartyForCookies));

    resourceRequest = request;
    return true;
}


void ArgumentCoder<ResourceResponse>::encode(ArgumentEncoder& encoder, const ResourceResponse& resourceResponse)
{
    bool responseIsNull = resourceResponse.isNull();
    encoder << responseIsNull;
    if (responseIsNull)
        return;

    encoder << resourceResponse.url().string();
    encoder << static_cast<int32_t>(resourceResponse.httpStatusCode());

    const HTTPHeaderMap& headers = resourceResponse.httpHeaderFields();
    encoder << headers;

    encoder << resourceResponse.mimeType();
    encoder << resourceResponse.textEncodingName();
    encoder << static_cast<int64_t>(resourceResponse.expectedContentLength());
    encoder << resourceResponse.httpStatusText();
    encoder << resourceResponse.suggestedFilename();
}

bool ArgumentCoder<ResourceResponse>::decode(ArgumentDecoder& decoder, ResourceResponse& resourceResponse)
{
    bool responseIsNull;
    if (!decoder.decode(responseIsNull))
        return false;
    if (responseIsNull) {
        resourceResponse = ResourceResponse();
        return true;
    }

    ResourceResponse response;

    String url;
    if (!decoder.decode(url))
        return false;
    response.setURL(KURL(KURL(), url));

    int32_t httpStatusCode;
    if (!decoder.decode(httpStatusCode))
        return false;
    response.setHTTPStatusCode(httpStatusCode);

    HTTPHeaderMap headers;
    if (!decoder.decode(headers))
        return false;
    for (HTTPHeaderMap::const_iterator it = headers.begin(), end = headers.end(); it != end; ++it)
        response.setHTTPHeaderField(it->key, it->value);

    String mimeType;
    if (!decoder.decode(mimeType))
        return false;
    response.setMimeType(mimeType);

    String textEncodingName;
    if (!decoder.decode(textEncodingName))
        return false;
    response.setTextEncodingName(textEncodingName);

    int64_t contentLength;
    if (!decoder.decode(contentLength))
        return false;
    response.setExpectedContentLength(contentLength);

    String httpStatusText;
    if (!decoder.decode(httpStatusText))
        return false;
    response.setHTTPStatusText(httpStatusText);

    String suggestedFilename;
    if (!decoder.decode(suggestedFilename))
        return false;
    response.setSuggestedFilename(suggestedFilename);

    resourceResponse = response;
    return true;
}


void ArgumentCoder<ResourceError>::encode(ArgumentEncoder& encoder, const ResourceError& resourceError)
{
    bool errorIsNull = resourceError.isNull();
    encoder << errorIsNull;
    if (errorIsNull)
        return;

    encoder << resourceError.domain();
    encoder << resourceError.errorCode();
    encoder << resourceError.failingURL(); 
    encoder << resourceError.localizedDescription();
}

bool ArgumentCoder<ResourceError>::decode(ArgumentDecoder& decoder, ResourceError& resourceError)
{
    bool errorIsNull;
    if (!decoder.decode(errorIsNull))
        return false;
    if (errorIsNull) {
        resourceError = ResourceError();
        return true;
    }

    String domain;
    if (!decoder.decode(domain))
        return false;

    int errorCode;
    if (!decoder.decode(errorCode))
        return false;

    String failingURL;
    if (!decoder.decode(failingURL))
        return false;

    String localizedDescription;
    if (!decoder.decode(localizedDescription))
        return false;
    
    resourceError = ResourceError(domain, errorCode, failingURL, localizedDescription);
    return true;
}
#endif

}
