/*
 * Copyright (C) 2004, 2005, 2006, 2013 Apple Inc.
 * Copyright (C) 2009 Google Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */ 

#if defined(HAVE_CONFIG_H) && HAVE_CONFIG_H
#ifdef BUILDING_WITH_CMAKE
#include "cmakeconfig.h"
#else
#include "autotoolsconfig.h"
#endif
#endif

#include <wtf/Platform.h>

#if PLATFORM(MAC) || PLATFORM(IOS)
#define WTF_USE_FILE_LOCK 1
#endif

#if PLATFORM(WIN) && !USE(WINGDI)
#include <WebCore/WebCoreHeaderDetection.h>
#endif

#include <wtf/ExportMacros.h>
#include "PlatformExportMacros.h"

#include <runtime/JSExportMacros.h>

#ifdef __APPLE__
#define HAVE_FUNC_USLEEP 1
#endif /* __APPLE__ */

#if OS(WINDOWS)

#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x0502
#endif

#ifndef WINVER
#define WINVER 0x0502
#endif

// If we don't define these, they get defined in windef.h.
// We want to use std::min and std::max.
#ifndef max
#define max max
#endif
#ifndef min
#define min min
#endif

// CURL needs winsock, so don't prevent inclusion of it
#if !USE(CURL)
#ifndef _WINSOCKAPI_
#define _WINSOCKAPI_ // Prevent inclusion of winsock.h in windows.h
#endif
#endif

#endif /* OS(WINDOWS) */

#ifdef __cplusplus

// These undefs match up with defines in WebCorePrefix.h for Mac OS X.
// Helps us catch if anyone uses new or delete by accident in code and doesn't include "config.h".
#undef new
#undef delete
#include <wtf/FastMalloc.h>

#include <ciso646>

#endif

#include <wtf/DisallowCType.h>

#if COMPILER(MSVC)
#define SKIP_STATIC_CONSTRUCTORS_ON_MSVC 1
#else
#define SKIP_STATIC_CONSTRUCTORS_ON_GCC 1
#endif

#if PLATFORM(WIN)
#if PLATFORM(WIN_CAIRO)
#undef WTF_USE_CG
#define WTF_USE_CAIRO 1
#define WTF_USE_CURL 1
#ifndef _WINSOCKAPI_
#define _WINSOCKAPI_ // Prevent inclusion of winsock.h in windows.h
#endif
#elif !USE(WINGDI)
#define WTF_USE_CG 1
#undef WTF_USE_CAIRO
#undef WTF_USE_CURL
#endif
#endif

#if PLATFORM(MANX) && OS(WINDOWS)
#ifndef _WINSOCKAPI_
#define _WINSOCKAPI_ // Prevent inclusion of winsock.h in windows.h
#endif
#endif

#if PLATFORM(MAC)
// New theme
#define WTF_USE_NEW_THEME 1
#endif // PLATFORM(MAC)

#if USE(CG)
#ifndef CGFLOAT_DEFINED
#ifdef __LP64__
typedef double CGFloat;
#else
typedef float CGFloat;
#endif
#define CGFLOAT_DEFINED 1
#endif
#endif /* USE(CG) */

#if PLATFORM(WIN) && USE(CG)
#define WTF_USE_SAFARI_THEME 1
#endif

// CoreAnimation is available to IOS, Mac and Windows if using CG
#if PLATFORM(MAC) || PLATFORM(IOS) || (PLATFORM(WIN) && USE(CG))
#define WTF_USE_CA 1
#endif

// FIXME: Move this to JavaScriptCore/wtf/Platform.h, which is where we define WTF_USE_AVFOUNDATION on the Mac.
// https://bugs.webkit.org/show_bug.cgi?id=67334
#if PLATFORM(WIN)
#define WTF_USE_AVFOUNDATION 1

#if HAVE(AVCF_LEGIBLE_OUTPUT)
#define WTF_USE_AVFOUNDATION 1
#define HAVE_AVFOUNDATION_MEDIA_SELECTION_GROUP 1
#define HAVE_AVFOUNDATION_LEGIBLE_OUTPUT_SUPPORT 1
#define HAVE_MEDIA_ACCESSIBILITY_FRAMEWORK 1
#endif
#endif

#if PLATFORM(MANX)
#include <manx/util.h>

#define PUSH_CPU_MARKER(label, color) pa_push_marker(label, color)
#define POP_CPU_MARKER() pa_pop_marker()
#define CPU_SYNC() pa_sync()

#ifdef __cplusplus
class ScopedMarker
{
public:
    ScopedMarker(const char* label, unsigned int color) { PUSH_CPU_MARKER(label, color); }
    ~ScopedMarker() { POP_CPU_MARKER(); }
};
#define TOKENPASTE(x, y) x ## y
#define TOKENPASTE2(x, y) TOKENPASTE(x, y)
#define SCOPED_MARKER(label, color) ScopedMarker TOKENPASTE2(marker, __LINE__)(label, color)
#define FUNCTION_MARKER SCOPED_MARKER(__PRETTY_FUNCTION__, PA_COLOR_GREEN)
#endif // __cplusplus

#define GP_TRACE(label, number) gp_trace(label, number)

#else // PLATFORM(MANX)
#define PUSH_CPU_MARKER(label, color, flags)
#define POP_CPU_MARKER()
#define CPU_SYNC() 
#ifdef __cplusplus
#define LABELED_MARKER(label) pa_cpu_marker marker ## __LINE__(label)
#define FUNCTION_MARKER LABELED_MARKER(__FUNCTION__)
#endif // __cplusplus
#define GP_TRACE(label, number)
#endif // PLATFORM(MANX)
