/*
 * Copyright (C) 2013 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SuperRegion_h
#define SuperRegion_h

#include <wtf/MetaAllocator.h>
#include <wtf/PageBlock.h>
#include <wtf/PageReservation.h>

#include <JITBridge.h>

namespace JSC {

class VM;

class SuperRegion : public WTF::MetaAllocator {
#if ENABLE(DETACHED_JIT)
    friend class WTF::MetaAllocator;
    friend class BlockAllocator;
#endif

public:
    SuperRegion();
    DETACHED_JIT_VIRTUAL_DTOR ~SuperRegion();

protected:
    DETACHED_JIT_VIRTUAL void * allocateNewSpace(size_t&);
    DETACHED_JIT_VIRTUAL void notifyNeedPage(void*);
    DETACHED_JIT_VIRTUAL void notifyPageIsFree(void*);

private:
    static const uint64_t s_fixedHeapMemoryPoolSize;

    static void* getAlignedBase(PageReservation&);

    PageReservation m_reservation;
    void* m_reservationBase;
};

} // namespace JSC

#endif // SuperRegion_h
