{
    'includes' : [
        '../common_orbis.gypi',
    ],
    'variables' : {
    },
    'target_defaults' : {
        'msvs_configuration_attributes' : {
            'OutputDirectory' : '$(SolutionDir)\\dist\\$(PlatformName)_$(ConfigurationName)',
            'IntermediateDirectory' : '$(PlatformName)_$(ConfigurationName)\\$(ProjectName)',
        },
        'configurations': {
            'Debug' : {
                'defines' : [ '_DEBUG' ] ,
                'msvs_configuration_platform' : 'ORBIS',
            },
            'Release' : {
                'defines' : [ 'NDEBUG' ] ,
                'msvs_configuration_platform' : 'ORBIS',
                'msbuild_settings' : {
                    'ClCompile' : {
                        'OptimizationLevel' : 'Level2',
                    },
                },
            },
        },
        'product_prefix': 'lib',
        'product_extension': 'a',
        'defines' : [
            'WTF_PLATFORM_MANX=1',
            '<@(feature_defines)',
        ], # defines
        'include_dirs': [
            '../../../Source',
            '../../../../ANGLE/include',
            '../../../../dist/include',
            '../../../../dist/include/webkit-1.0',
            '../../../../libJITbridge/dist/include',
            '../../../../libmanx/dist/include',
            '../../../../libntf/dist/include',
            '../../../../orbis/dist/include',
            '../../../../orbis/dist/include/cairo',
            '../../../../orbis/dist/include/curl',
            '../../../../orbis/dist/include/freetype2',
            '../../../../orbis/dist/include/harfbuzz',
            '../../../../orbis/dist/include/libpng15',
            '../../../../orbis/dist/include/libxml2',
            '../../../../orbis/dist/include/orbis-compat',
            '$(SCE_ORBIS_SDK_DIR)/../orbis_psm/pss_platform_cache/include',
            '$(SCE_ORBIS_SDK_DIR)/../internal/include'
        ],
        'msbuild_settings' : {
            'ClCompile' : {
                'AdditionalOptions' : ['-Wno-c++11-narrowing',
                                       '-Wno-unused-private-field',
                                       '-Wno-mismatched-tags',
                                       '-Wno-overloaded-virtual',
                                       '-fPIC',
                                       '-fvisibility=hidden',
                                       '-fstack-protector-strong'],
                'GenerateDebugInformation' : 'true',
                'WarningsAsErrors' : 'true',
                'MultiProcessorCompilation' : 'true',
            },
        },
        'msbuild_props': [
            '$(ProjectDir)ManxOrbisCommon.props'
        ],
    },
}
