#!/bin/sh

OS=""

for OPT in $*
do
	case $OPT in
	--os=*)
		OS=`echo $OPT | cut -c 6-`;;
	esac
    shift
done

if [ ! $OS ]; then
	echo "No '--os=' option provided."
	exit
fi

WEBKIT_ROOT_DIR=`dirname $0`/../../

DERIVED_SOURCES_DIR="${WEBKIT_ROOT_DIR}DerivedSources_${OS}/"

SRC_ROOT="${WEBKIT_ROOT_DIR}Source/WebCore/"
DST_ROOT="${DERIVED_SOURCES_DIR}WebCore/WebCore"

if [ ! -e "${DST_ROOT}" ]; then
	mkdir "${DST_ROOT}"
fi

rm -r "${DST_ROOT}/inspector/"
cp -r "${SRC_ROOT}/inspector/" "${DST_ROOT}/inspector/"

pushd ${DERIVED_SOURCES_DIR}

INSPECTOR_GENERATOR_SCRIPTS="WebCore/WebCore/inspector/CodeGeneratorInspector.py"
INSPECTOR_JSON="WebCore/WebCore/inspector/Inspector.json"

`python ${INSPECTOR_GENERATOR_SCRIPTS} ${INSPECTOR_JSON} --output_h_dir WebCore --output_cpp_dir WebCore`

popd
