﻿/* SCE CONFIDENTIAL
$PSLibId$
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef _SCE_API_LIBGXM_HEAP_H
#define _SCE_API_LIBGXM_HEAP_H

#include <gxm.h>

/*! Initializes an empty heap.

	Use #heapExtend to add free blocks to the heap before allocating using
	#heapAlloc.
*/
void heapInitialize();

/*! Destroys the heap.
*/
void heapTerminate();

/*! Adds a block of memory to the heap.

	The block must not overlap with any existing block.

	@param type			Arbitrary value denoting the type of memory.  Use later with #heapAlloc
						to allocate memory of this type.
	@param base			The base address of the block.
	@param size			The size of the block.
	@param offset		A USSE offset to track with this block.  Can be set to zero if
						USSE offsets are not used.
*/
void heapExtend(int32_t type, void *base, uint32_t size, uint32_t offset = 0);

/*! Allocate memory from the heap.

	@param type			The block type to allocate from.  This should match a block type added
						earlier with #heapExtend.
	@param size			The size in bytes of the allocation.
	@param alignment	The alignment in bytes of the start of the allocation.
	@param offset		Optional USSE offset of the start of the allocation, can be NULL if
						the offset value is not required.

	@return				The address of the allocation is returned, or NULL if no allocation
						could be made.
*/
void *heapAlloc(int32_t type, uint32_t size, uint32_t alignment = 1, uint32_t *offset = SCE_NULL);

/*! Frees memory back to the heap.

	@pram addr			The address of the allocation to free, or NULL.  If non-NULL this should
						match a previous return value from #heapAlloc.
*/
void heapFree(void *addr);

#endif /* _SCE_API_LIBGXM_HEAP_H */

