/*
 * Copyright (C) 2008 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2013 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MGWebViewInternal_h
#define MGWebViewInternal_h

#include "WebViewQueue.h"
#include <ntf/NetworkProfile.h>
#include <webkit/WebView.h>

#define WEBVIEW_COMMAND_DATA_MAX 8

namespace MXGlue {

typedef enum {
    WEBVIEW_COMMAND_INITIALIZED,
    WEBVIEW_COMMAND_EXIT,
    WEBVIEW_COMMAND_CREATE,
    WEBVIEW_COMMAND_DESTROY,
    WEBVIEW_COMMAND_LOAD_URL,
    WEBVIEW_COMMAND_LOAD_HTML,
    WEBVIEW_COMMAND_LOAD_DATA,
    WEBVIEW_COMMAND_LOAD_ARCHIVE,
    WEBVIEW_COMMAND_RELOAD,
    WEBVIEW_COMMAND_STOP,
    WEBVIEW_COMMAND_GO_BACK,
    WEBVIEW_COMMAND_GO_FORWARD,
    WEBVIEW_COMMAND_INCREASE_TEXT_SIZE,
    WEBVIEW_COMMAND_DECREASE_TEXT_SIZE,
    WEBVIEW_COMMAND_RESET_TEXT_SIZE,
    WEBVIEW_COMMAND_SCROLL_EVENT,
    WEBVIEW_COMMAND_DRAW_RECT,
    WEBVIEW_COMMAND_SET_CLIP_RECT,
    WEBVIEW_COMMAND_MOUSE_EVENT,
    WEBVIEW_COMMAND_MOUSE_EVENT_MOVE,
    WEBVIEW_COMMAND_KEY_EVENT,
    WEBVIEW_COMMAND_HTML_EVENT,
    WEBVIEW_COMMAND_TOUCH_EVENT,
    WEBVIEW_COMMAND_HITTEST,
    WEBVIEW_COMMAND_UPLOAD,
    WEBVIEW_COMMAND_GESTURE_EVENT,
    WEBVIEW_COMMAND_SET_COOKIES,
    WEBVIEW_COMMAND_SET_SETTINGS_JS,
    WEBVIEW_COMMAND_SET_SETTINGS_COOKIE,
    WEBVIEW_COMMAND_SET_SETTINGS_WEBGL,
    WEBVIEW_COMMAND_SET_SETTINGS_WEBSECURITY,
    WEBVIEW_COMMAND_SET_SETTINGS_DEVELOPEREXTRAS,
    WEBVIEW_COMMAND_SET_USERAGENT,
    WEBVIEW_COMMAND_SELECT_POPUPMENU,
    WEBVIEW_COMMAND_GETITEM_POPUPMENU,
    WEBVIEW_COMMAND_SET_JSOBJ,
    WEBVIEW_COMMAND_SET_CARET_VISIBLE,
    WEBVIEW_COMMAND_SET_COMPOSITION,
    WEBVIEW_COMMAND_CONFIRM_COMPOSITION,
    WEBVIEW_COMMAND_CANCEL_COMPOSITION,
    WEBVIEW_COMMAND_EXIT_COMPOSITION,
    WEBVIEW_COMMAND_CLEAR_TEXT,
    WEBVIEW_COMMAND_DELETE_ALL_COOKIES,
    WEBVIEW_COMMAND_RELEASE_TILES,
    WEBVIEW_COMMAND_SET_LAYOUT_WIDTH,
    WEBVIEW_COMMAND_CREATE_ASYNC,
    WEBVIEW_COMMAND_REQUEST_DL_IMAGE,
    WEBVIEW_COMMAND_REQUEST_DL_IMAGE_DATA,
    WEBVIEW_COMMAND_SET_GEOLOCATION_PERMISSION,
    WEBVIEW_COMMAND_UPDATE_GEOLOCATION,
    WEBVIEW_COMMAND_SET_JAVA_SCRIPT_OBJ,
} WebViewCommandType;

class WebViewCommand : public WebViewQueueItem {
public:
    WebViewCommand(WebView* webview, WebViewCommandType type)
        : m_webView(webview)
    {
        setId(type);
    }

    WebView* m_webView;

    union {
        int typeInt;
        long typeLong;
        bool typeBool;
        char typeChar;
        char* typeCharPtr;
        void* typeVoidPtr;
        const char* typeConstCharPtr;
        const void* typeConstVoidPtr;

        NTF::SettingOptType typeNetOption;
        ScrollEventType typeScrollEvent;
        MouseEventType typeMouseEvent;
        MouseButtonType typeMouseButton;
        KeyEventType typeKeyEvent;
        KeyType typeKey;
        HtmlEventType typeHtmlEvent;
        HtmlEventData* typeHtmlEventDataPtr;
        Manx::TouchEvent* typeTouchEventDataPtr;
        WebViewHitTestResult* typeWebViewHitTestResultDataPtr;
    } m_data[WEBVIEW_COMMAND_DATA_MAX];
};

} // namespace MXGlue

#endif // MGWebViewInternal_h
