/*
 Copyright (C) 2013 Nokia Corporation and/or its subsidiary(-ies)
 Copyright (C) 2014 Sony Computer Entertainment Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 Boston, MA 02110-1301, USA.
 */

#ifndef AcagiTile_h
#define AcagiTile_h

#if USE(ACCELERATED_COMPOSITING) && USE(ACAGI)

#include "AcagiCompositor.h"
#include "FloatRect.h"
#include "Image.h"
#include "PlatformLayerAcagi.h"
#include <wtf/RefPtr.h>

namespace WebCore {

class GraphicsLayer;

class AcagiTile {
public:
    PassRefPtr<AcagiBitmapTexture> texture() const
    {
        return m_texture;
    }
    
    void setTexture(AcagiBitmapTexture* texture)
    {
        m_texture = texture;
    }

    void setTileRect(const IntRect& rect, float contentsScale)
    {
        m_tileRect = rect;
        m_dirtyRect = rect;
        m_dirtyRect.scale(contentsScale);
        m_contentsScale = contentsScale;
    }

    IntRect tileRect() const
    {
        return m_tileRect;
    }


    FloatRect scaledTileRect() const
    {
        FloatRect rect = m_tileRect;
        rect.scale(m_contentsScale);
        return rect;
    }

    void updateContents(AcagiCompositor*, Image*, const IntRect&, AcagiBitmapTexture::UpdateContentsFlag UpdateCanModifyOriginalImageData);
    void updateContents(AcagiCompositor*, GraphicsLayer*, const IntRect&, AcagiBitmapTexture::UpdateContentsFlag UpdateCanModifyOriginalImageData);
    virtual void paint(AcagiCompositor*, const TransformationMatrix&, float, const unsigned exposedEdges);
    virtual ~AcagiTile() { }

    explicit AcagiTile(const IntRect& rect, float contentsScale)
    {
        setTileRect(rect, contentsScale);
    }

private:
    RefPtr<AcagiBitmapTexture> m_texture;
    IntRect m_tileRect; // Rect in the device's coordinates.
    FloatRect m_dirtyRect; // Rect in the contents coordinates.
    float m_contentsScale;
};

}
#endif

#endif
