{
    'includes' : [
        '../common_orbis.gypi',
    ],
    'variables' : {
    },
    'target_defaults' : {
        'msvs_configuration_attributes' : {
            'OutputDirectory' : '$(SolutionDir)\\dist\\$(PlatformName)_$(ConfigurationName)',
            'IntermediateDirectory' : '$(PlatformName)_$(ConfigurationName)\\$(ProjectName)',
        },
        'configurations': {
            'Debug' : {
                'defines' : [ '_DEBUG' ] ,
                'msvs_configuration_platform' : 'ORBIS',
            },
            'Release' : {
                'defines' : [ 'NDEBUG' ] ,
                'msvs_configuration_platform' : 'ORBIS',
                'msbuild_settings' : {
                    'ClCompile' : {
                        'AdditionalOptions' : ['-O2'],
                    },
                },
            },
            # non-JIT JavaScriptCore configurations
            'Debug-NoJIT' : {
                'defines'                     : [ '_DEBUG', 'ENABLE_JIT=0', 'ENABLE_DETACHED_JIT=0' ],
                'msvs_configuration_platform' : 'ORBIS',
            },
            'Release-NoJIT' : {
                'defines'                     : [ 'NDEBUG', 'ENABLE_JIT=0', 'ENABLE_DETACHED_JIT=0' ],
                'msvs_configuration_platform' : 'ORBIS',
                'msbuild_settings' : {
                    'ClCompile' : { 
                        'AdditionalOptions' : ['-O2'],
                    },
                },
            },
        },
        'product_prefix': 'lib',
        'product_extension': 'a',
        'defines' : [
            'WTF_PLATFORM_MANX=1',
            '<@(feature_defines)',
        ], # defines
        'include_dirs': [
            '../../../Source',
            '../../../../orbis/dist/include/cairo',
            '../../../../orbis/dist/include/curl',
            '../../../../orbis/dist/include/freetype2',
            '../../../../orbis/dist/include/libpng15',
            '../../../../orbis/dist/include/libxml2',
            '../../../../orbis/dist/include/orbis-compat',
            '../../../../dist/include/webkit-1.0',
            '../../../../orbis/dist/include',
            '../../../../dist/include',
            '../../../../libmanx/dist/include',
            '../../../../libJITbridge/dist/include',
            '../../../../ANGLE/include',
            '$(SCE_ORBIS_SDK_DIR)/../orbis_psm/pss_platform_cache/include',
            '$(SCE_ORBIS_SDK_DIR)/../internal/include'
        ],
        'msbuild_settings' : {
            'ClCompile' : {
                'AdditionalOptions' : ['-Wno-c++11-narrowing',
                                       '-Wno-unused-private-field',
                                       '-fPIC',
                                       '-fvisibility=hidden',
                                       '-fstack-protector-strong'],
                'GenerateDebugInformation' : 'true',
                'WarningsAsErrors' : 'true',
                'MultiProcessorCompilation' : 'true',
            },
        },
        'msbuild_props': [
            '$(ProjectDir)ManxOrbisCommon.props'
        ],
    },
}
