/*
 * Copyright (C) 2012 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WKBundleFrameManx.h"

#include "InjectedBundleScriptWorld.h"
#include "WKAPICast.h"
#include "WKBundleAPICast.h"
#include "WKSharedAPICast.h"
#include "WebCertificateInfo.h"
#include "WebFrame.h"
#include "WebPage.h"
#include "WebTileManager.h"
#include <WebCore/DocumentLoader.h>
#include <WebCore/Frame.h>
#include <WebCore/ResourceResponse.h>

using namespace WebCore;
using namespace WebKit;

WKCertificateInfoRef WKBundleFrameCopyCertificateInfo(WKBundleFrameRef frame)
{
    const ResourceResponse& response = toImpl(frame)->coreFrame()->loader()->documentLoader()->response();
    return toAPI(WebCertificateInfo::create(PlatformCertificateInfo(response)).leakRef());
}

bool WKBundleFrameEnableHTMLTile(WKBundleFrameRef frame, WKBundleScriptWorldRef world)
{
#if ENABLE(MANX_HTMLTILE)
    return toImpl(frame)->page()->webTileManager().enableHTMLTileForFrame(toImpl(frame), toImpl(world)->coreWorld());
#else
    return false;
#endif
}

void WKBundleFrameEnableMemoryInfo(WKBundleFrameRef frame)
{
    Frame* coreFrame = toImpl(frame)->coreFrame();
    if (coreFrame->settings())
        coreFrame->settings()->setMemoryInfoEnabled(true);
}

double WKBundleFrameConvertMonotonicTimeToDocumentTime(WKBundleFrameRef frame, double timestamp)
{
    // Convert to the same format and base as webkitNow()
    return 1000.0 * toImpl(frame)->coreFrame()->document()->loader()->timing()->convertMonotonicTimeToZeroBasedDocumentTime(timestamp);
}
