/*
 * Copyright (C) 2013 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY SCE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SCE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebTileManagerProxy_h
#define WebTileManagerProxy_h

#if ENABLE(MANX_HTMLTILE)

#include <wtf/HashMap.h>
#include <wtf/RefCounted.h>
#include <wtf/RefPtr.h>
#include <wtf/text/WTFString.h>

namespace CoreIPC {
class ArgumentDecoder;
class ArgumentEncoder;
class Connection;
class MessageID;
}

namespace WebKit {

class WebContext;
class WebPageGroup;
class WebProcessProxy;
class WebTileProxy;
class UpdateInfo;

class WebTileManagerProxy : public RefCounted<WebTileManagerProxy> {
public:
    static PassRefPtr<WebTileManagerProxy> create(WebContext*);
    ~WebTileManagerProxy();

    WebContext* webTilesContext();

    void invalidate();
    void clearContext();
    bool shouldTerminate(WebProcessProxy*) const;

    void dispatchTileUpdated(uint64_t tileID, const UpdateInfo&) const;
    void dispatchTileUnresponsive(uint64_t tileID) const;
    void dispatchTileCrashed(uint64_t tileID) const;
    void dispatchLoadCompleted(uint64_t tileID) const;
    void dispatchLoadFailed(uint64_t tileID, uint32_t errorCode) const;
    void dispatchLocationChangeRequested(uint64_t tileID, const String& url) const;
    void dispatchRunJavaScriptResultCallback(uint64_t tileID, uint64_t callbackID, const String& result) const;

    void didReceiveMessage(CoreIPC::Connection*, CoreIPC::MessageID, CoreIPC::ArgumentDecoder*);
    void didReceiveSyncMessage(CoreIPC::Connection*, CoreIPC::MessageID, CoreIPC::ArgumentDecoder*, OwnPtr<CoreIPC::ArgumentEncoder>&);


private:
    WebTileManagerProxy(WebContext*);

    void createWebTile(uint32_t width, uint32_t height, uint64_t& newTileID);
    void destroyWebTile(uint64_t tileID);
    void pauseWebTile(uint64_t tileID);
    void resumeWebTile(uint64_t tileID);
    void sendWebTileEvent(uint64_t tileID, uint32_t eventType);
    void runJavaScriptInWebTile(uint64_t tileID, const String& jsScript, uint64_t callbackID);
    void didChangeWebTileURL(uint64_t tileID, const String& url);
    void didUpdateWebTile(uint64_t tileID);

    // Implemented in generated WebTileManagerProxyMessageReceiver.cpp
    void didReceiveWebTileManagerProxyMessage(CoreIPC::Connection*, CoreIPC::MessageID, CoreIPC::ArgumentDecoder*);
    void didReceiveSyncWebTileManagerProxyMessage(CoreIPC::Connection*, CoreIPC::MessageID, CoreIPC::ArgumentDecoder*, OwnPtr<CoreIPC::ArgumentEncoder>&);

    WebContext* m_webContext;
    RefPtr<WebContext> m_webTilesContext;
    RefPtr<WebPageGroup> m_webTilesPageGroup;

    HashMap<uint64_t, RefPtr<WebTileProxy> > m_webTiles;
    HashMap<uint64_t, uint64_t> m_destinationMap;
    uint64_t m_currentMessageDestinationID;
};

} // namespace WebKit

#endif // ENABLE(MANX_HTMLTILE)

#endif // WebTileManagerProxy_h
