/*
 * Copyright (C) 2008 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2012 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebViewJavaScriptObject_h
#define WebViewJavaScriptObject_h

#if defined _WINDOWS            /* should be moved to apropriate header */
    #ifdef BUILDING_WEBKIT
        #define WEBKIT_PUBLIC __declspec(dllexport)
    #else
        #define WEBKIT_PUBLIC __declspec(dllimport)
    #endif
#elif defined __ORBIS__
    #define WEBKIT_PUBLIC __attribute__ ((visibility ("default")))
#else
    #define WEBKIT_PUBLIC
#endif

enum WebViewJsType {
    WebViewJsTypeCountUndefined = -1,

    JSTYPE_BOOLEAN,
    JSTYPE_NUMBER,
    JSTYPE_STRING,

    WebViewJsTypeCount
};

enum WebViewJavaScriptObjectType {
    WebViewJavaScriptObjectTypeUndefined = -1,

    OBJECT_TYPE_OBJECT,
    OBJECT_TYPE_FUNCTION,

    WebViewJavaScriptObjectTypeCount
};

namespace WTF {
class CString;
}

class WebViewQueue;

struct JavaScriptArg {
    WebViewJsType type;
    bool argBool;
    double argDouble;
    char* argString;

    JavaScriptArg();
    ~JavaScriptArg();
};


struct WebViewJavaScriptObjectDelegate {
    char* funcName;
    int argCount;
    JavaScriptArg* args;

    WebViewJavaScriptObjectDelegate(const char* name, int argCount);
    WebViewJavaScriptObjectDelegate(WebViewJavaScriptObjectDelegate* base);
    ~WebViewJavaScriptObjectDelegate();
};


class WebViewJavaScriptObject {
public:
    WEBKIT_PUBLIC WebViewJavaScriptObject(const char* name, WebViewJavaScriptObjectType);
    WEBKIT_PUBLIC WebViewJavaScriptObject(WebViewJavaScriptObject* base);
    WEBKIT_PUBLIC virtual ~WebViewJavaScriptObject();

    WEBKIT_PUBLIC virtual bool auth(void* cert, const char*) {return true;}
    WEBKIT_PUBLIC const char* baseUrl();
    WEBKIT_PUBLIC WebViewJavaScriptObjectType objectType();
    WEBKIT_PUBLIC WebViewJavaScriptObject* childObject();
    WEBKIT_PUBLIC WebViewJavaScriptObject* childObjectAtIndex(int index);
    WEBKIT_PUBLIC void addChildObject(const WebViewJavaScriptObject*);
    WEBKIT_PUBLIC void deleteChildObject(const char* name);
    WEBKIT_PUBLIC void setdelegate(bool delegate);
    WEBKIT_PUBLIC bool delegate();

private:
    WTF::CString* m_baseUrl;
    WebViewJavaScriptObjectType m_type;
    WebViewQueue* m_childObjects;
    bool m_delegate;
};

#endif // WebViewJavaScriptObject_h
